/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Full fledged AHRS with 9 degrees of freedom.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/IMUV2_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ImuV2BrickFunction {
    GetAcceleration,
    GetMagneticField,
    GetAngularVelocity,
    GetTemperature,
    GetOrientation,
    GetLinearAcceleration,
    GetGravityVector,
    GetQuaternion,
    GetAllData,
    LedsOn,
    LedsOff,
    AreLedsOn,
    SaveCalibration,
    SetAccelerationPeriod,
    GetAccelerationPeriod,
    SetMagneticFieldPeriod,
    GetMagneticFieldPeriod,
    SetAngularVelocityPeriod,
    GetAngularVelocityPeriod,
    SetTemperaturePeriod,
    GetTemperaturePeriod,
    SetOrientationPeriod,
    GetOrientationPeriod,
    SetLinearAccelerationPeriod,
    GetLinearAccelerationPeriod,
    SetGravityVectorPeriod,
    GetGravityVectorPeriod,
    SetQuaternionPeriod,
    GetQuaternionPeriod,
    SetAllDataPeriod,
    GetAllDataPeriod,
    SetSensorConfiguration,
    GetSensorConfiguration,
    SetSensorFusionMode,
    GetSensorFusionMode,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackAcceleration,
    CallbackMagneticField,
    CallbackAngularVelocity,
    CallbackTemperature,
    CallbackLinearAcceleration,
    CallbackGravityVector,
    CallbackOrientation,
    CallbackQuaternion,
    CallbackAllData,
}
impl From<ImuV2BrickFunction> for u8 {
    fn from(fun: ImuV2BrickFunction) -> Self {
        match fun {
            ImuV2BrickFunction::GetAcceleration => 1,
            ImuV2BrickFunction::GetMagneticField => 2,
            ImuV2BrickFunction::GetAngularVelocity => 3,
            ImuV2BrickFunction::GetTemperature => 4,
            ImuV2BrickFunction::GetOrientation => 5,
            ImuV2BrickFunction::GetLinearAcceleration => 6,
            ImuV2BrickFunction::GetGravityVector => 7,
            ImuV2BrickFunction::GetQuaternion => 8,
            ImuV2BrickFunction::GetAllData => 9,
            ImuV2BrickFunction::LedsOn => 10,
            ImuV2BrickFunction::LedsOff => 11,
            ImuV2BrickFunction::AreLedsOn => 12,
            ImuV2BrickFunction::SaveCalibration => 13,
            ImuV2BrickFunction::SetAccelerationPeriod => 14,
            ImuV2BrickFunction::GetAccelerationPeriod => 15,
            ImuV2BrickFunction::SetMagneticFieldPeriod => 16,
            ImuV2BrickFunction::GetMagneticFieldPeriod => 17,
            ImuV2BrickFunction::SetAngularVelocityPeriod => 18,
            ImuV2BrickFunction::GetAngularVelocityPeriod => 19,
            ImuV2BrickFunction::SetTemperaturePeriod => 20,
            ImuV2BrickFunction::GetTemperaturePeriod => 21,
            ImuV2BrickFunction::SetOrientationPeriod => 22,
            ImuV2BrickFunction::GetOrientationPeriod => 23,
            ImuV2BrickFunction::SetLinearAccelerationPeriod => 24,
            ImuV2BrickFunction::GetLinearAccelerationPeriod => 25,
            ImuV2BrickFunction::SetGravityVectorPeriod => 26,
            ImuV2BrickFunction::GetGravityVectorPeriod => 27,
            ImuV2BrickFunction::SetQuaternionPeriod => 28,
            ImuV2BrickFunction::GetQuaternionPeriod => 29,
            ImuV2BrickFunction::SetAllDataPeriod => 30,
            ImuV2BrickFunction::GetAllDataPeriod => 31,
            ImuV2BrickFunction::SetSensorConfiguration => 41,
            ImuV2BrickFunction::GetSensorConfiguration => 42,
            ImuV2BrickFunction::SetSensorFusionMode => 43,
            ImuV2BrickFunction::GetSensorFusionMode => 44,
            ImuV2BrickFunction::SetSpitfpBaudrateConfig => 231,
            ImuV2BrickFunction::GetSpitfpBaudrateConfig => 232,
            ImuV2BrickFunction::GetSendTimeoutCount => 233,
            ImuV2BrickFunction::SetSpitfpBaudrate => 234,
            ImuV2BrickFunction::GetSpitfpBaudrate => 235,
            ImuV2BrickFunction::GetSpitfpErrorCount => 237,
            ImuV2BrickFunction::EnableStatusLed => 238,
            ImuV2BrickFunction::DisableStatusLed => 239,
            ImuV2BrickFunction::IsStatusLedEnabled => 240,
            ImuV2BrickFunction::GetProtocol1BrickletName => 241,
            ImuV2BrickFunction::GetChipTemperature => 242,
            ImuV2BrickFunction::Reset => 243,
            ImuV2BrickFunction::WriteBrickletPlugin => 246,
            ImuV2BrickFunction::ReadBrickletPlugin => 247,
            ImuV2BrickFunction::GetIdentity => 255,
            ImuV2BrickFunction::CallbackAcceleration => 32,
            ImuV2BrickFunction::CallbackMagneticField => 33,
            ImuV2BrickFunction::CallbackAngularVelocity => 34,
            ImuV2BrickFunction::CallbackTemperature => 35,
            ImuV2BrickFunction::CallbackLinearAcceleration => 36,
            ImuV2BrickFunction::CallbackGravityVector => 37,
            ImuV2BrickFunction::CallbackOrientation => 38,
            ImuV2BrickFunction::CallbackQuaternion => 39,
            ImuV2BrickFunction::CallbackAllData => 40,
        }
    }
}
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_2HZ: u8 = 0;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_6HZ: u8 = 1;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_8HZ: u8 = 2;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_10HZ: u8 = 3;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_15HZ: u8 = 4;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_20HZ: u8 = 5;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_25HZ: u8 = 6;
pub const IMU_V2_BRICK_MAGNETOMETER_RATE_30HZ: u8 = 7;
pub const IMU_V2_BRICK_GYROSCOPE_RANGE_2000DPS: u8 = 0;
pub const IMU_V2_BRICK_GYROSCOPE_RANGE_1000DPS: u8 = 1;
pub const IMU_V2_BRICK_GYROSCOPE_RANGE_500DPS: u8 = 2;
pub const IMU_V2_BRICK_GYROSCOPE_RANGE_250DPS: u8 = 3;
pub const IMU_V2_BRICK_GYROSCOPE_RANGE_125DPS: u8 = 4;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_523HZ: u8 = 0;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_230HZ: u8 = 1;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_116HZ: u8 = 2;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_47HZ: u8 = 3;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_23HZ: u8 = 4;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_12HZ: u8 = 5;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_64HZ: u8 = 6;
pub const IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_32HZ: u8 = 7;
pub const IMU_V2_BRICK_ACCELEROMETER_RANGE_2G: u8 = 0;
pub const IMU_V2_BRICK_ACCELEROMETER_RANGE_4G: u8 = 1;
pub const IMU_V2_BRICK_ACCELEROMETER_RANGE_8G: u8 = 2;
pub const IMU_V2_BRICK_ACCELEROMETER_RANGE_16G: u8 = 3;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_7_81HZ: u8 = 0;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_15_63HZ: u8 = 1;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_31_25HZ: u8 = 2;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_62_5HZ: u8 = 3;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_125HZ: u8 = 4;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_250HZ: u8 = 5;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_500HZ: u8 = 6;
pub const IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_1000HZ: u8 = 7;
pub const IMU_V2_BRICK_SENSOR_FUSION_OFF: u8 = 0;
pub const IMU_V2_BRICK_SENSOR_FUSION_ON: u8 = 1;
pub const IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER: u8 = 2;
pub const IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION: u8 = 3;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const IMU_V2_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Acceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Acceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Acceleration {
        Acceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticField {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticField {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticField {
        MagneticField {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocity {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocity {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocity {
        AngularVelocity {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Orientation {
    pub heading: i16,
    pub roll: i16,
    pub pitch: i16,
}
impl FromByteSlice for Orientation {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Orientation {
        Orientation {
            heading: <i16>::from_le_byte_slice(&bytes[0..2]),
            roll: <i16>::from_le_byte_slice(&bytes[2..4]),
            pitch: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LinearAcceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for LinearAcceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> LinearAcceleration {
        LinearAcceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GravityVector {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for GravityVector {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GravityVector {
        GravityVector {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Quaternion {
    pub w: i16,
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Quaternion {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Quaternion {
        Quaternion {
            w: <i16>::from_le_byte_slice(&bytes[0..2]),
            x: <i16>::from_le_byte_slice(&bytes[2..4]),
            y: <i16>::from_le_byte_slice(&bytes[4..6]),
            z: <i16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub acceleration: [i16; 3],
    pub magnetic_field: [i16; 3],
    pub angular_velocity: [i16; 3],
    pub euler_angle: [i16; 3],
    pub quaternion: [i16; 4],
    pub linear_acceleration: [i16; 3],
    pub gravity_vector: [i16; 3],
    pub temperature: i8,
    pub calibration_status: u8,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 46 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[0..6]),
            magnetic_field: <[i16; 3]>::from_le_byte_slice(&bytes[6..12]),
            angular_velocity: <[i16; 3]>::from_le_byte_slice(&bytes[12..18]),
            euler_angle: <[i16; 3]>::from_le_byte_slice(&bytes[18..24]),
            quaternion: <[i16; 4]>::from_le_byte_slice(&bytes[24..32]),
            linear_acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[32..38]),
            gravity_vector: <[i16; 3]>::from_le_byte_slice(&bytes[38..44]),
            temperature: <i8>::from_le_byte_slice(&bytes[44..45]),
            calibration_status: <u8>::from_le_byte_slice(&bytes[45..46]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationEvent {
        AccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFieldEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticFieldEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFieldEvent {
        MagneticFieldEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocityEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocityEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocityEvent {
        AngularVelocityEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LinearAccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for LinearAccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> LinearAccelerationEvent {
        LinearAccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GravityVectorEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for GravityVectorEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GravityVectorEvent {
        GravityVectorEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OrientationEvent {
    pub heading: i16,
    pub roll: i16,
    pub pitch: i16,
}
impl FromByteSlice for OrientationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> OrientationEvent {
        OrientationEvent {
            heading: <i16>::from_le_byte_slice(&bytes[0..2]),
            roll: <i16>::from_le_byte_slice(&bytes[2..4]),
            pitch: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct QuaternionEvent {
    pub w: i16,
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for QuaternionEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> QuaternionEvent {
        QuaternionEvent {
            w: <i16>::from_le_byte_slice(&bytes[0..2]),
            x: <i16>::from_le_byte_slice(&bytes[2..4]),
            y: <i16>::from_le_byte_slice(&bytes[4..6]),
            z: <i16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub acceleration: [i16; 3],
    pub magnetic_field: [i16; 3],
    pub angular_velocity: [i16; 3],
    pub euler_angle: [i16; 3],
    pub quaternion: [i16; 4],
    pub linear_acceleration: [i16; 3],
    pub gravity_vector: [i16; 3],
    pub temperature: i8,
    pub calibration_status: u8,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 46 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[0..6]),
            magnetic_field: <[i16; 3]>::from_le_byte_slice(&bytes[6..12]),
            angular_velocity: <[i16; 3]>::from_le_byte_slice(&bytes[12..18]),
            euler_angle: <[i16; 3]>::from_le_byte_slice(&bytes[18..24]),
            quaternion: <[i16; 4]>::from_le_byte_slice(&bytes[24..32]),
            linear_acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[32..38]),
            gravity_vector: <[i16; 3]>::from_le_byte_slice(&bytes[38..44]),
            temperature: <i8>::from_le_byte_slice(&bytes[44..45]),
            calibration_status: <u8>::from_le_byte_slice(&bytes[45..46]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SensorConfiguration {
    pub magnetometer_rate: u8,
    pub gyroscope_range: u8,
    pub gyroscope_bandwidth: u8,
    pub accelerometer_range: u8,
    pub accelerometer_bandwidth: u8,
}
impl FromByteSlice for SensorConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SensorConfiguration {
        SensorConfiguration {
            magnetometer_rate: <u8>::from_le_byte_slice(&bytes[0..1]),
            gyroscope_range: <u8>::from_le_byte_slice(&bytes[1..2]),
            gyroscope_bandwidth: <u8>::from_le_byte_slice(&bytes[2..3]),
            accelerometer_range: <u8>::from_le_byte_slice(&bytes[3..4]),
            accelerometer_bandwidth: <u8>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Full fledged AHRS with 9 degrees of freedom
#[derive(Clone)]
pub struct ImuV2Brick {
    device: Device,
}
impl ImuV2Brick {
    pub const DEVICE_IDENTIFIER: u16 = 18;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IMU Brick 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ImuV2Brick {
        let mut result = ImuV2Brick { device: Device::new([2, 0, 3], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetMagneticField) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAngularVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetOrientation) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetLinearAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetGravityVector) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetQuaternion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::LedsOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::LedsOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::AreLedsOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SaveCalibration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetAccelerationPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAccelerationPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetMagneticFieldPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetMagneticFieldPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetAngularVelocityPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAngularVelocityPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetTemperaturePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetTemperaturePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetOrientationPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetOrientationPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetLinearAccelerationPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetLinearAccelerationPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetGravityVectorPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetGravityVectorPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetQuaternionPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetQuaternionPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetAllDataPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetAllDataPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetSensorConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSensorConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetSensorFusionMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSensorFusionMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetProtocol1BrickletName) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV2BrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV2BrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::imu_v2_brick::ImuV2Brick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::imu_v2_brick::ImuV2Brick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ImuV2BrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ImuV2BrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_acceleration_period`]. The parameters are the acceleration
    /// for the x, y and z axis.
    ///
    /// [`set_acceleration_period`]: #method.set_acceleration_period
    pub fn get_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackAcceleration))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_magnetic_field_period`]. The parameters are the magnetic
    /// field for the x, y and z axis.
    pub fn get_magnetic_field_callback_receiver(&self) -> ConvertingCallbackReceiver<MagneticFieldEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackMagneticField))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_angular_velocity_period`]. The parameters are the angular
    /// velocity for the x, y and z axis.
    pub fn get_angular_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<AngularVelocityEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackAngularVelocity))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_temperature_period`]. The parameter is the temperature.
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i8> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackTemperature))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_linear_acceleration_period`]. The parameters are the
    /// linear acceleration for the x, y and z axis.
    pub fn get_linear_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<LinearAccelerationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackLinearAcceleration))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_gravity_vector_period`]. The parameters gravity vector
    /// for the x, y and z axis.
    pub fn get_gravity_vector_callback_receiver(&self) -> ConvertingCallbackReceiver<GravityVectorEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackGravityVector))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_orientation_period`]. The parameters are the orientation
    /// (heading (yaw), roll, pitch) of the IMU Brick in Euler angles. See
    /// [`get_orientation`] for details.
    pub fn get_orientation_callback_receiver(&self) -> ConvertingCallbackReceiver<OrientationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackOrientation))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_quaternion_period`]. The parameters are the orientation
    /// (w, x, y, z) of the IMU Brick in quaternions. See [`get_quaternion`]
    /// for details.
    pub fn get_quaternion_callback_receiver(&self) -> ConvertingCallbackReceiver<QuaternionEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackQuaternion))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_data_period`]. The parameters are as for
    /// [`get_all_data`].
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(ImuV2BrickFunction::CallbackAllData))
    }

    /// Returns the calibrated acceleration from the accelerometer for the
    /// x, y and z axis. The acceleration is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// If you want to get the acceleration periodically, it is recommended
    /// to use the [`get_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_acceleration_period`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<Acceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAcceleration), payload)
    }

    /// Returns the calibrated magnetic field from the magnetometer for the
    /// x, y and z axis.
    ///
    /// If you want to get the magnetic field periodically, it is recommended
    /// to use the [`get_magnetic_field_callback_receiver`] receiver and set the period with
    /// [`set_magnetic_field_period`].
    pub fn get_magnetic_field(&self) -> ConvertingReceiver<MagneticField> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetMagneticField), payload)
    }

    /// Returns the calibrated angular velocity from the gyroscope for the
    /// x, y and z axis. The angular velocity is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// If you want to get the angular velocity periodically, it is recommended
    /// to use the [`get_angular_velocity_callback_receiver`] areceiver nd set the period with
    /// [`set_angular_velocity_period`].
    pub fn get_angular_velocity(&self) -> ConvertingReceiver<AngularVelocity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAngularVelocity), payload)
    }

    /// Returns the temperature of the IMU Brick.
    /// The temperature is measured in the core of the BNO055 IC, it is not the
    /// ambient temperature
    pub fn get_temperature(&self) -> ConvertingReceiver<i8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetTemperature), payload)
    }

    /// Returns the current orientation (heading, roll, pitch) of the IMU Brick as
    /// independent Euler angles. Note that Euler angles always
    /// experience a [gimbal lock](https://en.wikipedia.org/wiki/Gimbal_lock)__.
    /// We recommend that you use quaternions instead, if you need the absolute
    /// orientation.
    ///
    /// If you want to get the orientation periodically, it is recommended
    /// to use the [`get_orientation_callback_receiver`] receiver and set the period with
    /// [`set_orientation_period`].
    pub fn get_orientation(&self) -> ConvertingReceiver<Orientation> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetOrientation), payload)
    }

    /// Returns the linear acceleration of the IMU Brick for the
    /// x, y and z axis. The acceleration is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// The linear acceleration is the acceleration in each of the three
    /// axis of the IMU Brick with the influences of gravity removed.
    ///
    /// It is also possible to get the gravity vector with the influence of linear
    /// acceleration removed, see [`get_gravity_vector`].
    ///
    /// If you want to get the linear acceleration periodically, it is recommended
    /// to use the [`get_linear_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_linear_acceleration_period`].
    pub fn get_linear_acceleration(&self) -> ConvertingReceiver<LinearAcceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetLinearAcceleration), payload)
    }

    /// Returns the current gravity vector of the IMU Brick for the
    /// x, y and z axis.
    ///
    /// The gravity vector is the acceleration that occurs due to gravity.
    /// Influences of additional linear acceleration are removed.
    ///
    /// It is also possible to get the linear acceleration with the influence
    /// of gravity removed, see [`get_linear_acceleration`].
    ///
    /// If you want to get the gravity vector periodically, it is recommended
    /// to use the [`get_gravity_vector_callback_receiver`] receiver and set the period with
    /// [`set_gravity_vector_period`].
    pub fn get_gravity_vector(&self) -> ConvertingReceiver<GravityVector> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetGravityVector), payload)
    }

    /// Returns the current orientation (w, x, y, z) of the IMU Brick as
    /// [quaternions](https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation)__.
    ///
    /// You have to divide the return values by 16383 (14 bit) to get
    /// the usual range of -1.0 to +1.0 for quaternions.
    ///
    /// If you want to get the quaternions periodically, it is recommended
    /// to use the [`get_quaternion_callback_receiver`] receiver and set the period with
    /// [`set_quaternion_period`].
    pub fn get_quaternion(&self) -> ConvertingReceiver<Quaternion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetQuaternion), payload)
    }

    /// Return all of the available data of the IMU Brick.
    ///
    /// * acceleration (see [`get_acceleration`])
    /// * magnetic field (see [`get_magnetic_field`])
    /// * angular velocity (see [`get_angular_velocity`])
    /// * Euler angles (see [`get_orientation`])
    /// * quaternion (see [`get_quaternion`])
    /// * linear acceleration (see [`get_linear_acceleration`])
    /// * gravity vector (see [`get_gravity_vector`])
    /// * temperature (see [`get_temperature`])
    /// * calibration status (see below)
    ///
    /// The calibration status consists of four pairs of two bits. Each pair
    /// of bits represents the status of the current calibration.
    ///
    /// * bit 0-1: Magnetometer
    /// * bit 2-3: Accelerometer
    /// * bit 4-5: Gyroscope
    /// * bit 6-7: System
    ///
    /// A value of 0 means for not calibrated and a value of 3 means
    /// fully calibrated. In your program you should always be able to
    /// ignore the calibration status, it is used by the calibration
    /// window of the Brick Viewer and it can be ignored after the first
    /// calibration. See the documentation in the calibration window for
    /// more information regarding the calibration of the IMU Brick.
    ///
    /// If you want to get the data periodically, it is recommended
    /// to use the [`get_all_data_callback_receiver`] receiver and set the period with
    /// [`set_all_data_period`].
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAllData), payload)
    }

    /// Turns the orientation and direction LEDs of the IMU Brick on.
    pub fn leds_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV2BrickFunction::LedsOn), payload)
    }

    /// Turns the orientation and direction LEDs of the IMU Brick off.
    pub fn leds_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV2BrickFunction::LedsOff), payload)
    }

    /// Returns *true* if the orientation and direction LEDs of the IMU Brick
    /// are on, *false* otherwise.
    pub fn are_leds_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::AreLedsOn), payload)
    }

    /// A call of this function saves the current calibration to be used
    /// as a starting point for the next restart of continuous calibration
    /// of the IMU Brick.
    ///
    /// A return value of *true* means that the calibration could be used and
    /// *false* means that it could not be used (this happens if the calibration
    /// status is not fully calibrated).
    ///
    /// This function is used by the calibration window of the Brick Viewer, you
    /// should not need to call it in your program.
    pub fn save_calibration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::SaveCalibration), payload)
    }

    /// Sets the period with which the [`get_acceleration_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_acceleration_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetAccelerationPeriod), payload)
    }

    /// Returns the period as set by [`set_acceleration_period`].
    pub fn get_acceleration_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAccelerationPeriod), payload)
    }

    /// Sets the period with which the [`get_magnetic_field_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_magnetic_field_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetMagneticFieldPeriod), payload)
    }

    /// Returns the period as set by [`set_magnetic_field_period`].
    pub fn get_magnetic_field_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetMagneticFieldPeriod), payload)
    }

    /// Sets the period with which the [`get_angular_velocity_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    pub fn set_angular_velocity_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetAngularVelocityPeriod), payload)
    }

    /// Returns the period as set by [`set_angular_velocity_period`].
    pub fn get_angular_velocity_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAngularVelocityPeriod), payload)
    }

    /// Sets the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_temperature_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetTemperaturePeriod), payload)
    }

    /// Returns the period as set by [`set_temperature_period`].
    pub fn get_temperature_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetTemperaturePeriod), payload)
    }

    /// Sets the period with which the [`get_orientation_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_orientation_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetOrientationPeriod), payload)
    }

    /// Returns the period as set by [`set_orientation_period`].
    pub fn get_orientation_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetOrientationPeriod), payload)
    }

    /// Sets the period with which the [`get_linear_acceleration_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    pub fn set_linear_acceleration_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetLinearAccelerationPeriod), payload)
    }

    /// Returns the period as set by [`set_linear_acceleration_period`].
    pub fn get_linear_acceleration_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetLinearAccelerationPeriod), payload)
    }

    /// Sets the period with which the [`get_gravity_vector_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_gravity_vector_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetGravityVectorPeriod), payload)
    }

    /// Returns the period as set by [`set_gravity_vector_period`].
    pub fn get_gravity_vector_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetGravityVectorPeriod), payload)
    }

    /// Sets the period with which the [`get_quaternion_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_quaternion_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetQuaternionPeriod), payload)
    }

    /// Returns the period as set by [`set_quaternion_period`].
    pub fn get_quaternion_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetQuaternionPeriod), payload)
    }

    /// Sets the period with which the [`get_all_data_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_all_data_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuV2BrickFunction::SetAllDataPeriod), payload)
    }

    /// Returns the period as set by [`set_all_data_period`].
    pub fn get_all_data_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetAllDataPeriod), payload)
    }

    /// Sets the available sensor configuration for the Magnetometer, Gyroscope and
    /// Accelerometer. The Accelerometer Range is user selectable in all fusion modes,
    /// all other configurations are auto-controlled in fusion mode.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_V2_BRICK_MAGNETOMETER_RATE_2HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_6HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_8HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_10HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_15HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_20HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_25HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_30HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_2000DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_1000DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_500DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_250DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_125DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_523HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_230HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_116HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_47HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_23HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_12HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_64HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_32HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_2G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_4G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_8G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_16G
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_7_81HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_15_63HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_31_25HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_62_5HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_125HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_250HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_500HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_1000HZ
    pub fn set_sensor_configuration(
        &self,
        magnetometer_rate: u8,
        gyroscope_range: u8,
        gyroscope_bandwidth: u8,
        accelerometer_range: u8,
        accelerometer_bandwidth: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(magnetometer_rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(gyroscope_range));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(gyroscope_bandwidth));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(accelerometer_range));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(accelerometer_bandwidth));

        self.device.set(u8::from(ImuV2BrickFunction::SetSensorConfiguration), payload)
    }

    /// Returns the sensor configuration as set by [`set_sensor_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_V2_BRICK_MAGNETOMETER_RATE_2HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_6HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_8HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_10HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_15HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_20HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_25HZ
    ///	* IMU_V2_BRICK_MAGNETOMETER_RATE_30HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_2000DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_1000DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_500DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_250DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_RANGE_125DPS
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_523HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_230HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_116HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_47HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_23HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_12HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_64HZ
    ///	* IMU_V2_BRICK_GYROSCOPE_BANDWIDTH_32HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_2G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_4G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_8G
    ///	* IMU_V2_BRICK_ACCELEROMETER_RANGE_16G
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_7_81HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_15_63HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_31_25HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_62_5HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_125HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_250HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_500HZ
    ///	* IMU_V2_BRICK_ACCELEROMETER_BANDWIDTH_1000HZ
    pub fn get_sensor_configuration(&self) -> ConvertingReceiver<SensorConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetSensorConfiguration), payload)
    }

    /// If the fusion mode is turned off, the functions [`get_acceleration`],
    /// [`get_magnetic_field`] and [`get_angular_velocity`] return uncalibrated
    /// and uncompensated sensor data. All other sensor data getters return no data.
    ///
    /// Since firmware version 2.0.6 you can also use a fusion mode without magnetometer.
    /// In this mode the calculated orientation is relative (with magnetometer it is
    /// absolute with respect to the earth). However, the calculation can't be influenced
    /// by spurious magnetic fields.
    ///
    /// Since firmware version 2.0.13 you can also use a fusion mode without fast
    /// magnetometer calibration. This mode is the same as the normal fusion mode,
    /// but the fast magnetometer calibration is turned off. So to find the orientation
    /// the first time will likely take longer, but small magnetic influences might
    /// not affect the automatic calibration as much.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_V2_BRICK_SENSOR_FUSION_OFF
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION
    pub fn set_sensor_fusion_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(ImuV2BrickFunction::SetSensorFusionMode), payload)
    }

    /// Returns the sensor fusion mode as set by [`set_sensor_fusion_mode`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_V2_BRICK_SENSOR_FUSION_OFF
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER
    ///	* IMU_V2_BRICK_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION
    pub fn get_sensor_fusion_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetSensorFusionMode), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.0.10$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(ImuV2BrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.0.10$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.0.7$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_V2_BRICK_COMMUNICATION_METHOD_NONE
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_USB
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_RS485
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* IMU_V2_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(ImuV2BrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(ImuV2BrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ImuV2BrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.0.5$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ImuV2BrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV2BrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV2BrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(ImuV2BrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV2BrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(ImuV2BrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(ImuV2BrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV2BrickFunction::GetIdentity), payload)
    }
}
