/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! HAT for Raspberry Pi Zero with 4 Bricklets ports.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/HATZero_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum HatZeroBrickFunction {
    GetUsbVoltage,
    SetUsbVoltageCallbackConfiguration,
    GetUsbVoltageCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackUsbVoltage,
}
impl From<HatZeroBrickFunction> for u8 {
    fn from(fun: HatZeroBrickFunction) -> Self {
        match fun {
            HatZeroBrickFunction::GetUsbVoltage => 1,
            HatZeroBrickFunction::SetUsbVoltageCallbackConfiguration => 2,
            HatZeroBrickFunction::GetUsbVoltageCallbackConfiguration => 3,
            HatZeroBrickFunction::GetSpitfpErrorCount => 234,
            HatZeroBrickFunction::SetBootloaderMode => 235,
            HatZeroBrickFunction::GetBootloaderMode => 236,
            HatZeroBrickFunction::SetWriteFirmwarePointer => 237,
            HatZeroBrickFunction::WriteFirmware => 238,
            HatZeroBrickFunction::SetStatusLedConfig => 239,
            HatZeroBrickFunction::GetStatusLedConfig => 240,
            HatZeroBrickFunction::GetChipTemperature => 242,
            HatZeroBrickFunction::Reset => 243,
            HatZeroBrickFunction::WriteUid => 248,
            HatZeroBrickFunction::ReadUid => 249,
            HatZeroBrickFunction::GetIdentity => 255,
            HatZeroBrickFunction::CallbackUsbVoltage => 4,
        }
    }
}
pub const HAT_ZERO_BRICK_THRESHOLD_OPTION_OFF: char = 'x';
pub const HAT_ZERO_BRICK_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const HAT_ZERO_BRICK_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const HAT_ZERO_BRICK_THRESHOLD_OPTION_SMALLER: char = '<';
pub const HAT_ZERO_BRICK_THRESHOLD_OPTION_GREATER: char = '>';
pub const HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_OK: u8 = 0;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const HAT_ZERO_BRICK_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const HAT_ZERO_BRICK_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const HAT_ZERO_BRICK_STATUS_LED_CONFIG_ON: u8 = 1;
pub const HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct UsbVoltageCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for UsbVoltageCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> UsbVoltageCallbackConfiguration {
        UsbVoltageCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u16>::from_le_byte_slice(&bytes[6..8]),
            max: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// HAT for Raspberry Pi Zero with 4 Bricklets ports
#[derive(Clone)]
pub struct HatZeroBrick {
    device: Device,
}
impl HatZeroBrick {
    pub const DEVICE_IDENTIFIER: u16 = 112;
    pub const DEVICE_DISPLAY_NAME: &'static str = "HAT Zero Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> HatZeroBrick {
        let mut result = HatZeroBrick { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetUsbVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::SetUsbVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetUsbVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatZeroBrickFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatZeroBrickFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatZeroBrickFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatZeroBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::hat_zero_brick::HatZeroBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::hat_zero_brick::HatZeroBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: HatZeroBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: HatZeroBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_usb_voltage_callback_configuration`].
    ///
    /// The parameter is the same as [`get_usb_voltage`].
    ///
    /// [`get_usb_voltage`]: #method.get_usb_voltage
    /// [`set_usb_voltage_callback_configuration`]: #method.set_usb_voltage_callback_configuration
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn get_usb_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(HatZeroBrickFunction::CallbackUsbVoltage))
    }

    /// Returns the USB supply voltage of the Raspberry Pi.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_usb_voltage_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_usb_voltage_callback_configuration`].
    pub fn get_usb_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetUsbVoltage), payload)
    }

    /// The period is the period with which the [`get_usb_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_usb_voltage_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_THRESHOLD_OPTION_OFF
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_GREATER
    pub fn set_usb_voltage_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u16,
        max: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(HatZeroBrickFunction::SetUsbVoltageCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_usb_voltage_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_THRESHOLD_OPTION_OFF
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_OUTSIDE
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_INSIDE
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_SMALLER
    ///	* HAT_ZERO_BRICK_THRESHOLD_OPTION_GREATER
    pub fn get_usb_voltage_callback_configuration(&self) -> ConvertingReceiver<UsbVoltageCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetUsbVoltageCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_OK
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_INVALID_MODE
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_NO_CHANGE
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(HatZeroBrickFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* HAT_ZERO_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(HatZeroBrickFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(HatZeroBrickFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_STATUS_LED_CONFIG_OFF
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_ON
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(HatZeroBrickFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * HAT_ZERO_BRICK_STATUS_LED_CONFIG_OFF
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_ON
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* HAT_ZERO_BRICK_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(HatZeroBrickFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(HatZeroBrickFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the HAT is connected to
    /// (typically '0' as the HAT is the root device in the topology),
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The HAT (Zero) Brick is always at position 'i'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatZeroBrickFunction::GetIdentity), payload)
    }
}
