/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Detects presence of magnetic field.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/HallEffect_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum HallEffectBrickletFunction {
    GetValue,
    GetEdgeCount,
    SetEdgeCountConfig,
    GetEdgeCountConfig,
    SetEdgeInterrupt,
    GetEdgeInterrupt,
    SetEdgeCountCallbackPeriod,
    GetEdgeCountCallbackPeriod,
    EdgeInterrupt,
    GetIdentity,
    CallbackEdgeCount,
}
impl From<HallEffectBrickletFunction> for u8 {
    fn from(fun: HallEffectBrickletFunction) -> Self {
        match fun {
            HallEffectBrickletFunction::GetValue => 1,
            HallEffectBrickletFunction::GetEdgeCount => 2,
            HallEffectBrickletFunction::SetEdgeCountConfig => 3,
            HallEffectBrickletFunction::GetEdgeCountConfig => 4,
            HallEffectBrickletFunction::SetEdgeInterrupt => 5,
            HallEffectBrickletFunction::GetEdgeInterrupt => 6,
            HallEffectBrickletFunction::SetEdgeCountCallbackPeriod => 7,
            HallEffectBrickletFunction::GetEdgeCountCallbackPeriod => 8,
            HallEffectBrickletFunction::EdgeInterrupt => 9,
            HallEffectBrickletFunction::GetIdentity => 255,
            HallEffectBrickletFunction::CallbackEdgeCount => 10,
        }
    }
}
pub const HALL_EFFECT_BRICKLET_EDGE_TYPE_RISING: u8 = 0;
pub const HALL_EFFECT_BRICKLET_EDGE_TYPE_FALLING: u8 = 1;
pub const HALL_EFFECT_BRICKLET_EDGE_TYPE_BOTH: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountConfig {
    pub edge_type: u8,
    pub debounce: u8,
}
impl FromByteSlice for EdgeCountConfig {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountConfig {
        EdgeCountConfig { edge_type: <u8>::from_le_byte_slice(&bytes[0..1]), debounce: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeInterrupt {
    pub count: u32,
    pub value: bool,
}
impl FromByteSlice for EdgeInterrupt {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeInterrupt {
        EdgeInterrupt { count: <u32>::from_le_byte_slice(&bytes[0..4]), value: <bool>::from_le_byte_slice(&bytes[4..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountEvent {
    pub count: u32,
    pub value: bool,
}
impl FromByteSlice for EdgeCountEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountEvent {
        EdgeCountEvent { count: <u32>::from_le_byte_slice(&bytes[0..4]), value: <bool>::from_le_byte_slice(&bytes[4..5]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Detects presence of magnetic field
#[derive(Clone)]
pub struct HallEffectBricklet {
    device: Device,
}
impl HallEffectBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 240;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Hall Effect Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> HallEffectBricklet {
        let mut result = HallEffectBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetEdgeCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::SetEdgeCountConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetEdgeCountConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::SetEdgeInterrupt) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetEdgeInterrupt) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::SetEdgeCountCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetEdgeCountCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::EdgeInterrupt) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HallEffectBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::hall_effect_bricklet::HallEffectBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::hall_effect_bricklet::HallEffectBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: HallEffectBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: HallEffectBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_edge_count_callback_period`]. The parameters are the
    /// current count and the current value (see [`get_value`] and
    /// [`get_edge_count`]).
    ///
    /// The [`get_edge_count_callback_receiver`] receiver is only triggered if the count or value changed
    /// since the last triggering.
    ///
    /// [`get_value`]: #method.get_value
    /// [`get_edge_count`]: #method.get_edge_count
    /// [`set_edge_count_callback_period`]: #method.set_edge_count_callback_period
    /// [`get_edge_count_callback_receiver`]: #method.get_edge_count_callback_receiver
    pub fn get_edge_count_callback_receiver(&self) -> ConvertingCallbackReceiver<EdgeCountEvent> {
        self.device.get_callback_receiver(u8::from(HallEffectBrickletFunction::CallbackEdgeCount))
    }

    /// Returns *true* if a magnetic field of 3.5 millitesla or greater is detected.
    pub fn get_value(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::GetValue), payload)
    }

    /// Returns the current value of the edge counter. You can configure
    /// edge type (rising, falling, both) that is counted with
    /// [`set_edge_count_config`].
    ///
    /// If you set the reset counter to *true*, the count is set back to 0
    /// directly after it is read.
    pub fn get_edge_count(&self, reset_counter: bool) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(reset_counter));

        self.device.get(u8::from(HallEffectBrickletFunction::GetEdgeCount), payload)
    }

    /// The edge type parameter configures if rising edges, falling edges or
    /// both are counted. Possible edge types are:
    ///
    /// * 0 = rising
    /// * 1 = falling
    /// * 2 = both
    ///
    /// A magnetic field of 3.5 millitesla or greater causes a falling edge and a
    /// magnetic field of 2.5 millitesla or smaller causes a rising edge.
    ///
    /// If a magnet comes near the Bricklet the signal goes low (falling edge), if
    /// a magnet is removed from the vicinity the signal goes high (rising edge).
    ///
    /// Configuring an edge counter resets its value to 0.
    ///
    /// If you don't know what any of this means, just leave it at default. The
    /// default configuration is very likely OK for you.
    ///
    /// Associated constants:
    /// * HALL_EFFECT_BRICKLET_EDGE_TYPE_RISING
    ///	* HALL_EFFECT_BRICKLET_EDGE_TYPE_FALLING
    ///	* HALL_EFFECT_BRICKLET_EDGE_TYPE_BOTH
    pub fn set_edge_count_config(&self, edge_type: u8, debounce: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(edge_type));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(debounce));

        self.device.set(u8::from(HallEffectBrickletFunction::SetEdgeCountConfig), payload)
    }

    /// Returns the edge type and debounce time as set by [`set_edge_count_config`].
    ///
    /// Associated constants:
    /// * HALL_EFFECT_BRICKLET_EDGE_TYPE_RISING
    ///	* HALL_EFFECT_BRICKLET_EDGE_TYPE_FALLING
    ///	* HALL_EFFECT_BRICKLET_EDGE_TYPE_BOTH
    pub fn get_edge_count_config(&self) -> ConvertingReceiver<EdgeCountConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::GetEdgeCountConfig), payload)
    }

    /// Sets the number of edges until an interrupt is invoked.
    ///
    /// If *edges* is set to n, an interrupt is invoked for every n-th detected edge.
    ///
    /// If *edges* is set to 0, the interrupt is disabled.
    pub fn set_edge_interrupt(&self, edges: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(edges));

        self.device.set(u8::from(HallEffectBrickletFunction::SetEdgeInterrupt), payload)
    }

    /// Returns the edges as set by [`set_edge_interrupt`].
    pub fn get_edge_interrupt(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::GetEdgeInterrupt), payload)
    }

    /// Sets the period with which the [`get_edge_count_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_edge_count_callback_receiver`] receiver is only triggered if the edge count has changed
    /// since the last triggering.
    pub fn set_edge_count_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(HallEffectBrickletFunction::SetEdgeCountCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_edge_count_callback_period`].
    pub fn get_edge_count_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::GetEdgeCountCallbackPeriod), payload)
    }

    /// This receiver is triggered every n-th count, as configured with
    /// [`set_edge_interrupt`]. The parameters are the
    /// current count and the current value (see [`get_value`] and
    /// [`get_edge_count`]).
    pub fn edge_interrupt(&self) -> ConvertingReceiver<EdgeInterrupt> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::EdgeInterrupt), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HallEffectBrickletFunction::GetIdentity), payload)
    }
}
