/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Determine position, velocity and altitude using GPS.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/GPS_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum GpsBrickletFunction {
    GetCoordinates,
    GetStatus,
    GetAltitude,
    GetMotion,
    GetDateTime,
    Restart,
    SetCoordinatesCallbackPeriod,
    GetCoordinatesCallbackPeriod,
    SetStatusCallbackPeriod,
    GetStatusCallbackPeriod,
    SetAltitudeCallbackPeriod,
    GetAltitudeCallbackPeriod,
    SetMotionCallbackPeriod,
    GetMotionCallbackPeriod,
    SetDateTimeCallbackPeriod,
    GetDateTimeCallbackPeriod,
    GetIdentity,
    CallbackCoordinates,
    CallbackStatus,
    CallbackAltitude,
    CallbackMotion,
    CallbackDateTime,
}
impl From<GpsBrickletFunction> for u8 {
    fn from(fun: GpsBrickletFunction) -> Self {
        match fun {
            GpsBrickletFunction::GetCoordinates => 1,
            GpsBrickletFunction::GetStatus => 2,
            GpsBrickletFunction::GetAltitude => 3,
            GpsBrickletFunction::GetMotion => 4,
            GpsBrickletFunction::GetDateTime => 5,
            GpsBrickletFunction::Restart => 6,
            GpsBrickletFunction::SetCoordinatesCallbackPeriod => 7,
            GpsBrickletFunction::GetCoordinatesCallbackPeriod => 8,
            GpsBrickletFunction::SetStatusCallbackPeriod => 9,
            GpsBrickletFunction::GetStatusCallbackPeriod => 10,
            GpsBrickletFunction::SetAltitudeCallbackPeriod => 11,
            GpsBrickletFunction::GetAltitudeCallbackPeriod => 12,
            GpsBrickletFunction::SetMotionCallbackPeriod => 13,
            GpsBrickletFunction::GetMotionCallbackPeriod => 14,
            GpsBrickletFunction::SetDateTimeCallbackPeriod => 15,
            GpsBrickletFunction::GetDateTimeCallbackPeriod => 16,
            GpsBrickletFunction::GetIdentity => 255,
            GpsBrickletFunction::CallbackCoordinates => 17,
            GpsBrickletFunction::CallbackStatus => 18,
            GpsBrickletFunction::CallbackAltitude => 19,
            GpsBrickletFunction::CallbackMotion => 20,
            GpsBrickletFunction::CallbackDateTime => 21,
        }
    }
}
pub const GPS_BRICKLET_FIX_NO_FIX: u8 = 1;
pub const GPS_BRICKLET_FIX_2D_FIX: u8 = 2;
pub const GPS_BRICKLET_FIX_3D_FIX: u8 = 3;
pub const GPS_BRICKLET_RESTART_TYPE_HOT_START: u8 = 0;
pub const GPS_BRICKLET_RESTART_TYPE_WARM_START: u8 = 1;
pub const GPS_BRICKLET_RESTART_TYPE_COLD_START: u8 = 2;
pub const GPS_BRICKLET_RESTART_TYPE_FACTORY_RESET: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Coordinates {
    pub latitude: u32,
    pub ns: char,
    pub longitude: u32,
    pub ew: char,
    pub pdop: u16,
    pub hdop: u16,
    pub vdop: u16,
    pub epe: u16,
}
impl FromByteSlice for Coordinates {
    fn bytes_expected() -> usize { 18 }
    fn from_le_byte_slice(bytes: &[u8]) -> Coordinates {
        Coordinates {
            latitude: <u32>::from_le_byte_slice(&bytes[0..4]),
            ns: <char>::from_le_byte_slice(&bytes[4..5]),
            longitude: <u32>::from_le_byte_slice(&bytes[5..9]),
            ew: <char>::from_le_byte_slice(&bytes[9..10]),
            pdop: <u16>::from_le_byte_slice(&bytes[10..12]),
            hdop: <u16>::from_le_byte_slice(&bytes[12..14]),
            vdop: <u16>::from_le_byte_slice(&bytes[14..16]),
            epe: <u16>::from_le_byte_slice(&bytes[16..18]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Status {
    pub fix: u8,
    pub satellites_view: u8,
    pub satellites_used: u8,
}
impl FromByteSlice for Status {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Status {
        Status {
            fix: <u8>::from_le_byte_slice(&bytes[0..1]),
            satellites_view: <u8>::from_le_byte_slice(&bytes[1..2]),
            satellites_used: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Altitude {
    pub altitude: i32,
    pub geoidal_separation: i32,
}
impl FromByteSlice for Altitude {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Altitude {
        Altitude { altitude: <i32>::from_le_byte_slice(&bytes[0..4]), geoidal_separation: <i32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Motion {
    pub course: u32,
    pub speed: u32,
}
impl FromByteSlice for Motion {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Motion {
        Motion { course: <u32>::from_le_byte_slice(&bytes[0..4]), speed: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTime {
    pub date: u32,
    pub time: u32,
}
impl FromByteSlice for DateTime {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTime {
        DateTime { date: <u32>::from_le_byte_slice(&bytes[0..4]), time: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CoordinatesEvent {
    pub latitude: u32,
    pub ns: char,
    pub longitude: u32,
    pub ew: char,
    pub pdop: u16,
    pub hdop: u16,
    pub vdop: u16,
    pub epe: u16,
}
impl FromByteSlice for CoordinatesEvent {
    fn bytes_expected() -> usize { 18 }
    fn from_le_byte_slice(bytes: &[u8]) -> CoordinatesEvent {
        CoordinatesEvent {
            latitude: <u32>::from_le_byte_slice(&bytes[0..4]),
            ns: <char>::from_le_byte_slice(&bytes[4..5]),
            longitude: <u32>::from_le_byte_slice(&bytes[5..9]),
            ew: <char>::from_le_byte_slice(&bytes[9..10]),
            pdop: <u16>::from_le_byte_slice(&bytes[10..12]),
            hdop: <u16>::from_le_byte_slice(&bytes[12..14]),
            vdop: <u16>::from_le_byte_slice(&bytes[14..16]),
            epe: <u16>::from_le_byte_slice(&bytes[16..18]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StatusEvent {
    pub fix: u8,
    pub satellites_view: u8,
    pub satellites_used: u8,
}
impl FromByteSlice for StatusEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> StatusEvent {
        StatusEvent {
            fix: <u8>::from_le_byte_slice(&bytes[0..1]),
            satellites_view: <u8>::from_le_byte_slice(&bytes[1..2]),
            satellites_used: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AltitudeEvent {
    pub altitude: i32,
    pub geoidal_separation: i32,
}
impl FromByteSlice for AltitudeEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> AltitudeEvent {
        AltitudeEvent { altitude: <i32>::from_le_byte_slice(&bytes[0..4]), geoidal_separation: <i32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MotionEvent {
    pub course: u32,
    pub speed: u32,
}
impl FromByteSlice for MotionEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> MotionEvent {
        MotionEvent { course: <u32>::from_le_byte_slice(&bytes[0..4]), speed: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTimeEvent {
    pub date: u32,
    pub time: u32,
}
impl FromByteSlice for DateTimeEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTimeEvent {
        DateTimeEvent { date: <u32>::from_le_byte_slice(&bytes[0..4]), time: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Determine position, velocity and altitude using GPS
#[derive(Clone)]
pub struct GpsBricklet {
    device: Device,
}
impl GpsBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 222;
    pub const DEVICE_DISPLAY_NAME: &'static str = "GPS Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> GpsBricklet {
        let mut result = GpsBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(GpsBrickletFunction::GetCoordinates) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetAltitude) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetMotion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetDateTime) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::Restart) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsBrickletFunction::SetCoordinatesCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetCoordinatesCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::SetStatusCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetStatusCallbackPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::SetAltitudeCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetAltitudeCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::SetMotionCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetMotionCallbackPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::SetDateTimeCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetDateTimeCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::gps_bricklet::GpsBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::gps_bricklet::GpsBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: GpsBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: GpsBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_coordinates_callback_period`]. The parameters are the same
    /// as for [`get_coordinates`].
    ///
    /// The [`get_coordinates_callback_receiver`] receiver is only triggered if the coordinates changed
    /// since the last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    ///
    /// [`get_coordinates`]: #method.get_coordinates
    /// [`get_status`]: #method.get_status
    /// [`set_coordinates_callback_period`]: #method.set_coordinates_callback_period
    /// [`get_coordinates_callback_receiver`]: #method.get_coordinates_callback_receiver
    pub fn get_coordinates_callback_receiver(&self) -> ConvertingCallbackReceiver<CoordinatesEvent> {
        self.device.get_callback_receiver(u8::from(GpsBrickletFunction::CallbackCoordinates))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_status_callback_period`]. The parameters are the same
    /// as for [`get_status`].
    ///
    /// The [`get_status_callback_receiver`] receiver is only triggered if the status changed since the
    /// last triggering.
    pub fn get_status_callback_receiver(&self) -> ConvertingCallbackReceiver<StatusEvent> {
        self.device.get_callback_receiver(u8::from(GpsBrickletFunction::CallbackStatus))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_altitude_callback_period`]. The parameters are the same
    /// as for [`get_altitude`].
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude changed since
    /// the last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_altitude_callback_receiver(&self) -> ConvertingCallbackReceiver<AltitudeEvent> {
        self.device.get_callback_receiver(u8::from(GpsBrickletFunction::CallbackAltitude))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_motion_callback_period`]. The parameters are the same
    /// as for [`get_motion`].
    ///
    /// The [`get_motion_callback_receiver`] receiver is only triggered if the motion changed since the
    /// last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_motion_callback_receiver(&self) -> ConvertingCallbackReceiver<MotionEvent> {
        self.device.get_callback_receiver(u8::from(GpsBrickletFunction::CallbackMotion))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_date_time_callback_period`]. The parameters are the same
    /// as for [`get_date_time`].
    ///
    /// The [`get_date_time_callback_receiver`] receiver is only triggered if the date or time changed
    /// since the last triggering.
    pub fn get_date_time_callback_receiver(&self) -> ConvertingCallbackReceiver<DateTimeEvent> {
        self.device.get_callback_receiver(u8::from(GpsBrickletFunction::CallbackDateTime))
    }

    /// Returns the GPS coordinates. Latitude and longitude are given in the
    /// [`DD.dddddd°`` format, the value 57123468 means 57.123468°.
    /// The parameter ``ns`` and ``ew`` are the cardinal directions for
    /// latitude and longitude. Possible values for ``ns`` and ``ew`` are 'N', 'S', 'E'
    /// and 'W' (north, south, east and west).
    ///
    /// PDOP, HDOP and VDOP are the dilution of precision (DOP) values. They specify
    /// the additional multiplicative effect of GPS satellite geometry on GPS
    /// precision. See
    /// `here](https://en.wikipedia.org/wiki/Dilution_of_precision_(GPS))__
    /// for more information.
    ///
    /// EPE is the Estimated Position Error. This is not the
    /// absolute maximum error, it is the error with a specific confidence. See
    /// [here](https://www.nps.gov/gis/gps/WhatisEPE.html)__ for more information.
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_coordinates(&self) -> ConvertingReceiver<Coordinates> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetCoordinates), payload)
    }

    /// Returns the current fix status, the number of satellites that are in view and
    /// the number of satellites that are currently used.
    ///
    /// Possible fix status values can be:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  1| No Fix| :func:[Get Coordinates`| [`get_altitude`] and [`get_motion`] return invalid data
    ///  2| 2D Fix| only [`get_coordinates`] and [`get_motion`] return valid data
    ///  3| 3D Fix| [`get_coordinates`]| [`get_altitude`] and [`get_motion`] return valid data
    ///
    /// There is also a `blue LED](gps_bricklet_fix_led) on the Bricklet that
    /// indicates the fix status.
    ///
    /// Associated constants:
    /// * GPS_BRICKLET_FIX_NO_FIX
    ///	* GPS_BRICKLET_FIX_2D_FIX
    ///	* GPS_BRICKLET_FIX_3D_FIX
    pub fn get_status(&self) -> ConvertingReceiver<Status> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetStatus), payload)
    }

    /// Returns the current altitude and corresponding geoidal separation.
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_altitude(&self) -> ConvertingReceiver<Altitude> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetAltitude), payload)
    }

    /// Returns the current course and speed. A course of 0° means the Bricklet is
    /// traveling north bound and 90° means it is traveling east bound.
    ///
    /// Please note that this only returns useful values if an actual movement
    /// is present.
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_motion(&self) -> ConvertingReceiver<Motion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetMotion), payload)
    }

    /// Returns the current date and time. The date is
    /// given in the format ``ddmmyy`` and the time is given
    /// in the format ``hhmmss.sss``. For example, 140713 means
    /// 14.07.13 as date and 195923568 means 19:59:23.568 as time.
    pub fn get_date_time(&self) -> ConvertingReceiver<DateTime> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetDateTime), payload)
    }

    /// Restarts the GPS Bricklet, the following restart types are available:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0| Hot start (use all available data in the NV store)
    ///  1| Warm start (don't use ephemeris at restart)
    ///  2| Cold start (don't use time| position| almanacs and ephemeris at restart)
    ///  3| Factory reset (clear all system/user configurations at restart)
    ///
    /// Associated constants:
    /// * GPS_BRICKLET_RESTART_TYPE_HOT_START
    ///	* GPS_BRICKLET_RESTART_TYPE_WARM_START
    ///	* GPS_BRICKLET_RESTART_TYPE_COLD_START
    ///	* GPS_BRICKLET_RESTART_TYPE_FACTORY_RESET
    pub fn restart(&self, restart_type: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(restart_type));

        self.device.set(u8::from(GpsBrickletFunction::Restart), payload)
    }

    /// Sets the period with which the [`get_coordinates_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_coordinates_callback_receiver`] receiver is only triggered if the coordinates changed
    /// since the last triggering.
    pub fn set_coordinates_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsBrickletFunction::SetCoordinatesCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_coordinates_callback_period`].
    pub fn get_coordinates_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetCoordinatesCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_status_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_status_callback_receiver`] receiver is only triggered if the status changed since the
    /// last triggering.
    pub fn set_status_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsBrickletFunction::SetStatusCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_status_callback_period`].
    pub fn get_status_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetStatusCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_altitude_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude changed since
    /// the last triggering.
    pub fn set_altitude_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsBrickletFunction::SetAltitudeCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_altitude_callback_period`].
    pub fn get_altitude_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetAltitudeCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_motion_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_motion_callback_receiver`] receiver is only triggered if the motion changed since the
    /// last triggering.
    pub fn set_motion_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsBrickletFunction::SetMotionCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_motion_callback_period`].
    pub fn get_motion_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetMotionCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_date_time_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_date_time_callback_receiver`] receiver is only triggered if the date or time changed
    /// since the last triggering.
    pub fn set_date_time_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsBrickletFunction::SetDateTimeCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_date_time_callback_period`].
    pub fn get_date_time_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetDateTimeCallbackPeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsBrickletFunction::GetIdentity), payload)
    }
}
