/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Three color 296x128 e-paper display.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/EPaper296x128_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum EPaper296x128BrickletFunction {
    Draw,
    GetDrawStatus,
    WriteBlackWhiteLowLevel,
    ReadBlackWhiteLowLevel,
    WriteColorLowLevel,
    ReadColorLowLevel,
    FillDisplay,
    DrawText,
    DrawLine,
    DrawBox,
    SetUpdateMode,
    GetUpdateMode,
    SetDisplayType,
    GetDisplayType,
    SetDisplayDriver,
    GetDisplayDriver,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackDrawStatus,
}
impl From<EPaper296x128BrickletFunction> for u8 {
    fn from(fun: EPaper296x128BrickletFunction) -> Self {
        match fun {
            EPaper296x128BrickletFunction::Draw => 1,
            EPaper296x128BrickletFunction::GetDrawStatus => 2,
            EPaper296x128BrickletFunction::WriteBlackWhiteLowLevel => 3,
            EPaper296x128BrickletFunction::ReadBlackWhiteLowLevel => 4,
            EPaper296x128BrickletFunction::WriteColorLowLevel => 5,
            EPaper296x128BrickletFunction::ReadColorLowLevel => 6,
            EPaper296x128BrickletFunction::FillDisplay => 7,
            EPaper296x128BrickletFunction::DrawText => 8,
            EPaper296x128BrickletFunction::DrawLine => 9,
            EPaper296x128BrickletFunction::DrawBox => 10,
            EPaper296x128BrickletFunction::SetUpdateMode => 12,
            EPaper296x128BrickletFunction::GetUpdateMode => 13,
            EPaper296x128BrickletFunction::SetDisplayType => 14,
            EPaper296x128BrickletFunction::GetDisplayType => 15,
            EPaper296x128BrickletFunction::SetDisplayDriver => 16,
            EPaper296x128BrickletFunction::GetDisplayDriver => 17,
            EPaper296x128BrickletFunction::GetSpitfpErrorCount => 234,
            EPaper296x128BrickletFunction::SetBootloaderMode => 235,
            EPaper296x128BrickletFunction::GetBootloaderMode => 236,
            EPaper296x128BrickletFunction::SetWriteFirmwarePointer => 237,
            EPaper296x128BrickletFunction::WriteFirmware => 238,
            EPaper296x128BrickletFunction::SetStatusLedConfig => 239,
            EPaper296x128BrickletFunction::GetStatusLedConfig => 240,
            EPaper296x128BrickletFunction::GetChipTemperature => 242,
            EPaper296x128BrickletFunction::Reset => 243,
            EPaper296x128BrickletFunction::WriteUid => 248,
            EPaper296x128BrickletFunction::ReadUid => 249,
            EPaper296x128BrickletFunction::GetIdentity => 255,
            EPaper296x128BrickletFunction::CallbackDrawStatus => 11,
        }
    }
}
pub const E_PAPER_296X128_BRICKLET_DRAW_STATUS_IDLE: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_DRAW_STATUS_COPYING: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_DRAW_STATUS_DRAWING: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_COLOR_BLACK: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_COLOR_WHITE: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_COLOR_RED: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_COLOR_GRAY: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_FONT_6X8: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_FONT_6X16: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_FONT_6X24: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_FONT_6X32: u8 = 3;
pub const E_PAPER_296X128_BRICKLET_FONT_12X16: u8 = 4;
pub const E_PAPER_296X128_BRICKLET_FONT_12X24: u8 = 5;
pub const E_PAPER_296X128_BRICKLET_FONT_12X32: u8 = 6;
pub const E_PAPER_296X128_BRICKLET_FONT_18X24: u8 = 7;
pub const E_PAPER_296X128_BRICKLET_FONT_18X32: u8 = 8;
pub const E_PAPER_296X128_BRICKLET_FONT_24X32: u8 = 9;
pub const E_PAPER_296X128_BRICKLET_ORIENTATION_HORIZONTAL: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_ORIENTATION_VERTICAL: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_UPDATE_MODE_DEFAULT: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_UPDATE_MODE_BLACK_WHITE: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_UPDATE_MODE_DELTA: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_RED: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_GRAY: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1675A: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1680: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteBlackWhiteLowLevel {}
impl FromByteSlice for WriteBlackWhiteLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> WriteBlackWhiteLowLevel { WriteBlackWhiteLowLevel {} }
}
impl LowLevelWrite<WriteBlackWhiteResult> for WriteBlackWhiteLowLevel {
    fn ll_message_written(&self) -> usize { 432 }

    fn get_result(&self) -> WriteBlackWhiteResult { WriteBlackWhiteResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadBlackWhiteLowLevel {
    pub pixels_length: u16,
    pub pixels_chunk_offset: u16,
    pub pixels_chunk_data: [bool; 464],
}
impl FromByteSlice for ReadBlackWhiteLowLevel {
    fn bytes_expected() -> usize { 62 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadBlackWhiteLowLevel {
        ReadBlackWhiteLowLevel {
            pixels_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            pixels_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            pixels_chunk_data: <[bool; 464]>::from_le_byte_slice(&bytes[4..62]),
        }
    }
}
impl LowLevelRead<bool, ReadBlackWhiteResult> for ReadBlackWhiteLowLevel {
    fn ll_message_length(&self) -> usize { self.pixels_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.pixels_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.pixels_chunk_data }

    fn get_result(&self) -> ReadBlackWhiteResult { ReadBlackWhiteResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteColorLowLevel {}
impl FromByteSlice for WriteColorLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> WriteColorLowLevel { WriteColorLowLevel {} }
}
impl LowLevelWrite<WriteColorResult> for WriteColorLowLevel {
    fn ll_message_written(&self) -> usize { 432 }

    fn get_result(&self) -> WriteColorResult { WriteColorResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadColorLowLevel {
    pub pixels_length: u16,
    pub pixels_chunk_offset: u16,
    pub pixels_chunk_data: [bool; 464],
}
impl FromByteSlice for ReadColorLowLevel {
    fn bytes_expected() -> usize { 62 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadColorLowLevel {
        ReadColorLowLevel {
            pixels_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            pixels_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            pixels_chunk_data: <[bool; 464]>::from_le_byte_slice(&bytes[4..62]),
        }
    }
}
impl LowLevelRead<bool, ReadColorResult> for ReadColorLowLevel {
    fn ll_message_length(&self) -> usize { self.pixels_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.pixels_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.pixels_chunk_data }

    fn get_result(&self) -> ReadColorResult { ReadColorResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteBlackWhiteResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadBlackWhiteResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteColorResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadColorResult {}

/// Three color 296x128 e-paper display
#[derive(Clone)]
pub struct EPaper296x128Bricklet {
    device: Device,
}
impl EPaper296x128Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2146;
    pub const DEVICE_DISPLAY_NAME: &'static str = "E-Paper 296x128 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> EPaper296x128Bricklet {
        let mut result = EPaper296x128Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 4) };
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::Draw) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetDrawStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::WriteBlackWhiteLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::ReadBlackWhiteLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::WriteColorLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::ReadColorLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::FillDisplay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::DrawText) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::DrawLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::DrawBox) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetUpdateMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetUpdateMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetDisplayType) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetDisplayType) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetDisplayDriver) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetDisplayDriver) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(EPaper296x128BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::e_paper_296x128_bricklet::EPaper296x128Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::e_paper_296x128_bricklet::EPaper296x128Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: EPaper296x128BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: EPaper296x128BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Receiver for the current draw status. Will be called every time the
    /// draw status changes (see [`get_draw_status`]).
    ///
    /// [`get_draw_status`]: #method.get_draw_status
    pub fn get_draw_status_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(EPaper296x128BrickletFunction::CallbackDrawStatus))
    }

    /// Draws the current black/white and red or gray buffer to the e-paper display.
    ///
    /// The Bricklet does not have any double-buffering. You should not call
    /// this function while writing to the buffer. See [`get_draw_status`].
    pub fn draw(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(EPaper296x128BrickletFunction::Draw), payload)
    }

    /// Returns one of three draw statuses:
    ///
    /// * Idle
    /// * Copying: Data is being copied from the buffer of the Bricklet to the buffer of the display.
    /// * Drawing: The display is updating its content (during this phase the flickering etc happens).
    ///
    /// You can write to the buffer (through one of the write or draw functions) when the status is
    /// either *idle* or *drawing*. You should not write to the buffer while it is being *copied* to the
    /// display. There is no double-buffering.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_DRAW_STATUS_IDLE
    ///	* E_PAPER_296X128_BRICKLET_DRAW_STATUS_COPYING
    ///	* E_PAPER_296X128_BRICKLET_DRAW_STATUS_DRAWING
    pub fn get_draw_status(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetDrawStatus), payload)
    }

    /// Writes black/white pixels to the specified window into the buffer.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The value 0 (false) corresponds to a black pixel and the value 1 (true) to a
    /// white pixel.
    ///
    /// This function writes the pixels into the black/white pixel buffer, to draw the
    /// buffer to the display use [`draw`].
    ///
    /// Use [`write_color`] to write red or gray pixels.
    pub fn write_black_white_low_level(
        &self,
        x_start: u16,
        y_start: u8,
        x_end: u16,
        y_end: u8,
        pixels_length: u16,
        pixels_chunk_offset: u16,
        pixels_chunk_data: [bool; 432],
    ) -> ConvertingReceiver<WriteBlackWhiteLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(y_end));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(pixels_length));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(pixels_chunk_offset));
        payload[10..64].copy_from_slice(&<[bool; 432]>::to_le_byte_vec(pixels_chunk_data));

        self.device.set(u8::from(EPaper296x128BrickletFunction::WriteBlackWhiteLowLevel), payload)
    }

    /// Writes black/white pixels to the specified window into the buffer.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The value 0 (false) corresponds to a black pixel and the value 1 (true) to a
    /// white pixel.
    ///
    /// This function writes the pixels into the black/white pixel buffer, to draw the
    /// buffer to the display use [`draw`].
    ///
    /// Use [`write_color`] to write red or gray pixels.
    pub fn write_black_white(
        &self,
        x_start: u16,
        y_start: u8,
        x_end: u16,
        y_end: u8,
        pixels: &[bool],
    ) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(0, pixels, 65535, 432, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 432];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result =
                self.write_black_white_low_level(x_start, y_start, x_end, y_end, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Returns the current content of the black/white pixel buffer for the specified window.
    ///
    /// The pixels are read into the window line by line top to bottom and
    /// each line is read from left to right.
    ///
    /// The current content of the buffer does not have to be the current content of the display.
    /// It is possible that the data was not drawn to the display yet and after a restart of
    /// the Bricklet the buffer will be reset to black, while the display retains its content.
    pub fn read_black_white_low_level(
        &self,
        x_start: u16,
        y_start: u8,
        x_end: u16,
        y_end: u8,
    ) -> ConvertingReceiver<ReadBlackWhiteLowLevel> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(y_end));

        self.device.get(u8::from(EPaper296x128BrickletFunction::ReadBlackWhiteLowLevel), payload)
    }

    /// Returns the current content of the black/white pixel buffer for the specified window.
    ///
    /// The pixels are read into the window line by line top to bottom and
    /// each line is read from left to right.
    ///
    /// The current content of the buffer does not have to be the current content of the display.
    /// It is possible that the data was not drawn to the display yet and after a restart of
    /// the Bricklet the buffer will be reset to black, while the display retains its content.
    pub fn read_black_white(&self, x_start: u16, y_start: u8, x_end: u16, y_end: u8) -> Result<Vec<bool>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_black_white_low_level(x_start, y_start, x_end, y_end).recv())?;
        Ok(ll_result.0)
    }

    /// The E-Paper 296x128 Bricklet is available with the colors black/white/red and
    /// black/white/gray. Depending on the model this function writes either red or
    /// gray pixels to the specified window into the buffer.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The value 0 (false) means that this pixel does not have color. It will be either black
    /// or white (see [`write_black_white`]). The value 1 (true) corresponds to a red or gray
    /// pixel, depending on the Bricklet model.
    ///
    /// This function writes the pixels into the red or gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// Use [`write_black_white`] to write black/white pixels.
    pub fn write_color_low_level(
        &self,
        x_start: u16,
        y_start: u8,
        x_end: u16,
        y_end: u8,
        pixels_length: u16,
        pixels_chunk_offset: u16,
        pixels_chunk_data: [bool; 432],
    ) -> ConvertingReceiver<WriteColorLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(y_end));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(pixels_length));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(pixels_chunk_offset));
        payload[10..64].copy_from_slice(&<[bool; 432]>::to_le_byte_vec(pixels_chunk_data));

        self.device.set(u8::from(EPaper296x128BrickletFunction::WriteColorLowLevel), payload)
    }

    /// The E-Paper 296x128 Bricklet is available with the colors black/white/red and
    /// black/white/gray. Depending on the model this function writes either red or
    /// gray pixels to the specified window into the buffer.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The value 0 (false) means that this pixel does not have color. It will be either black
    /// or white (see [`write_black_white`]). The value 1 (true) corresponds to a red or gray
    /// pixel, depending on the Bricklet model.
    ///
    /// This function writes the pixels into the red or gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// Use [`write_black_white`] to write black/white pixels.
    pub fn write_color(&self, x_start: u16, y_start: u8, x_end: u16, y_end: u8, pixels: &[bool]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(2, pixels, 65535, 432, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 432];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.write_color_low_level(x_start, y_start, x_end, y_end, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Returns the current content of the red or gray pixel buffer for the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The current content of the buffer does not have to be the current content of the display.
    /// It is possible that the data was not drawn to the display yet and after a restart of
    /// the Bricklet the buffer will be reset to black, while the display retains its content.
    pub fn read_color_low_level(&self, x_start: u16, y_start: u8, x_end: u16, y_end: u8) -> ConvertingReceiver<ReadColorLowLevel> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(y_end));

        self.device.get(u8::from(EPaper296x128BrickletFunction::ReadColorLowLevel), payload)
    }

    /// Returns the current content of the red or gray pixel buffer for the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// The current content of the buffer does not have to be the current content of the display.
    /// It is possible that the data was not drawn to the display yet and after a restart of
    /// the Bricklet the buffer will be reset to black, while the display retains its content.
    pub fn read_color(&self, x_start: u16, y_start: u8, x_end: u16, y_end: u8) -> Result<Vec<bool>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(3, &mut || self.read_color_low_level(x_start, y_start, x_end, y_end).recv())?;
        Ok(ll_result.0)
    }

    /// Fills the complete content of the display with the given color.
    ///
    /// This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_COLOR_BLACK
    ///	* E_PAPER_296X128_BRICKLET_COLOR_WHITE
    ///	* E_PAPER_296X128_BRICKLET_COLOR_RED
    ///	* E_PAPER_296X128_BRICKLET_COLOR_GRAY
    pub fn fill_display(&self, color: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(color));

        self.device.set(u8::from(EPaper296x128BrickletFunction::FillDisplay), payload)
    }

    /// Draws a text with up to 50 characters at the pixel position (x, y).
    ///
    /// You can use one of 9 different font sizes and draw the text in
    /// black/white/red|gray. The text can be drawn horizontal or vertical.
    ///
    /// This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// The font conforms to code page 437.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_FONT_6X8
    ///	* E_PAPER_296X128_BRICKLET_FONT_6X16
    ///	* E_PAPER_296X128_BRICKLET_FONT_6X24
    ///	* E_PAPER_296X128_BRICKLET_FONT_6X32
    ///	* E_PAPER_296X128_BRICKLET_FONT_12X16
    ///	* E_PAPER_296X128_BRICKLET_FONT_12X24
    ///	* E_PAPER_296X128_BRICKLET_FONT_12X32
    ///	* E_PAPER_296X128_BRICKLET_FONT_18X24
    ///	* E_PAPER_296X128_BRICKLET_FONT_18X32
    ///	* E_PAPER_296X128_BRICKLET_FONT_24X32
    ///	* E_PAPER_296X128_BRICKLET_COLOR_BLACK
    ///	* E_PAPER_296X128_BRICKLET_COLOR_WHITE
    ///	* E_PAPER_296X128_BRICKLET_COLOR_RED
    ///	* E_PAPER_296X128_BRICKLET_COLOR_GRAY
    ///	* E_PAPER_296X128_BRICKLET_ORIENTATION_HORIZONTAL
    ///	* E_PAPER_296X128_BRICKLET_ORIENTATION_VERTICAL
    pub fn draw_text(&self, position_x: u16, position_y: u8, font: u8, color: u8, orientation: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 56];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(position_x));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_y));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(font));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(color));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(orientation));
        match <String>::try_to_le_byte_vec(text, 50) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[6..56].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(EPaper296x128BrickletFunction::DrawText), payload)
    }

    /// Draws a line from (x, y)-start to (x, y)-end in the given color.
    ///
    /// This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_COLOR_BLACK
    ///	* E_PAPER_296X128_BRICKLET_COLOR_WHITE
    ///	* E_PAPER_296X128_BRICKLET_COLOR_RED
    ///	* E_PAPER_296X128_BRICKLET_COLOR_GRAY
    pub fn draw_line(
        &self,
        position_x_start: u16,
        position_y_start: u8,
        position_x_end: u16,
        position_y_end: u8,
        color: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(position_x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(position_x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(position_y_end));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(color));

        self.device.set(u8::from(EPaper296x128BrickletFunction::DrawLine), payload)
    }

    /// Draws a box from (x, y)-start to (x, y)-end in the given color.
    ///
    /// If you set fill to true, the box will be filled with the
    /// color. Otherwise only the outline will be drawn.
    ///
    /// This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
    /// to the display use [`draw`].
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_COLOR_BLACK
    ///	* E_PAPER_296X128_BRICKLET_COLOR_WHITE
    ///	* E_PAPER_296X128_BRICKLET_COLOR_RED
    ///	* E_PAPER_296X128_BRICKLET_COLOR_GRAY
    pub fn draw_box(
        &self,
        position_x_start: u16,
        position_y_start: u8,
        position_x_end: u16,
        position_y_end: u8,
        fill: bool,
        color: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 8];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(position_x_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(position_y_start));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(position_x_end));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(position_y_end));
        payload[6..7].copy_from_slice(&<bool>::to_le_byte_vec(fill));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(color));

        self.device.set(u8::from(EPaper296x128BrickletFunction::DrawBox), payload)
    }

    /// # Note
    ///  The default update mode corresponds to the default e-paper display
    ///  manufacturer settings. All of the other modes are experimental and
    ///  will result in increased ghosting and possibly other long-term
    ///  side effects.
    ///
    ///  If you want to know more about the inner workings of an e-paper display
    ///  take a look at this excellent video from Ben Krasnow:
    ///  [https://www.youtube.com/watch?v=MsbiO8EAsGw](https://www.youtube.com/watch?v=MsbiO8EAsGw)__.
    ///
    ///  If you are not sure about this option, leave the update mode at default.
    ///
    /// Currently there are three update modes available:
    ///
    /// * Default: Settings as given by the manufacturer. An update will take about
    ///   7.5 seconds and during the update the screen will flicker several times.
    /// * Black/White: This will only update the black/white pixel. It uses the manufacturer
    ///   settings for black/white and ignores the red or gray pixel buffer. With this mode the
    ///   display will flicker once and it takes about 2.5 seconds. Compared to the default settings
    ///   there is more ghosting.
    /// * Delta: This will only update the black/white pixel. It uses an aggressive method where
    ///   the changes are not applied for a whole buffer but only for the delta between the last
    ///   and the next buffer. With this mode the display will not flicker during an update and
    ///   it takes about 900-950ms. Compared to the other two settings there is more ghosting. This
    ///   mode can be used for something like a flicker-free live update of a text.
    ///
    /// With the black/white/red display if you use either the black/white or the delta mode,
    /// after a while of going back and forth between black and white the white color will
    /// start to appear red-ish or pink-ish.
    ///
    /// If you use the aggressive delta mode and rapidly change the content, we recommend that you
    /// change back to the default mode every few hours and in the default mode cycle between the
    /// three available colors a few times. This will get rid of the ghosting and after that you can
    /// go back to the delta mode with flicker-free updates.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_UPDATE_MODE_DEFAULT
    ///	* E_PAPER_296X128_BRICKLET_UPDATE_MODE_BLACK_WHITE
    ///	* E_PAPER_296X128_BRICKLET_UPDATE_MODE_DELTA
    pub fn set_update_mode(&self, update_mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(update_mode));

        self.device.set(u8::from(EPaper296x128BrickletFunction::SetUpdateMode), payload)
    }

    /// Returns the update mode as set by [`set_update_mode`].
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_UPDATE_MODE_DEFAULT
    ///	* E_PAPER_296X128_BRICKLET_UPDATE_MODE_BLACK_WHITE
    ///	* E_PAPER_296X128_BRICKLET_UPDATE_MODE_DELTA
    pub fn get_update_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetUpdateMode), payload)
    }

    /// Sets the type of the display. The e-paper display is available
    /// in black/white/red and black/white/gray. This will be factory set
    /// during the flashing and testing phase. The value is saved in
    /// non-volatile memory and will stay after a power cycle.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_RED
    ///	* E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_GRAY
    pub fn set_display_type(&self, display_type: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(display_type));

        self.device.set(u8::from(EPaper296x128BrickletFunction::SetDisplayType), payload)
    }

    /// Returns the type of the e-paper display. It can either be
    /// black/white/red or black/white/gray.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_RED
    ///	* E_PAPER_296X128_BRICKLET_DISPLAY_TYPE_BLACK_WHITE_GRAY
    pub fn get_display_type(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetDisplayType), payload)
    }

    /// Sets the type of display driver. The Bricklet can currently support
    /// SSD1675A and SSD1680. This will be factory set
    /// during the flashing and testing phase. The value is saved in
    /// non-volatile memory and will stay after a power cycle.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1675A
    ///	* E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1680
    pub fn set_display_driver(&self, display_driver: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(display_driver));

        self.device.set(u8::from(EPaper296x128BrickletFunction::SetDisplayDriver), payload)
    }

    /// Returns the e-paper display driver.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1675A
    ///	* E_PAPER_296X128_BRICKLET_DISPLAY_DRIVER_SSD1680
    pub fn get_display_driver(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetDisplayDriver), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(EPaper296x128BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* E_PAPER_296X128_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(EPaper296x128BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(EPaper296x128BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(EPaper296x128BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* E_PAPER_296X128_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(EPaper296x128BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(EPaper296x128BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(EPaper296x128BrickletFunction::GetIdentity), payload)
    }
}
