/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Two tactile buttons with built-in blue LEDs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DualButton_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DualButtonBrickletFunction {
    SetLedState,
    GetLedState,
    GetButtonState,
    SetSelectedLedState,
    GetIdentity,
    CallbackStateChanged,
}
impl From<DualButtonBrickletFunction> for u8 {
    fn from(fun: DualButtonBrickletFunction) -> Self {
        match fun {
            DualButtonBrickletFunction::SetLedState => 1,
            DualButtonBrickletFunction::GetLedState => 2,
            DualButtonBrickletFunction::GetButtonState => 3,
            DualButtonBrickletFunction::SetSelectedLedState => 5,
            DualButtonBrickletFunction::GetIdentity => 255,
            DualButtonBrickletFunction::CallbackStateChanged => 4,
        }
    }
}
pub const DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_ON: u8 = 0;
pub const DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF: u8 = 1;
pub const DUAL_BUTTON_BRICKLET_LED_STATE_ON: u8 = 2;
pub const DUAL_BUTTON_BRICKLET_LED_STATE_OFF: u8 = 3;
pub const DUAL_BUTTON_BRICKLET_BUTTON_STATE_PRESSED: u8 = 0;
pub const DUAL_BUTTON_BRICKLET_BUTTON_STATE_RELEASED: u8 = 1;
pub const DUAL_BUTTON_BRICKLET_LED_LEFT: u8 = 0;
pub const DUAL_BUTTON_BRICKLET_LED_RIGHT: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LedState {
    pub led_l: u8,
    pub led_r: u8,
}
impl FromByteSlice for LedState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> LedState {
        LedState { led_l: <u8>::from_le_byte_slice(&bytes[0..1]), led_r: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ButtonState {
    pub button_l: u8,
    pub button_r: u8,
}
impl FromByteSlice for ButtonState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ButtonState {
        ButtonState { button_l: <u8>::from_le_byte_slice(&bytes[0..1]), button_r: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StateChangedEvent {
    pub button_l: u8,
    pub button_r: u8,
    pub led_l: u8,
    pub led_r: u8,
}
impl FromByteSlice for StateChangedEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> StateChangedEvent {
        StateChangedEvent {
            button_l: <u8>::from_le_byte_slice(&bytes[0..1]),
            button_r: <u8>::from_le_byte_slice(&bytes[1..2]),
            led_l: <u8>::from_le_byte_slice(&bytes[2..3]),
            led_r: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Two tactile buttons with built-in blue LEDs
#[derive(Clone)]
pub struct DualButtonBricklet {
    device: Device,
}
impl DualButtonBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 230;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Dual Button Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DualButtonBricklet {
        let mut result = DualButtonBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DualButtonBrickletFunction::SetLedState) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonBrickletFunction::GetLedState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonBrickletFunction::GetButtonState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonBrickletFunction::SetSelectedLedState) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dual_button_bricklet::DualButtonBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dual_button_bricklet::DualButtonBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DualButtonBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: DualButtonBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called whenever a button is pressed.
    ///
    /// Possible states for buttons are:
    ///
    /// * 0 = pressed
    /// * 1 = released
    ///
    /// Possible states for LEDs are:
    ///
    /// * 0 = AutoToggleOn: Auto toggle enabled and LED on.
    /// * 1 = AutoToggleOff: Auto toggle enabled and LED off.
    /// * 2 = On: LED on (auto toggle is disabled).
    /// * 3 = Off: LED off (auto toggle is disabled).
    pub fn get_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<StateChangedEvent> {
        self.device.get_callback_receiver(u8::from(DualButtonBrickletFunction::CallbackStateChanged))
    }

    /// Sets the state of the LEDs. Possible states are:
    ///
    /// * 0 = AutoToggleOn: Enables auto toggle with initially enabled LED.
    /// * 1 = AutoToggleOff: Activates auto toggle with initially disabled LED.
    /// * 2 = On: Enables LED (auto toggle is disabled).
    /// * 3 = Off: Disables LED (auto toggle is disabled).
    ///
    /// In auto toggle mode the LED is toggled automatically at each press of a button.
    ///
    /// If you just want to set one of the LEDs and don't know the current state
    /// of the other LED, you can get the state with [`get_led_state`] or you
    /// can use [`set_selected_led_state`].
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_OFF
    pub fn set_led_state(&self, led_l: u8, led_r: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(led_l));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(led_r));

        self.device.set(u8::from(DualButtonBrickletFunction::SetLedState), payload)
    }

    /// Returns the current state of the LEDs, as set by [`set_led_state`].
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_OFF
    pub fn get_led_state(&self) -> ConvertingReceiver<LedState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonBrickletFunction::GetLedState), payload)
    }

    /// Returns the current state for both buttons. Possible states are:
    ///
    /// * 0 = pressed
    /// * 1 = released
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_BRICKLET_BUTTON_STATE_PRESSED
    ///	* DUAL_BUTTON_BRICKLET_BUTTON_STATE_RELEASED
    pub fn get_button_state(&self) -> ConvertingReceiver<ButtonState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonBrickletFunction::GetButtonState), payload)
    }

    /// Sets the state of the selected LED (0 or 1).
    ///
    /// The other LED remains untouched.
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_BRICKLET_LED_LEFT
    ///	* DUAL_BUTTON_BRICKLET_LED_RIGHT
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_BRICKLET_LED_STATE_OFF
    pub fn set_selected_led_state(&self, led: u8, state: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(led));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(state));

        self.device.set(u8::from(DualButtonBrickletFunction::SetSelectedLedState), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonBrickletFunction::GetIdentity), payload)
    }
}
