/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! DMX master and slave.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DMX_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum DmxBrickletFunction {
    SetDmxMode,
    GetDmxMode,
    WriteFrameLowLevel,
    ReadFrameLowLevel,
    SetFrameDuration,
    GetFrameDuration,
    GetFrameErrorCount,
    SetCommunicationLedConfig,
    GetCommunicationLedConfig,
    SetErrorLedConfig,
    GetErrorLedConfig,
    SetFrameCallbackConfig,
    GetFrameCallbackConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackFrameStarted,
    CallbackFrameAvailable,
    CallbackFrameLowLevel,
    CallbackFrameErrorCount,
}
impl From<DmxBrickletFunction> for u8 {
    fn from(fun: DmxBrickletFunction) -> Self {
        match fun {
            DmxBrickletFunction::SetDmxMode => 1,
            DmxBrickletFunction::GetDmxMode => 2,
            DmxBrickletFunction::WriteFrameLowLevel => 3,
            DmxBrickletFunction::ReadFrameLowLevel => 4,
            DmxBrickletFunction::SetFrameDuration => 5,
            DmxBrickletFunction::GetFrameDuration => 6,
            DmxBrickletFunction::GetFrameErrorCount => 7,
            DmxBrickletFunction::SetCommunicationLedConfig => 8,
            DmxBrickletFunction::GetCommunicationLedConfig => 9,
            DmxBrickletFunction::SetErrorLedConfig => 10,
            DmxBrickletFunction::GetErrorLedConfig => 11,
            DmxBrickletFunction::SetFrameCallbackConfig => 12,
            DmxBrickletFunction::GetFrameCallbackConfig => 13,
            DmxBrickletFunction::GetSpitfpErrorCount => 234,
            DmxBrickletFunction::SetBootloaderMode => 235,
            DmxBrickletFunction::GetBootloaderMode => 236,
            DmxBrickletFunction::SetWriteFirmwarePointer => 237,
            DmxBrickletFunction::WriteFirmware => 238,
            DmxBrickletFunction::SetStatusLedConfig => 239,
            DmxBrickletFunction::GetStatusLedConfig => 240,
            DmxBrickletFunction::GetChipTemperature => 242,
            DmxBrickletFunction::Reset => 243,
            DmxBrickletFunction::WriteUid => 248,
            DmxBrickletFunction::ReadUid => 249,
            DmxBrickletFunction::GetIdentity => 255,
            DmxBrickletFunction::CallbackFrameStarted => 14,
            DmxBrickletFunction::CallbackFrameAvailable => 15,
            DmxBrickletFunction::CallbackFrameLowLevel => 16,
            DmxBrickletFunction::CallbackFrameErrorCount => 17,
        }
    }
}
pub const DMX_BRICKLET_DMX_MODE_MASTER: u8 = 0;
pub const DMX_BRICKLET_DMX_MODE_SLAVE: u8 = 1;
pub const DMX_BRICKLET_COMMUNICATION_LED_CONFIG_OFF: u8 = 0;
pub const DMX_BRICKLET_COMMUNICATION_LED_CONFIG_ON: u8 = 1;
pub const DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION: u8 = 3;
pub const DMX_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const DMX_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 3;
pub const DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const DMX_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const DMX_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const DMX_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteFrameLowLevel {}
impl FromByteSlice for WriteFrameLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> WriteFrameLowLevel { WriteFrameLowLevel {} }
}
impl LowLevelWrite<WriteFrameResult> for WriteFrameLowLevel {
    fn ll_message_written(&self) -> usize { 60 }

    fn get_result(&self) -> WriteFrameResult { WriteFrameResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadFrameLowLevel {
    pub frame_length: u16,
    pub frame_chunk_offset: u16,
    pub frame_chunk_data: [u8; 56],
    pub frame_number: u32,
}
impl FromByteSlice for ReadFrameLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFrameLowLevel {
        ReadFrameLowLevel {
            frame_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            frame_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            frame_chunk_data: <[u8; 56]>::from_le_byte_slice(&bytes[4..60]),
            frame_number: <u32>::from_le_byte_slice(&bytes[60..64]),
        }
    }
}
impl LowLevelRead<u8, ReadFrameResult> for ReadFrameLowLevel {
    fn ll_message_length(&self) -> usize { self.frame_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.frame_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.frame_chunk_data }

    fn get_result(&self) -> ReadFrameResult { ReadFrameResult { frame_number: self.frame_number } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameErrorCount {
    pub overrun_error_count: u32,
    pub framing_error_count: u32,
}
impl FromByteSlice for FrameErrorCount {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameErrorCount {
        FrameErrorCount {
            overrun_error_count: <u32>::from_le_byte_slice(&bytes[0..4]),
            framing_error_count: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameCallbackConfig {
    pub frame_started_callback_enabled: bool,
    pub frame_available_callback_enabled: bool,
    pub frame_callback_enabled: bool,
    pub frame_error_count_callback_enabled: bool,
}
impl FromByteSlice for FrameCallbackConfig {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameCallbackConfig {
        FrameCallbackConfig {
            frame_started_callback_enabled: <bool>::from_le_byte_slice(&bytes[0..1]),
            frame_available_callback_enabled: <bool>::from_le_byte_slice(&bytes[1..2]),
            frame_callback_enabled: <bool>::from_le_byte_slice(&bytes[2..3]),
            frame_error_count_callback_enabled: <bool>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct FrameLowLevelEvent {
    pub frame_length: u16,
    pub frame_chunk_offset: u16,
    pub frame_chunk_data: [u8; 56],
    pub frame_number: u32,
}
impl FromByteSlice for FrameLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameLowLevelEvent {
        FrameLowLevelEvent {
            frame_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            frame_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            frame_chunk_data: <[u8; 56]>::from_le_byte_slice(&bytes[4..60]),
            frame_number: <u32>::from_le_byte_slice(&bytes[60..64]),
        }
    }
}
impl LowLevelRead<u8, FrameResult> for FrameLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.frame_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.frame_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.frame_chunk_data }

    fn get_result(&self) -> FrameResult { FrameResult { frame_number: self.frame_number } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameErrorCountEvent {
    pub overrun_error_count: u32,
    pub framing_error_count: u32,
}
impl FromByteSlice for FrameErrorCountEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameErrorCountEvent {
        FrameErrorCountEvent {
            overrun_error_count: <u32>::from_le_byte_slice(&bytes[0..4]),
            framing_error_count: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteFrameResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFrameResult {
    pub frame_number: u32,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameResult {
    pub frame_number: u32,
}

/// DMX master and slave
#[derive(Clone)]
pub struct DmxBricklet {
    device: Device,
}
impl DmxBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 285;
    pub const DEVICE_DISPLAY_NAME: &'static str = "DMX Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DmxBricklet {
        let mut result = DmxBricklet { device: Device::new([2, 0, 0], uid, req_sender, 3) };
        result.device.response_expected[u8::from(DmxBrickletFunction::SetDmxMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetDmxMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::WriteFrameLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DmxBrickletFunction::ReadFrameLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetFrameDuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetFrameDuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetFrameErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetCommunicationLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetCommunicationLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetErrorLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetErrorLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetFrameCallbackConfig) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetFrameCallbackConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DmxBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DmxBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dmx_bricklet::DmxBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dmx_bricklet::DmxBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DmxBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: DmxBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered as soon as a new frame write is started.
    /// You should send the data for the next frame directly after this receiver
    /// was triggered.
    ///
    /// For an explanation of the general approach see [`write_frame`].
    ///
    /// This receiver can be enabled via [`set_frame_callback_config`].
    ///
    /// This receiver can only be triggered in master mode.
    ///
    /// [`write_frame`]: #method.write_frame
    /// [`set_frame_callback_config`]: #method.set_frame_callback_config
    pub fn get_frame_started_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(DmxBrickletFunction::CallbackFrameStarted))
    }

    /// This receiver is triggered in slave mode when a new frame was received from the DMX master
    /// and it can be read out. You have to read the frame before the master has written
    /// the next frame, see [`read_frame`] for more details.
    ///
    /// The parameter is the frame number, it is increased by one with each received frame.
    ///
    /// This receiver can be enabled via [`set_frame_callback_config`].
    ///
    /// This receiver can only be triggered in slave mode.
    pub fn get_frame_available_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(DmxBrickletFunction::CallbackFrameAvailable))
    }

    /// See [`get_frame_callback_receiver`](crate::dmx::DMX::get_frame_callback_receiver)
    pub fn get_frame_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<FrameLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(DmxBrickletFunction::CallbackFrameLowLevel))
    }

    /// This receiver is called as soon as a new frame is available
    /// (written by the DMX master).
    ///
    /// The size of the array is equivalent to the number of channels in
    /// the frame. Each byte represents one channel.
    ///
    /// This receiver can be enabled via [`set_frame_callback_config`].
    ///
    /// This receiver can only be triggered in slave mode.
    pub fn get_frame_callback_receiver(&self) -> ConvertingHighLevelCallbackReceiver<u8, FrameResult, FrameLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(self.device.get_callback_receiver(u8::from(DmxBrickletFunction::CallbackFrameLowLevel)))
    }

    /// This receiver is called if a new error occurs. It returns
    /// the current overrun and framing error count.
    pub fn get_frame_error_count_callback_receiver(&self) -> ConvertingCallbackReceiver<FrameErrorCountEvent> {
        self.device.get_callback_receiver(u8::from(DmxBrickletFunction::CallbackFrameErrorCount))
    }

    /// Sets the DMX mode to either master or slave.
    ///
    /// Calling this function sets frame number to 0.
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_DMX_MODE_MASTER
    ///	* DMX_BRICKLET_DMX_MODE_SLAVE
    pub fn set_dmx_mode(&self, dmx_mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(dmx_mode));

        self.device.set(u8::from(DmxBrickletFunction::SetDmxMode), payload)
    }

    /// Returns the DMX mode, as set by [`set_dmx_mode`].
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_DMX_MODE_MASTER
    ///	* DMX_BRICKLET_DMX_MODE_SLAVE
    pub fn get_dmx_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetDmxMode), payload)
    }

    /// Writes a DMX frame. The maximum frame size is 512 byte. Each byte represents one channel.
    ///
    /// The next frame can be written after the [`get_frame_started_callback_receiver`] receiver was called. The frame
    /// is double buffered, so a new frame can be written as soon as the writing of the prior frame
    /// starts.
    ///
    /// The data will be transfered when the next frame duration ends, see [`set_frame_duration`].
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents the number of frames per second you want to achieve.
    /// * Set channels for first frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * Set channels for next frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// This approach ensures that you can set new DMX data with a fixed frame rate.
    ///
    /// This function can only be called in master mode.
    pub fn write_frame_low_level(
        &self,
        frame_length: u16,
        frame_chunk_offset: u16,
        frame_chunk_data: [u8; 60],
    ) -> ConvertingReceiver<WriteFrameLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frame_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(frame_chunk_offset));
        payload[4..64].copy_from_slice(&<[u8; 60]>::to_le_byte_vec(frame_chunk_data));

        self.device.set(u8::from(DmxBrickletFunction::WriteFrameLowLevel), payload)
    }

    /// Writes a DMX frame. The maximum frame size is 512 byte. Each byte represents one channel.
    ///
    /// The next frame can be written after the [`get_frame_started_callback_receiver`] receiver was called. The frame
    /// is double buffered, so a new frame can be written as soon as the writing of the prior frame
    /// starts.
    ///
    /// The data will be transfered when the next frame duration ends, see [`set_frame_duration`].
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents the number of frames per second you want to achieve.
    /// * Set channels for first frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * Set channels for next frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// This approach ensures that you can set new DMX data with a fixed frame rate.
    ///
    /// This function can only be called in master mode.
    pub fn write_frame(&self, frame: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(0, frame, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.write_frame_low_level(length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Returns the last frame that was written by the DMX master. The size of the array
    /// is equivalent to the number of channels in the frame. Each byte represents one channel.
    ///
    /// The next frame is available after the [`get_frame_available_callback_receiver`] receiver was called.
    ///
    /// Generic approach:
    ///
    /// * Call [`read_frame`] to get first frame.
    /// * Wait for the [`get_frame_available_callback_receiver`] receiver.
    /// * Call [`read_frame`] to get second frame.
    /// * Wait for the [`get_frame_available_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// Instead of polling this function you can also use the [`get_frame_callback_receiver`] receiver.
    /// You can enable it with [`set_frame_callback_config`].
    ///
    /// The frame number starts at 0 and it is increased by one with each received frame.
    ///
    /// This function can only be called in slave mode.
    pub fn read_frame_low_level(&self) -> ConvertingReceiver<ReadFrameLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::ReadFrameLowLevel), payload)
    }

    /// Returns the last frame that was written by the DMX master. The size of the array
    /// is equivalent to the number of channels in the frame. Each byte represents one channel.
    ///
    /// The next frame is available after the [`get_frame_available_callback_receiver`] receiver was called.
    ///
    /// Generic approach:
    ///
    /// * Call [`read_frame`] to get first frame.
    /// * Wait for the [`get_frame_available_callback_receiver`] receiver.
    /// * Call [`read_frame`] to get second frame.
    /// * Wait for the [`get_frame_available_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// Instead of polling this function you can also use the [`get_frame_callback_receiver`] receiver.
    /// You can enable it with [`set_frame_callback_config`].
    ///
    /// The frame number starts at 0 and it is increased by one with each received frame.
    ///
    /// This function can only be called in slave mode.
    pub fn read_frame(&self) -> Result<(Vec<u8>, u32), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_frame_low_level().recv())?;
        Ok((ll_result.0, ll_result.1.frame_number))
    }

    /// Sets the duration of a frame.
    ///
    /// Example: If you want to achieve 20 frames per second, you should
    /// set the frame duration to 50ms (50ms * 20 = 1 second).
    ///
    /// If you always want to send a frame as fast as possible you can set
    /// this value to 0.
    ///
    /// This setting is only used in master mode.
    pub fn set_frame_duration(&self, frame_duration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frame_duration));

        self.device.set(u8::from(DmxBrickletFunction::SetFrameDuration), payload)
    }

    /// Returns the frame duration as set by [`set_frame_duration`].
    pub fn get_frame_duration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetFrameDuration), payload)
    }

    /// Returns the current number of overrun and framing errors.
    pub fn get_frame_error_count(&self) -> ConvertingReceiver<FrameErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetFrameErrorCount), payload)
    }

    /// Sets the communication LED configuration. By default the LED shows
    /// communication traffic, it flickers once for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn set_communication_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DmxBrickletFunction::SetCommunicationLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_communication_led_config`]
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn get_communication_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetCommunicationLedConfig), payload)
    }

    /// Sets the error LED configuration.
    ///
    /// By default the error LED turns on if there is any error (see [`get_frame_error_count_callback_receiver`]
    /// callback). If you call this function with the Show-Error option again, the LED
    /// will turn off until the next error occurs.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DmxBrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_error_led_config`].
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetErrorLedConfig), payload)
    }

    /// Enables/Disables the different receivers. By default the
    /// [`get_frame_started_callback_receiver`] receiver and [`get_frame_available_callback_receiver`] receiver are enabled while
    /// the [`get_frame_callback_receiver`] receiver and [`get_frame_error_count_callback_receiver`] receiver are disabled.
    ///
    /// If you want to use the [`get_frame_callback_receiver`] receiver you can enable it and disable
    /// the [`get_frame_available_callback_receiver`] receiver at the same time. It becomes redundant in
    /// this case.
    pub fn set_frame_callback_config(
        &self,
        frame_started_callback_enabled: bool,
        frame_available_callback_enabled: bool,
        frame_callback_enabled: bool,
        frame_error_count_callback_enabled: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(frame_started_callback_enabled));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(frame_available_callback_enabled));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(frame_callback_enabled));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(frame_error_count_callback_enabled));

        self.device.set(u8::from(DmxBrickletFunction::SetFrameCallbackConfig), payload)
    }

    /// Returns the frame receiver config as set by [`set_frame_callback_config`].
    pub fn get_frame_callback_config(&self) -> ConvertingReceiver<FrameCallbackConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetFrameCallbackConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* DMX_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(DmxBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DMX_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(DmxBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(DmxBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DmxBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * DMX_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DMX_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DmxBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(DmxBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DmxBrickletFunction::GetIdentity), payload)
    }
}
