/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives one brushed DC motor with up to 28V and 5A (peak).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DCV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DcV2BrickletFunction {
    SetEnabled,
    GetEnabled,
    SetVelocity,
    GetVelocity,
    GetCurrentVelocity,
    SetMotion,
    GetMotion,
    FullBrake,
    SetDriveMode,
    GetDriveMode,
    SetPwmFrequency,
    GetPwmFrequency,
    GetPowerStatistics,
    SetErrorLedConfig,
    GetErrorLedConfig,
    SetEmergencyShutdownCallbackConfiguration,
    GetEmergencyShutdownCallbackConfiguration,
    SetVelocityReachedCallbackConfiguration,
    GetVelocityReachedCallbackConfiguration,
    SetCurrentVelocityCallbackConfiguration,
    GetCurrentVelocityCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackEmergencyShutdown,
    CallbackVelocityReached,
    CallbackCurrentVelocity,
}
impl From<DcV2BrickletFunction> for u8 {
    fn from(fun: DcV2BrickletFunction) -> Self {
        match fun {
            DcV2BrickletFunction::SetEnabled => 1,
            DcV2BrickletFunction::GetEnabled => 2,
            DcV2BrickletFunction::SetVelocity => 3,
            DcV2BrickletFunction::GetVelocity => 4,
            DcV2BrickletFunction::GetCurrentVelocity => 5,
            DcV2BrickletFunction::SetMotion => 6,
            DcV2BrickletFunction::GetMotion => 7,
            DcV2BrickletFunction::FullBrake => 8,
            DcV2BrickletFunction::SetDriveMode => 9,
            DcV2BrickletFunction::GetDriveMode => 10,
            DcV2BrickletFunction::SetPwmFrequency => 11,
            DcV2BrickletFunction::GetPwmFrequency => 12,
            DcV2BrickletFunction::GetPowerStatistics => 13,
            DcV2BrickletFunction::SetErrorLedConfig => 14,
            DcV2BrickletFunction::GetErrorLedConfig => 15,
            DcV2BrickletFunction::SetEmergencyShutdownCallbackConfiguration => 16,
            DcV2BrickletFunction::GetEmergencyShutdownCallbackConfiguration => 17,
            DcV2BrickletFunction::SetVelocityReachedCallbackConfiguration => 18,
            DcV2BrickletFunction::GetVelocityReachedCallbackConfiguration => 19,
            DcV2BrickletFunction::SetCurrentVelocityCallbackConfiguration => 20,
            DcV2BrickletFunction::GetCurrentVelocityCallbackConfiguration => 21,
            DcV2BrickletFunction::GetSpitfpErrorCount => 234,
            DcV2BrickletFunction::SetBootloaderMode => 235,
            DcV2BrickletFunction::GetBootloaderMode => 236,
            DcV2BrickletFunction::SetWriteFirmwarePointer => 237,
            DcV2BrickletFunction::WriteFirmware => 238,
            DcV2BrickletFunction::SetStatusLedConfig => 239,
            DcV2BrickletFunction::GetStatusLedConfig => 240,
            DcV2BrickletFunction::GetChipTemperature => 242,
            DcV2BrickletFunction::Reset => 243,
            DcV2BrickletFunction::WriteUid => 248,
            DcV2BrickletFunction::ReadUid => 249,
            DcV2BrickletFunction::GetIdentity => 255,
            DcV2BrickletFunction::CallbackEmergencyShutdown => 22,
            DcV2BrickletFunction::CallbackVelocityReached => 23,
            DcV2BrickletFunction::CallbackCurrentVelocity => 24,
        }
    }
}
pub const DC_V2_BRICKLET_DRIVE_MODE_DRIVE_BRAKE: u8 = 0;
pub const DC_V2_BRICKLET_DRIVE_MODE_DRIVE_COAST: u8 = 1;
pub const DC_V2_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const DC_V2_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 3;
pub const DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const DC_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const DC_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const DC_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Motion {
    pub acceleration: u16,
    pub deceleration: u16,
}
impl FromByteSlice for Motion {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Motion {
        Motion { acceleration: <u16>::from_le_byte_slice(&bytes[0..2]), deceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PowerStatistics {
    pub voltage: u16,
    pub current: u16,
}
impl FromByteSlice for PowerStatistics {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> PowerStatistics {
        PowerStatistics { voltage: <u16>::from_le_byte_slice(&bytes[0..2]), current: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentVelocityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for CurrentVelocityCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentVelocityCallbackConfiguration {
        CurrentVelocityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives one brushed DC motor with up to 28V and 5A (peak)
#[derive(Clone)]
pub struct DcV2Bricklet {
    device: Device,
}
impl DcV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2165;
    pub const DEVICE_DISPLAY_NAME: &'static str = "DC Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DcV2Bricklet {
        let mut result = DcV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetEnabled) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetCurrentVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetMotion) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetMotion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetDriveMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetDriveMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetPwmFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetPwmFrequency) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetPowerStatistics) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetErrorLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetErrorLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetEmergencyShutdownCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetEmergencyShutdownCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetVelocityReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetVelocityReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetCurrentVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetCurrentVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dc_v2_bricklet::DcV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dc_v2_bricklet::DcV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DcV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: DcV2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered if either the current consumption
    /// is too high (above 5A) or the temperature of the driver chip is too high
    /// (above 175°C). These two possibilities are essentially the same, since the
    /// temperature will reach this threshold immediately if the motor consumes too
    /// much current. In case of a voltage below 3.3V (external or stack) this
    /// receiver is triggered as well.
    ///
    /// If this receiver is triggered, the driver chip gets disabled at the same time.
    /// That means, [`set_enabled`] has to be called to drive the motor again.
    ///
    /// # Note
    ///  This receiver only works in Drive/Brake mode (see [`set_drive_mode`]). In
    ///  Drive/Coast mode it is unfortunately impossible to reliably read the
    ///  overcurrent/overtemperature signal from the driver chip.
    ///
    /// [`set_enabled`]: #method.set_enabled
    /// [`set_drive_mode`]: #method.set_drive_mode
    pub fn get_emergency_shutdown_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(DcV2BrickletFunction::CallbackEmergencyShutdown))
    }

    /// This receiver is triggered whenever a set velocity is reached. For example:
    /// If a velocity of 0 is present, acceleration is set to 5000 and velocity
    /// to 10000, the [`get_velocity_reached_callback_receiver`] receiver will be triggered after about
    /// 2 seconds, when the set velocity is actually reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the DC motor, this only works if the
    ///  acceleration (see [`set_motion`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_velocity_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(DcV2BrickletFunction::CallbackVelocityReached))
    }

    /// This receiver is triggered with the period that is set by
    /// [`set_current_velocity_callback_configuration`]. The parameter is the *current*
    /// velocity used by the motor.
    ///
    /// The [`get_current_velocity_callback_receiver`] receiver is only triggered after the set period
    /// if there is a change in the velocity.
    pub fn get_current_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(DcV2BrickletFunction::CallbackCurrentVelocity))
    }

    /// Enables/Disables the driver chip. The driver parameters can be configured
    /// (velocity, acceleration, etc) before it is enabled.
    pub fn set_enabled(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(DcV2BrickletFunction::SetEnabled), payload)
    }

    /// Returns *true* if the driver chip is enabled, *false* otherwise.
    pub fn get_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetEnabled), payload)
    }

    /// Sets the velocity of the motor. Whereas -32767 is full speed backward,
    /// 0 is stop and 32767 is full speed forward. Depending on the
    /// acceleration (see [`set_motion`]), the motor is not immediately
    /// brought to the velocity but smoothly accelerated.
    ///
    /// The velocity describes the duty cycle of the PWM with which the motor is
    /// controlled, e.g. a velocity of 3277 sets a PWM with a 10% duty cycle.
    /// You can not only control the duty cycle of the PWM but also the frequency,
    /// see [`set_pwm_frequency`].
    pub fn set_velocity(&self, velocity: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(DcV2BrickletFunction::SetVelocity), payload)
    }

    /// Returns the velocity as set by [`set_velocity`].
    pub fn get_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetVelocity), payload)
    }

    /// Returns the *current* velocity of the motor. This value is different
    /// from [`get_velocity`] whenever the motor is currently accelerating
    /// to a goal set by [`set_velocity`].
    pub fn get_current_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration and deceleration of the motor. It is given in *velocity/s*.
    /// An acceleration of 10000 means, that every second the velocity is increased
    /// by 10000 (or about 30% duty cycle).
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 16000 (about 50% duty cycle) in 10 seconds, you should set
    /// an acceleration of 1600.
    ///
    /// If acceleration and deceleration is set to 0, there is no speed ramping, i.e. a
    /// new velocity is immediately given to the motor.
    pub fn set_motion(&self, acceleration: u16, deceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(deceleration));

        self.device.set(u8::from(DcV2BrickletFunction::SetMotion), payload)
    }

    /// Returns the acceleration/deceleration as set by [`set_motion`].
    pub fn get_motion(&self) -> ConvertingReceiver<Motion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetMotion), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`set_velocity`] with 0 if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcV2BrickletFunction::FullBrake), payload)
    }

    /// Sets the drive mode. Possible modes are:
    ///
    /// * 0 = Drive/Brake
    /// * 1 = Drive/Coast
    ///
    /// These modes are different kinds of motor controls.
    ///
    /// In Drive/Brake mode, the motor is always either driving or braking. There
    /// is no freewheeling. Advantages are: A more linear correlation between
    /// PWM and velocity, more exact accelerations and the possibility to drive
    /// with slower velocities.
    ///
    /// In Drive/Coast mode, the motor is always either driving or freewheeling.
    /// Advantages are: Less current consumption and less demands on the motor and
    /// driver chip.
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_DRIVE_MODE_DRIVE_BRAKE
    ///	* DC_V2_BRICKLET_DRIVE_MODE_DRIVE_COAST
    pub fn set_drive_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(DcV2BrickletFunction::SetDriveMode), payload)
    }

    /// Returns the drive mode, as set by [`set_drive_mode`].
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_DRIVE_MODE_DRIVE_BRAKE
    ///	* DC_V2_BRICKLET_DRIVE_MODE_DRIVE_COAST
    pub fn get_drive_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetDriveMode), payload)
    }

    /// Sets the frequency of the PWM with which the motor is driven.
    /// Often a high frequency
    /// is less noisy and the motor runs smoother. However, with a low frequency
    /// there are less switches and therefore fewer switching losses. Also with
    /// most motors lower frequencies enable higher torque.
    ///
    /// If you have no idea what all this means, just ignore this function and use
    /// the default frequency, it will very likely work fine.
    pub fn set_pwm_frequency(&self, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(DcV2BrickletFunction::SetPwmFrequency), payload)
    }

    /// Returns the PWM frequency as set by [`set_pwm_frequency`].
    pub fn get_pwm_frequency(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetPwmFrequency), payload)
    }

    /// Returns input voltage and current usage of the driver.
    pub fn get_power_statistics(&self) -> ConvertingReceiver<PowerStatistics> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetPowerStatistics), payload)
    }

    /// Configures the error LED to be either turned off, turned on, blink in
    /// heartbeat mode or show an error.
    ///
    /// If the LED is configured to show errors it has three different states:
    ///
    /// * Off: No error present.
    /// * 1s interval blinking: Input voltage too low (below 6V).
    /// * 250ms interval blinking: Overtemperature or overcurrent.
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DcV2BrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_error_led_config`]
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DC_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetErrorLedConfig), payload)
    }

    /// Enable/Disable [`get_emergency_shutdown_callback_receiver`] receiver.
    pub fn set_emergency_shutdown_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(DcV2BrickletFunction::SetEmergencyShutdownCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_emergency_shutdown_callback_configuration`].
    pub fn get_emergency_shutdown_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetEmergencyShutdownCallbackConfiguration), payload)
    }

    /// Enable/Disable [`get_velocity_reached_callback_receiver`] receiver.
    pub fn set_velocity_reached_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(DcV2BrickletFunction::SetVelocityReachedCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_velocity_reached_callback_configuration`].
    pub fn get_velocity_reached_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetVelocityReachedCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_current_velocity_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_current_velocity_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(DcV2BrickletFunction::SetCurrentVelocityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_current_velocity_callback_configuration`].
    pub fn get_current_velocity_callback_configuration(&self) -> ConvertingReceiver<CurrentVelocityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetCurrentVelocityCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* DC_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(DcV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DC_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(DcV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(DcV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DcV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * DC_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DC_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(DcV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcV2BrickletFunction::GetIdentity), payload)
    }
}
