/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures AC/DC current between -25A and +25A.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Current25_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum Current25BrickletFunction {
    GetCurrent,
    Calibrate,
    IsOverCurrent,
    GetAnalogValue,
    SetCurrentCallbackPeriod,
    GetCurrentCallbackPeriod,
    SetAnalogValueCallbackPeriod,
    GetAnalogValueCallbackPeriod,
    SetCurrentCallbackThreshold,
    GetCurrentCallbackThreshold,
    SetAnalogValueCallbackThreshold,
    GetAnalogValueCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackCurrent,
    CallbackAnalogValue,
    CallbackCurrentReached,
    CallbackAnalogValueReached,
    CallbackOverCurrent,
}
impl From<Current25BrickletFunction> for u8 {
    fn from(fun: Current25BrickletFunction) -> Self {
        match fun {
            Current25BrickletFunction::GetCurrent => 1,
            Current25BrickletFunction::Calibrate => 2,
            Current25BrickletFunction::IsOverCurrent => 3,
            Current25BrickletFunction::GetAnalogValue => 4,
            Current25BrickletFunction::SetCurrentCallbackPeriod => 5,
            Current25BrickletFunction::GetCurrentCallbackPeriod => 6,
            Current25BrickletFunction::SetAnalogValueCallbackPeriod => 7,
            Current25BrickletFunction::GetAnalogValueCallbackPeriod => 8,
            Current25BrickletFunction::SetCurrentCallbackThreshold => 9,
            Current25BrickletFunction::GetCurrentCallbackThreshold => 10,
            Current25BrickletFunction::SetAnalogValueCallbackThreshold => 11,
            Current25BrickletFunction::GetAnalogValueCallbackThreshold => 12,
            Current25BrickletFunction::SetDebouncePeriod => 13,
            Current25BrickletFunction::GetDebouncePeriod => 14,
            Current25BrickletFunction::GetIdentity => 255,
            Current25BrickletFunction::CallbackCurrent => 15,
            Current25BrickletFunction::CallbackAnalogValue => 16,
            Current25BrickletFunction::CallbackCurrentReached => 17,
            Current25BrickletFunction::CallbackAnalogValueReached => 18,
            Current25BrickletFunction::CallbackOverCurrent => 19,
        }
    }
}
pub const CURRENT25_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const CURRENT25_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const CURRENT25_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const CURRENT25_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const CURRENT25_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentCallbackThreshold {
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for CurrentCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentCallbackThreshold {
        CurrentCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i16>::from_le_byte_slice(&bytes[1..3]),
            max: <i16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for AnalogValueCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackThreshold {
        AnalogValueCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures AC/DC current between -25A and +25A
#[derive(Clone)]
pub struct Current25Bricklet {
    device: Device,
}
impl Current25Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 24;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Current25 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Current25Bricklet {
        let mut result = Current25Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Current25BrickletFunction::GetCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Current25BrickletFunction::IsOverCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::SetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetCurrentCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::SetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::SetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetCurrentCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::SetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Current25BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::current25_bricklet::Current25Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::current25_bricklet::Current25Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Current25BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: Current25BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_current_callback_period`]. The parameter is the current of the
    /// sensor.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since the
    /// last triggering.
    ///
    /// [`set_current_callback_period`]: #method.set_current_callback_period
    /// [`get_current_callback_receiver`]: #method.get_current_callback_receiver
    pub fn get_current_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(Current25BrickletFunction::CallbackCurrent))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_analog_value_callback_period`]. The parameter is the analog value of the
    /// sensor.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the current has changed since the
    /// last triggering.
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(Current25BrickletFunction::CallbackAnalogValue))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_current_callback_threshold`] is reached.
    /// The parameter is the current of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_current_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(Current25BrickletFunction::CallbackCurrentReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_analog_value_callback_threshold`] is reached.
    /// The parameter is the analog value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_analog_value_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(Current25BrickletFunction::CallbackAnalogValueReached))
    }

    /// This receiver is triggered when an over current is measured
    /// (see [`is_over_current`]).
    pub fn get_over_current_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(Current25BrickletFunction::CallbackOverCurrent))
    }

    /// Returns the current of the sensor.
    ///
    /// If you want to get the current periodically, it is recommended to use the
    /// [`get_current_callback_receiver`] receiver and set the period with
    /// [`set_current_callback_period`].
    pub fn get_current(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetCurrent), payload)
    }

    /// Calibrates the 0 value of the sensor. You have to call this function
    /// when there is no current present.
    ///
    /// The zero point of the current sensor
    /// is depending on the exact properties of the analog-to-digital converter,
    /// the length of the Bricklet cable and the temperature. Thus, if you change
    /// the Brick or the environment in which the Bricklet is used, you might
    /// have to recalibrate.
    ///
    /// The resulting calibration will be saved on the EEPROM of the Current
    /// Bricklet.
    pub fn calibrate(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Current25BrickletFunction::Calibrate), payload)
    }

    /// Returns *true* if more than 25A were measured.
    ///
    /// # Note
    ///  To reset this value you have to power cycle the Bricklet.
    pub fn is_over_current(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::IsOverCurrent), payload)
    }

    /// Returns the value as read by a 12-bit analog-to-digital converter.
    ///
    /// # Note
    ///  The value returned by [`get_current`] is averaged over several samples
    ///  to yield less noise, while [`get_analog_value`] gives back raw
    ///  unfiltered analog values. The only reason to use [`get_analog_value`] is,
    ///  if you need the full resolution of the analog-to-digital converter.
    ///
    /// If you want the analog value periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver and set the period with
    /// [`set_analog_value_callback_period`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetAnalogValue), payload)
    }

    /// Sets the period with which the [`get_current_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_current_callback_receiver`] receiver is only triggered if the current has changed since
    /// the last triggering.
    pub fn set_current_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(Current25BrickletFunction::SetCurrentCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_current_callback_period`].
    pub fn get_current_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetCurrentCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog value has
    /// changed since the last triggering.
    pub fn set_analog_value_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(Current25BrickletFunction::SetAnalogValueCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_analog_value_callback_period`].
    pub fn get_analog_value_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetAnalogValueCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_current_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the current is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the current is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the current is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the current is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * CURRENT25_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_current_callback_threshold(&self, option: char, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(Current25BrickletFunction::SetCurrentCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_current_callback_threshold`].
    ///
    /// Associated constants:
    /// * CURRENT25_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_current_callback_threshold(&self) -> ConvertingReceiver<CurrentCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetCurrentCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_analog_value_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the analog value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the analog value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the analog value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the analog value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * CURRENT25_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(Current25BrickletFunction::SetAnalogValueCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_analog_value_callback_threshold`].
    ///
    /// Associated constants:
    /// * CURRENT25_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* CURRENT25_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_threshold(&self) -> ConvertingReceiver<AnalogValueCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetAnalogValueCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_current_reached_callback_receiver`],
    /// * [`get_analog_value_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_current_callback_threshold`],
    /// * [`set_analog_value_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Current25BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Current25BrickletFunction::GetIdentity), payload)
    }
}
