/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 3-axis compass with 10 nanotesla and 0.1° resolution.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Compass_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum CompassBrickletFunction {
    GetHeading,
    SetHeadingCallbackConfiguration,
    GetHeadingCallbackConfiguration,
    GetMagneticFluxDensity,
    SetMagneticFluxDensityCallbackConfiguration,
    GetMagneticFluxDensityCallbackConfiguration,
    SetConfiguration,
    GetConfiguration,
    SetCalibration,
    GetCalibration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackHeading,
    CallbackMagneticFluxDensity,
}
impl From<CompassBrickletFunction> for u8 {
    fn from(fun: CompassBrickletFunction) -> Self {
        match fun {
            CompassBrickletFunction::GetHeading => 1,
            CompassBrickletFunction::SetHeadingCallbackConfiguration => 2,
            CompassBrickletFunction::GetHeadingCallbackConfiguration => 3,
            CompassBrickletFunction::GetMagneticFluxDensity => 5,
            CompassBrickletFunction::SetMagneticFluxDensityCallbackConfiguration => 6,
            CompassBrickletFunction::GetMagneticFluxDensityCallbackConfiguration => 7,
            CompassBrickletFunction::SetConfiguration => 9,
            CompassBrickletFunction::GetConfiguration => 10,
            CompassBrickletFunction::SetCalibration => 11,
            CompassBrickletFunction::GetCalibration => 12,
            CompassBrickletFunction::GetSpitfpErrorCount => 234,
            CompassBrickletFunction::SetBootloaderMode => 235,
            CompassBrickletFunction::GetBootloaderMode => 236,
            CompassBrickletFunction::SetWriteFirmwarePointer => 237,
            CompassBrickletFunction::WriteFirmware => 238,
            CompassBrickletFunction::SetStatusLedConfig => 239,
            CompassBrickletFunction::GetStatusLedConfig => 240,
            CompassBrickletFunction::GetChipTemperature => 242,
            CompassBrickletFunction::Reset => 243,
            CompassBrickletFunction::WriteUid => 248,
            CompassBrickletFunction::ReadUid => 249,
            CompassBrickletFunction::GetIdentity => 255,
            CompassBrickletFunction::CallbackHeading => 4,
            CompassBrickletFunction::CallbackMagneticFluxDensity => 8,
        }
    }
}
pub const COMPASS_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const COMPASS_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const COMPASS_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const COMPASS_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const COMPASS_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const COMPASS_BRICKLET_DATA_RATE_100HZ: u8 = 0;
pub const COMPASS_BRICKLET_DATA_RATE_200HZ: u8 = 1;
pub const COMPASS_BRICKLET_DATA_RATE_400HZ: u8 = 2;
pub const COMPASS_BRICKLET_DATA_RATE_600HZ: u8 = 3;
pub const COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const COMPASS_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const COMPASS_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const COMPASS_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct HeadingCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for HeadingCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> HeadingCallbackConfiguration {
        HeadingCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i16>::from_le_byte_slice(&bytes[6..8]),
            max: <i16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFluxDensity {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl FromByteSlice for MagneticFluxDensity {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFluxDensity {
        MagneticFluxDensity {
            x: <i32>::from_le_byte_slice(&bytes[0..4]),
            y: <i32>::from_le_byte_slice(&bytes[4..8]),
            z: <i32>::from_le_byte_slice(&bytes[8..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFluxDensityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for MagneticFluxDensityCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFluxDensityCallbackConfiguration {
        MagneticFluxDensityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFluxDensityEvent {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl FromByteSlice for MagneticFluxDensityEvent {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFluxDensityEvent {
        MagneticFluxDensityEvent {
            x: <i32>::from_le_byte_slice(&bytes[0..4]),
            y: <i32>::from_le_byte_slice(&bytes[4..8]),
            z: <i32>::from_le_byte_slice(&bytes[8..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub data_rate: u8,
    pub background_calibration: bool,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            data_rate: <u8>::from_le_byte_slice(&bytes[0..1]),
            background_calibration: <bool>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Calibration {
    pub offset: [i16; 3],
    pub gain: [i16; 3],
}
impl FromByteSlice for Calibration {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> Calibration {
        Calibration { offset: <[i16; 3]>::from_le_byte_slice(&bytes[0..6]), gain: <[i16; 3]>::from_le_byte_slice(&bytes[6..12]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 3-axis compass with 10 nanotesla and 0.1° resolution
#[derive(Clone)]
pub struct CompassBricklet {
    device: Device,
}
impl CompassBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2153;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Compass Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> CompassBricklet {
        let mut result = CompassBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(CompassBrickletFunction::GetHeading) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetHeadingCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetHeadingCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetMagneticFluxDensity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetMagneticFluxDensityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetMagneticFluxDensityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetCalibration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CompassBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CompassBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::compass_bricklet::CompassBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::compass_bricklet::CompassBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: CompassBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: CompassBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_heading_callback_configuration`].
    ///
    /// The parameter is the same as [`get_heading`].
    ///
    /// [`get_heading`]: #method.get_heading
    /// [`set_heading_callback_configuration`]: #method.set_heading_callback_configuration
    pub fn get_heading_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(CompassBrickletFunction::CallbackHeading))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_magnetic_flux_density_callback_configuration`].
    ///
    /// The parameters are the same as [`get_magnetic_flux_density`].
    pub fn get_magnetic_flux_density_callback_receiver(&self) -> ConvertingCallbackReceiver<MagneticFluxDensityEvent> {
        self.device.get_callback_receiver(u8::from(CompassBrickletFunction::CallbackMagneticFluxDensity))
    }

    /// Returns the heading (north = 0 degree, east = 90 degree).
    ///
    /// Alternatively you can use [`get_magnetic_flux_density`] and calculate the
    /// heading with ``heading = atan2(y, x) * 180 / PI``.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_heading_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_heading_callback_configuration`].
    pub fn get_heading(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetHeading), payload)
    }

    /// The period is the period with which the [`get_heading_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_heading_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_heading_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i16,
        max: i16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(CompassBrickletFunction::SetHeadingCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_heading_callback_configuration`].
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COMPASS_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_heading_callback_configuration(&self) -> ConvertingReceiver<HeadingCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetHeadingCallbackConfiguration), payload)
    }

    /// Returns the [magnetic flux density (magnetic induction)](https://en.wikipedia.org/wiki/Magnetic_flux)__
    /// for all three axis.
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_magnetic_flux_density_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_magnetic_flux_density_callback_configuration`].
    pub fn get_magnetic_flux_density(&self) -> ConvertingReceiver<MagneticFluxDensity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetMagneticFluxDensity), payload)
    }

    /// The period is the period with which the [`get_magnetic_flux_density_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_magnetic_flux_density_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(CompassBrickletFunction::SetMagneticFluxDensityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_magnetic_flux_density_callback_configuration`].
    pub fn get_magnetic_flux_density_callback_configuration(&self) -> ConvertingReceiver<MagneticFluxDensityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetMagneticFluxDensityCallbackConfiguration), payload)
    }

    /// Configures the data rate and background calibration.
    ///
    /// * Data Rate: Sets the data rate that is used by the magnetometer.
    ///   The lower the data rate, the lower is the noise on the data.
    /// * Background Calibration: Set to *true* to enable the background
    ///   calibration and *false* to turn it off. If the background calibration
    ///   is enabled the sensing polarity is flipped once per second to automatically
    ///   calculate and remove offset that is caused by temperature changes.
    ///   This polarity flipping takes about 20ms. This means that once a second
    ///   you will not get new data for a period of 20ms. We highly recommend that
    ///   you keep the background calibration enabled and only disable it if the 20ms
    ///   off-time is a problem in your application.
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_DATA_RATE_100HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_200HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_400HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_600HZ
    pub fn set_configuration(&self, data_rate: u8, background_calibration: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(data_rate));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(background_calibration));

        self.device.set(u8::from(CompassBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_DATA_RATE_100HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_200HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_400HZ
    ///	* COMPASS_BRICKLET_DATA_RATE_600HZ
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetConfiguration), payload)
    }

    /// Sets offset and gain for each of the three axes.
    ///
    /// The Bricklet is factory calibrated. If you want to re-calibrate the
    /// Bricklet we recommend that you do the calibration through Brick Viewer.
    ///
    /// The calibration is saved in non-volatile memory and only has to be
    /// done once.
    pub fn set_calibration(&self, offset: [i16; 3], gain: [i16; 3]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 12];
        payload[0..6].copy_from_slice(&<[i16; 3]>::to_le_byte_vec(offset));
        payload[6..12].copy_from_slice(&<[i16; 3]>::to_le_byte_vec(gain));

        self.device.set(u8::from(CompassBrickletFunction::SetCalibration), payload)
    }

    /// Returns the calibration parameters as set by [`set_calibration`].
    pub fn get_calibration(&self) -> ConvertingReceiver<Calibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetCalibration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* COMPASS_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(CompassBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* COMPASS_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(CompassBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(CompassBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(CompassBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * COMPASS_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* COMPASS_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(CompassBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(CompassBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CompassBrickletFunction::GetIdentity), payload)
    }
}
