/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures color (RGB value), illuminance and color temperature.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/ColorV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ColorV2BrickletFunction {
    GetColor,
    SetColorCallbackConfiguration,
    GetColorCallbackConfiguration,
    GetIlluminance,
    SetIlluminanceCallbackConfiguration,
    GetIlluminanceCallbackConfiguration,
    GetColorTemperature,
    SetColorTemperatureCallbackConfiguration,
    GetColorTemperatureCallbackConfiguration,
    SetLight,
    GetLight,
    SetConfiguration,
    GetConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackColor,
    CallbackIlluminance,
    CallbackColorTemperature,
}
impl From<ColorV2BrickletFunction> for u8 {
    fn from(fun: ColorV2BrickletFunction) -> Self {
        match fun {
            ColorV2BrickletFunction::GetColor => 1,
            ColorV2BrickletFunction::SetColorCallbackConfiguration => 2,
            ColorV2BrickletFunction::GetColorCallbackConfiguration => 3,
            ColorV2BrickletFunction::GetIlluminance => 5,
            ColorV2BrickletFunction::SetIlluminanceCallbackConfiguration => 6,
            ColorV2BrickletFunction::GetIlluminanceCallbackConfiguration => 7,
            ColorV2BrickletFunction::GetColorTemperature => 9,
            ColorV2BrickletFunction::SetColorTemperatureCallbackConfiguration => 10,
            ColorV2BrickletFunction::GetColorTemperatureCallbackConfiguration => 11,
            ColorV2BrickletFunction::SetLight => 13,
            ColorV2BrickletFunction::GetLight => 14,
            ColorV2BrickletFunction::SetConfiguration => 15,
            ColorV2BrickletFunction::GetConfiguration => 16,
            ColorV2BrickletFunction::GetSpitfpErrorCount => 234,
            ColorV2BrickletFunction::SetBootloaderMode => 235,
            ColorV2BrickletFunction::GetBootloaderMode => 236,
            ColorV2BrickletFunction::SetWriteFirmwarePointer => 237,
            ColorV2BrickletFunction::WriteFirmware => 238,
            ColorV2BrickletFunction::SetStatusLedConfig => 239,
            ColorV2BrickletFunction::GetStatusLedConfig => 240,
            ColorV2BrickletFunction::GetChipTemperature => 242,
            ColorV2BrickletFunction::Reset => 243,
            ColorV2BrickletFunction::WriteUid => 248,
            ColorV2BrickletFunction::ReadUid => 249,
            ColorV2BrickletFunction::GetIdentity => 255,
            ColorV2BrickletFunction::CallbackColor => 4,
            ColorV2BrickletFunction::CallbackIlluminance => 8,
            ColorV2BrickletFunction::CallbackColorTemperature => 12,
        }
    }
}
pub const COLOR_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const COLOR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const COLOR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const COLOR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const COLOR_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const COLOR_V2_BRICKLET_GAIN_1X: u8 = 0;
pub const COLOR_V2_BRICKLET_GAIN_4X: u8 = 1;
pub const COLOR_V2_BRICKLET_GAIN_16X: u8 = 2;
pub const COLOR_V2_BRICKLET_GAIN_60X: u8 = 3;
pub const COLOR_V2_BRICKLET_INTEGRATION_TIME_2MS: u8 = 0;
pub const COLOR_V2_BRICKLET_INTEGRATION_TIME_24MS: u8 = 1;
pub const COLOR_V2_BRICKLET_INTEGRATION_TIME_101MS: u8 = 2;
pub const COLOR_V2_BRICKLET_INTEGRATION_TIME_154MS: u8 = 3;
pub const COLOR_V2_BRICKLET_INTEGRATION_TIME_700MS: u8 = 4;
pub const COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const COLOR_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const COLOR_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const COLOR_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Color {
    pub r: u16,
    pub g: u16,
    pub b: u16,
    pub c: u16,
}
impl FromByteSlice for Color {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Color {
        Color {
            r: <u16>::from_le_byte_slice(&bytes[0..2]),
            g: <u16>::from_le_byte_slice(&bytes[2..4]),
            b: <u16>::from_le_byte_slice(&bytes[4..6]),
            c: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for ColorCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorCallbackConfiguration {
        ColorCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorEvent {
    pub r: u16,
    pub g: u16,
    pub b: u16,
    pub c: u16,
}
impl FromByteSlice for ColorEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorEvent {
        ColorEvent {
            r: <u16>::from_le_byte_slice(&bytes[0..2]),
            g: <u16>::from_le_byte_slice(&bytes[2..4]),
            b: <u16>::from_le_byte_slice(&bytes[4..6]),
            c: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IlluminanceCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for IlluminanceCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> IlluminanceCallbackConfiguration {
        IlluminanceCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u32>::from_le_byte_slice(&bytes[6..10]),
            max: <u32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorTemperatureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for ColorTemperatureCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorTemperatureCallbackConfiguration {
        ColorTemperatureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u16>::from_le_byte_slice(&bytes[6..8]),
            max: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub gain: u8,
    pub integration_time: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { gain: <u8>::from_le_byte_slice(&bytes[0..1]), integration_time: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures color (RGB value), illuminance and color temperature
#[derive(Clone)]
pub struct ColorV2Bricklet {
    device: Device,
}
impl ColorV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2128;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Color Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ColorV2Bricklet {
        let mut result = ColorV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetColor) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetColorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetColorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetIlluminance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetIlluminanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetIlluminanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetColorTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetColorTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetColorTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetLight) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetLight) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::color_v2_bricklet::ColorV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::color_v2_bricklet::ColorV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ColorV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ColorV2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_color_callback_configuration`]. The parameter is the color
    /// of the sensor as RGBC.
    ///
    /// The [`get_color_callback_receiver`] receiver is only triggered if the color has changed since the
    /// last triggering.
    ///
    /// [`set_color_callback_configuration`]: #method.set_color_callback_configuration
    /// [`get_color_callback_receiver`]: #method.get_color_callback_receiver
    pub fn get_color_callback_receiver(&self) -> ConvertingCallbackReceiver<ColorEvent> {
        self.device.get_callback_receiver(u8::from(ColorV2BrickletFunction::CallbackColor))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_illuminance_callback_configuration`].
    ///
    /// The parameter is the same as [`get_illuminance`].
    pub fn get_illuminance_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(ColorV2BrickletFunction::CallbackIlluminance))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_color_temperature_callback_configuration`].
    ///
    /// The parameter is the same as [`get_color_temperature`].
    pub fn get_color_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(ColorV2BrickletFunction::CallbackColorTemperature))
    }

    /// Returns the measured color of the sensor.
    ///
    /// The red (r), green (g), blue (b) and clear (c) colors are measured
    /// with four different photodiodes that are responsive at different
    /// wavelengths:
    ///
    /// .. image:: /Images/Bricklets/bricklet_color_wavelength_chart_600.jpg
    ///    :scale: 100 %
    ///    :alt: Chart Responsivity / Wavelength
    ///    :align: center
    ///    :target: ../../_images/Bricklets/bricklet_color_wavelength_chart_600.jpg
    ///
    /// If you want to get the color periodically, it is recommended
    /// to use the [`get_color_callback_receiver`] receiver and set the period with
    /// [`set_color_callback_configuration`].
    pub fn get_color(&self) -> ConvertingReceiver<Color> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetColor), payload)
    }

    /// The period is the period with which the [`get_color_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_color_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ColorV2BrickletFunction::SetColorCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_color_callback_configuration`].
    pub fn get_color_callback_configuration(&self) -> ConvertingReceiver<ColorCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetColorCallbackConfiguration), payload)
    }

    /// Returns the illuminance affected by the gain and integration time as
    /// set by [`set_configuration`]. To get the illuminance in Lux apply this formula::
    ///
    ///  lux = illuminance * 700 / gain / integration_time
    ///
    /// To get a correct illuminance measurement make sure that the color
    /// values themselves are not saturated. The color value (R, G or B)
    /// is saturated if it is equal to the maximum value of 65535.
    /// In that case you have to reduce the gain, see [`set_configuration`].
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_illuminance_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_illuminance_callback_configuration`].
    pub fn get_illuminance(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetIlluminance), payload)
    }

    /// The period is the period with which the [`get_illuminance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_illuminance_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_illuminance_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u32,
        max: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(ColorV2BrickletFunction::SetIlluminanceCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_illuminance_callback_configuration`].
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_illuminance_callback_configuration(&self) -> ConvertingReceiver<IlluminanceCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetIlluminanceCallbackConfiguration), payload)
    }

    /// Returns the color temperature.
    ///
    /// To get a correct color temperature measurement make sure that the color
    /// values themselves are not saturated. The color value (R, G or B)
    /// is saturated if it is equal to the maximum value of 65535.
    /// In that case you have to reduce the gain, see [`set_configuration`].
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_color_temperature_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_color_temperature_callback_configuration`].
    pub fn get_color_temperature(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetColorTemperature), payload)
    }

    /// The period is the period with which the [`get_color_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_color_temperature_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_color_temperature_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u16,
        max: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(ColorV2BrickletFunction::SetColorTemperatureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_color_temperature_callback_configuration`].
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_color_temperature_callback_configuration(&self) -> ConvertingReceiver<ColorTemperatureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetColorTemperatureCallbackConfiguration), payload)
    }

    /// Turns the white LED on the Bricklet on/off.
    pub fn set_light(&self, enable: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));

        self.device.set(u8::from(ColorV2BrickletFunction::SetLight), payload)
    }

    /// Returns the value as set by [`set_light`].
    pub fn get_light(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetLight), payload)
    }

    /// Sets the configuration of the sensor. Gain and integration time
    /// can be configured this way.
    ///
    /// For configuring the gain:
    ///
    /// * 0: 1x Gain
    /// * 1: 4x Gain
    /// * 2: 16x Gain
    /// * 3: 60x Gain
    ///
    /// For configuring the integration time:
    ///
    /// * 0: 2.4ms
    /// * 1: 24ms
    /// * 2: 101ms
    /// * 3: 154ms
    /// * 4: 700ms
    ///
    /// Increasing the gain enables the sensor to detect a
    /// color from a higher distance.
    ///
    /// The integration time provides a trade-off between conversion time
    /// and accuracy. With a longer integration time the values read will
    /// be more accurate but it will take longer to get the conversion
    /// results.
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_GAIN_1X
    ///	* COLOR_V2_BRICKLET_GAIN_4X
    ///	* COLOR_V2_BRICKLET_GAIN_16X
    ///	* COLOR_V2_BRICKLET_GAIN_60X
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_2MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_24MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_101MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_154MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_700MS
    pub fn set_configuration(&self, gain: u8, integration_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(gain));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(integration_time));

        self.device.set(u8::from(ColorV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_GAIN_1X
    ///	* COLOR_V2_BRICKLET_GAIN_4X
    ///	* COLOR_V2_BRICKLET_GAIN_16X
    ///	* COLOR_V2_BRICKLET_GAIN_60X
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_2MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_24MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_101MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_154MS
    ///	* COLOR_V2_BRICKLET_INTEGRATION_TIME_700MS
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(ColorV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* COLOR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(ColorV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(ColorV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ColorV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * COLOR_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* COLOR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ColorV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(ColorV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorV2BrickletFunction::GetIdentity), payload)
    }
}
