/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures color (RGB value), illuminance and color temperature.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Color_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ColorBrickletFunction {
    GetColor,
    SetColorCallbackPeriod,
    GetColorCallbackPeriod,
    SetColorCallbackThreshold,
    GetColorCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    LightOn,
    LightOff,
    IsLightOn,
    SetConfig,
    GetConfig,
    GetIlluminance,
    GetColorTemperature,
    SetIlluminanceCallbackPeriod,
    GetIlluminanceCallbackPeriod,
    SetColorTemperatureCallbackPeriod,
    GetColorTemperatureCallbackPeriod,
    GetIdentity,
    CallbackColor,
    CallbackColorReached,
    CallbackIlluminance,
    CallbackColorTemperature,
}
impl From<ColorBrickletFunction> for u8 {
    fn from(fun: ColorBrickletFunction) -> Self {
        match fun {
            ColorBrickletFunction::GetColor => 1,
            ColorBrickletFunction::SetColorCallbackPeriod => 2,
            ColorBrickletFunction::GetColorCallbackPeriod => 3,
            ColorBrickletFunction::SetColorCallbackThreshold => 4,
            ColorBrickletFunction::GetColorCallbackThreshold => 5,
            ColorBrickletFunction::SetDebouncePeriod => 6,
            ColorBrickletFunction::GetDebouncePeriod => 7,
            ColorBrickletFunction::LightOn => 10,
            ColorBrickletFunction::LightOff => 11,
            ColorBrickletFunction::IsLightOn => 12,
            ColorBrickletFunction::SetConfig => 13,
            ColorBrickletFunction::GetConfig => 14,
            ColorBrickletFunction::GetIlluminance => 15,
            ColorBrickletFunction::GetColorTemperature => 16,
            ColorBrickletFunction::SetIlluminanceCallbackPeriod => 17,
            ColorBrickletFunction::GetIlluminanceCallbackPeriod => 18,
            ColorBrickletFunction::SetColorTemperatureCallbackPeriod => 19,
            ColorBrickletFunction::GetColorTemperatureCallbackPeriod => 20,
            ColorBrickletFunction::GetIdentity => 255,
            ColorBrickletFunction::CallbackColor => 8,
            ColorBrickletFunction::CallbackColorReached => 9,
            ColorBrickletFunction::CallbackIlluminance => 21,
            ColorBrickletFunction::CallbackColorTemperature => 22,
        }
    }
}
pub const COLOR_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const COLOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const COLOR_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const COLOR_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const COLOR_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const COLOR_BRICKLET_LIGHT_ON: u8 = 0;
pub const COLOR_BRICKLET_LIGHT_OFF: u8 = 1;
pub const COLOR_BRICKLET_GAIN_1X: u8 = 0;
pub const COLOR_BRICKLET_GAIN_4X: u8 = 1;
pub const COLOR_BRICKLET_GAIN_16X: u8 = 2;
pub const COLOR_BRICKLET_GAIN_60X: u8 = 3;
pub const COLOR_BRICKLET_INTEGRATION_TIME_2MS: u8 = 0;
pub const COLOR_BRICKLET_INTEGRATION_TIME_24MS: u8 = 1;
pub const COLOR_BRICKLET_INTEGRATION_TIME_101MS: u8 = 2;
pub const COLOR_BRICKLET_INTEGRATION_TIME_154MS: u8 = 3;
pub const COLOR_BRICKLET_INTEGRATION_TIME_700MS: u8 = 4;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Color {
    pub r: u16,
    pub g: u16,
    pub b: u16,
    pub c: u16,
}
impl FromByteSlice for Color {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Color {
        Color {
            r: <u16>::from_le_byte_slice(&bytes[0..2]),
            g: <u16>::from_le_byte_slice(&bytes[2..4]),
            b: <u16>::from_le_byte_slice(&bytes[4..6]),
            c: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorCallbackThreshold {
    pub option: char,
    pub min_r: u16,
    pub max_r: u16,
    pub min_g: u16,
    pub max_g: u16,
    pub min_b: u16,
    pub max_b: u16,
    pub min_c: u16,
    pub max_c: u16,
}
impl FromByteSlice for ColorCallbackThreshold {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorCallbackThreshold {
        ColorCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min_r: <u16>::from_le_byte_slice(&bytes[1..3]),
            max_r: <u16>::from_le_byte_slice(&bytes[3..5]),
            min_g: <u16>::from_le_byte_slice(&bytes[5..7]),
            max_g: <u16>::from_le_byte_slice(&bytes[7..9]),
            min_b: <u16>::from_le_byte_slice(&bytes[9..11]),
            max_b: <u16>::from_le_byte_slice(&bytes[11..13]),
            min_c: <u16>::from_le_byte_slice(&bytes[13..15]),
            max_c: <u16>::from_le_byte_slice(&bytes[15..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorEvent {
    pub r: u16,
    pub g: u16,
    pub b: u16,
    pub c: u16,
}
impl FromByteSlice for ColorEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorEvent {
        ColorEvent {
            r: <u16>::from_le_byte_slice(&bytes[0..2]),
            g: <u16>::from_le_byte_slice(&bytes[2..4]),
            b: <u16>::from_le_byte_slice(&bytes[4..6]),
            c: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorReachedEvent {
    pub r: u16,
    pub g: u16,
    pub b: u16,
    pub c: u16,
}
impl FromByteSlice for ColorReachedEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorReachedEvent {
        ColorReachedEvent {
            r: <u16>::from_le_byte_slice(&bytes[0..2]),
            g: <u16>::from_le_byte_slice(&bytes[2..4]),
            b: <u16>::from_le_byte_slice(&bytes[4..6]),
            c: <u16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Config {
    pub gain: u8,
    pub integration_time: u8,
}
impl FromByteSlice for Config {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Config {
        Config { gain: <u8>::from_le_byte_slice(&bytes[0..1]), integration_time: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures color (RGB value), illuminance and color temperature
#[derive(Clone)]
pub struct ColorBricklet {
    device: Device,
}
impl ColorBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 243;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Color Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ColorBricklet {
        let mut result = ColorBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ColorBrickletFunction::GetColor) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetColorCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetColorCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetColorCallbackThreshold) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetColorCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::LightOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorBrickletFunction::LightOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorBrickletFunction::IsLightOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetIlluminance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetColorTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::SetColorTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetColorTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ColorBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::color_bricklet::ColorBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::color_bricklet::ColorBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ColorBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ColorBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_color_callback_period`]. The parameter is the color
    /// of the sensor as RGBC.
    ///
    /// The [`get_color_callback_receiver`] receiver is only triggered if the color has changed since the
    /// last triggering.
    ///
    /// [`set_color_callback_period`]: #method.set_color_callback_period
    /// [`get_color_callback_receiver`]: #method.get_color_callback_receiver
    pub fn get_color_callback_receiver(&self) -> ConvertingCallbackReceiver<ColorEvent> {
        self.device.get_callback_receiver(u8::from(ColorBrickletFunction::CallbackColor))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_color_callback_threshold`] is reached.
    /// The parameter is the color
    /// of the sensor as RGBC.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_color_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<ColorReachedEvent> {
        self.device.get_callback_receiver(u8::from(ColorBrickletFunction::CallbackColorReached))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_illuminance_callback_period`]. The parameter is the illuminance.
    /// See [`get_illuminance`] for how to interpret this value.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed
    /// since the last triggering.
    pub fn get_illuminance_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(ColorBrickletFunction::CallbackIlluminance))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_color_temperature_callback_period`]. The parameter is the
    /// color temperature.
    ///
    /// The [`get_color_temperature_callback_receiver`] receiver is only triggered if the color temperature
    /// has changed since the last triggering.
    pub fn get_color_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(ColorBrickletFunction::CallbackColorTemperature))
    }

    /// Returns the measured color of the sensor.
    ///
    /// The red (r), green (g), blue (b) and clear (c) colors are measured
    /// with four different photodiodes that are responsive at different
    /// wavelengths:
    ///
    /// .. image:: /Images/Bricklets/bricklet_color_wavelength_chart_600.jpg
    ///    :scale: 100 %
    ///    :alt: Chart Responsivity / Wavelength
    ///    :align: center
    ///    :target: ../../_images/Bricklets/bricklet_color_wavelength_chart_600.jpg
    ///
    /// If you want to get the color periodically, it is recommended
    /// to use the [`get_color_callback_receiver`] receiver and set the period with
    /// [`set_color_callback_period`].
    pub fn get_color(&self) -> ConvertingReceiver<Color> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetColor), payload)
    }

    /// Sets the period with which the [`get_color_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_color_callback_receiver`] receiver is only triggered if the color has changed since the
    /// last triggering.
    pub fn set_color_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ColorBrickletFunction::SetColorCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_color_callback_period`].
    pub fn get_color_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetColorCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_color_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * COLOR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_color_callback_threshold(
        &self,
        option: char,
        min_r: u16,
        max_r: u16,
        min_g: u16,
        max_g: u16,
        min_b: u16,
        max_b: u16,
        min_c: u16,
        max_c: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 17];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min_r));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max_r));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(min_g));
        payload[7..9].copy_from_slice(&<u16>::to_le_byte_vec(max_g));
        payload[9..11].copy_from_slice(&<u16>::to_le_byte_vec(min_b));
        payload[11..13].copy_from_slice(&<u16>::to_le_byte_vec(max_b));
        payload[13..15].copy_from_slice(&<u16>::to_le_byte_vec(min_c));
        payload[15..17].copy_from_slice(&<u16>::to_le_byte_vec(max_c));

        self.device.set(u8::from(ColorBrickletFunction::SetColorCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_color_callback_threshold`].
    ///
    /// Associated constants:
    /// * COLOR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* COLOR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_color_callback_threshold(&self) -> ConvertingReceiver<ColorCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetColorCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_color_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_color_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(ColorBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Turns the LED on.
    pub fn light_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ColorBrickletFunction::LightOn), payload)
    }

    /// Turns the LED off.
    pub fn light_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ColorBrickletFunction::LightOff), payload)
    }

    /// Returns the state of the LED. Possible values are:
    ///
    /// * 0: On
    /// * 1: Off
    ///
    /// Associated constants:
    /// * COLOR_BRICKLET_LIGHT_ON
    ///	* COLOR_BRICKLET_LIGHT_OFF
    pub fn is_light_on(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::IsLightOn), payload)
    }

    /// Sets the configuration of the sensor. Gain and integration time
    /// can be configured in this way.
    ///
    /// For configuring the gain:
    ///
    /// * 0: 1x Gain
    /// * 1: 4x Gain
    /// * 2: 16x Gain
    /// * 3: 60x Gain
    ///
    /// For configuring the integration time:
    ///
    /// * 0: 2.4ms
    /// * 1: 24ms
    /// * 2: 101ms
    /// * 3: 154ms
    /// * 4: 700ms
    ///
    /// Increasing the gain enables the sensor to detect a
    /// color from a higher distance.
    ///
    /// The integration time provides a trade-off between conversion time
    /// and accuracy. With a longer integration time the values read will
    /// be more accurate but it will take longer time to get the conversion
    /// results.
    ///
    /// Associated constants:
    /// * COLOR_BRICKLET_GAIN_1X
    ///	* COLOR_BRICKLET_GAIN_4X
    ///	* COLOR_BRICKLET_GAIN_16X
    ///	* COLOR_BRICKLET_GAIN_60X
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_2MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_24MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_101MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_154MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_700MS
    pub fn set_config(&self, gain: u8, integration_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(gain));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(integration_time));

        self.device.set(u8::from(ColorBrickletFunction::SetConfig), payload)
    }

    /// Returns the configuration as set by [`set_config`].
    ///
    /// Associated constants:
    /// * COLOR_BRICKLET_GAIN_1X
    ///	* COLOR_BRICKLET_GAIN_4X
    ///	* COLOR_BRICKLET_GAIN_16X
    ///	* COLOR_BRICKLET_GAIN_60X
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_2MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_24MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_101MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_154MS
    ///	* COLOR_BRICKLET_INTEGRATION_TIME_700MS
    pub fn get_config(&self) -> ConvertingReceiver<Config> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetConfig), payload)
    }

    /// Returns the illuminance affected by the gain and integration time as
    /// set by [`set_config`]. To get the illuminance in Lux apply this formula::
    ///
    ///  lux = illuminance * 700 / gain / integration_time
    ///
    /// To get a correct illuminance measurement make sure that the color
    /// values themselves are not saturated. The color value (R, G or B)
    /// is saturated if it is equal to the maximum value of 65535.
    /// In that case you have to reduce the gain, see [`set_config`].
    pub fn get_illuminance(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetIlluminance), payload)
    }

    /// Returns the color temperature.
    ///
    /// To get a correct color temperature measurement make sure that the color
    /// values themselves are not saturated. The color value (R, G or B)
    /// is saturated if it is equal to the maximum value of 65535.
    /// In that case you have to reduce the gain, see [`set_config`].
    pub fn get_color_temperature(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetColorTemperature), payload)
    }

    /// Sets the period with which the [`get_illuminance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed
    /// since the last triggering.
    pub fn set_illuminance_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ColorBrickletFunction::SetIlluminanceCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_illuminance_callback_period`].
    pub fn get_illuminance_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetIlluminanceCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_color_temperature_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_color_temperature_callback_receiver`] receiver is only triggered if the color temperature
    /// has changed since the last triggering.
    pub fn set_color_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ColorBrickletFunction::SetColorTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_color_temperature_callback_period`].
    pub fn get_color_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetColorTemperatureCallbackPeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ColorBrickletFunction::GetIdentity), payload)
    }
}
