/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Communicates with CAN bus devices.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/CANV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum CanV2BrickletFunction {
    WriteFrameLowLevel,
    ReadFrameLowLevel,
    SetFrameReadCallbackConfiguration,
    GetFrameReadCallbackConfiguration,
    SetTransceiverConfiguration,
    GetTransceiverConfiguration,
    SetQueueConfigurationLowLevel,
    GetQueueConfigurationLowLevel,
    SetReadFilterConfiguration,
    GetReadFilterConfiguration,
    GetErrorLogLowLevel,
    SetCommunicationLedConfig,
    GetCommunicationLedConfig,
    SetErrorLedConfig,
    GetErrorLedConfig,
    SetFrameReadableCallbackConfiguration,
    GetFrameReadableCallbackConfiguration,
    SetErrorOccurredCallbackConfiguration,
    GetErrorOccurredCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackFrameReadLowLevel,
    CallbackFrameReadable,
    CallbackErrorOccurred,
}
impl From<CanV2BrickletFunction> for u8 {
    fn from(fun: CanV2BrickletFunction) -> Self {
        match fun {
            CanV2BrickletFunction::WriteFrameLowLevel => 1,
            CanV2BrickletFunction::ReadFrameLowLevel => 2,
            CanV2BrickletFunction::SetFrameReadCallbackConfiguration => 3,
            CanV2BrickletFunction::GetFrameReadCallbackConfiguration => 4,
            CanV2BrickletFunction::SetTransceiverConfiguration => 5,
            CanV2BrickletFunction::GetTransceiverConfiguration => 6,
            CanV2BrickletFunction::SetQueueConfigurationLowLevel => 7,
            CanV2BrickletFunction::GetQueueConfigurationLowLevel => 8,
            CanV2BrickletFunction::SetReadFilterConfiguration => 9,
            CanV2BrickletFunction::GetReadFilterConfiguration => 10,
            CanV2BrickletFunction::GetErrorLogLowLevel => 11,
            CanV2BrickletFunction::SetCommunicationLedConfig => 12,
            CanV2BrickletFunction::GetCommunicationLedConfig => 13,
            CanV2BrickletFunction::SetErrorLedConfig => 14,
            CanV2BrickletFunction::GetErrorLedConfig => 15,
            CanV2BrickletFunction::SetFrameReadableCallbackConfiguration => 17,
            CanV2BrickletFunction::GetFrameReadableCallbackConfiguration => 18,
            CanV2BrickletFunction::SetErrorOccurredCallbackConfiguration => 20,
            CanV2BrickletFunction::GetErrorOccurredCallbackConfiguration => 21,
            CanV2BrickletFunction::GetSpitfpErrorCount => 234,
            CanV2BrickletFunction::SetBootloaderMode => 235,
            CanV2BrickletFunction::GetBootloaderMode => 236,
            CanV2BrickletFunction::SetWriteFirmwarePointer => 237,
            CanV2BrickletFunction::WriteFirmware => 238,
            CanV2BrickletFunction::SetStatusLedConfig => 239,
            CanV2BrickletFunction::GetStatusLedConfig => 240,
            CanV2BrickletFunction::GetChipTemperature => 242,
            CanV2BrickletFunction::Reset => 243,
            CanV2BrickletFunction::WriteUid => 248,
            CanV2BrickletFunction::ReadUid => 249,
            CanV2BrickletFunction::GetIdentity => 255,
            CanV2BrickletFunction::CallbackFrameReadLowLevel => 16,
            CanV2BrickletFunction::CallbackFrameReadable => 19,
            CanV2BrickletFunction::CallbackErrorOccurred => 22,
        }
    }
}
pub const CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_DATA: u8 = 0;
pub const CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_REMOTE: u8 = 1;
pub const CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_DATA: u8 = 2;
pub const CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE: u8 = 3;
pub const CAN_V2_BRICKLET_TRANSCEIVER_MODE_NORMAL: u8 = 0;
pub const CAN_V2_BRICKLET_TRANSCEIVER_MODE_LOOPBACK: u8 = 1;
pub const CAN_V2_BRICKLET_TRANSCEIVER_MODE_READ_ONLY: u8 = 2;
pub const CAN_V2_BRICKLET_FILTER_MODE_ACCEPT_ALL: u8 = 0;
pub const CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_ONLY: u8 = 1;
pub const CAN_V2_BRICKLET_FILTER_MODE_MATCH_EXTENDED_ONLY: u8 = 2;
pub const CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_EXTENDED: u8 = 3;
pub const CAN_V2_BRICKLET_TRANSCEIVER_STATE_ACTIVE: u8 = 0;
pub const CAN_V2_BRICKLET_TRANSCEIVER_STATE_PASSIVE: u8 = 1;
pub const CAN_V2_BRICKLET_TRANSCEIVER_STATE_DISABLED: u8 = 2;
pub const CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_OFF: u8 = 0;
pub const CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_ON: u8 = 1;
pub const CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION: u8 = 3;
pub const CAN_V2_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const CAN_V2_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_TRANSCEIVER_STATE: u8 = 3;
pub const CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 4;
pub const CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const CAN_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const CAN_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const CAN_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteFrameLowLevel {
    pub success: bool,
}
impl FromByteSlice for WriteFrameLowLevel {
    fn bytes_expected() -> usize { 1 }
    fn from_le_byte_slice(bytes: &[u8]) -> WriteFrameLowLevel { WriteFrameLowLevel { success: <bool>::from_le_byte_slice(&bytes[0..1]) } }
}
impl LowLevelWrite<WriteFrameResult> for WriteFrameLowLevel {
    fn ll_message_written(&self) -> usize { 15 }

    fn get_result(&self) -> WriteFrameResult { WriteFrameResult { success: self.success } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFrameLowLevel {
    pub success: bool,
    pub frame_type: u8,
    pub identifier: u32,
    pub data_length: u8,
    pub data_data: [u8; 15],
}
impl FromByteSlice for ReadFrameLowLevel {
    fn bytes_expected() -> usize { 22 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFrameLowLevel {
        ReadFrameLowLevel {
            success: <bool>::from_le_byte_slice(&bytes[0..1]),
            frame_type: <u8>::from_le_byte_slice(&bytes[1..2]),
            identifier: <u32>::from_le_byte_slice(&bytes[2..6]),
            data_length: <u8>::from_le_byte_slice(&bytes[6..7]),
            data_data: <[u8; 15]>::from_le_byte_slice(&bytes[7..22]),
        }
    }
}
impl LowLevelRead<u8, ReadFrameResult> for ReadFrameLowLevel {
    fn ll_message_length(&self) -> usize { self.data_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.data_data }

    fn get_result(&self) -> ReadFrameResult {
        ReadFrameResult { success: self.success, frame_type: self.frame_type, identifier: self.identifier }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TransceiverConfiguration {
    pub baud_rate: u32,
    pub sample_point: u16,
    pub transceiver_mode: u8,
}
impl FromByteSlice for TransceiverConfiguration {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> TransceiverConfiguration {
        TransceiverConfiguration {
            baud_rate: <u32>::from_le_byte_slice(&bytes[0..4]),
            sample_point: <u16>::from_le_byte_slice(&bytes[4..6]),
            transceiver_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetQueueConfigurationLowLevel {}
impl FromByteSlice for SetQueueConfigurationLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> SetQueueConfigurationLowLevel { SetQueueConfigurationLowLevel {} }
}
impl LowLevelWrite<SetQueueConfigurationResult> for SetQueueConfigurationLowLevel {
    fn ll_message_written(&self) -> usize { 32 }

    fn get_result(&self) -> SetQueueConfigurationResult { SetQueueConfigurationResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct QueueConfigurationLowLevel {
    pub write_buffer_size: u8,
    pub write_buffer_timeout: i32,
    pub write_backlog_size: u16,
    pub read_buffer_sizes_length: u8,
    pub read_buffer_sizes_data: [i8; 32],
    pub read_backlog_size: u16,
}
impl FromByteSlice for QueueConfigurationLowLevel {
    fn bytes_expected() -> usize { 42 }
    fn from_le_byte_slice(bytes: &[u8]) -> QueueConfigurationLowLevel {
        QueueConfigurationLowLevel {
            write_buffer_size: <u8>::from_le_byte_slice(&bytes[0..1]),
            write_buffer_timeout: <i32>::from_le_byte_slice(&bytes[1..5]),
            write_backlog_size: <u16>::from_le_byte_slice(&bytes[5..7]),
            read_buffer_sizes_length: <u8>::from_le_byte_slice(&bytes[7..8]),
            read_buffer_sizes_data: <[i8; 32]>::from_le_byte_slice(&bytes[8..40]),
            read_backlog_size: <u16>::from_le_byte_slice(&bytes[40..42]),
        }
    }
}
impl LowLevelRead<i8, QueueConfigurationResult> for QueueConfigurationLowLevel {
    fn ll_message_length(&self) -> usize { self.read_buffer_sizes_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[i8] { &self.read_buffer_sizes_data }

    fn get_result(&self) -> QueueConfigurationResult {
        QueueConfigurationResult {
            write_buffer_size: self.write_buffer_size,
            write_buffer_timeout: self.write_buffer_timeout,
            write_backlog_size: self.write_backlog_size,
            read_backlog_size: self.read_backlog_size,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFilterConfiguration {
    pub filter_mode: u8,
    pub filter_mask: u32,
    pub filter_identifier: u32,
}
impl FromByteSlice for ReadFilterConfiguration {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFilterConfiguration {
        ReadFilterConfiguration {
            filter_mode: <u8>::from_le_byte_slice(&bytes[0..1]),
            filter_mask: <u32>::from_le_byte_slice(&bytes[1..5]),
            filter_identifier: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorLogLowLevel {
    pub transceiver_state: u8,
    pub transceiver_write_error_level: u8,
    pub transceiver_read_error_level: u8,
    pub transceiver_stuffing_error_count: u32,
    pub transceiver_format_error_count: u32,
    pub transceiver_ack_error_count: u32,
    pub transceiver_bit1_error_count: u32,
    pub transceiver_bit0_error_count: u32,
    pub transceiver_crc_error_count: u32,
    pub write_buffer_timeout_error_count: u32,
    pub read_buffer_overflow_error_count: u32,
    pub read_buffer_overflow_error_occurred_length: u8,
    pub read_buffer_overflow_error_occurred_data: [bool; 32],
    pub read_backlog_overflow_error_count: u32,
}
impl FromByteSlice for ErrorLogLowLevel {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorLogLowLevel {
        ErrorLogLowLevel {
            transceiver_state: <u8>::from_le_byte_slice(&bytes[0..1]),
            transceiver_write_error_level: <u8>::from_le_byte_slice(&bytes[1..2]),
            transceiver_read_error_level: <u8>::from_le_byte_slice(&bytes[2..3]),
            transceiver_stuffing_error_count: <u32>::from_le_byte_slice(&bytes[3..7]),
            transceiver_format_error_count: <u32>::from_le_byte_slice(&bytes[7..11]),
            transceiver_ack_error_count: <u32>::from_le_byte_slice(&bytes[11..15]),
            transceiver_bit1_error_count: <u32>::from_le_byte_slice(&bytes[15..19]),
            transceiver_bit0_error_count: <u32>::from_le_byte_slice(&bytes[19..23]),
            transceiver_crc_error_count: <u32>::from_le_byte_slice(&bytes[23..27]),
            write_buffer_timeout_error_count: <u32>::from_le_byte_slice(&bytes[27..31]),
            read_buffer_overflow_error_count: <u32>::from_le_byte_slice(&bytes[31..35]),
            read_buffer_overflow_error_occurred_length: <u8>::from_le_byte_slice(&bytes[35..36]),
            read_buffer_overflow_error_occurred_data: <[bool; 32]>::from_le_byte_slice(&bytes[36..40]),
            read_backlog_overflow_error_count: <u32>::from_le_byte_slice(&bytes[40..44]),
        }
    }
}
impl LowLevelRead<bool, ErrorLogResult> for ErrorLogLowLevel {
    fn ll_message_length(&self) -> usize { self.read_buffer_overflow_error_occurred_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.read_buffer_overflow_error_occurred_data }

    fn get_result(&self) -> ErrorLogResult {
        ErrorLogResult {
            transceiver_state: self.transceiver_state,
            transceiver_write_error_level: self.transceiver_write_error_level,
            transceiver_read_error_level: self.transceiver_read_error_level,
            transceiver_stuffing_error_count: self.transceiver_stuffing_error_count,
            transceiver_format_error_count: self.transceiver_format_error_count,
            transceiver_ack_error_count: self.transceiver_ack_error_count,
            transceiver_bit1_error_count: self.transceiver_bit1_error_count,
            transceiver_bit0_error_count: self.transceiver_bit0_error_count,
            transceiver_crc_error_count: self.transceiver_crc_error_count,
            write_buffer_timeout_error_count: self.write_buffer_timeout_error_count,
            read_buffer_overflow_error_count: self.read_buffer_overflow_error_count,
            read_backlog_overflow_error_count: self.read_backlog_overflow_error_count,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameReadLowLevelEvent {
    pub frame_type: u8,
    pub identifier: u32,
    pub data_length: u8,
    pub data_data: [u8; 15],
}
impl FromByteSlice for FrameReadLowLevelEvent {
    fn bytes_expected() -> usize { 21 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameReadLowLevelEvent {
        FrameReadLowLevelEvent {
            frame_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            identifier: <u32>::from_le_byte_slice(&bytes[1..5]),
            data_length: <u8>::from_le_byte_slice(&bytes[5..6]),
            data_data: <[u8; 15]>::from_le_byte_slice(&bytes[6..21]),
        }
    }
}
impl LowLevelRead<u8, FrameReadResult> for FrameReadLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.data_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.data_data }

    fn get_result(&self) -> FrameReadResult { FrameReadResult { frame_type: self.frame_type, identifier: self.identifier } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteFrameResult {
    pub success: bool,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFrameResult {
    pub success: bool,
    pub frame_type: u8,
    pub identifier: u32,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetQueueConfigurationResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct QueueConfigurationResult {
    pub write_buffer_size: u8,
    pub write_buffer_timeout: i32,
    pub write_backlog_size: u16,
    pub read_backlog_size: u16,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorLogResult {
    pub transceiver_state: u8,
    pub transceiver_write_error_level: u8,
    pub transceiver_read_error_level: u8,
    pub transceiver_stuffing_error_count: u32,
    pub transceiver_format_error_count: u32,
    pub transceiver_ack_error_count: u32,
    pub transceiver_bit1_error_count: u32,
    pub transceiver_bit0_error_count: u32,
    pub transceiver_crc_error_count: u32,
    pub write_buffer_timeout_error_count: u32,
    pub read_buffer_overflow_error_count: u32,
    pub read_backlog_overflow_error_count: u32,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameReadResult {
    pub frame_type: u8,
    pub identifier: u32,
}

/// Communicates with CAN bus devices
#[derive(Clone)]
pub struct CanV2Bricklet {
    device: Device,
}
impl CanV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2107;
    pub const DEVICE_DISPLAY_NAME: &'static str = "CAN Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> CanV2Bricklet {
        let mut result = CanV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 6) };
        result.device.response_expected[u8::from(CanV2BrickletFunction::WriteFrameLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::ReadFrameLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetFrameReadCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetFrameReadCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetTransceiverConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetTransceiverConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetQueueConfigurationLowLevel) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetQueueConfigurationLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetReadFilterConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetReadFilterConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetErrorLogLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetCommunicationLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetCommunicationLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetErrorLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetErrorLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetErrorOccurredCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetErrorOccurredCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::can_v2_bricklet::CanV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::can_v2_bricklet::CanV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: CanV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: CanV2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// See [`get_frame_read_callback_receiver`](crate::can_v2::CANV2::get_frame_read_callback_receiver)
    pub fn get_frame_read_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<FrameReadLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(CanV2BrickletFunction::CallbackFrameReadLowLevel))
    }

    /// This receiver is triggered if a data or remote frame was received by the CAN
    /// transceiver.
    ///
    /// The ``identifier`` return value follows the identifier format described for
    /// [`write_frame`].
    ///
    /// For details on the ``data`` return value see [`read_frame`].
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read queue (see
    /// [`set_read_filter_configuration`]).
    ///
    /// To enable this receiver, use [`set_frame_read_callback_configuration`].
    ///
    /// [`write_frame`]: #method.write_frame
    /// [`read_frame`]: #method.read_frame
    /// [`set_frame_read_callback_configuration`]: #method.set_frame_read_callback_configuration
    /// [`set_read_filter_configuration`]: #method.set_read_filter_configuration
    pub fn get_frame_read_callback_receiver(&self) -> ConvertingHighLevelCallbackReceiver<u8, FrameReadResult, FrameReadLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(CanV2BrickletFunction::CallbackFrameReadLowLevel)),
        )
    }

    /// This receiver is triggered if a data or remote frame was received by the CAN
    /// transceiver. The received frame can be read with [`read_frame`].
    /// If additional frames are received, but [`read_frame`] was not called yet, the receiver
    /// will not trigger again.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read queue (see
    /// [`set_read_filter_configuration`]).
    ///
    /// To enable this receiver, use [`set_frame_readable_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_frame_readable_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(CanV2BrickletFunction::CallbackFrameReadable))
    }

    /// This receiver is triggered if any error occurred while writing, reading or transmitting CAN frames.
    ///
    /// The receiver is only triggered once until [`get_error_log`] is called. That function will return
    /// details abount the error(s) occurred.
    ///
    /// To enable this receiver, use [`set_error_occurred_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_error_occurred_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(CanV2BrickletFunction::CallbackErrorOccurred))
    }

    /// Writes a data or remote frame to the write queue to be transmitted over the
    /// CAN transceiver.
    ///
    /// The Bricklet supports the standard 11-bit (CAN 2.0A) and the additional extended
    /// 29-bit (CAN 2.0B) identifiers. For standard frames the Bricklet uses bit 0 to 10
    /// from the ``identifier`` parameter as standard 11-bit identifier. For extended
    /// frames the Bricklet uses bit 0 to 28 from the ``identifier`` parameter as
    /// extended 29-bit identifier.
    ///
    /// The ``data`` parameter can be up to 15 bytes long. For data frames up to 8 bytes
    /// will be used as the actual data. The length (DLC) field in the data or remote
    /// frame will be set to the actual length of the ``data`` parameter. This allows
    /// to transmit data and remote frames with excess length. For remote frames only
    /// the length of the ``data`` parameter is used. The actual ``data`` bytes are
    /// ignored.
    ///
    /// Returns *true* if the frame was successfully added to the write queue. Returns
    /// *false* if the frame could not be added because write queue is already full or
    /// because the write buffer or the write backlog are configured with a size of
    /// zero (see [`set_queue_configuration`]).
    ///
    /// The write queue can overflow if frames are written to it at a higher rate
    /// than the Bricklet can transmitted them over the CAN transceiver. This may
    /// happen if the CAN transceiver is configured as read-only or is using a low baud
    /// rate (see [`set_transceiver_configuration`]). It can also happen if the CAN
    /// bus is congested and the frame cannot be transmitted because it constantly loses
    /// arbitration or because the CAN transceiver is currently disabled due to a high
    /// write error level (see [`get_error_log`]).
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_DATA
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_REMOTE
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_DATA
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE
    pub fn write_frame_low_level(
        &self,
        frame_type: u8,
        identifier: u32,
        data_length: u8,
        data_data: [u8; 15],
    ) -> ConvertingReceiver<WriteFrameLowLevel> {
        let mut payload = vec![0; 21];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(frame_type));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(identifier));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(data_length));
        payload[6..21].copy_from_slice(&<[u8; 15]>::to_le_byte_vec(data_data));

        self.device.get(u8::from(CanV2BrickletFunction::WriteFrameLowLevel), payload)
    }

    /// Writes a data or remote frame to the write queue to be transmitted over the
    /// CAN transceiver.
    ///
    /// The Bricklet supports the standard 11-bit (CAN 2.0A) and the additional extended
    /// 29-bit (CAN 2.0B) identifiers. For standard frames the Bricklet uses bit 0 to 10
    /// from the ``identifier`` parameter as standard 11-bit identifier. For extended
    /// frames the Bricklet uses bit 0 to 28 from the ``identifier`` parameter as
    /// extended 29-bit identifier.
    ///
    /// The ``data`` parameter can be up to 15 bytes long. For data frames up to 8 bytes
    /// will be used as the actual data. The length (DLC) field in the data or remote
    /// frame will be set to the actual length of the ``data`` parameter. This allows
    /// to transmit data and remote frames with excess length. For remote frames only
    /// the length of the ``data`` parameter is used. The actual ``data`` bytes are
    /// ignored.
    ///
    /// Returns *true* if the frame was successfully added to the write queue. Returns
    /// *false* if the frame could not be added because write queue is already full or
    /// because the write buffer or the write backlog are configured with a size of
    /// zero (see [`set_queue_configuration`]).
    ///
    /// The write queue can overflow if frames are written to it at a higher rate
    /// than the Bricklet can transmitted them over the CAN transceiver. This may
    /// happen if the CAN transceiver is configured as read-only or is using a low baud
    /// rate (see [`set_transceiver_configuration`]). It can also happen if the CAN
    /// bus is congested and the frame cannot be transmitted because it constantly loses
    /// arbitration or because the CAN transceiver is currently disabled due to a high
    /// write error level (see [`get_error_log`]).
    pub fn write_frame(&self, frame_type: u8, identifier: u32, data: &[u8]) -> Result<bool, BrickletRecvTimeoutError> {
        let ll_result = self.device.set_high_level(0, data, 15, 15, &mut |length: usize, _chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 15];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            self.write_frame_low_level(frame_type, identifier, length as u8, chunk_array).recv()
        })?;
        Ok(ll_result.1.success)
    }

    /// Tries to read the next data or remote frame from the read queue and returns it.
    /// If a frame was successfully read, then the ``success`` return value is set to
    /// *true* and the other return values contain the frame. If the read queue is
    /// empty and no frame could be read, then the ``success`` return value is set to
    /// *false* and the other return values contain invalid data.
    ///
    /// The ``identifier`` return value follows the identifier format described for
    /// [`write_frame`].
    ///
    /// The ``data`` return value can be up to 15 bytes long. For data frames up to the
    /// first 8 bytes are the actual received data. All bytes after the 8th byte are
    /// always zero and only there to indicate the length of a data or remote frame
    /// with excess length. For remote frames the length of the ``data`` return value
    /// represents the requested length. The actual ``data`` bytes are always zero.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read queue (see
    /// [`set_read_filter_configuration`]).
    ///
    /// Instead of polling with this function, you can also use receivers. See the
    /// [`set_frame_read_callback_configuration`] function and the [`get_frame_read_callback_receiver`]
    /// callback.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_DATA
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_STANDARD_REMOTE
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_DATA
    ///	* CAN_V2_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE
    pub fn read_frame_low_level(&self) -> ConvertingReceiver<ReadFrameLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::ReadFrameLowLevel), payload)
    }

    /// Tries to read the next data or remote frame from the read queue and returns it.
    /// If a frame was successfully read, then the ``success`` return value is set to
    /// *true* and the other return values contain the frame. If the read queue is
    /// empty and no frame could be read, then the ``success`` return value is set to
    /// *false* and the other return values contain invalid data.
    ///
    /// The ``identifier`` return value follows the identifier format described for
    /// [`write_frame`].
    ///
    /// The ``data`` return value can be up to 15 bytes long. For data frames up to the
    /// first 8 bytes are the actual received data. All bytes after the 8th byte are
    /// always zero and only there to indicate the length of a data or remote frame
    /// with excess length. For remote frames the length of the ``data`` return value
    /// represents the requested length. The actual ``data`` bytes are always zero.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read queue (see
    /// [`set_read_filter_configuration`]).
    ///
    /// Instead of polling with this function, you can also use receivers. See the
    /// [`set_frame_read_callback_configuration`] function and the [`get_frame_read_callback_receiver`]
    /// callback.
    pub fn read_frame(&self) -> Result<(Vec<u8>, ReadFrameResult), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_frame_low_level().recv())?;
        Ok((ll_result.0, ll_result.1))
    }

    /// Enables and disables the [`get_frame_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled. Enabling this receiver will disable the [`get_frame_readable_callback_receiver`] receiver.
    pub fn set_frame_read_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(CanV2BrickletFunction::SetFrameReadCallbackConfiguration), payload)
    }

    /// Returns *true* if the [`get_frame_read_callback_receiver`] receiver is enabled, *false* otherwise.
    pub fn get_frame_read_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetFrameReadCallbackConfiguration), payload)
    }

    /// Sets the transceiver configuration for the CAN bus communication.
    ///
    /// The CAN transceiver has three different modes:
    ///
    /// * Normal: Reads from and writes to the CAN bus and performs active bus
    ///   error detection and acknowledgement.
    /// * Loopback: All reads and writes are performed internally. The transceiver
    ///   is disconnected from the actual CAN bus.
    /// * Read-Only: Only reads from the CAN bus, but does neither active bus error
    ///   detection nor acknowledgement. Only the receiving part of the transceiver
    ///   is connected to the CAN bus.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_TRANSCEIVER_MODE_NORMAL
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_MODE_LOOPBACK
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_MODE_READ_ONLY
    pub fn set_transceiver_configuration(&self, baud_rate: u32, sample_point: u16, transceiver_mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(baud_rate));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(sample_point));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(transceiver_mode));

        self.device.set(u8::from(CanV2BrickletFunction::SetTransceiverConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_transceiver_configuration`].
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_TRANSCEIVER_MODE_NORMAL
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_MODE_LOOPBACK
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_MODE_READ_ONLY
    pub fn get_transceiver_configuration(&self) -> ConvertingReceiver<TransceiverConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetTransceiverConfiguration), payload)
    }

    /// Sets the write and read queue configuration.
    ///
    /// The CAN transceiver has 32 buffers in total in hardware for transmitting and
    /// receiving frames. Additionally, the Bricklet has a backlog for 768 frames in
    /// total in software. The buffers and the backlog can be freely assigned to the
    /// write and read queues.
    ///
    /// [`write_frame`] writes a frame into the write backlog. The Bricklet moves
    /// the frame from the backlog into a free write buffer. The CAN transceiver then
    /// transmits the frame from the write buffer to the CAN bus. If there are no
    /// write buffers (``write_buffer_size`` is zero) or there is no write backlog
    /// (``write_backlog_size`` is zero) then no frames can be transmitted and
    /// [`write_frame`] returns always *false*.
    ///
    /// The CAN transceiver receives a frame from the CAN bus and stores it into a
    /// free read buffer. The Bricklet moves the frame from the read buffer into the
    /// read backlog. [`read_frame`] reads the frame from the read backlog and
    /// returns it. If there are no read buffers (``read_buffer_sizes`` is empty) or
    /// there is no read backlog (``read_backlog_size`` is zero) then no frames can be
    /// received and [`read_frame`] returns always *false*.
    ///
    /// There can be multiple read buffers, because the CAN transceiver cannot receive
    /// data and remote frames into the same read buffer. A positive read buffer size
    /// represents a data frame read buffer and a negative read buffer size represents
    /// a remote frame read buffer. A read buffer size of zero is not allowed. By
    /// default the first read buffer is configured for data frames and the second read
    /// buffer is configured for remote frame. There can be up to 32 different read
    /// buffers, assuming that no write buffer is used. Each read buffer has its own
    /// filter configuration (see [`set_read_filter_configuration`]).
    ///
    /// A valid queue configuration fulfills these conditions::
    ///
    ///  write_buffer_size + abs(read_buffer_size_0) + abs(read_buffer_size_1) + ... + abs(read_buffer_size_31) <= 32
    ///  write_backlog_size + read_backlog_size <= 768
    ///
    /// The write buffer timeout has three different modes that define how a failed
    /// frame transmission should be handled:
    ///
    /// * Single-Shot (< 0): Only one transmission attempt will be made. If the
    ///   transmission fails then the frame is discarded.
    /// * Infinite (= 0): Infinite transmission attempts will be made. The frame will
    ///   never be discarded.
    /// * Milliseconds (> 0): A limited number of transmission attempts will be made.
    ///   If the frame could not be transmitted successfully after the configured
    ///   number of milliseconds then the frame is discarded.
    ///
    /// The current content of the queues is lost when this function is called.
    pub fn set_queue_configuration_low_level(
        &self,
        write_buffer_size: u8,
        write_buffer_timeout: i32,
        write_backlog_size: u16,
        read_buffer_sizes_length: u8,
        read_buffer_sizes_data: [i8; 32],
        read_backlog_size: u16,
    ) -> ConvertingReceiver<SetQueueConfigurationLowLevel> {
        let mut payload = vec![0; 42];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(write_buffer_size));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(write_buffer_timeout));
        payload[5..7].copy_from_slice(&<u16>::to_le_byte_vec(write_backlog_size));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(read_buffer_sizes_length));
        payload[8..40].copy_from_slice(&<[i8; 32]>::to_le_byte_vec(read_buffer_sizes_data));
        payload[40..42].copy_from_slice(&<u16>::to_le_byte_vec(read_backlog_size));

        self.device.set(u8::from(CanV2BrickletFunction::SetQueueConfigurationLowLevel), payload)
    }

    /// Sets the write and read queue configuration.
    ///
    /// The CAN transceiver has 32 buffers in total in hardware for transmitting and
    /// receiving frames. Additionally, the Bricklet has a backlog for 768 frames in
    /// total in software. The buffers and the backlog can be freely assigned to the
    /// write and read queues.
    ///
    /// [`write_frame`] writes a frame into the write backlog. The Bricklet moves
    /// the frame from the backlog into a free write buffer. The CAN transceiver then
    /// transmits the frame from the write buffer to the CAN bus. If there are no
    /// write buffers (``write_buffer_size`` is zero) or there is no write backlog
    /// (``write_backlog_size`` is zero) then no frames can be transmitted and
    /// [`write_frame`] returns always *false*.
    ///
    /// The CAN transceiver receives a frame from the CAN bus and stores it into a
    /// free read buffer. The Bricklet moves the frame from the read buffer into the
    /// read backlog. [`read_frame`] reads the frame from the read backlog and
    /// returns it. If there are no read buffers (``read_buffer_sizes`` is empty) or
    /// there is no read backlog (``read_backlog_size`` is zero) then no frames can be
    /// received and [`read_frame`] returns always *false*.
    ///
    /// There can be multiple read buffers, because the CAN transceiver cannot receive
    /// data and remote frames into the same read buffer. A positive read buffer size
    /// represents a data frame read buffer and a negative read buffer size represents
    /// a remote frame read buffer. A read buffer size of zero is not allowed. By
    /// default the first read buffer is configured for data frames and the second read
    /// buffer is configured for remote frame. There can be up to 32 different read
    /// buffers, assuming that no write buffer is used. Each read buffer has its own
    /// filter configuration (see [`set_read_filter_configuration`]).
    ///
    /// A valid queue configuration fulfills these conditions::
    ///
    ///  write_buffer_size + abs(read_buffer_size_0) + abs(read_buffer_size_1) + ... + abs(read_buffer_size_31) <= 32
    ///  write_backlog_size + read_backlog_size <= 768
    ///
    /// The write buffer timeout has three different modes that define how a failed
    /// frame transmission should be handled:
    ///
    /// * Single-Shot (< 0): Only one transmission attempt will be made. If the
    ///   transmission fails then the frame is discarded.
    /// * Infinite (= 0): Infinite transmission attempts will be made. The frame will
    ///   never be discarded.
    /// * Milliseconds (> 0): A limited number of transmission attempts will be made.
    ///   If the frame could not be transmitted successfully after the configured
    ///   number of milliseconds then the frame is discarded.
    ///
    /// The current content of the queues is lost when this function is called.
    pub fn set_queue_configuration(
        &self,
        write_buffer_size: u8,
        write_buffer_timeout: i32,
        write_backlog_size: u16,
        read_backlog_size: u16,
        read_buffer_sizes: &[i8],
    ) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result =
            self.device.set_high_level(2, read_buffer_sizes, 32, 32, &mut |length: usize, _chunk_offset: usize, chunk: &[i8]| {
                let chunk_length = chunk.len() as u16;
                let mut chunk_array = [<i8>::default(); 32];
                chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

                let result = self
                    .set_queue_configuration_low_level(
                        write_buffer_size,
                        write_buffer_timeout,
                        write_backlog_size,
                        length as u8,
                        chunk_array,
                        read_backlog_size,
                    )
                    .recv();
                if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                    Ok(Default::default())
                } else {
                    result
                }
            })?;
        Ok(())
    }

    /// Returns the queue configuration as set by [`set_queue_configuration`].
    pub fn get_queue_configuration_low_level(&self) -> ConvertingReceiver<QueueConfigurationLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetQueueConfigurationLowLevel), payload)
    }

    /// Returns the queue configuration as set by [`set_queue_configuration`].
    pub fn get_queue_configuration(&self) -> Result<(Vec<i8>, QueueConfigurationResult), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(3, &mut || self.get_queue_configuration_low_level().recv())?;
        Ok((ll_result.0, ll_result.1))
    }

    /// Set the read filter configuration for the given read buffer index. This can be
    /// used to define which frames should be received by the CAN transceiver and put
    /// into the read buffer.
    ///
    /// The read filter has four different modes that define if and how the filter mask
    /// and the filter identifier are applied:
    ///
    /// * Accept-All: All frames are received.
    /// * Match-Standard-Only: Only standard frames with a matching identifier are
    ///   received.
    /// * Match-Extended-Only: Only extended frames with a matching identifier are
    ///   received.
    /// * Match-Standard-And-Extended: Standard and extended frames with a matching
    ///   identifier are received.
    ///
    /// The filter mask and filter identifier are used as bit masks. Their usage
    /// depends on the mode:
    ///
    /// * Accept-All: Mask and identifier are ignored.
    /// * Match-Standard-Only: Bit 0 to 10 (11 bits) of filter mask and filter
    ///   identifier are used to match the 11-bit identifier of standard frames.
    /// * Match-Extended-Only: Bit 0 to 28 (29 bits) of filter mask and filter
    ///   identifier are used to match the 29-bit identifier of extended frames.
    /// * Match-Standard-And-Extended: Bit 18 to 28 (11 bits) of filter mask and filter
    ///   identifier are used to match the 11-bit identifier of standard frames, bit 0
    ///   to 17 (18 bits) are ignored in this case. Bit 0 to 28 (29 bits) of filter
    ///   mask and filter identifier are used to match the 29-bit identifier of extended
    ///   frames.
    ///
    /// The filter mask and filter identifier are applied in this way: The filter mask
    /// is used to select the frame identifier bits that should be compared to the
    /// corresponding filter identifier bits. All unselected bits are automatically
    /// accepted. All selected bits have to match the filter identifier to be accepted.
    /// If all bits for the selected mode are accepted then the frame is accepted and
    /// is added to the read buffer.
    ///
    ///  Filter Mask Bit| Filter Identifier Bit| Frame Identifier Bit| Result
    ///  --- | --- | --- | ---
    ///  0| X| X| Accept
    ///  1| 0| 0| Accept
    ///  1| 0| 1| Reject
    ///  1| 1| 0| Reject
    ///  1| 1| 1| Accept
    ///
    /// For example, to receive standard frames with identifier 0x123 only, the mode
    /// can be set to Match-Standard-Only with 0x7FF as mask and 0x123 as identifier.
    /// The mask of 0x7FF selects all 11 identifier bits for matching so that the
    /// identifier has to be exactly 0x123 to be accepted.
    ///
    /// To accept identifier 0x123 and identifier 0x456 at the same time, just set
    /// filter 2 to 0x456 and keep mask and filter 1 unchanged.
    ///
    /// There can be up to 32 different read filters configured at the same time,
    /// because there can be up to 32 read buffer (see [`set_queue_configuration`]).
    ///
    /// The default mode is accept-all for all read buffers.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_FILTER_MODE_ACCEPT_ALL
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_ONLY
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_EXTENDED_ONLY
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_EXTENDED
    pub fn set_read_filter_configuration(
        &self,
        buffer_index: u8,
        filter_mode: u8,
        filter_mask: u32,
        filter_identifier: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(buffer_index));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(filter_mode));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(filter_mask));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(filter_identifier));

        self.device.set(u8::from(CanV2BrickletFunction::SetReadFilterConfiguration), payload)
    }

    /// Returns the read filter configuration as set by [`set_read_filter_configuration`].
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_FILTER_MODE_ACCEPT_ALL
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_ONLY
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_EXTENDED_ONLY
    ///	* CAN_V2_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_EXTENDED
    pub fn get_read_filter_configuration(&self, buffer_index: u8) -> ConvertingReceiver<ReadFilterConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(buffer_index));

        self.device.get(u8::from(CanV2BrickletFunction::GetReadFilterConfiguration), payload)
    }

    /// Returns information about different kinds of errors.
    ///
    /// The write and read error levels indicate the current level of stuffing, form,
    /// acknowledgement, bit and checksum errors during CAN bus write and read
    /// operations. For each of this error kinds there is also an individual counter.
    ///
    /// When the write error level extends 255 then the CAN transceiver gets disabled
    /// and no frames can be transmitted or received anymore. The CAN transceiver will
    /// automatically be activated again after the CAN bus is idle for a while.
    ///
    /// The write buffer timeout, read buffer and backlog overflow counts represents the
    /// number of these errors:
    ///
    /// * A write buffer timeout occurs if a frame could not be transmitted before the
    ///   configured write buffer timeout expired (see [`set_queue_configuration`]).
    /// * A read buffer overflow occurs if a read buffer of the CAN transceiver
    ///   still contains the last received frame when the next frame arrives. In this
    ///   case the last received frame is lost. This happens if the CAN transceiver
    ///   receives more frames than the Bricklet can handle. Using the read filter
    ///   (see [`set_read_filter_configuration`]) can help to reduce the amount of
    ///   received frames. This count is not exact, but a lower bound, because the
    ///   Bricklet might not able detect all overflows if they occur in rapid succession.
    /// * A read backlog overflow occurs if the read backlog of the Bricklet is already
    ///   full when the next frame should be read from a read buffer of the CAN
    ///   transceiver. In this case the frame in the read buffer is lost. This
    ///   happens if the CAN transceiver receives more frames to be added to the read
    ///   backlog than are removed from the read backlog using the [`read_frame`]
    ///   function. Using the [`get_frame_read_callback_receiver`] receiver ensures that the read backlog
    ///   can not overflow.
    ///
    /// The read buffer overflow counter counts the overflows of all configured read
    /// buffers. Which read buffer exactly suffered from an overflow can be figured
    /// out from the read buffer overflow occurrence list
    /// (``read_buffer_overflow_error_occurred``). Reading the error log clears the
    /// occurence list.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_TRANSCEIVER_STATE_ACTIVE
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_STATE_PASSIVE
    ///	* CAN_V2_BRICKLET_TRANSCEIVER_STATE_DISABLED
    pub fn get_error_log_low_level(&self) -> ConvertingReceiver<ErrorLogLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetErrorLogLowLevel), payload)
    }

    /// Returns information about different kinds of errors.
    ///
    /// The write and read error levels indicate the current level of stuffing, form,
    /// acknowledgement, bit and checksum errors during CAN bus write and read
    /// operations. For each of this error kinds there is also an individual counter.
    ///
    /// When the write error level extends 255 then the CAN transceiver gets disabled
    /// and no frames can be transmitted or received anymore. The CAN transceiver will
    /// automatically be activated again after the CAN bus is idle for a while.
    ///
    /// The write buffer timeout, read buffer and backlog overflow counts represents the
    /// number of these errors:
    ///
    /// * A write buffer timeout occurs if a frame could not be transmitted before the
    ///   configured write buffer timeout expired (see [`set_queue_configuration`]).
    /// * A read buffer overflow occurs if a read buffer of the CAN transceiver
    ///   still contains the last received frame when the next frame arrives. In this
    ///   case the last received frame is lost. This happens if the CAN transceiver
    ///   receives more frames than the Bricklet can handle. Using the read filter
    ///   (see [`set_read_filter_configuration`]) can help to reduce the amount of
    ///   received frames. This count is not exact, but a lower bound, because the
    ///   Bricklet might not able detect all overflows if they occur in rapid succession.
    /// * A read backlog overflow occurs if the read backlog of the Bricklet is already
    ///   full when the next frame should be read from a read buffer of the CAN
    ///   transceiver. In this case the frame in the read buffer is lost. This
    ///   happens if the CAN transceiver receives more frames to be added to the read
    ///   backlog than are removed from the read backlog using the [`read_frame`]
    ///   function. Using the [`get_frame_read_callback_receiver`] receiver ensures that the read backlog
    ///   can not overflow.
    ///
    /// The read buffer overflow counter counts the overflows of all configured read
    /// buffers. Which read buffer exactly suffered from an overflow can be figured
    /// out from the read buffer overflow occurrence list
    /// (``read_buffer_overflow_error_occurred``). Reading the error log clears the
    /// occurence list.
    pub fn get_error_log(&self) -> Result<(Vec<bool>, ErrorLogResult), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(4, &mut || self.get_error_log_low_level().recv())?;
        Ok((ll_result.0, ll_result.1))
    }

    /// Sets the communication LED configuration. By default the LED shows
    /// CAN-Bus traffic, it flickers once for every 40 transmitted or received frames.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn set_communication_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(CanV2BrickletFunction::SetCommunicationLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_communication_led_config`]
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_COMMUNICATION_LED_CONFIG_SHOW_COMMUNICATION
    pub fn get_communication_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetCommunicationLedConfig), payload)
    }

    /// Sets the error LED configuration.
    ///
    /// By default (show-transceiver-state) the error LED turns on if the CAN
    /// transceiver is passive or disabled state (see [`get_error_log`]). If
    /// the CAN transceiver is in active state the LED turns off.
    ///
    /// If the LED is configured as show-error then the error LED turns on if any error
    /// occurs. If you call this function with the show-error option again, the LED will
    /// turn off until the next error occurs.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_TRANSCEIVER_STATE
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(CanV2BrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_error_led_config`].
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_TRANSCEIVER_STATE
    ///	* CAN_V2_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetErrorLedConfig), payload)
    }

    /// Enables and disables the [`get_frame_readable_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled. Enabling this receiver will disable the [`get_frame_read_callback_receiver`] receiver.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn set_frame_readable_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(CanV2BrickletFunction::SetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns *true* if the [`get_frame_readable_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_frame_readable_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetFrameReadableCallbackConfiguration), payload)
    }

    /// Enables and disables the [`get_error_occurred_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn set_error_occurred_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(CanV2BrickletFunction::SetErrorOccurredCallbackConfiguration), payload)
    }

    /// Returns *true* if the [`get_error_occurred_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_error_occurred_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetErrorOccurredCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(CanV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* CAN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(CanV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(CanV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(CanV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * CAN_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* CAN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(CanV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(CanV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanV2BrickletFunction::GetIdentity), payload)
    }
}
