/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures air pressure and altitude changes.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Barometer_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum BarometerBrickletFunction {
    GetAirPressure,
    GetAltitude,
    SetAirPressureCallbackPeriod,
    GetAirPressureCallbackPeriod,
    SetAltitudeCallbackPeriod,
    GetAltitudeCallbackPeriod,
    SetAirPressureCallbackThreshold,
    GetAirPressureCallbackThreshold,
    SetAltitudeCallbackThreshold,
    GetAltitudeCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetReferenceAirPressure,
    GetChipTemperature,
    GetReferenceAirPressure,
    SetAveraging,
    GetAveraging,
    SetI2cMode,
    GetI2cMode,
    GetIdentity,
    CallbackAirPressure,
    CallbackAltitude,
    CallbackAirPressureReached,
    CallbackAltitudeReached,
}
impl From<BarometerBrickletFunction> for u8 {
    fn from(fun: BarometerBrickletFunction) -> Self {
        match fun {
            BarometerBrickletFunction::GetAirPressure => 1,
            BarometerBrickletFunction::GetAltitude => 2,
            BarometerBrickletFunction::SetAirPressureCallbackPeriod => 3,
            BarometerBrickletFunction::GetAirPressureCallbackPeriod => 4,
            BarometerBrickletFunction::SetAltitudeCallbackPeriod => 5,
            BarometerBrickletFunction::GetAltitudeCallbackPeriod => 6,
            BarometerBrickletFunction::SetAirPressureCallbackThreshold => 7,
            BarometerBrickletFunction::GetAirPressureCallbackThreshold => 8,
            BarometerBrickletFunction::SetAltitudeCallbackThreshold => 9,
            BarometerBrickletFunction::GetAltitudeCallbackThreshold => 10,
            BarometerBrickletFunction::SetDebouncePeriod => 11,
            BarometerBrickletFunction::GetDebouncePeriod => 12,
            BarometerBrickletFunction::SetReferenceAirPressure => 13,
            BarometerBrickletFunction::GetChipTemperature => 14,
            BarometerBrickletFunction::GetReferenceAirPressure => 19,
            BarometerBrickletFunction::SetAveraging => 20,
            BarometerBrickletFunction::GetAveraging => 21,
            BarometerBrickletFunction::SetI2cMode => 22,
            BarometerBrickletFunction::GetI2cMode => 23,
            BarometerBrickletFunction::GetIdentity => 255,
            BarometerBrickletFunction::CallbackAirPressure => 15,
            BarometerBrickletFunction::CallbackAltitude => 16,
            BarometerBrickletFunction::CallbackAirPressureReached => 17,
            BarometerBrickletFunction::CallbackAltitudeReached => 18,
        }
    }
}
pub const BAROMETER_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const BAROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const BAROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const BAROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const BAROMETER_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const BAROMETER_BRICKLET_I2C_MODE_FAST: u8 = 0;
pub const BAROMETER_BRICKLET_I2C_MODE_SLOW: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AirPressureCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for AirPressureCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> AirPressureCallbackThreshold {
        AirPressureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AltitudeCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for AltitudeCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> AltitudeCallbackThreshold {
        AltitudeCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Averaging {
    pub moving_average_pressure: u8,
    pub average_pressure: u8,
    pub average_temperature: u8,
}
impl FromByteSlice for Averaging {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Averaging {
        Averaging {
            moving_average_pressure: <u8>::from_le_byte_slice(&bytes[0..1]),
            average_pressure: <u8>::from_le_byte_slice(&bytes[1..2]),
            average_temperature: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures air pressure and altitude changes
#[derive(Clone)]
pub struct BarometerBricklet {
    device: Device,
}
impl BarometerBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 221;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Barometer Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> BarometerBricklet {
        let mut result = BarometerBricklet { device: Device::new([2, 0, 2], uid, req_sender, 0) };
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAirPressure) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAltitude) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetAirPressureCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAirPressureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetAltitudeCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAltitudeCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetAirPressureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAirPressureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetAltitudeCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAltitudeCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetReferenceAirPressure) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetReferenceAirPressure) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetAveraging) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetAveraging) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::SetI2cMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetI2cMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(BarometerBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::barometer_bricklet::BarometerBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::barometer_bricklet::BarometerBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: BarometerBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: BarometerBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_air_pressure_callback_period`]. The parameter is the air
    /// pressure of the air pressure sensor.
    ///
    /// The [`get_air_pressure_callback_receiver`] receiver is only triggered if the air pressure has
    /// changed since the last triggering.
    ///
    /// [`set_air_pressure_callback_period`]: #method.set_air_pressure_callback_period
    /// [`get_air_pressure_callback_receiver`]: #method.get_air_pressure_callback_receiver
    pub fn get_air_pressure_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(BarometerBrickletFunction::CallbackAirPressure))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_altitude_callback_period`]. The parameter is the altitude of
    /// the air pressure sensor.
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude has changed since
    /// the last triggering.
    pub fn get_altitude_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(BarometerBrickletFunction::CallbackAltitude))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_air_pressure_callback_threshold`] is reached.
    /// The parameter is the air pressure of the air pressure sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_air_pressure_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(BarometerBrickletFunction::CallbackAirPressureReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_altitude_callback_threshold`] is reached.
    /// The parameter is the altitude of the air pressure sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_altitude_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(BarometerBrickletFunction::CallbackAltitudeReached))
    }

    /// Returns the air pressure of the air pressure sensor.
    ///
    /// If you want to get the air pressure periodically, it is recommended to use the
    /// [`get_air_pressure_callback_receiver`] receiver and set the period with
    /// [`set_air_pressure_callback_period`].
    pub fn get_air_pressure(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAirPressure), payload)
    }

    /// Returns the relative altitude of the air pressure sensor. The value is
    /// calculated based on the difference between the current air pressure
    /// and the reference air pressure that can be set with [`set_reference_air_pressure`].
    ///
    /// If you want to get the altitude periodically, it is recommended to use the
    /// [`get_altitude_callback_receiver`] receiver and set the period with
    /// [`set_altitude_callback_period`].
    pub fn get_altitude(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAltitude), payload)
    }

    /// Sets the period with which the [`get_air_pressure_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_air_pressure_callback_receiver`] receiver is only triggered if the air pressure has
    /// changed since the last triggering.
    pub fn set_air_pressure_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(BarometerBrickletFunction::SetAirPressureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_air_pressure_callback_period`].
    pub fn get_air_pressure_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAirPressureCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_altitude_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude has changed since
    /// the last triggering.
    pub fn set_altitude_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(BarometerBrickletFunction::SetAltitudeCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_altitude_callback_period`].
    pub fn get_altitude_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAltitudeCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_air_pressure_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the air pressure is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the air pressure is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the air pressure is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the air pressure is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_air_pressure_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(BarometerBrickletFunction::SetAirPressureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_air_pressure_callback_threshold`].
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_air_pressure_callback_threshold(&self) -> ConvertingReceiver<AirPressureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAirPressureCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_altitude_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the altitude is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the altitude is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the altitude is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the altitude is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_altitude_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(BarometerBrickletFunction::SetAltitudeCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_altitude_callback_threshold`].
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* BAROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_altitude_callback_threshold(&self) -> ConvertingReceiver<AltitudeCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAltitudeCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_air_pressure_reached_callback_receiver`],
    /// * [`get_altitude_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_air_pressure_callback_threshold`],
    /// * [`set_altitude_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(BarometerBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the reference air pressure for the altitude calculation.
    /// Setting the reference to the current air pressure results in a calculated
    /// altitude of 0cm. Passing 0 is a shortcut for passing the current air pressure as
    /// reference.
    ///
    /// Well known reference values are the Q codes
    /// [QNH](https://en.wikipedia.org/wiki/QNH)__ and
    /// [QFE](https://en.wikipedia.org/wiki/Mean_sea_level_pressure#Mean_sea_level_pressure)__
    /// used in aviation.
    pub fn set_reference_air_pressure(&self, air_pressure: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(air_pressure));

        self.device.set(u8::from(BarometerBrickletFunction::SetReferenceAirPressure), payload)
    }

    /// Returns the temperature of the air pressure sensor.
    ///
    /// This temperature is used internally for temperature compensation of the air
    /// pressure measurement. It is not as accurate as the temperature measured by the
    /// `temperature_bricklet` or the `temperature_ir_bricklet`.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetChipTemperature), payload)
    }

    /// Returns the reference air pressure as set by [`set_reference_air_pressure`].
    pub fn get_reference_air_pressure(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetReferenceAirPressure), payload)
    }

    /// Sets the different averaging parameters. It is possible to set
    /// the length of a normal averaging for the temperature and pressure,
    /// as well as an additional length of a
    /// [moving average](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the pressure. The moving average is calculated from the normal
    /// averages.  There is no moving average for the temperature.
    ///
    /// Setting the all three parameters to 0 will turn the averaging
    /// completely off. If the averaging is off, there is lots of noise
    /// on the data, but the data is without delay. Thus we recommend
    /// to turn the averaging off if the Barometer Bricklet data is
    /// to be used for sensor fusion with other sensors.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn set_averaging(&self, moving_average_pressure: u8, average_pressure: u8, average_temperature: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(moving_average_pressure));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(average_pressure));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(average_temperature));

        self.device.set(u8::from(BarometerBrickletFunction::SetAveraging), payload)
    }

    /// Returns the averaging configuration as set by [`set_averaging`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_averaging(&self) -> ConvertingReceiver<Averaging> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetAveraging), payload)
    }

    /// Sets the I2C mode. Possible modes are:
    ///
    /// * 0: Fast (400kHz)
    /// * 1: Slow (100kHz)
    ///
    /// If you have problems with obvious outliers in the
    /// Barometer Bricklet measurements, they may be caused by EMI issues.
    /// In this case it may be helpful to lower the I2C speed.
    ///
    /// It is however not recommended to lower the I2C speed in applications where
    /// a high throughput needs to be achieved.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_I2C_MODE_FAST
    ///	* BAROMETER_BRICKLET_I2C_MODE_SLOW
    pub fn set_i2c_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(BarometerBrickletFunction::SetI2cMode), payload)
    }

    /// Returns the I2C mode as set by [`set_i2c_mode`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * BAROMETER_BRICKLET_I2C_MODE_FAST
    ///	* BAROMETER_BRICKLET_I2C_MODE_SLOW
    pub fn get_i2c_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetI2cMode), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(BarometerBrickletFunction::GetIdentity), payload)
    }
}
