/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures DC voltage between 0V and 42V.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AnalogInV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AnalogInV2BrickletFunction {
    GetVoltage,
    GetAnalogValue,
    SetVoltageCallbackPeriod,
    GetVoltageCallbackPeriod,
    SetAnalogValueCallbackPeriod,
    GetAnalogValueCallbackPeriod,
    SetVoltageCallbackThreshold,
    GetVoltageCallbackThreshold,
    SetAnalogValueCallbackThreshold,
    GetAnalogValueCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetMovingAverage,
    GetMovingAverage,
    GetIdentity,
    CallbackVoltage,
    CallbackAnalogValue,
    CallbackVoltageReached,
    CallbackAnalogValueReached,
}
impl From<AnalogInV2BrickletFunction> for u8 {
    fn from(fun: AnalogInV2BrickletFunction) -> Self {
        match fun {
            AnalogInV2BrickletFunction::GetVoltage => 1,
            AnalogInV2BrickletFunction::GetAnalogValue => 2,
            AnalogInV2BrickletFunction::SetVoltageCallbackPeriod => 3,
            AnalogInV2BrickletFunction::GetVoltageCallbackPeriod => 4,
            AnalogInV2BrickletFunction::SetAnalogValueCallbackPeriod => 5,
            AnalogInV2BrickletFunction::GetAnalogValueCallbackPeriod => 6,
            AnalogInV2BrickletFunction::SetVoltageCallbackThreshold => 7,
            AnalogInV2BrickletFunction::GetVoltageCallbackThreshold => 8,
            AnalogInV2BrickletFunction::SetAnalogValueCallbackThreshold => 9,
            AnalogInV2BrickletFunction::GetAnalogValueCallbackThreshold => 10,
            AnalogInV2BrickletFunction::SetDebouncePeriod => 11,
            AnalogInV2BrickletFunction::GetDebouncePeriod => 12,
            AnalogInV2BrickletFunction::SetMovingAverage => 13,
            AnalogInV2BrickletFunction::GetMovingAverage => 14,
            AnalogInV2BrickletFunction::GetIdentity => 255,
            AnalogInV2BrickletFunction::CallbackVoltage => 15,
            AnalogInV2BrickletFunction::CallbackAnalogValue => 16,
            AnalogInV2BrickletFunction::CallbackVoltageReached => 17,
            AnalogInV2BrickletFunction::CallbackAnalogValueReached => 18,
        }
    }
}
pub const ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for VoltageCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackThreshold {
        VoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for AnalogValueCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackThreshold {
        AnalogValueCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures DC voltage between 0V and 42V
#[derive(Clone)]
pub struct AnalogInV2Bricklet {
    device: Device,
}
impl AnalogInV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 251;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Analog In Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AnalogInV2Bricklet {
        let mut result = AnalogInV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::SetMovingAverage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetMovingAverage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::analog_in_v2_bricklet::AnalogInV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::analog_in_v2_bricklet::AnalogInV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AnalogInV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AnalogInV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_voltage_callback_period`]. The parameter is the voltage of the
    /// sensor.
    ///
    /// Der [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    ///
    /// [`set_voltage_callback_period`]: #method.set_voltage_callback_period
    /// [`get_voltage_callback_receiver`]: #method.get_voltage_callback_receiver
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInV2BrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_analog_value_callback_period`]. The parameter is the analog
    /// value of the sensor.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the voltage has changed
    /// since the last triggering.
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInV2BrickletFunction::CallbackAnalogValue))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_voltage_callback_threshold`] is reached.
    /// The parameter is the voltage of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInV2BrickletFunction::CallbackVoltageReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_analog_value_callback_threshold`] is reached.
    /// The parameter is the analog value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_analog_value_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInV2BrickletFunction::CallbackAnalogValueReached))
    }

    /// Returns the measured voltage. The resolution is approximately 10mV.
    ///
    /// If you want to get the voltage periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver and set the period with
    /// [`set_voltage_callback_period`].
    pub fn get_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetVoltage), payload)
    }

    /// Returns the value as read by a 12-bit analog-to-digital converter.
    ///
    /// If you want the analog value periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver and set the period with
    /// [`set_analog_value_callback_period`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetAnalogValue), payload)
    }

    /// Sets the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    pub fn set_voltage_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_voltage_callback_period`].
    pub fn get_voltage_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetVoltageCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog value has
    /// changed since the last triggering.
    pub fn set_analog_value_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetAnalogValueCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_analog_value_callback_period`].
    pub fn get_analog_value_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetAnalogValueCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_voltage_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_voltage_callback_threshold`].
    ///
    /// Associated constants:
    /// * ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_threshold(&self) -> ConvertingReceiver<VoltageCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetVoltageCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_analog_value_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the analog value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the analog value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the analog value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the analog value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetAnalogValueCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_analog_value_callback_threshold`].
    ///
    /// Associated constants:
    /// * ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_threshold(&self) -> ConvertingReceiver<AnalogValueCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetAnalogValueCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_voltage_reached_callback_receiver`],
    /// * [`get_analog_value_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_voltage_callback_threshold`],
    /// * [`set_analog_value_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the voltage.
    ///
    /// Setting the length to 1 will turn the averaging off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, average: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(average));

        self.device.set(u8::from(AnalogInV2BrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length of the moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetMovingAverage), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInV2BrickletFunction::GetIdentity), payload)
    }
}
