/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures DC voltage between 0V and 45V.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AnalogIn_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AnalogInBrickletFunction {
    GetVoltage,
    GetAnalogValue,
    SetVoltageCallbackPeriod,
    GetVoltageCallbackPeriod,
    SetAnalogValueCallbackPeriod,
    GetAnalogValueCallbackPeriod,
    SetVoltageCallbackThreshold,
    GetVoltageCallbackThreshold,
    SetAnalogValueCallbackThreshold,
    GetAnalogValueCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetRange,
    GetRange,
    SetAveraging,
    GetAveraging,
    GetIdentity,
    CallbackVoltage,
    CallbackAnalogValue,
    CallbackVoltageReached,
    CallbackAnalogValueReached,
}
impl From<AnalogInBrickletFunction> for u8 {
    fn from(fun: AnalogInBrickletFunction) -> Self {
        match fun {
            AnalogInBrickletFunction::GetVoltage => 1,
            AnalogInBrickletFunction::GetAnalogValue => 2,
            AnalogInBrickletFunction::SetVoltageCallbackPeriod => 3,
            AnalogInBrickletFunction::GetVoltageCallbackPeriod => 4,
            AnalogInBrickletFunction::SetAnalogValueCallbackPeriod => 5,
            AnalogInBrickletFunction::GetAnalogValueCallbackPeriod => 6,
            AnalogInBrickletFunction::SetVoltageCallbackThreshold => 7,
            AnalogInBrickletFunction::GetVoltageCallbackThreshold => 8,
            AnalogInBrickletFunction::SetAnalogValueCallbackThreshold => 9,
            AnalogInBrickletFunction::GetAnalogValueCallbackThreshold => 10,
            AnalogInBrickletFunction::SetDebouncePeriod => 11,
            AnalogInBrickletFunction::GetDebouncePeriod => 12,
            AnalogInBrickletFunction::SetRange => 17,
            AnalogInBrickletFunction::GetRange => 18,
            AnalogInBrickletFunction::SetAveraging => 19,
            AnalogInBrickletFunction::GetAveraging => 20,
            AnalogInBrickletFunction::GetIdentity => 255,
            AnalogInBrickletFunction::CallbackVoltage => 13,
            AnalogInBrickletFunction::CallbackAnalogValue => 14,
            AnalogInBrickletFunction::CallbackVoltageReached => 15,
            AnalogInBrickletFunction::CallbackAnalogValueReached => 16,
        }
    }
}
pub const ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const ANALOG_IN_BRICKLET_RANGE_AUTOMATIC: u8 = 0;
pub const ANALOG_IN_BRICKLET_RANGE_UP_TO_6V: u8 = 1;
pub const ANALOG_IN_BRICKLET_RANGE_UP_TO_10V: u8 = 2;
pub const ANALOG_IN_BRICKLET_RANGE_UP_TO_36V: u8 = 3;
pub const ANALOG_IN_BRICKLET_RANGE_UP_TO_45V: u8 = 4;
pub const ANALOG_IN_BRICKLET_RANGE_UP_TO_3V: u8 = 5;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for VoltageCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackThreshold {
        VoltageCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for AnalogValueCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackThreshold {
        AnalogValueCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures DC voltage between 0V and 45V
#[derive(Clone)]
pub struct AnalogInBricklet {
    device: Device,
}
impl AnalogInBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 219;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Analog In Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AnalogInBricklet {
        let mut result = AnalogInBricklet { device: Device::new([2, 0, 3], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetVoltageCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetVoltageCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetVoltageCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetRange) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetRange) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::SetAveraging) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetAveraging) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogInBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::analog_in_bricklet::AnalogInBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::analog_in_bricklet::AnalogInBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AnalogInBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AnalogInBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_voltage_callback_period`]. The parameter is the voltage of the
    /// sensor.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    ///
    /// [`set_voltage_callback_period`]: #method.set_voltage_callback_period
    /// [`get_voltage_callback_receiver`]: #method.get_voltage_callback_receiver
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInBrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_analog_value_callback_period`]. The parameter is the analog
    /// value of the sensor.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the voltage has changed
    /// since the last triggering.
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInBrickletFunction::CallbackAnalogValue))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_voltage_callback_threshold`] is reached.
    /// The parameter is the voltage of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_voltage_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInBrickletFunction::CallbackVoltageReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_analog_value_callback_threshold`] is reached.
    /// The parameter is the analog value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_analog_value_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AnalogInBrickletFunction::CallbackAnalogValueReached))
    }

    /// Returns the voltage of the sensor. The resolution between 0 and 6V is about 2mV.
    /// Between 6 and 45V the resolution is about 10mV.
    ///
    /// If you want to get the voltage periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver and set the period with
    /// [`set_voltage_callback_period`].
    pub fn get_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetVoltage), payload)
    }

    /// Returns the value as read by a 12-bit analog-to-digital converter.
    ///
    /// # Note
    ///  The value returned by [`get_voltage`] is averaged over several samples
    ///  to yield less noise, while [`get_analog_value`] gives back raw
    ///  unfiltered analog values. The only reason to use [`get_analog_value`] is,
    ///  if you need the full resolution of the analog-to-digital converter.
    ///
    /// If you want the analog value periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver and set the period with
    /// [`set_analog_value_callback_period`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetAnalogValue), payload)
    }

    /// Sets the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_voltage_callback_receiver`] receiver is only triggered if the voltage has changed since
    /// the last triggering.
    pub fn set_voltage_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AnalogInBrickletFunction::SetVoltageCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_voltage_callback_period`].
    pub fn get_voltage_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetVoltageCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog value has
    /// changed since the last triggering.
    pub fn set_analog_value_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AnalogInBrickletFunction::SetAnalogValueCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_analog_value_callback_period`].
    pub fn get_analog_value_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetAnalogValueCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_voltage_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the voltage is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the voltage is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the voltage is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the voltage is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AnalogInBrickletFunction::SetVoltageCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_voltage_callback_threshold`].
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_threshold(&self) -> ConvertingReceiver<VoltageCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetVoltageCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_analog_value_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the analog value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the analog value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the analog value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the analog value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AnalogInBrickletFunction::SetAnalogValueCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_analog_value_callback_threshold`].
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ANALOG_IN_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_threshold(&self) -> ConvertingReceiver<AnalogValueCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetAnalogValueCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_voltage_reached_callback_receiver`],
    /// * [`get_analog_value_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_voltage_callback_threshold`],
    /// * [`set_analog_value_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(AnalogInBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the measurement range. Possible ranges:
    ///
    /// * 0: Automatically switched
    /// * 1: 0V - 6.05V, ~1.48mV resolution
    /// * 2: 0V - 10.32V, ~2.52mV resolution
    /// * 3: 0V - 36.30V, ~8.86mV resolution
    /// * 4: 0V - 45.00V, ~11.25mV resolution
    /// * 5: 0V - 3.3V, ~0.81mV resolution, new in version 2.0.3$nbsp;(Plugin)
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_RANGE_AUTOMATIC
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_6V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_10V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_36V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_45V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_3V
    pub fn set_range(&self, range: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(range));

        self.device.set(u8::from(AnalogInBrickletFunction::SetRange), payload)
    }

    /// Returns the measurement range as set by [`set_range`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * ANALOG_IN_BRICKLET_RANGE_AUTOMATIC
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_6V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_10V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_36V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_45V
    ///	* ANALOG_IN_BRICKLET_RANGE_UP_TO_3V
    pub fn get_range(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetRange), payload)
    }

    /// Set the length of a averaging for the voltage value.
    ///
    /// Setting the length to 0 will turn the averaging completely off. If the
    /// averaging is off, there is more noise on the data, but the data is without
    /// delay.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn set_averaging(&self, average: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(average));

        self.device.set(u8::from(AnalogInBrickletFunction::SetAveraging), payload)
    }

    /// Returns the averaging configuration as set by [`set_averaging`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_averaging(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetAveraging), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogInBrickletFunction::GetIdentity), payload)
    }
}
