/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures ambient light up to 64000lux.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AmbientLightV3_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AmbientLightV3BrickletFunction {
    GetIlluminance,
    SetIlluminanceCallbackConfiguration,
    GetIlluminanceCallbackConfiguration,
    SetConfiguration,
    GetConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackIlluminance,
}
impl From<AmbientLightV3BrickletFunction> for u8 {
    fn from(fun: AmbientLightV3BrickletFunction) -> Self {
        match fun {
            AmbientLightV3BrickletFunction::GetIlluminance => 1,
            AmbientLightV3BrickletFunction::SetIlluminanceCallbackConfiguration => 2,
            AmbientLightV3BrickletFunction::GetIlluminanceCallbackConfiguration => 3,
            AmbientLightV3BrickletFunction::SetConfiguration => 5,
            AmbientLightV3BrickletFunction::GetConfiguration => 6,
            AmbientLightV3BrickletFunction::GetSpitfpErrorCount => 234,
            AmbientLightV3BrickletFunction::SetBootloaderMode => 235,
            AmbientLightV3BrickletFunction::GetBootloaderMode => 236,
            AmbientLightV3BrickletFunction::SetWriteFirmwarePointer => 237,
            AmbientLightV3BrickletFunction::WriteFirmware => 238,
            AmbientLightV3BrickletFunction::SetStatusLedConfig => 239,
            AmbientLightV3BrickletFunction::GetStatusLedConfig => 240,
            AmbientLightV3BrickletFunction::GetChipTemperature => 242,
            AmbientLightV3BrickletFunction::Reset => 243,
            AmbientLightV3BrickletFunction::WriteUid => 248,
            AmbientLightV3BrickletFunction::ReadUid => 249,
            AmbientLightV3BrickletFunction::GetIdentity => 255,
            AmbientLightV3BrickletFunction::CallbackIlluminance => 4,
        }
    }
}
pub const AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED: u8 = 6;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_64000LUX: u8 = 0;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_32000LUX: u8 = 1;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_16000LUX: u8 = 2;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_8000LUX: u8 = 3;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_1300LUX: u8 = 4;
pub const AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_600LUX: u8 = 5;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_50MS: u8 = 0;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_100MS: u8 = 1;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_150MS: u8 = 2;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_200MS: u8 = 3;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_250MS: u8 = 4;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_300MS: u8 = 5;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_350MS: u8 = 6;
pub const AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_400MS: u8 = 7;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IlluminanceCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for IlluminanceCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> IlluminanceCallbackConfiguration {
        IlluminanceCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u32>::from_le_byte_slice(&bytes[6..10]),
            max: <u32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub illuminance_range: u8,
    pub integration_time: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            illuminance_range: <u8>::from_le_byte_slice(&bytes[0..1]),
            integration_time: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures ambient light up to 64000lux
#[derive(Clone)]
pub struct AmbientLightV3Bricklet {
    device: Device,
}
impl AmbientLightV3Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2131;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Ambient Light Bricklet 3.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AmbientLightV3Bricklet {
        let mut result = AmbientLightV3Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetIlluminance) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::SetIlluminanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetIlluminanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV3BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::ambient_light_v3_bricklet::AmbientLightV3Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::ambient_light_v3_bricklet::AmbientLightV3Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AmbientLightV3BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AmbientLightV3BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_illuminance_callback_configuration`].
    ///
    /// The parameter is the same as [`get_illuminance`].
    ///
    /// [`get_illuminance`]: #method.get_illuminance
    /// [`set_illuminance_callback_configuration`]: #method.set_illuminance_callback_configuration
    pub fn get_illuminance_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(AmbientLightV3BrickletFunction::CallbackIlluminance))
    }

    /// Returns the illuminance of the ambient light sensor. The measurement range goes
    /// up to about 100000lux, but above 64000lux the precision starts to drop.
    /// The illuminance is given in lux/100, i.e. a value of 450000 means that an
    /// illuminance of 4500lux is measured.
    ///
    /// An illuminance of 0lux indicates an error condition where the sensor cannot
    /// perform a reasonable measurement. This can happen with very dim or very bright
    /// light conditions. In bright light conditions this might indicate that the sensor
    /// is saturated and the configuration should be modified ([`set_configuration`])
    /// to better match the conditions.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_illuminance_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_illuminance_callback_configuration`].
    pub fn get_illuminance(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetIlluminance), payload)
    }

    /// The period is the period with which the [`get_illuminance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_illuminance_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_illuminance_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u32,
        max: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(AmbientLightV3BrickletFunction::SetIlluminanceCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_illuminance_callback_configuration`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_V3_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_illuminance_callback_configuration(&self) -> ConvertingReceiver<IlluminanceCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetIlluminanceCallbackConfiguration), payload)
    }

    /// Sets the configuration. It is possible to configure an illuminance range
    /// between 0-600lux and 0-64000lux and an integration time between 50ms and 400ms.
    ///
    /// The unlimited illuminance range allows to measure up to about 100000lux, but
    /// above 64000lux the precision starts to drop.
    ///
    /// A smaller illuminance range increases the resolution of the data. A longer
    /// integration time will result in less noise on the data.
    ///
    /// If the actual measure illuminance is out-of-range then the current illuminance
    /// range maximum +0.01lux is reported by [`get_illuminance`] and the
    /// [`get_illuminance_callback_receiver`] receiver. For example, 800001 for the 0-8000lux range.
    ///
    /// With a long integration time the sensor might be saturated before the measured
    /// value reaches the maximum of the selected illuminance range. In this case 0lux
    /// is reported by [`get_illuminance`] and the [`get_illuminance_callback_receiver`] receiver.
    ///
    /// If the measurement is out-of-range or the sensor is saturated then you should
    /// configure the next higher illuminance range. If the highest range is already
    /// in use, then start to reduce the integration time.
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_64000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_32000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_16000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_8000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_1300LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_600LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_50MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_100MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_150MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_200MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_250MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_300MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_350MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_400MS
    pub fn set_configuration(&self, illuminance_range: u8, integration_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(illuminance_range));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(integration_time));

        self.device.set(u8::from(AmbientLightV3BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_64000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_32000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_16000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_8000LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_1300LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_ILLUMINANCE_RANGE_600LUX
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_50MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_100MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_150MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_200MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_250MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_300MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_350MS
    ///	* AMBIENT_LIGHT_V3_BRICKLET_INTEGRATION_TIME_400MS
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(AmbientLightV3BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(AmbientLightV3BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(AmbientLightV3BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(AmbientLightV3BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* AMBIENT_LIGHT_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AmbientLightV3BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(AmbientLightV3BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV3BrickletFunction::GetIdentity), payload)
    }
}
