/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures ambient light up to 900lux.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AmbientLight_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AmbientLightBrickletFunction {
    GetIlluminance,
    GetAnalogValue,
    SetIlluminanceCallbackPeriod,
    GetIlluminanceCallbackPeriod,
    SetAnalogValueCallbackPeriod,
    GetAnalogValueCallbackPeriod,
    SetIlluminanceCallbackThreshold,
    GetIlluminanceCallbackThreshold,
    SetAnalogValueCallbackThreshold,
    GetAnalogValueCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetIdentity,
    CallbackIlluminance,
    CallbackAnalogValue,
    CallbackIlluminanceReached,
    CallbackAnalogValueReached,
}
impl From<AmbientLightBrickletFunction> for u8 {
    fn from(fun: AmbientLightBrickletFunction) -> Self {
        match fun {
            AmbientLightBrickletFunction::GetIlluminance => 1,
            AmbientLightBrickletFunction::GetAnalogValue => 2,
            AmbientLightBrickletFunction::SetIlluminanceCallbackPeriod => 3,
            AmbientLightBrickletFunction::GetIlluminanceCallbackPeriod => 4,
            AmbientLightBrickletFunction::SetAnalogValueCallbackPeriod => 5,
            AmbientLightBrickletFunction::GetAnalogValueCallbackPeriod => 6,
            AmbientLightBrickletFunction::SetIlluminanceCallbackThreshold => 7,
            AmbientLightBrickletFunction::GetIlluminanceCallbackThreshold => 8,
            AmbientLightBrickletFunction::SetAnalogValueCallbackThreshold => 9,
            AmbientLightBrickletFunction::GetAnalogValueCallbackThreshold => 10,
            AmbientLightBrickletFunction::SetDebouncePeriod => 11,
            AmbientLightBrickletFunction::GetDebouncePeriod => 12,
            AmbientLightBrickletFunction::GetIdentity => 255,
            AmbientLightBrickletFunction::CallbackIlluminance => 13,
            AmbientLightBrickletFunction::CallbackAnalogValue => 14,
            AmbientLightBrickletFunction::CallbackIlluminanceReached => 15,
            AmbientLightBrickletFunction::CallbackAnalogValueReached => 16,
        }
    }
}
pub const AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IlluminanceCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for IlluminanceCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> IlluminanceCallbackThreshold {
        IlluminanceCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for AnalogValueCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackThreshold {
        AnalogValueCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures ambient light up to 900lux
#[derive(Clone)]
pub struct AmbientLightBricklet {
    device: Device,
}
impl AmbientLightBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 21;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Ambient Light Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AmbientLightBricklet {
        let mut result = AmbientLightBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetIlluminance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::SetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::SetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetAnalogValueCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::SetIlluminanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetIlluminanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::SetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetAnalogValueCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::ambient_light_bricklet::AmbientLightBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::ambient_light_bricklet::AmbientLightBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AmbientLightBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AmbientLightBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_illuminance_callback_period`]. The parameter is the illuminance of the
    /// ambient light sensor.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed
    /// since the last triggering.
    ///
    /// [`set_illuminance_callback_period`]: #method.set_illuminance_callback_period
    /// [`get_illuminance_callback_receiver`]: #method.get_illuminance_callback_receiver
    pub fn get_illuminance_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AmbientLightBrickletFunction::CallbackIlluminance))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_analog_value_callback_period`]. The parameter is the analog value of the
    /// ambient light sensor.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog value has
    /// changed since the last triggering.
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AmbientLightBrickletFunction::CallbackAnalogValue))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_illuminance_callback_threshold`] is reached.
    /// The parameter is the illuminance of the ambient light sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_illuminance_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AmbientLightBrickletFunction::CallbackIlluminanceReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_analog_value_callback_threshold`] is reached.
    /// The parameter is the analog value of the ambient light sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_analog_value_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(AmbientLightBrickletFunction::CallbackAnalogValueReached))
    }

    /// Returns the illuminance of the ambient light sensor.
    ///
    /// If you want to get the illuminance periodically, it is recommended to use the
    /// [`get_illuminance_callback_receiver`] receiver and set the period with
    /// [`set_illuminance_callback_period`].
    pub fn get_illuminance(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetIlluminance), payload)
    }

    /// Returns the value as read by a 12-bit analog-to-digital converter.
    ///
    /// # Note
    ///  The value returned by [`get_illuminance`] is averaged over several samples
    ///  to yield less noise, while [`get_analog_value`] gives back raw
    ///  unfiltered analog values. The only reason to use [`get_analog_value`] is,
    ///  if you need the full resolution of the analog-to-digital converter.
    ///
    ///  Also, the analog-to-digital converter covers three different ranges that are
    ///  set dynamically depending on the light intensity. It is impossible to
    ///  distinguish between these ranges with the analog value.
    ///
    /// If you want the analog value periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver and set the period with
    /// [`set_analog_value_callback_period`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetAnalogValue), payload)
    }

    /// Sets the period with which the [`get_illuminance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed
    /// since the last triggering.
    pub fn set_illuminance_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AmbientLightBrickletFunction::SetIlluminanceCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_illuminance_callback_period`].
    pub fn get_illuminance_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetIlluminanceCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_analog_value_callback_receiver`] receiver is only triggered if the analog value has
    /// changed since the last triggering.
    pub fn set_analog_value_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AmbientLightBrickletFunction::SetAnalogValueCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_analog_value_callback_period`].
    pub fn get_analog_value_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetAnalogValueCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_illuminance_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the illuminance is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the illuminance is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the illuminance is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the illuminance is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_illuminance_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AmbientLightBrickletFunction::SetIlluminanceCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_illuminance_callback_threshold`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_illuminance_callback_threshold(&self) -> ConvertingReceiver<IlluminanceCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetIlluminanceCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_analog_value_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the analog value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the analog value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the analog value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the analog value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(AmbientLightBrickletFunction::SetAnalogValueCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_analog_value_callback_threshold`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_threshold(&self) -> ConvertingReceiver<AnalogValueCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetAnalogValueCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_illuminance_reached_callback_receiver`],
    /// * [`get_analog_value_reached_callback_receiver`]
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_illuminance_callback_threshold`],
    /// * [`set_analog_value_callback_threshold`]
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(AmbientLightBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightBrickletFunction::GetIdentity), payload)
    }
}
