/* ***********************************************************
 * This file was automatically generated on 2022-05-11.      *
 *                                                           *
 * Rust Bindings Version 2.0.20                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures IAQ index, temperature, humidity and air pressure.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AirQuality_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AirQualityBrickletFunction {
    GetAllValues,
    SetTemperatureOffset,
    GetTemperatureOffset,
    SetAllValuesCallbackConfiguration,
    GetAllValuesCallbackConfiguration,
    GetIaqIndex,
    SetIaqIndexCallbackConfiguration,
    GetIaqIndexCallbackConfiguration,
    GetTemperature,
    SetTemperatureCallbackConfiguration,
    GetTemperatureCallbackConfiguration,
    GetHumidity,
    SetHumidityCallbackConfiguration,
    GetHumidityCallbackConfiguration,
    GetAirPressure,
    SetAirPressureCallbackConfiguration,
    GetAirPressureCallbackConfiguration,
    RemoveCalibration,
    SetBackgroundCalibrationDuration,
    GetBackgroundCalibrationDuration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackAllValues,
    CallbackIaqIndex,
    CallbackTemperature,
    CallbackHumidity,
    CallbackAirPressure,
}
impl From<AirQualityBrickletFunction> for u8 {
    fn from(fun: AirQualityBrickletFunction) -> Self {
        match fun {
            AirQualityBrickletFunction::GetAllValues => 1,
            AirQualityBrickletFunction::SetTemperatureOffset => 2,
            AirQualityBrickletFunction::GetTemperatureOffset => 3,
            AirQualityBrickletFunction::SetAllValuesCallbackConfiguration => 4,
            AirQualityBrickletFunction::GetAllValuesCallbackConfiguration => 5,
            AirQualityBrickletFunction::GetIaqIndex => 7,
            AirQualityBrickletFunction::SetIaqIndexCallbackConfiguration => 8,
            AirQualityBrickletFunction::GetIaqIndexCallbackConfiguration => 9,
            AirQualityBrickletFunction::GetTemperature => 11,
            AirQualityBrickletFunction::SetTemperatureCallbackConfiguration => 12,
            AirQualityBrickletFunction::GetTemperatureCallbackConfiguration => 13,
            AirQualityBrickletFunction::GetHumidity => 15,
            AirQualityBrickletFunction::SetHumidityCallbackConfiguration => 16,
            AirQualityBrickletFunction::GetHumidityCallbackConfiguration => 17,
            AirQualityBrickletFunction::GetAirPressure => 19,
            AirQualityBrickletFunction::SetAirPressureCallbackConfiguration => 20,
            AirQualityBrickletFunction::GetAirPressureCallbackConfiguration => 21,
            AirQualityBrickletFunction::RemoveCalibration => 23,
            AirQualityBrickletFunction::SetBackgroundCalibrationDuration => 24,
            AirQualityBrickletFunction::GetBackgroundCalibrationDuration => 25,
            AirQualityBrickletFunction::GetSpitfpErrorCount => 234,
            AirQualityBrickletFunction::SetBootloaderMode => 235,
            AirQualityBrickletFunction::GetBootloaderMode => 236,
            AirQualityBrickletFunction::SetWriteFirmwarePointer => 237,
            AirQualityBrickletFunction::WriteFirmware => 238,
            AirQualityBrickletFunction::SetStatusLedConfig => 239,
            AirQualityBrickletFunction::GetStatusLedConfig => 240,
            AirQualityBrickletFunction::GetChipTemperature => 242,
            AirQualityBrickletFunction::Reset => 243,
            AirQualityBrickletFunction::WriteUid => 248,
            AirQualityBrickletFunction::ReadUid => 249,
            AirQualityBrickletFunction::GetIdentity => 255,
            AirQualityBrickletFunction::CallbackAllValues => 6,
            AirQualityBrickletFunction::CallbackIaqIndex => 10,
            AirQualityBrickletFunction::CallbackTemperature => 14,
            AirQualityBrickletFunction::CallbackHumidity => 18,
            AirQualityBrickletFunction::CallbackAirPressure => 22,
        }
    }
}
pub const AIR_QUALITY_BRICKLET_ACCURACY_UNRELIABLE: u8 = 0;
pub const AIR_QUALITY_BRICKLET_ACCURACY_LOW: u8 = 1;
pub const AIR_QUALITY_BRICKLET_ACCURACY_MEDIUM: u8 = 2;
pub const AIR_QUALITY_BRICKLET_ACCURACY_HIGH: u8 = 3;
pub const AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const AIR_QUALITY_BRICKLET_DURATION_4_DAYS: u8 = 0;
pub const AIR_QUALITY_BRICKLET_DURATION_28_DAYS: u8 = 1;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllValues {
    pub iaq_index: i32,
    pub iaq_index_accuracy: u8,
    pub temperature: i32,
    pub humidity: i32,
    pub air_pressure: i32,
}
impl FromByteSlice for AllValues {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllValues {
        AllValues {
            iaq_index: <i32>::from_le_byte_slice(&bytes[0..4]),
            iaq_index_accuracy: <u8>::from_le_byte_slice(&bytes[4..5]),
            temperature: <i32>::from_le_byte_slice(&bytes[5..9]),
            humidity: <i32>::from_le_byte_slice(&bytes[9..13]),
            air_pressure: <i32>::from_le_byte_slice(&bytes[13..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllValuesCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllValuesCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllValuesCallbackConfiguration {
        AllValuesCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllValuesEvent {
    pub iaq_index: i32,
    pub iaq_index_accuracy: u8,
    pub temperature: i32,
    pub humidity: i32,
    pub air_pressure: i32,
}
impl FromByteSlice for AllValuesEvent {
    fn bytes_expected() -> usize { 17 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllValuesEvent {
        AllValuesEvent {
            iaq_index: <i32>::from_le_byte_slice(&bytes[0..4]),
            iaq_index_accuracy: <u8>::from_le_byte_slice(&bytes[4..5]),
            temperature: <i32>::from_le_byte_slice(&bytes[5..9]),
            humidity: <i32>::from_le_byte_slice(&bytes[9..13]),
            air_pressure: <i32>::from_le_byte_slice(&bytes[13..17]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IaqIndex {
    pub iaq_index: i32,
    pub iaq_index_accuracy: u8,
}
impl FromByteSlice for IaqIndex {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> IaqIndex {
        IaqIndex { iaq_index: <i32>::from_le_byte_slice(&bytes[0..4]), iaq_index_accuracy: <u8>::from_le_byte_slice(&bytes[4..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IaqIndexCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for IaqIndexCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> IaqIndexCallbackConfiguration {
        IaqIndexCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IaqIndexEvent {
    pub iaq_index: i32,
    pub iaq_index_accuracy: u8,
}
impl FromByteSlice for IaqIndexEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> IaqIndexEvent {
        IaqIndexEvent { iaq_index: <i32>::from_le_byte_slice(&bytes[0..4]), iaq_index_accuracy: <u8>::from_le_byte_slice(&bytes[4..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for TemperatureCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackConfiguration {
        TemperatureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct HumidityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for HumidityCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> HumidityCallbackConfiguration {
        HumidityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AirPressureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for AirPressureCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> AirPressureCallbackConfiguration {
        AirPressureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures IAQ index, temperature, humidity and air pressure
#[derive(Clone)]
pub struct AirQualityBricklet {
    device: Device,
}
impl AirQualityBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 297;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Air Quality Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AirQualityBricklet {
        let mut result = AirQualityBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetAllValues) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetTemperatureOffset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetTemperatureOffset) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetAllValuesCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetAllValuesCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetIaqIndex) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetIaqIndexCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetIaqIndexCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetHumidity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetHumidityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetHumidityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetAirPressure) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetAirPressureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetAirPressureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::RemoveCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetBackgroundCalibrationDuration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetBackgroundCalibrationDuration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AirQualityBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::air_quality_bricklet::AirQualityBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::air_quality_bricklet::AirQualityBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AirQualityBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AirQualityBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_all_values_callback_configuration`].
    ///
    /// The parameters are the same as [`get_all_values`].
    ///
    /// [`get_all_values`]: #method.get_all_values
    /// [`set_all_values_callback_configuration`]: #method.set_all_values_callback_configuration
    pub fn get_all_values_callback_receiver(&self) -> ConvertingCallbackReceiver<AllValuesEvent> {
        self.device.get_callback_receiver(u8::from(AirQualityBrickletFunction::CallbackAllValues))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_iaq_index_callback_configuration`].
    ///
    /// The parameters are the same as [`get_iaq_index`].
    pub fn get_iaq_index_callback_receiver(&self) -> ConvertingCallbackReceiver<IaqIndexEvent> {
        self.device.get_callback_receiver(u8::from(AirQualityBrickletFunction::CallbackIaqIndex))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_temperature_callback_configuration`].
    ///
    /// The parameter is the same as [`get_temperature`].
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(AirQualityBrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_humidity_callback_configuration`].
    ///
    /// The parameter is the same as [`get_humidity`].
    pub fn get_humidity_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(AirQualityBrickletFunction::CallbackHumidity))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_air_pressure_callback_configuration`].
    ///
    /// The parameter is the same as [`get_air_pressure`].
    pub fn get_air_pressure_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(AirQualityBrickletFunction::CallbackAirPressure))
    }

    /// Returns all values measured by the Air Quality Bricklet. The values are
    /// IAQ (Indoor Air Quality) Index (higher value means greater level of air pollution), IAQ Index Accuracy, Temperature, Humidity and
    /// Air Pressure.
    ///
    /// .. image:: /Images/Misc/bricklet_air_quality_iaq_index.png
    ///    :scale: 100 %
    ///    :alt: Air Quality Index description
    ///    :align: center
    ///    :target: ../../_images/Misc/bricklet_air_quality_iaq_index.png
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_ACCURACY_UNRELIABLE
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_LOW
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_MEDIUM
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_HIGH
    pub fn get_all_values(&self) -> ConvertingReceiver<AllValues> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetAllValues), payload)
    }

    /// Sets a temperature offset. A offset of 10 will decrease the measured temperature by 0.1 °C.
    ///
    /// If you install this Bricklet into an enclosure and you want to measure the ambient
    /// temperature, you may have to decrease the measured temperature by some value to
    /// compensate for the error because of the heating inside of the enclosure.
    ///
    /// We recommend that you leave the parts in the enclosure running for at least
    /// 24 hours such that a temperature equilibrium can be reached. After that you can measure
    /// the temperature directly outside of enclosure and set the difference as offset.
    ///
    /// This temperature offset is used to calculate the relative humidity and
    /// IAQ index measurements. In case the Bricklet is installed in an enclosure, we
    /// recommend to measure and set the temperature offset to improve the accuracy of
    /// the measurements.
    pub fn set_temperature_offset(&self, offset: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(offset));

        self.device.set(u8::from(AirQualityBrickletFunction::SetTemperatureOffset), payload)
    }

    /// Returns the temperature offset as set by
    /// [`set_temperature_offset`].
    pub fn get_temperature_offset(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetTemperatureOffset), payload)
    }

    /// The period is the period with which the [`get_all_values_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after at least one of the values has changed. If the values didn't
    /// change within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_all_values_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(AirQualityBrickletFunction::SetAllValuesCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_all_values_callback_configuration`].
    pub fn get_all_values_callback_configuration(&self) -> ConvertingReceiver<AllValuesCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetAllValuesCallbackConfiguration), payload)
    }

    /// Returns the IAQ index and accuracy. The higher the IAQ index, the greater the level of air pollution.
    ///
    /// .. image:: /Images/Misc/bricklet_air_quality_iaq_index.png
    ///    :scale: 100 %
    ///    :alt: IAQ index description
    ///    :align: center
    ///    :target: ../../_images/Misc/bricklet_air_quality_iaq_index.png
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_iaq_index_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_iaq_index_callback_configuration`].
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_ACCURACY_UNRELIABLE
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_LOW
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_MEDIUM
    ///	* AIR_QUALITY_BRICKLET_ACCURACY_HIGH
    pub fn get_iaq_index(&self) -> ConvertingReceiver<IaqIndex> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetIaqIndex), payload)
    }

    /// The period is the period with which the [`get_iaq_index_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after at least one of the values has changed. If the values didn't
    /// change within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_iaq_index_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(AirQualityBrickletFunction::SetIaqIndexCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_iaq_index_callback_configuration`].
    pub fn get_iaq_index_callback_configuration(&self) -> ConvertingReceiver<IaqIndexCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetIaqIndexCallbackConfiguration), payload)
    }

    /// Returns temperature.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_temperature_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_temperature_callback_configuration`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetTemperature), payload)
    }

    /// The period is the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_temperature_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(AirQualityBrickletFunction::SetTemperatureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_temperature_callback_configuration`].
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_configuration(&self) -> ConvertingReceiver<TemperatureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetTemperatureCallbackConfiguration), payload)
    }

    /// Returns relative humidity.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_humidity_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_humidity_callback_configuration`].
    pub fn get_humidity(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetHumidity), payload)
    }

    /// The period is the period with which the [`get_humidity_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_humidity_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_humidity_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(AirQualityBrickletFunction::SetHumidityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_humidity_callback_configuration`].
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_humidity_callback_configuration(&self) -> ConvertingReceiver<HumidityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetHumidityCallbackConfiguration), payload)
    }

    /// Returns air pressure.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_air_pressure_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_air_pressure_callback_configuration`].
    pub fn get_air_pressure(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetAirPressure), payload)
    }

    /// The period is the period with which the [`get_air_pressure_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_air_pressure_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_air_pressure_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(AirQualityBrickletFunction::SetAirPressureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_air_pressure_callback_configuration`].
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AIR_QUALITY_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_air_pressure_callback_configuration(&self) -> ConvertingReceiver<AirPressureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetAirPressureCallbackConfiguration), payload)
    }

    /// Deletes the calibration from flash. After you call this function,
    /// you need to power cycle the Air Quality Bricklet.
    ///
    /// On the next power up the Bricklet will start a new calibration, as
    /// if it was started for the very first time.
    ///
    /// The calibration is based on the data of the last four days, so it takes
    /// four days until a full calibration is re-established.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn remove_calibration(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AirQualityBrickletFunction::RemoveCalibration), payload)
    }

    /// The Air Quality Bricklet uses an automatic background calibration mechanism to
    /// calculate the IAQ Index. This calibration mechanism considers a history of
    /// measured data. The duration of this history can be configured to either be
    /// 4 days or 28 days.
    ///
    /// If you keep the Bricklet mostly at one place and it does not get moved around
    /// to different environments, we recommend that you use a duration of 28 days.
    ///
    /// If you change the duration, the current calibration will be discarded and
    /// the calibration will start from beginning again. The configuration of the
    /// duration is saved in flash, so you should only have to call this function
    /// once in the lifetime of the Bricklet.
    ///
    /// The Bricklet has to be power cycled after this function is called
    /// for a duration change to take effect.
    ///
    /// Before firmware version 2.0.3 this was not configurable and the duration was
    /// 4 days.
    ///
    /// The default value (since firmware version 2.0.3) is 28 days.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_DURATION_4_DAYS
    ///	* AIR_QUALITY_BRICKLET_DURATION_28_DAYS
    pub fn set_background_calibration_duration(&self, duration: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(duration));

        self.device.set(u8::from(AirQualityBrickletFunction::SetBackgroundCalibrationDuration), payload)
    }

    /// Returns the background calibration duration as set by
    /// [`set_background_calibration_duration`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_DURATION_4_DAYS
    ///	* AIR_QUALITY_BRICKLET_DURATION_28_DAYS
    pub fn get_background_calibration_duration(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetBackgroundCalibrationDuration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(AirQualityBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* AIR_QUALITY_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(AirQualityBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(AirQualityBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(AirQualityBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* AIR_QUALITY_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AirQualityBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(AirQualityBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AirQualityBrickletFunction::GetIdentity), payload)
    }
}
