/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Detects inclination of Bricklet (tilt switch open/closed).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Tilt_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum TiltBrickletFunction {
    GetTiltState,
    EnableTiltStateCallback,
    DisableTiltStateCallback,
    IsTiltStateCallbackEnabled,
    GetIdentity,
    CallbackTiltState,
}
impl From<TiltBrickletFunction> for u8 {
    fn from(fun: TiltBrickletFunction) -> Self {
        match fun {
            TiltBrickletFunction::GetTiltState => 1,
            TiltBrickletFunction::EnableTiltStateCallback => 2,
            TiltBrickletFunction::DisableTiltStateCallback => 3,
            TiltBrickletFunction::IsTiltStateCallbackEnabled => 4,
            TiltBrickletFunction::GetIdentity => 255,
            TiltBrickletFunction::CallbackTiltState => 5,
        }
    }
}
pub const TILT_BRICKLET_TILT_STATE_CLOSED: u8 = 0;
pub const TILT_BRICKLET_TILT_STATE_OPEN: u8 = 1;
pub const TILT_BRICKLET_TILT_STATE_CLOSED_VIBRATING: u8 = 2;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Detects inclination of Bricklet (tilt switch open/closed)
#[derive(Clone)]
pub struct TiltBricklet {
    device: Device,
}
impl TiltBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 239;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Tilt Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> TiltBricklet {
        let mut result = TiltBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(TiltBrickletFunction::GetTiltState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TiltBrickletFunction::EnableTiltStateCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TiltBrickletFunction::DisableTiltStateCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(TiltBrickletFunction::IsTiltStateCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(TiltBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::tilt_bricklet::TiltBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::tilt_bricklet::TiltBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: TiltBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: TiltBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver provides the current tilt state. It is called every time the
    /// state changes.
    ///
    /// See [`get_tilt_state`] for a description of the states.
    ///
    /// [`get_tilt_state`]: #method.get_tilt_state
    pub fn get_tilt_state_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(TiltBrickletFunction::CallbackTiltState))
    }

    /// Returns the current tilt state. The state can either be
    ///
    /// * 0 = Closed: The ball in the tilt switch closes the circuit.
    /// * 1 = Open: The ball in the tilt switch does not close the circuit.
    /// * 2 = Closed Vibrating: The tilt switch is in motion (rapid change between open and close).
    ///
    /// .. image:: /Images/Bricklets/bricklet_tilt_mechanics.jpg
    ///    :scale: 100 %
    ///    :alt: Tilt states
    ///    :align: center
    ///    :target: ../../_images/Bricklets/bricklet_tilt_mechanics.jpg
    ///
    /// Associated constants:
    /// * TILT_BRICKLET_TILT_STATE_CLOSED
    ///	* TILT_BRICKLET_TILT_STATE_OPEN
    ///	* TILT_BRICKLET_TILT_STATE_CLOSED_VIBRATING
    pub fn get_tilt_state(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TiltBrickletFunction::GetTiltState), payload)
    }

    /// Enables the [`get_tilt_state_callback_receiver`] receiver.
    pub fn enable_tilt_state_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(TiltBrickletFunction::EnableTiltStateCallback), payload)
    }

    /// Disables the [`get_tilt_state_callback_receiver`] receiver.
    pub fn disable_tilt_state_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(TiltBrickletFunction::DisableTiltStateCallback), payload)
    }

    /// Returns *true* if the [`get_tilt_state_callback_receiver`] receiver is enabled.
    pub fn is_tilt_state_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TiltBrickletFunction::IsTiltStateCallbackEnabled), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(TiltBrickletFunction::GetIdentity), payload)
    }
}
