/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives one bipolar stepper motor with up to 38V and 2.5A per phase.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/Stepper_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum StepperBrickFunction {
    SetMaxVelocity,
    GetMaxVelocity,
    GetCurrentVelocity,
    SetSpeedRamping,
    GetSpeedRamping,
    FullBrake,
    SetCurrentPosition,
    GetCurrentPosition,
    SetTargetPosition,
    GetTargetPosition,
    SetSteps,
    GetSteps,
    GetRemainingSteps,
    SetStepMode,
    GetStepMode,
    DriveForward,
    DriveBackward,
    Stop,
    GetStackInputVoltage,
    GetExternalInputVoltage,
    GetCurrentConsumption,
    SetMotorCurrent,
    GetMotorCurrent,
    Enable,
    Disable,
    IsEnabled,
    SetDecay,
    GetDecay,
    SetMinimumVoltage,
    GetMinimumVoltage,
    SetSyncRect,
    IsSyncRect,
    SetTimeBase,
    GetTimeBase,
    GetAllData,
    SetAllDataPeriod,
    GetAllDataPeriod,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackUnderVoltage,
    CallbackPositionReached,
    CallbackAllData,
    CallbackNewState,
}
impl From<StepperBrickFunction> for u8 {
    fn from(fun: StepperBrickFunction) -> Self {
        match fun {
            StepperBrickFunction::SetMaxVelocity => 1,
            StepperBrickFunction::GetMaxVelocity => 2,
            StepperBrickFunction::GetCurrentVelocity => 3,
            StepperBrickFunction::SetSpeedRamping => 4,
            StepperBrickFunction::GetSpeedRamping => 5,
            StepperBrickFunction::FullBrake => 6,
            StepperBrickFunction::SetCurrentPosition => 7,
            StepperBrickFunction::GetCurrentPosition => 8,
            StepperBrickFunction::SetTargetPosition => 9,
            StepperBrickFunction::GetTargetPosition => 10,
            StepperBrickFunction::SetSteps => 11,
            StepperBrickFunction::GetSteps => 12,
            StepperBrickFunction::GetRemainingSteps => 13,
            StepperBrickFunction::SetStepMode => 14,
            StepperBrickFunction::GetStepMode => 15,
            StepperBrickFunction::DriveForward => 16,
            StepperBrickFunction::DriveBackward => 17,
            StepperBrickFunction::Stop => 18,
            StepperBrickFunction::GetStackInputVoltage => 19,
            StepperBrickFunction::GetExternalInputVoltage => 20,
            StepperBrickFunction::GetCurrentConsumption => 21,
            StepperBrickFunction::SetMotorCurrent => 22,
            StepperBrickFunction::GetMotorCurrent => 23,
            StepperBrickFunction::Enable => 24,
            StepperBrickFunction::Disable => 25,
            StepperBrickFunction::IsEnabled => 26,
            StepperBrickFunction::SetDecay => 27,
            StepperBrickFunction::GetDecay => 28,
            StepperBrickFunction::SetMinimumVoltage => 29,
            StepperBrickFunction::GetMinimumVoltage => 30,
            StepperBrickFunction::SetSyncRect => 33,
            StepperBrickFunction::IsSyncRect => 34,
            StepperBrickFunction::SetTimeBase => 35,
            StepperBrickFunction::GetTimeBase => 36,
            StepperBrickFunction::GetAllData => 37,
            StepperBrickFunction::SetAllDataPeriod => 38,
            StepperBrickFunction::GetAllDataPeriod => 39,
            StepperBrickFunction::SetSpitfpBaudrateConfig => 231,
            StepperBrickFunction::GetSpitfpBaudrateConfig => 232,
            StepperBrickFunction::GetSendTimeoutCount => 233,
            StepperBrickFunction::SetSpitfpBaudrate => 234,
            StepperBrickFunction::GetSpitfpBaudrate => 235,
            StepperBrickFunction::GetSpitfpErrorCount => 237,
            StepperBrickFunction::EnableStatusLed => 238,
            StepperBrickFunction::DisableStatusLed => 239,
            StepperBrickFunction::IsStatusLedEnabled => 240,
            StepperBrickFunction::GetProtocol1BrickletName => 241,
            StepperBrickFunction::GetChipTemperature => 242,
            StepperBrickFunction::Reset => 243,
            StepperBrickFunction::WriteBrickletPlugin => 246,
            StepperBrickFunction::ReadBrickletPlugin => 247,
            StepperBrickFunction::GetIdentity => 255,
            StepperBrickFunction::CallbackUnderVoltage => 31,
            StepperBrickFunction::CallbackPositionReached => 32,
            StepperBrickFunction::CallbackAllData => 40,
            StepperBrickFunction::CallbackNewState => 41,
        }
    }
}
pub const STEPPER_BRICK_STEP_MODE_FULL_STEP: u8 = 1;
pub const STEPPER_BRICK_STEP_MODE_HALF_STEP: u8 = 2;
pub const STEPPER_BRICK_STEP_MODE_QUARTER_STEP: u8 = 4;
pub const STEPPER_BRICK_STEP_MODE_EIGHTH_STEP: u8 = 8;
pub const STEPPER_BRICK_STATE_STOP: u8 = 1;
pub const STEPPER_BRICK_STATE_ACCELERATION: u8 = 2;
pub const STEPPER_BRICK_STATE_RUN: u8 = 3;
pub const STEPPER_BRICK_STATE_DEACCELERATION: u8 = 4;
pub const STEPPER_BRICK_STATE_DIRECTION_CHANGE_TO_FORWARD: u8 = 5;
pub const STEPPER_BRICK_STATE_DIRECTION_CHANGE_TO_BACKWARD: u8 = 6;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const STEPPER_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpeedRamping {
    pub acceleration: u16,
    pub deacceleration: u16,
}
impl FromByteSlice for SpeedRamping {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpeedRamping {
        SpeedRamping { acceleration: <u16>::from_le_byte_slice(&bytes[0..2]), deacceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub stack_voltage: u16,
    pub external_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            stack_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            external_voltage: <u16>::from_le_byte_slice(&bytes[12..14]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[14..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub stack_voltage: u16,
    pub external_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            stack_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            external_voltage: <u16>::from_le_byte_slice(&bytes[12..14]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[14..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct NewStateEvent {
    pub state_new: u8,
    pub state_previous: u8,
}
impl FromByteSlice for NewStateEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> NewStateEvent {
        NewStateEvent { state_new: <u8>::from_le_byte_slice(&bytes[0..1]), state_previous: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives one bipolar stepper motor with up to 38V and 2.5A per phase
#[derive(Clone)]
pub struct StepperBrick {
    device: Device,
}
impl StepperBrick {
    pub const DEVICE_IDENTIFIER: u16 = 15;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Stepper Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> StepperBrick {
        let mut result = StepperBrick { device: Device::new([2, 0, 4], uid, req_sender, 0) };
        result.device.response_expected[u8::from(StepperBrickFunction::SetMaxVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetMaxVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetCurrentVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetSpeedRamping) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSpeedRamping) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::SetCurrentPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetCurrentPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetTargetPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetTargetPosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetSteps) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSteps) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetRemainingSteps) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetStepMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetStepMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::DriveForward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::DriveBackward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::Stop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetStackInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetExternalInputVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetCurrentConsumption) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetMotorCurrent) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetMotorCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::Enable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::Disable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::IsEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetDecay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetDecay) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetMinimumVoltage) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(StepperBrickFunction::GetMinimumVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetSyncRect) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::IsSyncRect) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetTimeBase) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetTimeBase) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetAllDataPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(StepperBrickFunction::GetAllDataPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSpitfpBaudrateConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetProtocol1BrickletName) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(StepperBrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(StepperBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::stepper_brick::StepperBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::stepper_brick::StepperBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: StepperBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: StepperBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the input voltage drops below the value set by
    /// [`set_minimum_voltage`]. The parameter is the current voltage.
    ///
    /// [`set_minimum_voltage`]: #method.set_minimum_voltage
    pub fn get_under_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(StepperBrickFunction::CallbackUnderVoltage))
    }

    /// This receiver is triggered when a position set by [`set_steps`] or
    /// [`set_target_position`] is reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the stepper motor, this only works if the
    ///  acceleration (see [`set_speed_ramping`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(StepperBrickFunction::CallbackPositionReached))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_data_period`]. The parameters are: the current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(StepperBrickFunction::CallbackAllData))
    }

    /// This receiver is triggered whenever the Stepper Brick enters a new state.
    /// It returns the new state as well as the previous state.
    pub fn get_new_state_callback_receiver(&self) -> ConvertingCallbackReceiver<NewStateEvent> {
        self.device.get_callback_receiver(u8::from(StepperBrickFunction::CallbackNewState))
    }

    /// Sets the maximum velocity of the stepper motor.
    /// This function does *not* start the motor, it merely sets the maximum
    /// velocity the stepper motor is accelerated to. To get the motor running use
    /// either [`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`].
    pub fn set_max_velocity(&self, velocity: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(StepperBrickFunction::SetMaxVelocity), payload)
    }

    /// Returns the velocity as set by [`set_max_velocity`].
    pub fn get_max_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetMaxVelocity), payload)
    }

    /// Returns the *current* velocity of the stepper motor.
    pub fn get_current_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration and deacceleration of the stepper motor.
    /// An acceleration of 1000 means, that
    /// every second the velocity is increased by 1000 *steps/s*.
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 8000 *steps/s* in 10 seconds, you should set an acceleration
    /// of 800 *steps/s²*.
    ///
    /// An acceleration/deacceleration of 0 means instantaneous
    /// acceleration/deacceleration (not recommended)
    pub fn set_speed_ramping(&self, acceleration: u16, deacceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(deacceleration));

        self.device.set(u8::from(StepperBrickFunction::SetSpeedRamping), payload)
    }

    /// Returns the acceleration and deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn get_speed_ramping(&self) -> ConvertingReceiver<SpeedRamping> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetSpeedRamping), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`stop`] if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::FullBrake), payload)
    }

    /// Sets the current steps of the internal step counter. This can be used to
    /// set the current position to 0 when some kind of starting position
    /// is reached (e.g. when a CNC machine reaches a corner).
    pub fn set_current_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(StepperBrickFunction::SetCurrentPosition), payload)
    }

    /// Returns the current position of the stepper motor in steps. On startup
    /// the position is 0. The steps are counted with all possible driving
    /// functions ([`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`]). It also is possible to reset the steps to 0 or
    /// set them to any other desired value with [`set_current_position`].
    pub fn get_current_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetCurrentPosition), payload)
    }

    /// Sets the target position of the stepper motor in steps. For example,
    /// if the current position of the motor is 500 and [`set_target_position`] is
    /// called with 1000, the stepper motor will drive 500 steps forward. It will
    /// use the velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`].
    ///
    /// A call of [`set_target_position`] with the parameter *x* is equivalent to
    /// a call of [`set_steps`] with the parameter
    /// (*x* - [`get_current_position`]).
    pub fn set_target_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(StepperBrickFunction::SetTargetPosition), payload)
    }

    /// Returns the last target position as set by [`set_target_position`].
    pub fn get_target_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetTargetPosition), payload)
    }

    /// Sets the number of steps the stepper motor should run. Positive values
    /// will drive the motor forward and negative values backward.
    /// The velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn set_steps(&self, steps: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(steps));

        self.device.set(u8::from(StepperBrickFunction::SetSteps), payload)
    }

    /// Returns the last steps as set by [`set_steps`].
    pub fn get_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetSteps), payload)
    }

    /// Returns the remaining steps of the last call of [`set_steps`].
    /// For example, if [`set_steps`] is called with 2000 and
    /// [`get_remaining_steps`] is called after the motor has run for 500 steps,
    /// it will return 1500.
    pub fn get_remaining_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetRemainingSteps), payload)
    }

    /// Sets the step mode of the stepper motor. Possible values are:
    ///
    /// * Full Step = 1
    /// * Half Step = 2
    /// * Quarter Step = 4
    /// * Eighth Step = 8
    ///
    /// A higher value will increase the resolution and
    /// decrease the torque of the stepper motor.
    ///
    /// Associated constants:
    /// * STEPPER_BRICK_STEP_MODE_FULL_STEP
    ///	* STEPPER_BRICK_STEP_MODE_HALF_STEP
    ///	* STEPPER_BRICK_STEP_MODE_QUARTER_STEP
    ///	* STEPPER_BRICK_STEP_MODE_EIGHTH_STEP
    pub fn set_step_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(StepperBrickFunction::SetStepMode), payload)
    }

    /// Returns the step mode as set by [`set_step_mode`].
    ///
    /// Associated constants:
    /// * STEPPER_BRICK_STEP_MODE_FULL_STEP
    ///	* STEPPER_BRICK_STEP_MODE_HALF_STEP
    ///	* STEPPER_BRICK_STEP_MODE_QUARTER_STEP
    ///	* STEPPER_BRICK_STEP_MODE_EIGHTH_STEP
    pub fn get_step_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetStepMode), payload)
    }

    /// Drives the stepper motor forward until [`drive_backward`] or
    /// [`stop`] is called. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_forward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::DriveForward), payload)
    }

    /// Drives the stepper motor backward until [`drive_forward`] or
    /// [`stop`] is triggered. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_backward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::DriveBackward), payload)
    }

    /// Stops the stepper motor with the deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn stop(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::Stop), payload)
    }

    /// Returns the stack input voltage. The stack input voltage is the
    /// voltage that is supplied via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    pub fn get_stack_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetStackInputVoltage), payload)
    }

    /// Returns the external input voltage. The external input voltage is
    /// given via the black power input connector on the Stepper Brick.
    ///
    /// If there is an external input voltage and a stack input voltage, the motor
    /// will be driven by the external input voltage. If there is only a stack
    /// voltage present, the motor will be driven by this voltage.
    ///
    /// # Warning
    ///  This means, if you have a high stack voltage and a low external voltage,
    ///  the motor will be driven with the low external voltage. If you then remove
    ///  the external connection, it will immediately be driven by the high
    ///  stack voltage
    pub fn get_external_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetExternalInputVoltage), payload)
    }

    /// Returns the current consumption of the motor.
    pub fn get_current_consumption(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetCurrentConsumption), payload)
    }

    /// Sets the current with which the motor will be driven.
    ///
    /// # Warning
    ///  Do not set this value above the specifications of your stepper motor.
    ///  Otherwise it may damage your motor.
    pub fn set_motor_current(&self, current: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(current));

        self.device.set(u8::from(StepperBrickFunction::SetMotorCurrent), payload)
    }

    /// Returns the current as set by [`set_motor_current`].
    pub fn get_motor_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetMotorCurrent), payload)
    }

    /// Enables the driver chip. The driver parameters can be configured (maximum velocity,
    /// acceleration, etc) before it is enabled.
    pub fn enable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::Enable), payload)
    }

    /// Disables the driver chip. The configurations are kept (maximum velocity,
    /// acceleration, etc) but the motor is not driven until it is enabled again.
    ///
    /// # Warning
    ///  Disabling the driver chip while the motor is still turning can damage the
    ///  driver chip. The motor should be stopped calling [`stop`] function
    ///  before disabling the motor power. The [`stop`] function will **not**
    ///  wait until the motor is actually stopped. You have to explicitly wait for the
    ///  appropriate time after calling the [`stop`] function before calling
    ///  the [`disable`] function.
    pub fn disable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::Disable), payload)
    }

    /// Returns *true* if the driver chip is enabled, *false* otherwise.
    pub fn is_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::IsEnabled), payload)
    }

    /// Sets the decay mode of the stepper motor.
    /// A value of 0 sets the fast decay mode, a value of
    /// 65535 sets the slow decay mode and a value in between sets the mixed
    /// decay mode.
    ///
    /// Changing the decay mode is only possible if synchronous rectification
    /// is enabled (see :func:[Set Sync Rect`).
    ///
    /// For a good explanation of the different decay modes see
    /// `this](https://ebldc.com/?p=86/)__ blog post by Avayan.
    ///
    /// A good decay mode is unfortunately different for every motor. The best
    /// way to work out a good decay mode for your stepper motor, if you can't
    /// measure the current with an oscilloscope, is to listen to the sound of
    /// the motor. If the value is too low, you often hear a high pitched
    /// sound and if it is too high you can often hear a humming sound.
    ///
    /// Generally, fast decay mode (small value) will be noisier but also
    /// allow higher motor speeds.
    ///
    /// # Note
    ///  There is unfortunately no formula to calculate a perfect decay
    ///  mode for a given stepper motor. If you have problems with loud noises
    ///  or the maximum motor speed is too slow, you should try to tinker with
    ///  the decay value
    pub fn set_decay(&self, decay: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(decay));

        self.device.set(u8::from(StepperBrickFunction::SetDecay), payload)
    }

    /// Returns the decay mode as set by [`set_decay`].
    pub fn get_decay(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetDecay), payload)
    }

    /// Sets the minimum voltage, below which the [`get_under_voltage_callback_receiver`] receiver
    /// is triggered. The minimum possible value that works with the Stepper Brick is 8V.
    /// You can use this function to detect the discharge of a battery that is used
    /// to drive the stepper motor. If you have a fixed power supply, you likely do
    /// not need this functionality.
    pub fn set_minimum_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(StepperBrickFunction::SetMinimumVoltage), payload)
    }

    /// Returns the minimum voltage as set by [`set_minimum_voltage`].
    pub fn get_minimum_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetMinimumVoltage), payload)
    }

    /// Turns synchronous rectification on or off (*true* or *false*).
    ///
    /// With synchronous rectification on, the decay can be changed
    /// (see :func:[Set Decay`). Without synchronous rectification fast
    /// decay is used.
    ///
    /// For an explanation of synchronous rectification see
    /// `here](https://en.wikipedia.org/wiki/Active_rectification)__.
    ///
    /// # Warning
    ///  If you want to use high speeds (> 10000 steps/s) for a large
    ///  stepper motor with a large inductivity we strongly
    ///  suggest that you disable synchronous rectification. Otherwise the
    ///  Brick may not be able to cope with the load and overheat.
    pub fn set_sync_rect(&self, sync_rect: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(sync_rect));

        self.device.set(u8::from(StepperBrickFunction::SetSyncRect), payload)
    }

    /// Returns *true* if synchronous rectification is enabled, *false* otherwise.
    pub fn is_sync_rect(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::IsSyncRect), payload)
    }

    /// Sets the time base of the velocity and the acceleration of the stepper brick.
    ///
    /// For example, if you want to make one step every 1.5 seconds, you can set
    /// the time base to 15 and the velocity to 10. Now the velocity is
    /// 10steps/15s = 1steps/1.5s.
    pub fn set_time_base(&self, time_base: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(time_base));

        self.device.set(u8::from(StepperBrickFunction::SetTimeBase), payload)
    }

    /// Returns the time base as set by [`set_time_base`].
    pub fn get_time_base(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetTimeBase), payload)
    }

    /// Returns the following parameters: The current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    ///
    /// There is also a receiver for this function, see [`get_all_data_callback_receiver`] receiver.
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetAllData), payload)
    }

    /// Sets the period with which the [`get_all_data_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_all_data_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(StepperBrickFunction::SetAllDataPeriod), payload)
    }

    /// Returns the period as set by [`set_all_data_period`].
    pub fn get_all_data_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetAllDataPeriod), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.3.6$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(StepperBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.3.6$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.3.4$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * STEPPER_BRICK_COMMUNICATION_METHOD_NONE
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_USB
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_RS485
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* STEPPER_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(StepperBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(StepperBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(StepperBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(StepperBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(StepperBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(StepperBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(StepperBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(StepperBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(StepperBrickFunction::GetIdentity), payload)
    }
}
