/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures Sound Pressure Level in dB(A/B/C/D/Z).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/SoundPressureLevel_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum SoundPressureLevelBrickletFunction {
    GetDecibel,
    SetDecibelCallbackConfiguration,
    GetDecibelCallbackConfiguration,
    GetSpectrumLowLevel,
    SetSpectrumCallbackConfiguration,
    GetSpectrumCallbackConfiguration,
    SetConfiguration,
    GetConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackDecibel,
    CallbackSpectrumLowLevel,
}
impl From<SoundPressureLevelBrickletFunction> for u8 {
    fn from(fun: SoundPressureLevelBrickletFunction) -> Self {
        match fun {
            SoundPressureLevelBrickletFunction::GetDecibel => 1,
            SoundPressureLevelBrickletFunction::SetDecibelCallbackConfiguration => 2,
            SoundPressureLevelBrickletFunction::GetDecibelCallbackConfiguration => 3,
            SoundPressureLevelBrickletFunction::GetSpectrumLowLevel => 5,
            SoundPressureLevelBrickletFunction::SetSpectrumCallbackConfiguration => 6,
            SoundPressureLevelBrickletFunction::GetSpectrumCallbackConfiguration => 7,
            SoundPressureLevelBrickletFunction::SetConfiguration => 9,
            SoundPressureLevelBrickletFunction::GetConfiguration => 10,
            SoundPressureLevelBrickletFunction::GetSpitfpErrorCount => 234,
            SoundPressureLevelBrickletFunction::SetBootloaderMode => 235,
            SoundPressureLevelBrickletFunction::GetBootloaderMode => 236,
            SoundPressureLevelBrickletFunction::SetWriteFirmwarePointer => 237,
            SoundPressureLevelBrickletFunction::WriteFirmware => 238,
            SoundPressureLevelBrickletFunction::SetStatusLedConfig => 239,
            SoundPressureLevelBrickletFunction::GetStatusLedConfig => 240,
            SoundPressureLevelBrickletFunction::GetChipTemperature => 242,
            SoundPressureLevelBrickletFunction::Reset => 243,
            SoundPressureLevelBrickletFunction::WriteUid => 248,
            SoundPressureLevelBrickletFunction::ReadUid => 249,
            SoundPressureLevelBrickletFunction::GetIdentity => 255,
            SoundPressureLevelBrickletFunction::CallbackDecibel => 4,
            SoundPressureLevelBrickletFunction::CallbackSpectrumLowLevel => 8,
        }
    }
}
pub const SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_128: u8 = 0;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_256: u8 = 1;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_512: u8 = 2;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_1024: u8 = 3;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_A: u8 = 0;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_B: u8 = 1;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_C: u8 = 2;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_D: u8 = 3;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_Z: u8 = 4;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_ITU_R_468: u8 = 5;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DecibelCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for DecibelCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> DecibelCallbackConfiguration {
        DecibelCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u16>::from_le_byte_slice(&bytes[6..8]),
            max: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpectrumLowLevel {
    pub spectrum_length: u16,
    pub spectrum_chunk_offset: u16,
    pub spectrum_chunk_data: [u16; 30],
}
impl FromByteSlice for SpectrumLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpectrumLowLevel {
        SpectrumLowLevel {
            spectrum_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            spectrum_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            spectrum_chunk_data: <[u16; 30]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u16, SpectrumResult> for SpectrumLowLevel {
    fn ll_message_length(&self) -> usize { self.spectrum_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.spectrum_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.spectrum_chunk_data }

    fn get_result(&self) -> SpectrumResult { SpectrumResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpectrumLowLevelEvent {
    pub spectrum_length: u16,
    pub spectrum_chunk_offset: u16,
    pub spectrum_chunk_data: [u16; 30],
}
impl FromByteSlice for SpectrumLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpectrumLowLevelEvent {
        SpectrumLowLevelEvent {
            spectrum_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            spectrum_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            spectrum_chunk_data: <[u16; 30]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u16, SpectrumResult> for SpectrumLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.spectrum_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.spectrum_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u16] { &self.spectrum_chunk_data }

    fn get_result(&self) -> SpectrumResult { SpectrumResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub fft_size: u8,
    pub weighting: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { fft_size: <u8>::from_le_byte_slice(&bytes[0..1]), weighting: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpectrumResult {}

/// Measures Sound Pressure Level in dB(A/B/C/D/Z)
#[derive(Clone)]
pub struct SoundPressureLevelBricklet {
    device: Device,
}
impl SoundPressureLevelBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 290;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Sound Pressure Level Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SoundPressureLevelBricklet {
        let mut result = SoundPressureLevelBricklet { device: Device::new([2, 0, 0], uid, req_sender, 2) };
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetDecibel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetDecibelCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetDecibelCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetSpectrumLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetSpectrumCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetSpectrumCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SoundPressureLevelBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::sound_pressure_level_bricklet::SoundPressureLevelBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::sound_pressure_level_bricklet::SoundPressureLevelBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SoundPressureLevelBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SoundPressureLevelBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_decibel_callback_configuration`].
    ///
    /// The parameter is the same as [`get_decibel`].
    ///
    /// [`get_decibel`]: #method.get_decibel
    /// [`set_decibel_callback_configuration`]: #method.set_decibel_callback_configuration
    pub fn get_decibel_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(SoundPressureLevelBrickletFunction::CallbackDecibel))
    }

    /// See [`get_spectrum_callback_receiver`](crate::sound_pressure_level::SoundPressureLevel::get_spectrum_callback_receiver)
    pub fn get_spectrum_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<SpectrumLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(SoundPressureLevelBrickletFunction::CallbackSpectrumLowLevel))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_spectrum_callback_configuration`].
    ///
    /// The parameter is the same as [`get_spectrum`].
    pub fn get_spectrum_callback_receiver(&self) -> ConvertingHighLevelCallbackReceiver<u16, SpectrumResult, SpectrumLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(
            self.device.get_callback_receiver(u8::from(SoundPressureLevelBrickletFunction::CallbackSpectrumLowLevel)),
        )
    }

    /// Returns the measured sound pressure in decibels.
    ///
    /// The Bricklet supports the weighting standards dB(A), dB(B), dB(C), dB(D),
    /// dB(Z) and ITU-R 468. You can configure the weighting with [`set_configuration`].
    ///
    /// By default dB(A) will be used.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_decibel_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_decibel_callback_configuration`].
    pub fn get_decibel(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetDecibel), payload)
    }

    /// The period is the period with which the [`get_decibel_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_decibel_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_decibel_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u16,
        max: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::SetDecibelCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_decibel_callback_configuration`].
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_decibel_callback_configuration(&self) -> ConvertingReceiver<DecibelCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetDecibelCallbackConfiguration), payload)
    }

    /// Returns the frequency spectrum. The length of the spectrum is between
    /// 512 (FFT size 1024) and 64 (FFT size 128). See [`set_configuration`].
    ///
    /// Each array element is one bin of the FFT. The first bin is always the
    /// DC offset and the other bins have a size between 40Hz (FFT size 1024) and
    /// 320Hz (FFT size 128).
    ///
    /// In sum the frequency of the spectrum always has a range from 0 to
    /// 20480Hz (the FFT is applied to samples with a frequency of 40960Hz).
    ///
    /// The returned data is already equalized, which means that the microphone
    /// frequency response is compensated and the weighting function is applied
    /// (see [`set_configuration`] for the available weighting standards). Use
    /// dB(Z) if you need the unaltered spectrum.
    ///
    /// The values are not in dB form yet. If you want a proper dB scale of the
    /// spectrum you have to apply the formula f(x) = 20*log10(max(1, x/sqrt(2)))
    /// on each value.
    pub fn get_spectrum_low_level(&self) -> ConvertingReceiver<SpectrumLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetSpectrumLowLevel), payload)
    }

    /// Returns the frequency spectrum. The length of the spectrum is between
    /// 512 (FFT size 1024) and 64 (FFT size 128). See [`set_configuration`].
    ///
    /// Each array element is one bin of the FFT. The first bin is always the
    /// DC offset and the other bins have a size between 40Hz (FFT size 1024) and
    /// 320Hz (FFT size 128).
    ///
    /// In sum the frequency of the spectrum always has a range from 0 to
    /// 20480Hz (the FFT is applied to samples with a frequency of 40960Hz).
    ///
    /// The returned data is already equalized, which means that the microphone
    /// frequency response is compensated and the weighting function is applied
    /// (see [`set_configuration`] for the available weighting standards). Use
    /// dB(Z) if you need the unaltered spectrum.
    ///
    /// The values are not in dB form yet. If you want a proper dB scale of the
    /// spectrum you have to apply the formula f(x) = 20*log10(max(1, x/sqrt(2)))
    /// on each value.
    pub fn get_spectrum(&self) -> Result<Vec<u16>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(0, &mut || self.get_spectrum_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// The period is the period with which the [`get_spectrum_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    ///
    /// Every new measured spectrum will be send at most once. Set the period to 1 to
    /// make sure that you get every spectrum.
    pub fn set_spectrum_callback_configuration(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::SetSpectrumCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`get_spectrum_callback_configuration`].
    pub fn get_spectrum_callback_configuration(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetSpectrumCallbackConfiguration), payload)
    }

    /// Sets the Sound Pressure Level Bricklet configuration.
    ///
    /// With different FFT sizes the Bricklet has a different
    /// amount of samples per second and the size of the FFT bins
    /// changes. The higher the FFT size the more precise is the result
    /// of the dB(X) calculation.
    ///
    /// Available FFT sizes are:
    ///
    /// * 1024: 512 bins, 10 samples per second, each bin has size 40Hz
    /// * 512: 256 bins, 20 samples per second, each bin has size 80Hz
    /// * 256: 128 bins, 40 samples per second, each bin has size 160Hz
    /// * 128: 64 bins, 80 samples per second, each bin has size 320Hz
    ///
    /// The Bricklet supports different weighting functions. You can choose
    /// between dB(A), dB(B), dB(C), dB(D), dB(Z) and ITU-R 468.
    ///
    /// dB(A/B/C/D) are the standard dB weighting curves. dB(A) is
    /// often used to measure volumes at concerts etc. dB(Z) has a
    /// flat response, no weighting is applied. ITU-R 468 is an ITU
    /// weighting standard mostly used in the UK and Europe.
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_128
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_256
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_512
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_1024
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_A
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_B
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_C
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_D
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_Z
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_ITU_R_468
    pub fn set_configuration(&self, fft_size: u8, weighting: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(fft_size));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(weighting));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_128
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_256
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_512
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_FFT_SIZE_1024
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_A
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_B
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_C
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_D
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_Z
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_WEIGHTING_ITU_R_468
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SOUND_PRESSURE_LEVEL_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(SoundPressureLevelBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SoundPressureLevelBrickletFunction::GetIdentity), payload)
    }
}
