/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Controls AC and DC Solid State Relays.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/SolidStateRelay_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum SolidStateRelayBrickletFunction {
    SetState,
    GetState,
    SetMonoflop,
    GetMonoflop,
    GetIdentity,
    CallbackMonoflopDone,
}
impl From<SolidStateRelayBrickletFunction> for u8 {
    fn from(fun: SolidStateRelayBrickletFunction) -> Self {
        match fun {
            SolidStateRelayBrickletFunction::SetState => 1,
            SolidStateRelayBrickletFunction::GetState => 2,
            SolidStateRelayBrickletFunction::SetMonoflop => 3,
            SolidStateRelayBrickletFunction::GetMonoflop => 4,
            SolidStateRelayBrickletFunction::GetIdentity => 255,
            SolidStateRelayBrickletFunction::CallbackMonoflopDone => 5,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Monoflop {
    pub state: bool,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for Monoflop {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> Monoflop {
        Monoflop {
            state: <bool>::from_le_byte_slice(&bytes[0..1]),
            time: <u32>::from_le_byte_slice(&bytes[1..5]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Controls AC and DC Solid State Relays
#[derive(Clone)]
pub struct SolidStateRelayBricklet {
    device: Device,
}
impl SolidStateRelayBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 244;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Solid State Relay Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SolidStateRelayBricklet {
        let mut result = SolidStateRelayBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(SolidStateRelayBrickletFunction::SetState) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SolidStateRelayBrickletFunction::GetState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SolidStateRelayBrickletFunction::SetMonoflop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SolidStateRelayBrickletFunction::GetMonoflop) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SolidStateRelayBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::solid_state_relay_bricklet::SolidStateRelayBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::solid_state_relay_bricklet::SolidStateRelayBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SolidStateRelayBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SolidStateRelayBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever the monoflop timer reaches 0.
    /// The parameter is the current state of the relay
    /// (the state after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<bool> {
        self.device.get_callback_receiver(u8::from(SolidStateRelayBrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the state of the relays *true* means on and *false* means off.
    ///
    /// A running monoflop timer will be aborted if this function is called.
    pub fn set_state(&self, state: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(state));

        self.device.set(u8::from(SolidStateRelayBrickletFunction::SetState), payload)
    }

    /// Returns the state of the relay, *true* means on and *false* means off.
    pub fn get_state(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SolidStateRelayBrickletFunction::GetState), payload)
    }

    /// The first parameter  is the desired state of the relay (*true* means on
    /// and *false* means off). The second parameter indicates the time that
    /// the relay should hold the state.
    ///
    /// If this function is called with the parameters (true, 1500):
    /// The relay will turn on and in 1.5s it will turn off again.
    ///
    /// A monoflop can be used as a failsafe mechanism. For example: Lets assume you
    /// have a RS485 bus and a Solid State Relay Bricklet connected to one of the slave
    /// stacks. You can now call this function every second, with a time parameter
    /// of two seconds. The relay will be on all the time. If now the RS485
    /// connection is lost, the relay will turn off in at most two seconds.
    pub fn set_monoflop(&self, state: bool, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(state));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(SolidStateRelayBrickletFunction::SetMonoflop), payload)
    }

    /// Returns the current state and the time as set by
    /// [`set_monoflop`] as well as the remaining time until the state flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_monoflop(&self) -> ConvertingReceiver<Monoflop> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SolidStateRelayBrickletFunction::GetMonoflop), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SolidStateRelayBrickletFunction::GetIdentity), payload)
    }
}
