/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Silently drives one bipolar stepper motor with up to 46V and 1.6A per phase.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/SilentStepper_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum SilentStepperBrickFunction {
    SetMaxVelocity,
    GetMaxVelocity,
    GetCurrentVelocity,
    SetSpeedRamping,
    GetSpeedRamping,
    FullBrake,
    SetCurrentPosition,
    GetCurrentPosition,
    SetTargetPosition,
    GetTargetPosition,
    SetSteps,
    GetSteps,
    GetRemainingSteps,
    SetStepConfiguration,
    GetStepConfiguration,
    DriveForward,
    DriveBackward,
    Stop,
    GetStackInputVoltage,
    GetExternalInputVoltage,
    SetMotorCurrent,
    GetMotorCurrent,
    Enable,
    Disable,
    IsEnabled,
    SetBasicConfiguration,
    GetBasicConfiguration,
    SetSpreadcycleConfiguration,
    GetSpreadcycleConfiguration,
    SetStealthConfiguration,
    GetStealthConfiguration,
    SetCoolstepConfiguration,
    GetCoolstepConfiguration,
    SetMiscConfiguration,
    GetMiscConfiguration,
    GetDriverStatus,
    SetMinimumVoltage,
    GetMinimumVoltage,
    SetTimeBase,
    GetTimeBase,
    GetAllData,
    SetAllDataPeriod,
    GetAllDataPeriod,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackUnderVoltage,
    CallbackPositionReached,
    CallbackAllData,
    CallbackNewState,
}
impl From<SilentStepperBrickFunction> for u8 {
    fn from(fun: SilentStepperBrickFunction) -> Self {
        match fun {
            SilentStepperBrickFunction::SetMaxVelocity => 1,
            SilentStepperBrickFunction::GetMaxVelocity => 2,
            SilentStepperBrickFunction::GetCurrentVelocity => 3,
            SilentStepperBrickFunction::SetSpeedRamping => 4,
            SilentStepperBrickFunction::GetSpeedRamping => 5,
            SilentStepperBrickFunction::FullBrake => 6,
            SilentStepperBrickFunction::SetCurrentPosition => 7,
            SilentStepperBrickFunction::GetCurrentPosition => 8,
            SilentStepperBrickFunction::SetTargetPosition => 9,
            SilentStepperBrickFunction::GetTargetPosition => 10,
            SilentStepperBrickFunction::SetSteps => 11,
            SilentStepperBrickFunction::GetSteps => 12,
            SilentStepperBrickFunction::GetRemainingSteps => 13,
            SilentStepperBrickFunction::SetStepConfiguration => 14,
            SilentStepperBrickFunction::GetStepConfiguration => 15,
            SilentStepperBrickFunction::DriveForward => 16,
            SilentStepperBrickFunction::DriveBackward => 17,
            SilentStepperBrickFunction::Stop => 18,
            SilentStepperBrickFunction::GetStackInputVoltage => 19,
            SilentStepperBrickFunction::GetExternalInputVoltage => 20,
            SilentStepperBrickFunction::SetMotorCurrent => 22,
            SilentStepperBrickFunction::GetMotorCurrent => 23,
            SilentStepperBrickFunction::Enable => 24,
            SilentStepperBrickFunction::Disable => 25,
            SilentStepperBrickFunction::IsEnabled => 26,
            SilentStepperBrickFunction::SetBasicConfiguration => 27,
            SilentStepperBrickFunction::GetBasicConfiguration => 28,
            SilentStepperBrickFunction::SetSpreadcycleConfiguration => 29,
            SilentStepperBrickFunction::GetSpreadcycleConfiguration => 30,
            SilentStepperBrickFunction::SetStealthConfiguration => 31,
            SilentStepperBrickFunction::GetStealthConfiguration => 32,
            SilentStepperBrickFunction::SetCoolstepConfiguration => 33,
            SilentStepperBrickFunction::GetCoolstepConfiguration => 34,
            SilentStepperBrickFunction::SetMiscConfiguration => 35,
            SilentStepperBrickFunction::GetMiscConfiguration => 36,
            SilentStepperBrickFunction::GetDriverStatus => 37,
            SilentStepperBrickFunction::SetMinimumVoltage => 38,
            SilentStepperBrickFunction::GetMinimumVoltage => 39,
            SilentStepperBrickFunction::SetTimeBase => 42,
            SilentStepperBrickFunction::GetTimeBase => 43,
            SilentStepperBrickFunction::GetAllData => 44,
            SilentStepperBrickFunction::SetAllDataPeriod => 45,
            SilentStepperBrickFunction::GetAllDataPeriod => 46,
            SilentStepperBrickFunction::SetSpitfpBaudrateConfig => 231,
            SilentStepperBrickFunction::GetSpitfpBaudrateConfig => 232,
            SilentStepperBrickFunction::GetSendTimeoutCount => 233,
            SilentStepperBrickFunction::SetSpitfpBaudrate => 234,
            SilentStepperBrickFunction::GetSpitfpBaudrate => 235,
            SilentStepperBrickFunction::GetSpitfpErrorCount => 237,
            SilentStepperBrickFunction::EnableStatusLed => 238,
            SilentStepperBrickFunction::DisableStatusLed => 239,
            SilentStepperBrickFunction::IsStatusLedEnabled => 240,
            SilentStepperBrickFunction::GetProtocol1BrickletName => 241,
            SilentStepperBrickFunction::GetChipTemperature => 242,
            SilentStepperBrickFunction::Reset => 243,
            SilentStepperBrickFunction::WriteBrickletPlugin => 246,
            SilentStepperBrickFunction::ReadBrickletPlugin => 247,
            SilentStepperBrickFunction::GetIdentity => 255,
            SilentStepperBrickFunction::CallbackUnderVoltage => 40,
            SilentStepperBrickFunction::CallbackPositionReached => 41,
            SilentStepperBrickFunction::CallbackAllData => 47,
            SilentStepperBrickFunction::CallbackNewState => 48,
        }
    }
}
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_1: u8 = 8;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_2: u8 = 7;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_4: u8 = 6;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_8: u8 = 5;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_16: u8 = 4;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_32: u8 = 3;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_64: u8 = 2;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_128: u8 = 1;
pub const SILENT_STEPPER_BRICK_STEP_RESOLUTION_256: u8 = 0;
pub const SILENT_STEPPER_BRICK_CHOPPER_MODE_SPREAD_CYCLE: u8 = 0;
pub const SILENT_STEPPER_BRICK_CHOPPER_MODE_FAST_DECAY: u8 = 1;
pub const SILENT_STEPPER_BRICK_FREEWHEEL_MODE_NORMAL: u8 = 0;
pub const SILENT_STEPPER_BRICK_FREEWHEEL_MODE_FREEWHEELING: u8 = 1;
pub const SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_LS: u8 = 2;
pub const SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_HS: u8 = 3;
pub const SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_1: u8 = 0;
pub const SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_2: u8 = 1;
pub const SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_4: u8 = 2;
pub const SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_8: u8 = 3;
pub const SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_1: u8 = 0;
pub const SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_2: u8 = 1;
pub const SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_8: u8 = 2;
pub const SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_32: u8 = 3;
pub const SILENT_STEPPER_BRICK_MINIMUM_CURRENT_HALF: u8 = 0;
pub const SILENT_STEPPER_BRICK_MINIMUM_CURRENT_QUARTER: u8 = 1;
pub const SILENT_STEPPER_BRICK_STALLGUARD_MODE_STANDARD: u8 = 0;
pub const SILENT_STEPPER_BRICK_STALLGUARD_MODE_FILTERED: u8 = 1;
pub const SILENT_STEPPER_BRICK_OPEN_LOAD_NONE: u8 = 0;
pub const SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_A: u8 = 1;
pub const SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_B: u8 = 2;
pub const SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_AB: u8 = 3;
pub const SILENT_STEPPER_BRICK_SHORT_TO_GROUND_NONE: u8 = 0;
pub const SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_A: u8 = 1;
pub const SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_B: u8 = 2;
pub const SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_AB: u8 = 3;
pub const SILENT_STEPPER_BRICK_OVER_TEMPERATURE_NONE: u8 = 0;
pub const SILENT_STEPPER_BRICK_OVER_TEMPERATURE_WARNING: u8 = 1;
pub const SILENT_STEPPER_BRICK_OVER_TEMPERATURE_LIMIT: u8 = 2;
pub const SILENT_STEPPER_BRICK_STATE_STOP: u8 = 1;
pub const SILENT_STEPPER_BRICK_STATE_ACCELERATION: u8 = 2;
pub const SILENT_STEPPER_BRICK_STATE_RUN: u8 = 3;
pub const SILENT_STEPPER_BRICK_STATE_DEACCELERATION: u8 = 4;
pub const SILENT_STEPPER_BRICK_STATE_DIRECTION_CHANGE_TO_FORWARD: u8 = 5;
pub const SILENT_STEPPER_BRICK_STATE_DIRECTION_CHANGE_TO_BACKWARD: u8 = 6;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpeedRamping {
    pub acceleration: u16,
    pub deacceleration: u16,
}
impl FromByteSlice for SpeedRamping {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpeedRamping {
        SpeedRamping { acceleration: <u16>::from_le_byte_slice(&bytes[0..2]), deacceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StepConfiguration {
    pub step_resolution: u8,
    pub interpolation: bool,
}
impl FromByteSlice for StepConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> StepConfiguration {
        StepConfiguration {
            step_resolution: <u8>::from_le_byte_slice(&bytes[0..1]),
            interpolation: <bool>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BasicConfiguration {
    pub standstill_current: u16,
    pub motor_run_current: u16,
    pub standstill_delay_time: u16,
    pub power_down_time: u16,
    pub stealth_threshold: u16,
    pub coolstep_threshold: u16,
    pub classic_threshold: u16,
    pub high_velocity_chopper_mode: bool,
}
impl FromByteSlice for BasicConfiguration {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> BasicConfiguration {
        BasicConfiguration {
            standstill_current: <u16>::from_le_byte_slice(&bytes[0..2]),
            motor_run_current: <u16>::from_le_byte_slice(&bytes[2..4]),
            standstill_delay_time: <u16>::from_le_byte_slice(&bytes[4..6]),
            power_down_time: <u16>::from_le_byte_slice(&bytes[6..8]),
            stealth_threshold: <u16>::from_le_byte_slice(&bytes[8..10]),
            coolstep_threshold: <u16>::from_le_byte_slice(&bytes[10..12]),
            classic_threshold: <u16>::from_le_byte_slice(&bytes[12..14]),
            high_velocity_chopper_mode: <bool>::from_le_byte_slice(&bytes[14..15]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpreadcycleConfiguration {
    pub slow_decay_duration: u8,
    pub enable_random_slow_decay: bool,
    pub fast_decay_duration: u8,
    pub hysteresis_start_value: u8,
    pub hysteresis_end_value: i8,
    pub sine_wave_offset: i8,
    pub chopper_mode: u8,
    pub comparator_blank_time: u8,
    pub fast_decay_without_comparator: bool,
}
impl FromByteSlice for SpreadcycleConfiguration {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpreadcycleConfiguration {
        SpreadcycleConfiguration {
            slow_decay_duration: <u8>::from_le_byte_slice(&bytes[0..1]),
            enable_random_slow_decay: <bool>::from_le_byte_slice(&bytes[1..2]),
            fast_decay_duration: <u8>::from_le_byte_slice(&bytes[2..3]),
            hysteresis_start_value: <u8>::from_le_byte_slice(&bytes[3..4]),
            hysteresis_end_value: <i8>::from_le_byte_slice(&bytes[4..5]),
            sine_wave_offset: <i8>::from_le_byte_slice(&bytes[5..6]),
            chopper_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
            comparator_blank_time: <u8>::from_le_byte_slice(&bytes[7..8]),
            fast_decay_without_comparator: <bool>::from_le_byte_slice(&bytes[8..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StealthConfiguration {
    pub enable_stealth: bool,
    pub amplitude: u8,
    pub gradient: u8,
    pub enable_autoscale: bool,
    pub force_symmetric: bool,
    pub freewheel_mode: u8,
}
impl FromByteSlice for StealthConfiguration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> StealthConfiguration {
        StealthConfiguration {
            enable_stealth: <bool>::from_le_byte_slice(&bytes[0..1]),
            amplitude: <u8>::from_le_byte_slice(&bytes[1..2]),
            gradient: <u8>::from_le_byte_slice(&bytes[2..3]),
            enable_autoscale: <bool>::from_le_byte_slice(&bytes[3..4]),
            force_symmetric: <bool>::from_le_byte_slice(&bytes[4..5]),
            freewheel_mode: <u8>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CoolstepConfiguration {
    pub minimum_stallguard_value: u8,
    pub maximum_stallguard_value: u8,
    pub current_up_step_width: u8,
    pub current_down_step_width: u8,
    pub minimum_current: u8,
    pub stallguard_threshold_value: i8,
    pub stallguard_mode: u8,
}
impl FromByteSlice for CoolstepConfiguration {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> CoolstepConfiguration {
        CoolstepConfiguration {
            minimum_stallguard_value: <u8>::from_le_byte_slice(&bytes[0..1]),
            maximum_stallguard_value: <u8>::from_le_byte_slice(&bytes[1..2]),
            current_up_step_width: <u8>::from_le_byte_slice(&bytes[2..3]),
            current_down_step_width: <u8>::from_le_byte_slice(&bytes[3..4]),
            minimum_current: <u8>::from_le_byte_slice(&bytes[4..5]),
            stallguard_threshold_value: <i8>::from_le_byte_slice(&bytes[5..6]),
            stallguard_mode: <u8>::from_le_byte_slice(&bytes[6..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MiscConfiguration {
    pub disable_short_to_ground_protection: bool,
    pub synchronize_phase_frequency: u8,
}
impl FromByteSlice for MiscConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MiscConfiguration {
        MiscConfiguration {
            disable_short_to_ground_protection: <bool>::from_le_byte_slice(&bytes[0..1]),
            synchronize_phase_frequency: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DriverStatus {
    pub open_load: u8,
    pub short_to_ground: u8,
    pub over_temperature: u8,
    pub motor_stalled: bool,
    pub actual_motor_current: u8,
    pub full_step_active: bool,
    pub stallguard_result: u8,
    pub stealth_voltage_amplitude: u8,
}
impl FromByteSlice for DriverStatus {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DriverStatus {
        DriverStatus {
            open_load: <u8>::from_le_byte_slice(&bytes[0..1]),
            short_to_ground: <u8>::from_le_byte_slice(&bytes[1..2]),
            over_temperature: <u8>::from_le_byte_slice(&bytes[2..3]),
            motor_stalled: <bool>::from_le_byte_slice(&bytes[3..4]),
            actual_motor_current: <u8>::from_le_byte_slice(&bytes[4..5]),
            full_step_active: <bool>::from_le_byte_slice(&bytes[5..6]),
            stallguard_result: <u8>::from_le_byte_slice(&bytes[6..7]),
            stealth_voltage_amplitude: <u8>::from_le_byte_slice(&bytes[7..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub stack_voltage: u16,
    pub external_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            stack_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            external_voltage: <u16>::from_le_byte_slice(&bytes[12..14]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[14..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub current_velocity: u16,
    pub current_position: i32,
    pub remaining_steps: i32,
    pub stack_voltage: u16,
    pub external_voltage: u16,
    pub current_consumption: u16,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            current_velocity: <u16>::from_le_byte_slice(&bytes[0..2]),
            current_position: <i32>::from_le_byte_slice(&bytes[2..6]),
            remaining_steps: <i32>::from_le_byte_slice(&bytes[6..10]),
            stack_voltage: <u16>::from_le_byte_slice(&bytes[10..12]),
            external_voltage: <u16>::from_le_byte_slice(&bytes[12..14]),
            current_consumption: <u16>::from_le_byte_slice(&bytes[14..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct NewStateEvent {
    pub state_new: u8,
    pub state_previous: u8,
}
impl FromByteSlice for NewStateEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> NewStateEvent {
        NewStateEvent { state_new: <u8>::from_le_byte_slice(&bytes[0..1]), state_previous: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Silently drives one bipolar stepper motor with up to 46V and 1.6A per phase
#[derive(Clone)]
pub struct SilentStepperBrick {
    device: Device,
}
impl SilentStepperBrick {
    pub const DEVICE_IDENTIFIER: u16 = 19;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Silent Stepper Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SilentStepperBrick {
        let mut result = SilentStepperBrick { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetMaxVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetMaxVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetCurrentVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetSpeedRamping) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSpeedRamping) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetCurrentPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetCurrentPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetTargetPosition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetTargetPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetSteps) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSteps) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetRemainingSteps) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetStepConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetStepConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::DriveForward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::DriveBackward) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::Stop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetStackInputVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetExternalInputVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetMotorCurrent) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetMotorCurrent) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::Enable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::Disable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::IsEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetBasicConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetBasicConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetSpreadcycleConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSpreadcycleConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetStealthConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetStealthConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetCoolstepConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetCoolstepConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetMiscConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetMiscConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetDriverStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetMinimumVoltage) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetMinimumVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetTimeBase) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetTimeBase) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetAllDataPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetAllDataPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetSpitfpBaudrateConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSpitfpBaudrateConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSendTimeoutCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSpitfpBaudrate) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::IsStatusLedEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetProtocol1BrickletName) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::ReadBrickletPlugin) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SilentStepperBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::silent_stepper_brick::SilentStepperBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::silent_stepper_brick::SilentStepperBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SilentStepperBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SilentStepperBrickFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the input voltage drops below the value set by
    /// [`set_minimum_voltage`]. The parameter is the current voltage.
    ///
    /// [`set_minimum_voltage`]: #method.set_minimum_voltage
    pub fn get_under_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(SilentStepperBrickFunction::CallbackUnderVoltage))
    }

    /// This receiver is triggered when a position set by [`set_steps`] or
    /// [`set_target_position`] is reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the stepper motor, this only works if the
    ///  acceleration (see [`set_speed_ramping`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(SilentStepperBrickFunction::CallbackPositionReached))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_data_period`]. The parameters are: the current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(SilentStepperBrickFunction::CallbackAllData))
    }

    /// This receiver is triggered whenever the Silent Stepper Brick enters a new state.
    /// It returns the new state as well as the previous state.
    pub fn get_new_state_callback_receiver(&self) -> ConvertingCallbackReceiver<NewStateEvent> {
        self.device.get_callback_receiver(u8::from(SilentStepperBrickFunction::CallbackNewState))
    }

    /// Sets the maximum velocity of the stepper motor.
    /// This function does *not* start the motor, it merely sets the maximum
    /// velocity the stepper motor is accelerated to. To get the motor running use
    /// either [`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`].
    pub fn set_max_velocity(&self, velocity: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(SilentStepperBrickFunction::SetMaxVelocity), payload)
    }

    /// Returns the velocity as set by [`set_max_velocity`].
    pub fn get_max_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetMaxVelocity), payload)
    }

    /// Returns the *current* velocity of the stepper motor.
    pub fn get_current_velocity(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration and deacceleration of the stepper motor.
    /// An acceleration of 1000 means, that
    /// every second the velocity is increased by 1000 *steps/s*.
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 8000 *steps/s* in 10 seconds, you should set an acceleration
    /// of 800 *steps/s²*.
    ///
    /// An acceleration/deacceleration of 0 means instantaneous
    /// acceleration/deacceleration (not recommended)
    pub fn set_speed_ramping(&self, acceleration: u16, deacceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(deacceleration));

        self.device.set(u8::from(SilentStepperBrickFunction::SetSpeedRamping), payload)
    }

    /// Returns the acceleration and deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn get_speed_ramping(&self) -> ConvertingReceiver<SpeedRamping> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetSpeedRamping), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`stop`] if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::FullBrake), payload)
    }

    /// Sets the current steps of the internal step counter. This can be used to
    /// set the current position to 0 when some kind of starting position
    /// is reached (e.g. when a CNC machine reaches a corner).
    pub fn set_current_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(SilentStepperBrickFunction::SetCurrentPosition), payload)
    }

    /// Returns the current position of the stepper motor in steps. On startup
    /// the position is 0. The steps are counted with all possible driving
    /// functions ([`set_target_position`], [`set_steps`], [`drive_forward`] or
    /// [`drive_backward`]). It also is possible to reset the steps to 0 or
    /// set them to any other desired value with [`set_current_position`].
    pub fn get_current_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetCurrentPosition), payload)
    }

    /// Sets the target position of the stepper motor in steps. For example,
    /// if the current position of the motor is 500 and [`set_target_position`] is
    /// called with 1000, the stepper motor will drive 500 steps forward. It will
    /// use the velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`].
    ///
    /// A call of [`set_target_position`] with the parameter *x* is equivalent to
    /// a call of [`set_steps`] with the parameter
    /// (*x* - [`get_current_position`]).
    pub fn set_target_position(&self, position: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(position));

        self.device.set(u8::from(SilentStepperBrickFunction::SetTargetPosition), payload)
    }

    /// Returns the last target position as set by [`set_target_position`].
    pub fn get_target_position(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetTargetPosition), payload)
    }

    /// Sets the number of steps the stepper motor should run. Positive values
    /// will drive the motor forward and negative values backward.
    /// The velocity, acceleration and deacceleration as set by
    /// [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn set_steps(&self, steps: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(steps));

        self.device.set(u8::from(SilentStepperBrickFunction::SetSteps), payload)
    }

    /// Returns the last steps as set by [`set_steps`].
    pub fn get_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetSteps), payload)
    }

    /// Returns the remaining steps of the last call of [`set_steps`].
    /// For example, if [`set_steps`] is called with 2000 and
    /// [`get_remaining_steps`] is called after the motor has run for 500 steps,
    /// it will return 1500.
    pub fn get_remaining_steps(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetRemainingSteps), payload)
    }

    /// Sets the step resolution from full-step up to 1/256-step.
    ///
    /// If interpolation is turned on, the Silent Stepper Brick will always interpolate
    /// your step inputs as 1/256-step. If you use full-step mode with interpolation, each
    /// step will generate 256 1/256 steps.
    ///
    /// For maximum torque use full-step without interpolation. For maximum resolution use
    /// 1/256-step. Turn interpolation on to make the Stepper driving less noisy.
    ///
    /// If you often change the speed with high acceleration you should turn the
    /// interpolation off.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_STEP_RESOLUTION_1
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_2
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_4
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_8
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_16
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_32
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_64
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_128
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_256
    pub fn set_step_configuration(&self, step_resolution: u8, interpolation: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(step_resolution));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(interpolation));

        self.device.set(u8::from(SilentStepperBrickFunction::SetStepConfiguration), payload)
    }

    /// Returns the step mode as set by [`set_step_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_STEP_RESOLUTION_1
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_2
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_4
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_8
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_16
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_32
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_64
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_128
    ///	* SILENT_STEPPER_BRICK_STEP_RESOLUTION_256
    pub fn get_step_configuration(&self) -> ConvertingReceiver<StepConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetStepConfiguration), payload)
    }

    /// Drives the stepper motor forward until [`drive_backward`] or
    /// [`stop`] is called. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_forward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::DriveForward), payload)
    }

    /// Drives the stepper motor backward until [`drive_forward`] or
    /// [`stop`] is triggered. The velocity, acceleration and deacceleration as
    /// set by [`set_max_velocity`] and [`set_speed_ramping`] will be used.
    pub fn drive_backward(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::DriveBackward), payload)
    }

    /// Stops the stepper motor with the deacceleration as set by
    /// [`set_speed_ramping`].
    pub fn stop(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::Stop), payload)
    }

    /// Returns the stack input voltage. The stack input voltage is the
    /// voltage that is supplied via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    pub fn get_stack_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetStackInputVoltage), payload)
    }

    /// Returns the external input voltage. The external input voltage is
    /// given via the black power input connector on the Silent Stepper Brick.
    ///
    /// If there is an external input voltage and a stack input voltage, the motor
    /// will be driven by the external input voltage. If there is only a stack
    /// voltage present, the motor will be driven by this voltage.
    ///
    /// # Warning
    ///  This means, if you have a high stack voltage and a low external voltage,
    ///  the motor will be driven with the low external voltage. If you then remove
    ///  the external connection, it will immediately be driven by the high
    ///  stack voltage
    pub fn get_external_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetExternalInputVoltage), payload)
    }

    /// Sets the current with which the motor will be driven.
    ///
    /// # Warning
    ///  Do not set this value above the specifications of your stepper motor.
    ///  Otherwise it may damage your motor.
    pub fn set_motor_current(&self, current: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(current));

        self.device.set(u8::from(SilentStepperBrickFunction::SetMotorCurrent), payload)
    }

    /// Returns the current as set by [`set_motor_current`].
    pub fn get_motor_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetMotorCurrent), payload)
    }

    /// Enables the driver chip. The driver parameters can be configured (maximum velocity,
    /// acceleration, etc) before it is enabled.
    pub fn enable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::Enable), payload)
    }

    /// Disables the driver chip. The configurations are kept (maximum velocity,
    /// acceleration, etc) but the motor is not driven until it is enabled again.
    ///
    /// # Warning
    ///  Disabling the driver chip while the motor is still turning can damage the
    ///  driver chip. The motor should be stopped calling [`stop`] function
    ///  before disabling the motor power. The [`stop`] function will **not**
    ///  wait until the motor is actually stopped. You have to explicitly wait for the
    ///  appropriate time after calling the [`stop`] function before calling
    ///  the [`disable`] function.
    pub fn disable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::Disable), payload)
    }

    /// Returns *true* if the driver chip is enabled, *false* otherwise.
    pub fn is_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::IsEnabled), payload)
    }

    /// Sets the basic configuration parameters for the different modes (Stealth, Coolstep, Classic).
    ///
    /// * Standstill Current: This value can be used to lower the current during stand still. This might
    ///   be reasonable to reduce the heating of the motor and the Brick. When the motor is in standstill
    ///   the configured motor phase current will be driven until the configured
    ///   Power Down Time is elapsed. After that the phase current will be reduced to the standstill
    ///   current. The elapsed time for this reduction can be configured with the Standstill Delay Time.
    ///   The maximum allowed value is the configured maximum motor current
    ///   (see [`set_motor_current`]).
    ///
    /// * Motor Run Current: The value sets the motor current when the motor is running.
    ///   Use a value of at least one half of the global maximum motor current for a good
    ///   microstep performance. The maximum allowed value is the current
    ///   motor current. The API maps the entered value to 1/32 ... 32/32 of the maximum
    ///   motor current. This value should be used to change the motor current during motor movement,
    ///   whereas the global maximum motor current should not be changed while the motor is moving
    ///   (see [`set_motor_current`]).
    ///
    /// * Standstill Delay Time: Controls the duration for motor power down after a motion
    ///   as soon as standstill is detected and the Power Down Time is expired. A high Standstill Delay
    ///   Time results in a smooth transition that avoids motor jerk during power down.
    ///
    /// * Power Down Time: Sets the delay time after a stand still.
    ///
    /// * Stealth Threshold: Sets the upper threshold for Stealth mode.
    ///   If the velocity of the motor goes above this value, Stealth mode is turned
    ///   off. Otherwise it is turned on. In Stealth mode the torque declines with high speed.
    ///
    /// * Coolstep Threshold: Sets the lower threshold for Coolstep mode.
    ///   The Coolstep Threshold needs to be above the Stealth Threshold.
    ///
    /// * Classic Threshold: Sets the lower threshold for classic mode.
    ///   In classic mode the stepper becomes more noisy, but the torque is maximized.
    ///
    /// * High Velocity Chopper Mode: If High Velocity Chopper Mode is enabled, the stepper control
    ///   is optimized to run the stepper motors at high velocities.
    ///
    /// If you want to use all three thresholds make sure that
    /// Stealth Threshold < Coolstep Threshold < Classic Threshold.
    pub fn set_basic_configuration(
        &self,
        standstill_current: u16,
        motor_run_current: u16,
        standstill_delay_time: u16,
        power_down_time: u16,
        stealth_threshold: u16,
        coolstep_threshold: u16,
        classic_threshold: u16,
        high_velocity_chopper_mode: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(standstill_current));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(motor_run_current));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(standstill_delay_time));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(power_down_time));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(stealth_threshold));
        payload[10..12].copy_from_slice(&<u16>::to_le_byte_vec(coolstep_threshold));
        payload[12..14].copy_from_slice(&<u16>::to_le_byte_vec(classic_threshold));
        payload[14..15].copy_from_slice(&<bool>::to_le_byte_vec(high_velocity_chopper_mode));

        self.device.set(u8::from(SilentStepperBrickFunction::SetBasicConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_basic_configuration`].
    pub fn get_basic_configuration(&self) -> ConvertingReceiver<BasicConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetBasicConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the Spreadcycle configuration parameters. Spreadcycle is a chopper algorithm which actively
    /// controls the motor current flow. More information can be found in the TMC2130 datasheet on page
    /// 47 (7 spreadCycle and Classic Chopper).
    ///
    /// * Slow Decay Duration: Controls duration of off time setting of slow decay phase.
    ///   0 = driver disabled, all bridges off. Use 1 only with Comparator Blank time >= 2.
    ///
    /// * Enable Random Slow Decay: Set to false to fix chopper off time as set by Slow Decay Duration.
    ///   If you set it to true, Decay Duration is randomly modulated.
    ///
    /// * Fast Decay Duration: Sets the fast decay duration. This parameters is
    ///   only used if the Chopper Mode is set to Fast Decay.
    ///
    /// * Hysteresis Start Value: Sets the hysteresis start value. This parameter is
    ///   only used if the Chopper Mode is set to Spread Cycle.
    ///
    /// * Hysteresis End Value: Sets the hysteresis end value. This parameter is
    ///   only used if the Chopper Mode is set to Spread Cycle.
    ///
    /// * Sine Wave Offset: Sets the sine wave offset. This parameters is
    ///   only used if the Chopper Mode is set to Fast Decay. 1/512 of the value becomes added to the absolute
    ///   value of the sine wave.
    ///
    /// * Chopper Mode: 0 = Spread Cycle, 1 = Fast Decay.
    ///
    /// * Comparator Blank Time: Sets the blank time of the comparator. Available values are
    ///
    ///   * 0 = 16 clocks,
    ///   * 1 = 24 clocks,
    ///   * 2 = 36 clocks and
    ///   * 3 = 54 clocks.
    ///
    ///   A value of 1 or 2 is recommended for most applications.
    ///
    /// * Fast Decay Without Comparator: If set to true the current comparator usage for termination of the
    ///   fast decay cycle is disabled.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_CHOPPER_MODE_SPREAD_CYCLE
    ///	* SILENT_STEPPER_BRICK_CHOPPER_MODE_FAST_DECAY
    pub fn set_spreadcycle_configuration(
        &self,
        slow_decay_duration: u8,
        enable_random_slow_decay: bool,
        fast_decay_duration: u8,
        hysteresis_start_value: u8,
        hysteresis_end_value: i8,
        sine_wave_offset: i8,
        chopper_mode: u8,
        comparator_blank_time: u8,
        fast_decay_without_comparator: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(slow_decay_duration));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(enable_random_slow_decay));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(fast_decay_duration));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(hysteresis_start_value));
        payload[4..5].copy_from_slice(&<i8>::to_le_byte_vec(hysteresis_end_value));
        payload[5..6].copy_from_slice(&<i8>::to_le_byte_vec(sine_wave_offset));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(chopper_mode));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(comparator_blank_time));
        payload[8..9].copy_from_slice(&<bool>::to_le_byte_vec(fast_decay_without_comparator));

        self.device.set(u8::from(SilentStepperBrickFunction::SetSpreadcycleConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_basic_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_CHOPPER_MODE_SPREAD_CYCLE
    ///	* SILENT_STEPPER_BRICK_CHOPPER_MODE_FAST_DECAY
    pub fn get_spreadcycle_configuration(&self) -> ConvertingReceiver<SpreadcycleConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetSpreadcycleConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the configuration relevant for Stealth mode.
    ///
    /// * Enable Stealth: If set to true the stealth mode is enabled, if set to false the
    ///   stealth mode is disabled, even if the speed is below the threshold set in [`set_basic_configuration`].
    ///
    /// * Amplitude: If autoscale is disabled, the PWM amplitude is scaled by this value. If autoscale is enabled,
    ///   this value defines the maximum PWM amplitude change per half wave.
    ///
    /// * Gradient: If autoscale is disabled, the PWM gradient is scaled by this value. If autoscale is enabled,
    ///   this value defines the maximum PWM gradient. With autoscale a value above 64 is recommended,
    ///   otherwise the regulation might not be able to measure the current.
    ///
    /// * Enable Autoscale: If set to true, automatic current control is used. Otherwise the user defined
    ///   amplitude and gradient are used.
    ///
    /// * Force Symmetric: If true, A symmetric PWM cycle is enforced. Otherwise the PWM value may change within each
    ///   PWM cycle.
    ///
    /// * Freewheel Mode: The freewheel mode defines the behavior in stand still if the Standstill Current
    ///   (see [`set_basic_configuration`]) is set to 0.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_FREEWHEEL_MODE_NORMAL
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_FREEWHEELING
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_LS
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_HS
    pub fn set_stealth_configuration(
        &self,
        enable_stealth: bool,
        amplitude: u8,
        gradient: u8,
        enable_autoscale: bool,
        force_symmetric: bool,
        freewheel_mode: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_stealth));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(amplitude));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(gradient));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(enable_autoscale));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(force_symmetric));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(freewheel_mode));

        self.device.set(u8::from(SilentStepperBrickFunction::SetStealthConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_stealth_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_FREEWHEEL_MODE_NORMAL
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_FREEWHEELING
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_LS
    ///	* SILENT_STEPPER_BRICK_FREEWHEEL_MODE_COIL_SHORT_HS
    pub fn get_stealth_configuration(&self) -> ConvertingReceiver<StealthConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetStealthConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets the configuration relevant for Coolstep.
    ///
    /// * Minimum Stallguard Value: If the Stallguard result falls below this value*32, the motor current
    ///   is increased to reduce motor load angle. A value of 0 turns Coolstep off.
    ///
    /// * Maximum Stallguard Value: If the Stallguard result goes above
    ///   (Min Stallguard Value + Max Stallguard Value + 1) * 32, the motor current is decreased to save
    ///   energy.
    ///
    /// * Current Up Step Width: Sets the up step increment per Stallguard value. The value range is 0-3,
    ///   corresponding to the increments 1, 2, 4 and 8.
    ///
    /// * Current Down Step Width: Sets the down step decrement per Stallguard value. The value range is 0-3,
    ///   corresponding to the decrements 1, 2, 8 and 16.
    ///
    /// * Minimum Current: Sets the minimum current for Coolstep current control. You can choose between
    ///   half and quarter of the run current.
    ///
    /// * Stallguard Threshold Value: Sets the level for stall output (see [`get_driver_status`]).
    ///   A lower value gives a higher sensitivity. You have to find a suitable value for your
    ///   motor by trial and error, 0 works for most motors.
    ///
    /// * Stallguard Mode: Set to 0 for standard resolution or 1 for filtered mode. In filtered mode the Stallguard
    ///   signal will be updated every four full-steps.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_1
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_2
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_4
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_8
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_1
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_2
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_8
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_32
    ///	* SILENT_STEPPER_BRICK_MINIMUM_CURRENT_HALF
    ///	* SILENT_STEPPER_BRICK_MINIMUM_CURRENT_QUARTER
    ///	* SILENT_STEPPER_BRICK_STALLGUARD_MODE_STANDARD
    ///	* SILENT_STEPPER_BRICK_STALLGUARD_MODE_FILTERED
    pub fn set_coolstep_configuration(
        &self,
        minimum_stallguard_value: u8,
        maximum_stallguard_value: u8,
        current_up_step_width: u8,
        current_down_step_width: u8,
        minimum_current: u8,
        stallguard_threshold_value: i8,
        stallguard_mode: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(minimum_stallguard_value));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(maximum_stallguard_value));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(current_up_step_width));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(current_down_step_width));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(minimum_current));
        payload[5..6].copy_from_slice(&<i8>::to_le_byte_vec(stallguard_threshold_value));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(stallguard_mode));

        self.device.set(u8::from(SilentStepperBrickFunction::SetCoolstepConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_coolstep_configuration`].
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_1
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_2
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_4
    ///	* SILENT_STEPPER_BRICK_CURRENT_UP_STEP_INCREMENT_8
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_1
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_2
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_8
    ///	* SILENT_STEPPER_BRICK_CURRENT_DOWN_STEP_DECREMENT_32
    ///	* SILENT_STEPPER_BRICK_MINIMUM_CURRENT_HALF
    ///	* SILENT_STEPPER_BRICK_MINIMUM_CURRENT_QUARTER
    ///	* SILENT_STEPPER_BRICK_STALLGUARD_MODE_STANDARD
    ///	* SILENT_STEPPER_BRICK_STALLGUARD_MODE_FILTERED
    pub fn get_coolstep_configuration(&self) -> ConvertingReceiver<CoolstepConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetCoolstepConfiguration), payload)
    }

    /// Note: If you don't know what any of this means you can very likely keep all of
    /// the values as default!
    ///
    /// Sets miscellaneous configuration parameters.
    ///
    /// * Disable Short To Ground Protection: Set to false to enable short to ground protection, otherwise
    ///   it is disabled.
    ///
    /// * Synchronize Phase Frequency: With this parameter you can synchronize the chopper for both phases
    ///   of a two phase motor to avoid the occurrence of a beat. The value range is 0-15. If set to 0,
    ///   the synchronization is turned off. Otherwise the synchronization is done through the formula
    ///   f_sync = f_clk/(value*64). In Classic Mode the synchronization is automatically switched off.
    ///   f_clk is 12.8MHz.
    pub fn set_misc_configuration(
        &self,
        disable_short_to_ground_protection: bool,
        synchronize_phase_frequency: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(disable_short_to_ground_protection));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(synchronize_phase_frequency));

        self.device.set(u8::from(SilentStepperBrickFunction::SetMiscConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_misc_configuration`].
    pub fn get_misc_configuration(&self) -> ConvertingReceiver<MiscConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetMiscConfiguration), payload)
    }

    /// Returns the current driver status.
    ///
    /// * Open Load: Indicates if an open load is present on phase A, B or both. This could mean that there is a problem
    ///   with the wiring of the motor. False detection can occur in fast motion as well as during stand still.
    ///
    /// * Short To Ground: Indicates if a short to ground is present on phase A, B or both. If this is detected the driver
    ///   automatically becomes disabled and stays disabled until it is enabled again manually.
    ///
    /// * Over Temperature: The over temperature indicator switches to Warning if the driver IC warms up. The warning flag
    ///   is expected during long duration stepper uses. If the temperature limit is reached the indicator switches
    ///   to Limit. In this case the driver becomes disabled until it cools down again.
    ///
    /// * Motor Stalled: Is true if a motor stall was detected.
    ///
    /// * Actual Motor Current: Indicates the actual current control scaling as used in Coolstep mode.
    ///   It represents a multiplier of 1/32 to 32/32 of the
    ///   ``Motor Run Current`` as set by [`set_basic_configuration`]. Example: If a ``Motor Run Current``
    ///   of 1000mA was set and the returned value is 15, the ``Actual Motor Current`` is 16/32*1000mA = 500mA.
    ///
    /// * Stallguard Result: Indicates the load of the motor. A lower value signals a higher load. Per trial and error
    ///   you can find out which value corresponds to a suitable torque for the velocity used in your application.
    ///   After that you can use this threshold value to find out if a motor stall becomes probable and react on it (e.g.
    ///   decrease velocity).
    ///   During stand still this value can not be used for stall detection, it shows the chopper on-time for motor coil A.
    ///
    /// * Stealth Voltage Amplitude: Shows the actual PWM scaling. In Stealth mode it can be used to detect motor load and
    ///   stall if autoscale is enabled (see [`set_stealth_configuration`]).
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_OPEN_LOAD_NONE
    ///	* SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_A
    ///	* SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_B
    ///	* SILENT_STEPPER_BRICK_OPEN_LOAD_PHASE_AB
    ///	* SILENT_STEPPER_BRICK_SHORT_TO_GROUND_NONE
    ///	* SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_A
    ///	* SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_B
    ///	* SILENT_STEPPER_BRICK_SHORT_TO_GROUND_PHASE_AB
    ///	* SILENT_STEPPER_BRICK_OVER_TEMPERATURE_NONE
    ///	* SILENT_STEPPER_BRICK_OVER_TEMPERATURE_WARNING
    ///	* SILENT_STEPPER_BRICK_OVER_TEMPERATURE_LIMIT
    pub fn get_driver_status(&self) -> ConvertingReceiver<DriverStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetDriverStatus), payload)
    }

    /// Sets the minimum voltage, below which the [`get_under_voltage_callback_receiver`] receiver
    /// is triggered. The minimum possible value that works with the Silent Stepper
    /// Brick is 8V.
    /// You can use this function to detect the discharge of a battery that is used
    /// to drive the stepper motor. If you have a fixed power supply, you likely do
    /// not need this functionality.
    pub fn set_minimum_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(SilentStepperBrickFunction::SetMinimumVoltage), payload)
    }

    /// Returns the minimum voltage as set by [`set_minimum_voltage`].
    pub fn get_minimum_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetMinimumVoltage), payload)
    }

    /// Sets the time base of the velocity and the acceleration of the Silent Stepper
    /// Brick.
    ///
    /// For example, if you want to make one step every 1.5 seconds, you can set
    /// the time base to 15 and the velocity to 10. Now the velocity is
    /// 10steps/15s = 1steps/1.5s.
    pub fn set_time_base(&self, time_base: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(time_base));

        self.device.set(u8::from(SilentStepperBrickFunction::SetTimeBase), payload)
    }

    /// Returns the time base as set by [`set_time_base`].
    pub fn get_time_base(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetTimeBase), payload)
    }

    /// Returns the following parameters: The current velocity,
    /// the current position, the remaining steps, the stack voltage, the external
    /// voltage and the current consumption of the stepper motor.
    ///
    /// The current consumption is calculated by multiplying the ``Actual Motor Current``
    /// value (see [`set_basic_configuration`]) with the ``Motor Run Current``
    /// (see [`get_driver_status`]). This is an internal calculation of the
    /// driver, not an independent external measurement.
    ///
    /// The current consumption calculation was broken up to firmware 2.0.1, it is fixed
    /// since firmware 2.0.2.
    ///
    /// There is also a receiver for this function, see [`get_all_data_callback_receiver`] receiver.
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetAllData), payload)
    }

    /// Sets the period with which the [`get_all_data_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_all_data_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(SilentStepperBrickFunction::SetAllDataPeriod), payload)
    }

    /// Returns the period as set by [`set_all_data_period`].
    pub fn get_all_data_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetAllDataPeriod), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(SilentStepperBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    /// Associated constants:
    /// * SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_NONE
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_USB
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_RS485
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* SILENT_STEPPER_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(SilentStepperBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(SilentStepperBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(SilentStepperBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(SilentStepperBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(SilentStepperBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SilentStepperBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(SilentStepperBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(SilentStepperBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SilentStepperBrickFunction::GetIdentity), payload)
    }
}
