/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Four 7-segment displays with switchable dots.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/SegmentDisplay4x7V2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum SegmentDisplay4x7V2BrickletFunction {
    SetSegments,
    GetSegments,
    SetBrightness,
    GetBrightness,
    SetNumericValue,
    SetSelectedSegment,
    GetSelectedSegment,
    StartCounter,
    GetCounterValue,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackCounterFinished,
}
impl From<SegmentDisplay4x7V2BrickletFunction> for u8 {
    fn from(fun: SegmentDisplay4x7V2BrickletFunction) -> Self {
        match fun {
            SegmentDisplay4x7V2BrickletFunction::SetSegments => 1,
            SegmentDisplay4x7V2BrickletFunction::GetSegments => 2,
            SegmentDisplay4x7V2BrickletFunction::SetBrightness => 3,
            SegmentDisplay4x7V2BrickletFunction::GetBrightness => 4,
            SegmentDisplay4x7V2BrickletFunction::SetNumericValue => 5,
            SegmentDisplay4x7V2BrickletFunction::SetSelectedSegment => 6,
            SegmentDisplay4x7V2BrickletFunction::GetSelectedSegment => 7,
            SegmentDisplay4x7V2BrickletFunction::StartCounter => 8,
            SegmentDisplay4x7V2BrickletFunction::GetCounterValue => 9,
            SegmentDisplay4x7V2BrickletFunction::GetSpitfpErrorCount => 234,
            SegmentDisplay4x7V2BrickletFunction::SetBootloaderMode => 235,
            SegmentDisplay4x7V2BrickletFunction::GetBootloaderMode => 236,
            SegmentDisplay4x7V2BrickletFunction::SetWriteFirmwarePointer => 237,
            SegmentDisplay4x7V2BrickletFunction::WriteFirmware => 238,
            SegmentDisplay4x7V2BrickletFunction::SetStatusLedConfig => 239,
            SegmentDisplay4x7V2BrickletFunction::GetStatusLedConfig => 240,
            SegmentDisplay4x7V2BrickletFunction::GetChipTemperature => 242,
            SegmentDisplay4x7V2BrickletFunction::Reset => 243,
            SegmentDisplay4x7V2BrickletFunction::WriteUid => 248,
            SegmentDisplay4x7V2BrickletFunction::ReadUid => 249,
            SegmentDisplay4x7V2BrickletFunction::GetIdentity => 255,
            SegmentDisplay4x7V2BrickletFunction::CallbackCounterFinished => 10,
        }
    }
}
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Segments {
    pub digit0: [bool; 8],
    pub digit1: [bool; 8],
    pub digit2: [bool; 8],
    pub digit3: [bool; 8],
    pub colon: [bool; 2],
    pub tick: bool,
}
impl FromByteSlice for Segments {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Segments {
        Segments {
            digit0: <[bool; 8]>::from_le_byte_slice(&bytes[0..1]),
            digit1: <[bool; 8]>::from_le_byte_slice(&bytes[1..2]),
            digit2: <[bool; 8]>::from_le_byte_slice(&bytes[2..3]),
            digit3: <[bool; 8]>::from_le_byte_slice(&bytes[3..4]),
            colon: <[bool; 2]>::from_le_byte_slice(&bytes[4..5]),
            tick: <bool>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Four 7-segment displays with switchable dots
#[derive(Clone)]
pub struct SegmentDisplay4x7V2Bricklet {
    device: Device,
}
impl SegmentDisplay4x7V2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2137;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Segment Display 4x7 Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> SegmentDisplay4x7V2Bricklet {
        let mut result = SegmentDisplay4x7V2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetSegments) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetSegments) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetBrightness) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetBrightness) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetNumericValue) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetSelectedSegment) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetSelectedSegment) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::StartCounter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetCounterValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(SegmentDisplay4x7V2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::segment_display_4x7_v2_bricklet::SegmentDisplay4x7V2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::segment_display_4x7_v2_bricklet::SegmentDisplay4x7V2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: SegmentDisplay4x7V2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: SegmentDisplay4x7V2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the counter (see [`start_counter`]) is
    /// finished.
    ///
    /// [`start_counter`]: #method.start_counter
    pub fn get_counter_finished_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(SegmentDisplay4x7V2BrickletFunction::CallbackCounterFinished))
    }

    /// Sets the segments of the Segment Display 4x7 Bricklet 2.0 segment-by-segment.
    ///
    /// The data is split into the four digits, two colon dots and the tick mark.
    ///
    /// The indices of the segments in the digit and colon parameters are as follows:
    ///
    /// .. image:: /Images/Bricklets/bricklet_segment_display_4x7_v2_segment_index.png
    ///    :scale: 100 %
    ///    :alt: Indices of segments
    ///    :align: center
    pub fn set_segments(
        &self,
        digit0: [bool; 8],
        digit1: [bool; 8],
        digit2: [bool; 8],
        digit3: [bool; 8],
        colon: [bool; 2],
        tick: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<[bool; 8]>::to_le_byte_vec(digit0));
        payload[1..2].copy_from_slice(&<[bool; 8]>::to_le_byte_vec(digit1));
        payload[2..3].copy_from_slice(&<[bool; 8]>::to_le_byte_vec(digit2));
        payload[3..4].copy_from_slice(&<[bool; 8]>::to_le_byte_vec(digit3));
        payload[4..5].copy_from_slice(&<[bool; 2]>::to_le_byte_vec(colon));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(tick));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetSegments), payload)
    }

    /// Returns the segment data as set by [`set_segments`].
    pub fn get_segments(&self) -> ConvertingReceiver<Segments> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetSegments), payload)
    }

    /// The brightness can be set between 0 (dark) and 7 (bright).
    pub fn set_brightness(&self, brightness: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(brightness));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetBrightness), payload)
    }

    /// Returns the brightness as set by [`set_brightness`].
    pub fn get_brightness(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetBrightness), payload)
    }

    /// Sets a numeric value for each of the digits. They represent:
    ///
    /// * -2: minus sign
    /// * -1: blank
    /// * 0-9: 0-9
    /// * 10: A
    /// * 11: b
    /// * 12: C
    /// * 13: d
    /// * 14: E
    /// * 15: F
    ///
    /// Example: A call with [-2, -1, 4, 2] will result in a display of - 42.
    pub fn set_numeric_value(&self, value: [i8; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<[i8; 4]>::to_le_byte_vec(value));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetNumericValue), payload)
    }

    /// Turns one specified segment on or off.
    ///
    /// The indices of the segments are as follows:
    ///
    /// .. image:: /Images/Bricklets/bricklet_segment_display_4x7_v2_selected_segment_index.png
    ///    :scale: 100 %
    ///    :alt: Indices of selected segments
    ///    :align: center
    pub fn set_selected_segment(&self, segment: u8, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(segment));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetSelectedSegment), payload)
    }

    /// Returns the value of a single segment.
    pub fn get_selected_segment(&self, segment: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(segment));

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetSelectedSegment), payload)
    }

    /// Starts a counter with the *from* value that counts to the *to*
    /// value with the each step incremented by *increment*.
    /// *length* is the pause between each increment.
    ///
    /// Example: If you set *from* to 0, *to* to 100, *increment* to 1 and
    /// *length* to 1000, a counter that goes from 0 to 100 with one second
    /// pause between each increment will be started.
    ///
    /// Using a negative *increment* allows to count backwards.
    ///
    /// You can stop the counter at every time by calling [`set_segments`]
    /// or [`set_numeric_value`].
    pub fn start_counter(&self, value_from: i16, value_to: i16, increment: i16, length: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(value_from));
        payload[2..4].copy_from_slice(&<i16>::to_le_byte_vec(value_to));
        payload[4..6].copy_from_slice(&<i16>::to_le_byte_vec(increment));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(length));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::StartCounter), payload)
    }

    /// Returns the counter value that is currently shown on the display.
    ///
    /// If there is no counter running a 0 will be returned.
    pub fn get_counter_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetCounterValue), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* SEGMENT_DISPLAY_4X7_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(SegmentDisplay4x7V2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(SegmentDisplay4x7V2BrickletFunction::GetIdentity), payload)
    }
}
