/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Communicates with RS232 devices.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RS232V2_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_high_level_callback_receiver::ConvertingHighLevelCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum Rs232V2BrickletFunction {
    WriteLowLevel,
    ReadLowLevel,
    EnableReadCallback,
    DisableReadCallback,
    IsReadCallbackEnabled,
    SetConfiguration,
    GetConfiguration,
    SetBufferConfig,
    GetBufferConfig,
    GetBufferStatus,
    GetErrorCount,
    SetFrameReadableCallbackConfiguration,
    GetFrameReadableCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackReadLowLevel,
    CallbackErrorCount,
    CallbackFrameReadable,
}
impl From<Rs232V2BrickletFunction> for u8 {
    fn from(fun: Rs232V2BrickletFunction) -> Self {
        match fun {
            Rs232V2BrickletFunction::WriteLowLevel => 1,
            Rs232V2BrickletFunction::ReadLowLevel => 2,
            Rs232V2BrickletFunction::EnableReadCallback => 3,
            Rs232V2BrickletFunction::DisableReadCallback => 4,
            Rs232V2BrickletFunction::IsReadCallbackEnabled => 5,
            Rs232V2BrickletFunction::SetConfiguration => 6,
            Rs232V2BrickletFunction::GetConfiguration => 7,
            Rs232V2BrickletFunction::SetBufferConfig => 8,
            Rs232V2BrickletFunction::GetBufferConfig => 9,
            Rs232V2BrickletFunction::GetBufferStatus => 10,
            Rs232V2BrickletFunction::GetErrorCount => 11,
            Rs232V2BrickletFunction::SetFrameReadableCallbackConfiguration => 14,
            Rs232V2BrickletFunction::GetFrameReadableCallbackConfiguration => 15,
            Rs232V2BrickletFunction::GetSpitfpErrorCount => 234,
            Rs232V2BrickletFunction::SetBootloaderMode => 235,
            Rs232V2BrickletFunction::GetBootloaderMode => 236,
            Rs232V2BrickletFunction::SetWriteFirmwarePointer => 237,
            Rs232V2BrickletFunction::WriteFirmware => 238,
            Rs232V2BrickletFunction::SetStatusLedConfig => 239,
            Rs232V2BrickletFunction::GetStatusLedConfig => 240,
            Rs232V2BrickletFunction::GetChipTemperature => 242,
            Rs232V2BrickletFunction::Reset => 243,
            Rs232V2BrickletFunction::WriteUid => 248,
            Rs232V2BrickletFunction::ReadUid => 249,
            Rs232V2BrickletFunction::GetIdentity => 255,
            Rs232V2BrickletFunction::CallbackReadLowLevel => 12,
            Rs232V2BrickletFunction::CallbackErrorCount => 13,
            Rs232V2BrickletFunction::CallbackFrameReadable => 16,
        }
    }
}
pub const RS232_V2_BRICKLET_PARITY_NONE: u8 = 0;
pub const RS232_V2_BRICKLET_PARITY_ODD: u8 = 1;
pub const RS232_V2_BRICKLET_PARITY_EVEN: u8 = 2;
pub const RS232_V2_BRICKLET_STOPBITS_1: u8 = 1;
pub const RS232_V2_BRICKLET_STOPBITS_2: u8 = 2;
pub const RS232_V2_BRICKLET_WORDLENGTH_5: u8 = 5;
pub const RS232_V2_BRICKLET_WORDLENGTH_6: u8 = 6;
pub const RS232_V2_BRICKLET_WORDLENGTH_7: u8 = 7;
pub const RS232_V2_BRICKLET_WORDLENGTH_8: u8 = 8;
pub const RS232_V2_BRICKLET_FLOWCONTROL_OFF: u8 = 0;
pub const RS232_V2_BRICKLET_FLOWCONTROL_SOFTWARE: u8 = 1;
pub const RS232_V2_BRICKLET_FLOWCONTROL_HARDWARE: u8 = 2;
pub const RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const RS232_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const RS232_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const RS232_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteLowLevel {
    pub message_chunk_written: u8,
}
impl FromByteSlice for WriteLowLevel {
    fn bytes_expected() -> usize { 1 }
    fn from_le_byte_slice(bytes: &[u8]) -> WriteLowLevel { WriteLowLevel { message_chunk_written: <u8>::from_le_byte_slice(&bytes[0..1]) } }
}
impl LowLevelWrite<WriteResult> for WriteLowLevel {
    fn ll_message_written(&self) -> usize { self.message_chunk_written as usize }

    fn get_result(&self) -> WriteResult { WriteResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadLowLevel {
    pub message_length: u16,
    pub message_chunk_offset: u16,
    pub message_chunk_data: [char; 60],
}
impl FromByteSlice for ReadLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadLowLevel {
        ReadLowLevel {
            message_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            message_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            message_chunk_data: <[char; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<char, ReadResult> for ReadLowLevel {
    fn ll_message_length(&self) -> usize { self.message_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.message_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[char] { &self.message_chunk_data }

    fn get_result(&self) -> ReadResult { ReadResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub baudrate: u32,
    pub parity: u8,
    pub stopbits: u8,
    pub wordlength: u8,
    pub flowcontrol: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            baudrate: <u32>::from_le_byte_slice(&bytes[0..4]),
            parity: <u8>::from_le_byte_slice(&bytes[4..5]),
            stopbits: <u8>::from_le_byte_slice(&bytes[5..6]),
            wordlength: <u8>::from_le_byte_slice(&bytes[6..7]),
            flowcontrol: <u8>::from_le_byte_slice(&bytes[7..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BufferConfig {
    pub send_buffer_size: u16,
    pub receive_buffer_size: u16,
}
impl FromByteSlice for BufferConfig {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> BufferConfig {
        BufferConfig {
            send_buffer_size: <u16>::from_le_byte_slice(&bytes[0..2]),
            receive_buffer_size: <u16>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct BufferStatus {
    pub send_buffer_used: u16,
    pub receive_buffer_used: u16,
}
impl FromByteSlice for BufferStatus {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> BufferStatus {
        BufferStatus {
            send_buffer_used: <u16>::from_le_byte_slice(&bytes[0..2]),
            receive_buffer_used: <u16>::from_le_byte_slice(&bytes[2..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorCount {
    pub error_count_overrun: u32,
    pub error_count_parity: u32,
}
impl FromByteSlice for ErrorCount {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorCount {
        ErrorCount {
            error_count_overrun: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_parity: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ReadLowLevelEvent {
    pub message_length: u16,
    pub message_chunk_offset: u16,
    pub message_chunk_data: [char; 60],
}
impl FromByteSlice for ReadLowLevelEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadLowLevelEvent {
        ReadLowLevelEvent {
            message_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            message_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            message_chunk_data: <[char; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<char, ReadResult> for ReadLowLevelEvent {
    fn ll_message_length(&self) -> usize { self.message_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.message_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[char] { &self.message_chunk_data }

    fn get_result(&self) -> ReadResult { ReadResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorCountEvent {
    pub error_count_overrun: u32,
    pub error_count_parity: u32,
}
impl FromByteSlice for ErrorCountEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorCountEvent {
        ErrorCountEvent {
            error_count_overrun: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_parity: <u32>::from_le_byte_slice(&bytes[4..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadResult {}

/// Communicates with RS232 devices
#[derive(Clone)]
pub struct Rs232V2Bricklet {
    device: Device,
}
impl Rs232V2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2108;
    pub const DEVICE_DISPLAY_NAME: &'static str = "RS232 Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Rs232V2Bricklet {
        let mut result = Rs232V2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 3) };
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::WriteLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::ReadLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::EnableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::DisableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::IsReadCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetBufferConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetBufferConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetBufferStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232V2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rs232_v2_bricklet::Rs232V2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rs232_v2_bricklet::Rs232V2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Rs232V2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Rs232V2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// See [`get_read_callback_receiver`](crate::rs232_v2::RS232V2::get_read_callback_receiver)
    pub fn get_read_low_level_callback_receiver(&self) -> ConvertingCallbackReceiver<ReadLowLevelEvent> {
        self.device.get_callback_receiver(u8::from(Rs232V2BrickletFunction::CallbackReadLowLevel))
    }

    /// This receiver is called if new data is available.
    ///
    /// To enable this receiver, use [`enable_read_callback`].
    ///
    /// [`enable_read_callback`]: #method.enable_read_callback
    pub fn get_read_callback_receiver(&self) -> ConvertingHighLevelCallbackReceiver<char, ReadResult, ReadLowLevelEvent> {
        ConvertingHighLevelCallbackReceiver::new(self.device.get_callback_receiver(u8::from(Rs232V2BrickletFunction::CallbackReadLowLevel)))
    }

    /// This receiver is called if a new error occurs. It returns
    /// the current overrun and parity error count.
    pub fn get_error_count_callback_receiver(&self) -> ConvertingCallbackReceiver<ErrorCountEvent> {
        self.device.get_callback_receiver(u8::from(Rs232V2BrickletFunction::CallbackErrorCount))
    }

    /// This receiver is called if at least one frame of data is readable. The frame size is configured with [`set_frame_readable_callback_configuration`].
    /// The frame count parameter is the number of frames that can be read.
    /// This receiver is triggered only once until [`read`] is called. This means, that if you have configured a frame size of X bytes,
    /// you can read exactly X bytes using the [`read`] function, every time the receiver triggers without checking the frame count parameter.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_frame_readable_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(Rs232V2BrickletFunction::CallbackFrameReadable))
    }

    /// Writes characters to the RS232 interface. The characters can be binary data,
    /// ASCII or similar is not necessary.
    ///
    /// The return value is the number of characters that were written.
    ///
    /// See [`set_configuration`] for configuration possibilities
    /// regarding baud rate, parity and so on.
    pub fn write_low_level(
        &self,
        message_length: u16,
        message_chunk_offset: u16,
        message_chunk_data: [char; 60],
    ) -> ConvertingReceiver<WriteLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(message_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(message_chunk_offset));
        payload[4..64].copy_from_slice(&<[char; 60]>::to_le_byte_vec(message_chunk_data));

        self.device.get(u8::from(Rs232V2BrickletFunction::WriteLowLevel), payload)
    }

    /// Writes characters to the RS232 interface. The characters can be binary data,
    /// ASCII or similar is not necessary.
    ///
    /// The return value is the number of characters that were written.
    ///
    /// See [`set_configuration`] for configuration possibilities
    /// regarding baud rate, parity and so on.
    pub fn write(&self, message: &[char]) -> Result<usize, BrickletRecvTimeoutError> {
        let ll_result = self.device.set_high_level(0, message, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[char]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<char>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            self.write_low_level(length as u16, chunk_offset as u16, chunk_array).recv()
        })?;
        Ok(ll_result.0)
    }

    /// Returns up to *length* characters from receive buffer.
    ///
    /// Instead of polling with this function, you can also use
    /// callbacks. But note that this function will return available
    /// data only when the read receiver is disabled.
    /// See [`enable_read_callback`] and [`get_read_callback_receiver`] receiver.
    pub fn read_low_level(&self, length: u16) -> ConvertingReceiver<ReadLowLevel> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(length));

        self.device.get(u8::from(Rs232V2BrickletFunction::ReadLowLevel), payload)
    }

    /// Returns up to *length* characters from receive buffer.
    ///
    /// Instead of polling with this function, you can also use
    /// callbacks. But note that this function will return available
    /// data only when the read receiver is disabled.
    /// See [`enable_read_callback`] and [`get_read_callback_receiver`] receiver.
    pub fn read(&self, length: u16) -> Result<Vec<char>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_low_level(length).recv())?;
        Ok(ll_result.0)
    }

    /// Enables the [`get_read_callback_receiver`] receiver. This will disable the [`get_frame_readable_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn enable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs232V2BrickletFunction::EnableReadCallback), payload)
    }

    /// Disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn disable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs232V2BrickletFunction::DisableReadCallback), payload)
    }

    /// Returns *true* if the [`get_read_callback_receiver`] receiver is enabled,
    /// *false* otherwise.
    pub fn is_read_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::IsReadCallbackEnabled), payload)
    }

    /// Sets the configuration for the RS232 communication.
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_PARITY_NONE
    ///	* RS232_V2_BRICKLET_PARITY_ODD
    ///	* RS232_V2_BRICKLET_PARITY_EVEN
    ///	* RS232_V2_BRICKLET_STOPBITS_1
    ///	* RS232_V2_BRICKLET_STOPBITS_2
    ///	* RS232_V2_BRICKLET_WORDLENGTH_5
    ///	* RS232_V2_BRICKLET_WORDLENGTH_6
    ///	* RS232_V2_BRICKLET_WORDLENGTH_7
    ///	* RS232_V2_BRICKLET_WORDLENGTH_8
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_OFF
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_SOFTWARE
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_HARDWARE
    pub fn set_configuration(&self, baudrate: u32, parity: u8, stopbits: u8, wordlength: u8, flowcontrol: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 8];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(parity));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(stopbits));
        payload[6..7].copy_from_slice(&<u8>::to_le_byte_vec(wordlength));
        payload[7..8].copy_from_slice(&<u8>::to_le_byte_vec(flowcontrol));

        self.device.set(u8::from(Rs232V2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_PARITY_NONE
    ///	* RS232_V2_BRICKLET_PARITY_ODD
    ///	* RS232_V2_BRICKLET_PARITY_EVEN
    ///	* RS232_V2_BRICKLET_STOPBITS_1
    ///	* RS232_V2_BRICKLET_STOPBITS_2
    ///	* RS232_V2_BRICKLET_WORDLENGTH_5
    ///	* RS232_V2_BRICKLET_WORDLENGTH_6
    ///	* RS232_V2_BRICKLET_WORDLENGTH_7
    ///	* RS232_V2_BRICKLET_WORDLENGTH_8
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_OFF
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_SOFTWARE
    ///	* RS232_V2_BRICKLET_FLOWCONTROL_HARDWARE
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetConfiguration), payload)
    }

    /// Sets the send and receive buffer size in byte. In total the buffers have to be
    /// 10240 byte (10KiB) in size, the minimum buffer size is 1024 byte (1KiB) for each.
    ///
    /// The current buffer content is lost if this function is called.
    ///
    /// The send buffer holds data that is given by [`write`] and
    /// can not be written yet. The receive buffer holds data that is
    /// received through RS232 but could not yet be send to the
    /// user, either by [`read`] or through [`get_read_callback_receiver`] receiver.
    pub fn set_buffer_config(&self, send_buffer_size: u16, receive_buffer_size: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(send_buffer_size));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(receive_buffer_size));

        self.device.set(u8::from(Rs232V2BrickletFunction::SetBufferConfig), payload)
    }

    /// Returns the buffer configuration as set by [`set_buffer_config`].
    pub fn get_buffer_config(&self) -> ConvertingReceiver<BufferConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetBufferConfig), payload)
    }

    /// Returns the currently used bytes for the send and received buffer.
    ///
    /// See [`set_buffer_config`] for buffer size configuration.
    pub fn get_buffer_status(&self) -> ConvertingReceiver<BufferStatus> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetBufferStatus), payload)
    }

    /// Returns the current number of overrun and parity errors.
    pub fn get_error_count(&self) -> ConvertingReceiver<ErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetErrorCount), payload)
    }

    /// Configures the [`get_frame_readable_callback_receiver`] receiver. The frame size is the number of bytes, that have to be readable to trigger the receiver.
    /// A frame size of 0 disables the receiver. A frame size greater than 0 enables the receiver and disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn set_frame_readable_callback_configuration(&self, frame_size: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frame_size));

        self.device.set(u8::from(Rs232V2BrickletFunction::SetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_frame_readable_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_frame_readable_callback_configuration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(Rs232V2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RS232_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(Rs232V2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(Rs232V2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Rs232V2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * RS232_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RS232_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs232V2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(Rs232V2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232V2BrickletFunction::GetIdentity), payload)
    }
}
