/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Communicates with RS232 devices.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RS232_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum Rs232BrickletFunction {
    Write,
    Read,
    EnableReadCallback,
    DisableReadCallback,
    IsReadCallbackEnabled,
    SetConfiguration,
    GetConfiguration,
    SetBreakCondition,
    SetFrameReadableCallbackConfiguration,
    GetFrameReadableCallbackConfiguration,
    ReadFrame,
    GetIdentity,
    CallbackRead,
    CallbackError,
    CallbackFrameReadable,
}
impl From<Rs232BrickletFunction> for u8 {
    fn from(fun: Rs232BrickletFunction) -> Self {
        match fun {
            Rs232BrickletFunction::Write => 1,
            Rs232BrickletFunction::Read => 2,
            Rs232BrickletFunction::EnableReadCallback => 3,
            Rs232BrickletFunction::DisableReadCallback => 4,
            Rs232BrickletFunction::IsReadCallbackEnabled => 5,
            Rs232BrickletFunction::SetConfiguration => 6,
            Rs232BrickletFunction::GetConfiguration => 7,
            Rs232BrickletFunction::SetBreakCondition => 10,
            Rs232BrickletFunction::SetFrameReadableCallbackConfiguration => 11,
            Rs232BrickletFunction::GetFrameReadableCallbackConfiguration => 12,
            Rs232BrickletFunction::ReadFrame => 14,
            Rs232BrickletFunction::GetIdentity => 255,
            Rs232BrickletFunction::CallbackRead => 8,
            Rs232BrickletFunction::CallbackError => 9,
            Rs232BrickletFunction::CallbackFrameReadable => 13,
        }
    }
}
pub const RS232_BRICKLET_BAUDRATE_300: u8 = 0;
pub const RS232_BRICKLET_BAUDRATE_600: u8 = 1;
pub const RS232_BRICKLET_BAUDRATE_1200: u8 = 2;
pub const RS232_BRICKLET_BAUDRATE_2400: u8 = 3;
pub const RS232_BRICKLET_BAUDRATE_4800: u8 = 4;
pub const RS232_BRICKLET_BAUDRATE_9600: u8 = 5;
pub const RS232_BRICKLET_BAUDRATE_14400: u8 = 6;
pub const RS232_BRICKLET_BAUDRATE_19200: u8 = 7;
pub const RS232_BRICKLET_BAUDRATE_28800: u8 = 8;
pub const RS232_BRICKLET_BAUDRATE_38400: u8 = 9;
pub const RS232_BRICKLET_BAUDRATE_57600: u8 = 10;
pub const RS232_BRICKLET_BAUDRATE_115200: u8 = 11;
pub const RS232_BRICKLET_BAUDRATE_230400: u8 = 12;
pub const RS232_BRICKLET_PARITY_NONE: u8 = 0;
pub const RS232_BRICKLET_PARITY_ODD: u8 = 1;
pub const RS232_BRICKLET_PARITY_EVEN: u8 = 2;
pub const RS232_BRICKLET_PARITY_FORCED_PARITY_1: u8 = 3;
pub const RS232_BRICKLET_PARITY_FORCED_PARITY_0: u8 = 4;
pub const RS232_BRICKLET_STOPBITS_1: u8 = 1;
pub const RS232_BRICKLET_STOPBITS_2: u8 = 2;
pub const RS232_BRICKLET_WORDLENGTH_5: u8 = 5;
pub const RS232_BRICKLET_WORDLENGTH_6: u8 = 6;
pub const RS232_BRICKLET_WORDLENGTH_7: u8 = 7;
pub const RS232_BRICKLET_WORDLENGTH_8: u8 = 8;
pub const RS232_BRICKLET_HARDWARE_FLOWCONTROL_OFF: u8 = 0;
pub const RS232_BRICKLET_HARDWARE_FLOWCONTROL_ON: u8 = 1;
pub const RS232_BRICKLET_SOFTWARE_FLOWCONTROL_OFF: u8 = 0;
pub const RS232_BRICKLET_SOFTWARE_FLOWCONTROL_ON: u8 = 1;
pub const RS232_BRICKLET_ERROR_OVERRUN: u8 = 1;
pub const RS232_BRICKLET_ERROR_PARITY: u8 = 2;
pub const RS232_BRICKLET_ERROR_FRAMING: u8 = 4;

#[derive(Clone, Copy)]
pub struct Read {
    pub message: [char; 60],
    pub length: u8,
}
impl FromByteSlice for Read {
    fn bytes_expected() -> usize { 61 }
    fn from_le_byte_slice(bytes: &[u8]) -> Read {
        Read { message: <[char; 60]>::from_le_byte_slice(&bytes[0..60]), length: <u8>::from_le_byte_slice(&bytes[60..61]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub baudrate: u8,
    pub parity: u8,
    pub stopbits: u8,
    pub wordlength: u8,
    pub hardware_flowcontrol: u8,
    pub software_flowcontrol: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            baudrate: <u8>::from_le_byte_slice(&bytes[0..1]),
            parity: <u8>::from_le_byte_slice(&bytes[1..2]),
            stopbits: <u8>::from_le_byte_slice(&bytes[2..3]),
            wordlength: <u8>::from_le_byte_slice(&bytes[3..4]),
            hardware_flowcontrol: <u8>::from_le_byte_slice(&bytes[4..5]),
            software_flowcontrol: <u8>::from_le_byte_slice(&bytes[5..6]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ReadEvent {
    pub message: [char; 60],
    pub length: u8,
}
impl FromByteSlice for ReadEvent {
    fn bytes_expected() -> usize { 61 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadEvent {
        ReadEvent { message: <[char; 60]>::from_le_byte_slice(&bytes[0..60]), length: <u8>::from_le_byte_slice(&bytes[60..61]) }
    }
}

#[derive(Clone, Copy)]
pub struct ReadFrame {
    pub message: [char; 60],
    pub length: u8,
}
impl FromByteSlice for ReadFrame {
    fn bytes_expected() -> usize { 61 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFrame {
        ReadFrame { message: <[char; 60]>::from_le_byte_slice(&bytes[0..60]), length: <u8>::from_le_byte_slice(&bytes[60..61]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Communicates with RS232 devices
#[derive(Clone)]
pub struct Rs232Bricklet {
    device: Device,
}
impl Rs232Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 254;
    pub const DEVICE_DISPLAY_NAME: &'static str = "RS232 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Rs232Bricklet {
        let mut result = Rs232Bricklet { device: Device::new([2, 0, 3], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Rs232BrickletFunction::Write) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::Read) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::EnableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232BrickletFunction::DisableReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232BrickletFunction::IsReadCallbackEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232BrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::SetBreakCondition) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Rs232BrickletFunction::SetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Rs232BrickletFunction::GetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::ReadFrame) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Rs232BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rs232_bricklet::Rs232Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rs232_bricklet::Rs232Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Rs232BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Rs232BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called if new data is available. The message has
    /// a maximum size of 60 characters. The actual length of the message
    /// is given in addition.
    ///
    /// To enable this receiver, use [`enable_read_callback`].
    ///
    /// [`enable_read_callback`]: #method.enable_read_callback
    pub fn get_read_callback_receiver(&self) -> ConvertingCallbackReceiver<ReadEvent> {
        self.device.get_callback_receiver(u8::from(Rs232BrickletFunction::CallbackRead))
    }

    /// This receiver is called if an error occurs.
    /// Possible errors are overrun, parity or framing error.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_error_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(Rs232BrickletFunction::CallbackError))
    }

    /// This receiver is called if at least one frame of data is readable. The frame size is configured with [`set_frame_readable_callback_configuration`].
    /// The frame count parameter is the number of frames that can be read.
    /// This receiver is triggered only once until [`read`] or [`read_frame`] is called. This means, that if you have configured a frame size of X bytes,
    /// you can read exactly X bytes using the [`read_frame`] function, every time the receiver triggers without checking the frame count parameter.
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Plugin)
    pub fn get_frame_readable_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(Rs232BrickletFunction::CallbackFrameReadable))
    }

    /// Writes a string of up to 60 characters to the RS232 interface. The string
    /// can be binary data, ASCII or similar is not necessary.
    ///
    /// The length of the string has to be given as an additional parameter.
    ///
    /// The return value is the number of bytes that could be written.
    ///
    /// See [`set_configuration`] for configuration possibilities
    /// regarding baudrate, parity and so on.
    pub fn write(&self, message: [char; 60], length: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 61];
        payload[0..60].copy_from_slice(&<[char; 60]>::to_le_byte_vec(message));
        payload[60..61].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(Rs232BrickletFunction::Write), payload)
    }

    /// Returns the currently buffered message. The maximum length
    /// of message is 60. If the returned length is 0, no new data was available.
    ///
    /// Instead of polling with this function, you can also use
    /// callbacks. See [`enable_read_callback`] and [`get_read_callback_receiver`] receiver.
    pub fn read(&self) -> ConvertingReceiver<Read> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::Read), payload)
    }

    /// Enables the [`get_read_callback_receiver`] receiver. This will disable the [`get_frame_readable_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn enable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs232BrickletFunction::EnableReadCallback), payload)
    }

    /// Disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn disable_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Rs232BrickletFunction::DisableReadCallback), payload)
    }

    /// Returns *true* if the [`get_read_callback_receiver`] receiver is enabled,
    /// *false* otherwise.
    pub fn is_read_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::IsReadCallbackEnabled), payload)
    }

    /// Sets the configuration for the RS232 communication.
    ///
    /// Hard-/Software flow control can either be on or off but not both simultaneously on.
    ///
    /// Associated constants:
    /// * RS232_BRICKLET_BAUDRATE_300
    ///	* RS232_BRICKLET_BAUDRATE_600
    ///	* RS232_BRICKLET_BAUDRATE_1200
    ///	* RS232_BRICKLET_BAUDRATE_2400
    ///	* RS232_BRICKLET_BAUDRATE_4800
    ///	* RS232_BRICKLET_BAUDRATE_9600
    ///	* RS232_BRICKLET_BAUDRATE_14400
    ///	* RS232_BRICKLET_BAUDRATE_19200
    ///	* RS232_BRICKLET_BAUDRATE_28800
    ///	* RS232_BRICKLET_BAUDRATE_38400
    ///	* RS232_BRICKLET_BAUDRATE_57600
    ///	* RS232_BRICKLET_BAUDRATE_115200
    ///	* RS232_BRICKLET_BAUDRATE_230400
    ///	* RS232_BRICKLET_PARITY_NONE
    ///	* RS232_BRICKLET_PARITY_ODD
    ///	* RS232_BRICKLET_PARITY_EVEN
    ///	* RS232_BRICKLET_PARITY_FORCED_PARITY_1
    ///	* RS232_BRICKLET_PARITY_FORCED_PARITY_0
    ///	* RS232_BRICKLET_STOPBITS_1
    ///	* RS232_BRICKLET_STOPBITS_2
    ///	* RS232_BRICKLET_WORDLENGTH_5
    ///	* RS232_BRICKLET_WORDLENGTH_6
    ///	* RS232_BRICKLET_WORDLENGTH_7
    ///	* RS232_BRICKLET_WORDLENGTH_8
    ///	* RS232_BRICKLET_HARDWARE_FLOWCONTROL_OFF
    ///	* RS232_BRICKLET_HARDWARE_FLOWCONTROL_ON
    ///	* RS232_BRICKLET_SOFTWARE_FLOWCONTROL_OFF
    ///	* RS232_BRICKLET_SOFTWARE_FLOWCONTROL_ON
    pub fn set_configuration(
        &self,
        baudrate: u8,
        parity: u8,
        stopbits: u8,
        wordlength: u8,
        hardware_flowcontrol: u8,
        software_flowcontrol: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(baudrate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(parity));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(stopbits));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(wordlength));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(hardware_flowcontrol));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(software_flowcontrol));

        self.device.set(u8::from(Rs232BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * RS232_BRICKLET_BAUDRATE_300
    ///	* RS232_BRICKLET_BAUDRATE_600
    ///	* RS232_BRICKLET_BAUDRATE_1200
    ///	* RS232_BRICKLET_BAUDRATE_2400
    ///	* RS232_BRICKLET_BAUDRATE_4800
    ///	* RS232_BRICKLET_BAUDRATE_9600
    ///	* RS232_BRICKLET_BAUDRATE_14400
    ///	* RS232_BRICKLET_BAUDRATE_19200
    ///	* RS232_BRICKLET_BAUDRATE_28800
    ///	* RS232_BRICKLET_BAUDRATE_38400
    ///	* RS232_BRICKLET_BAUDRATE_57600
    ///	* RS232_BRICKLET_BAUDRATE_115200
    ///	* RS232_BRICKLET_BAUDRATE_230400
    ///	* RS232_BRICKLET_PARITY_NONE
    ///	* RS232_BRICKLET_PARITY_ODD
    ///	* RS232_BRICKLET_PARITY_EVEN
    ///	* RS232_BRICKLET_PARITY_FORCED_PARITY_1
    ///	* RS232_BRICKLET_PARITY_FORCED_PARITY_0
    ///	* RS232_BRICKLET_STOPBITS_1
    ///	* RS232_BRICKLET_STOPBITS_2
    ///	* RS232_BRICKLET_WORDLENGTH_5
    ///	* RS232_BRICKLET_WORDLENGTH_6
    ///	* RS232_BRICKLET_WORDLENGTH_7
    ///	* RS232_BRICKLET_WORDLENGTH_8
    ///	* RS232_BRICKLET_HARDWARE_FLOWCONTROL_OFF
    ///	* RS232_BRICKLET_HARDWARE_FLOWCONTROL_ON
    ///	* RS232_BRICKLET_SOFTWARE_FLOWCONTROL_OFF
    ///	* RS232_BRICKLET_SOFTWARE_FLOWCONTROL_ON
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::GetConfiguration), payload)
    }

    /// Sets a break condition (the TX output is forced to a logic 0 state).
    /// The parameter sets the hold-time of the break condition.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_break_condition(&self, break_time: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(break_time));

        self.device.set(u8::from(Rs232BrickletFunction::SetBreakCondition), payload)
    }

    /// Configures the [`get_frame_readable_callback_receiver`] receiver. The frame size is the number of bytes, that have to be readable to trigger the receiver.
    /// A frame size of 0 disables the receiver. A frame size greater than 0 enables the receiver and disables the [`get_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Plugin)
    pub fn set_frame_readable_callback_configuration(&self, frame_size: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(frame_size));

        self.device.set(u8::from(Rs232BrickletFunction::SetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_frame_readable_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Plugin)
    pub fn get_frame_readable_callback_configuration(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::GetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns up to one frame of bytes from the read buffer.
    /// The frame size is configured with [`set_frame_readable_callback_configuration`].
    /// If the returned length is 0, no new data was available.
    ///
    ///
    /// .. versionadded:: 2.0.4$nbsp;(Plugin)
    pub fn read_frame(&self) -> ConvertingReceiver<ReadFrame> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::ReadFrame), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Rs232BrickletFunction::GetIdentity), payload)
    }
}
