/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 360° rotary encoder with push-button.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RotaryEncoder_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RotaryEncoderBrickletFunction {
    GetCount,
    SetCountCallbackPeriod,
    GetCountCallbackPeriod,
    SetCountCallbackThreshold,
    GetCountCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    IsPressed,
    GetIdentity,
    CallbackCount,
    CallbackCountReached,
    CallbackPressed,
    CallbackReleased,
}
impl From<RotaryEncoderBrickletFunction> for u8 {
    fn from(fun: RotaryEncoderBrickletFunction) -> Self {
        match fun {
            RotaryEncoderBrickletFunction::GetCount => 1,
            RotaryEncoderBrickletFunction::SetCountCallbackPeriod => 2,
            RotaryEncoderBrickletFunction::GetCountCallbackPeriod => 3,
            RotaryEncoderBrickletFunction::SetCountCallbackThreshold => 4,
            RotaryEncoderBrickletFunction::GetCountCallbackThreshold => 5,
            RotaryEncoderBrickletFunction::SetDebouncePeriod => 6,
            RotaryEncoderBrickletFunction::GetDebouncePeriod => 7,
            RotaryEncoderBrickletFunction::IsPressed => 10,
            RotaryEncoderBrickletFunction::GetIdentity => 255,
            RotaryEncoderBrickletFunction::CallbackCount => 8,
            RotaryEncoderBrickletFunction::CallbackCountReached => 9,
            RotaryEncoderBrickletFunction::CallbackPressed => 11,
            RotaryEncoderBrickletFunction::CallbackReleased => 12,
        }
    }
}
pub const ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CountCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CountCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> CountCallbackThreshold {
        CountCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 360° rotary encoder with push-button
#[derive(Clone)]
pub struct RotaryEncoderBricklet {
    device: Device,
}
impl RotaryEncoderBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 236;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Rotary Encoder Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RotaryEncoderBricklet {
        let mut result = RotaryEncoderBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::GetCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::SetCountCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::GetCountCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::SetCountCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::GetCountCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::IsPressed) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RotaryEncoderBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rotary_encoder_bricklet::RotaryEncoderBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rotary_encoder_bricklet::RotaryEncoderBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RotaryEncoderBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RotaryEncoderBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_count_callback_period`]. The parameter is the count of
    /// the encoder.
    ///
    /// The [`get_count_callback_receiver`] receiver is only triggered if the count has changed since the
    /// last triggering.
    ///
    /// [`set_count_callback_period`]: #method.set_count_callback_period
    /// [`get_count_callback_receiver`]: #method.get_count_callback_receiver
    pub fn get_count_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderBrickletFunction::CallbackCount))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_count_callback_threshold`] is reached.
    /// The parameter is the count of the encoder.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_count_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderBrickletFunction::CallbackCountReached))
    }

    /// This receiver is triggered when the button is pressed.
    pub fn get_pressed_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderBrickletFunction::CallbackPressed))
    }

    /// This receiver is triggered when the button is released.
    pub fn get_released_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(RotaryEncoderBrickletFunction::CallbackReleased))
    }

    /// Returns the current count of the encoder. If you set reset
    /// to true, the count is set back to 0 directly after the
    /// current count is read.
    ///
    /// The encoder has 24 steps per rotation
    ///
    /// Turning the encoder to the left decrements the counter,
    /// so a negative count is possible.
    pub fn get_count(&self, reset: bool) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(reset));

        self.device.get(u8::from(RotaryEncoderBrickletFunction::GetCount), payload)
    }

    /// Sets the period with which the [`get_count_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_count_callback_receiver`] receiver is only triggered if the count has changed since the
    /// last triggering.
    pub fn set_count_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(RotaryEncoderBrickletFunction::SetCountCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_count_callback_period`].
    pub fn get_count_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderBrickletFunction::GetCountCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_count_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the count is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the count is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the count is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the count is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_count_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(RotaryEncoderBrickletFunction::SetCountCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_count_callback_threshold`].
    ///
    /// Associated constants:
    /// * ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ROTARY_ENCODER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_count_callback_threshold(&self) -> ConvertingReceiver<CountCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderBrickletFunction::GetCountCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_count_reached_callback_receiver`]
    ///
    /// is triggered, if the thresholds
    ///
    /// * [`set_count_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(RotaryEncoderBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns *true* if the button is pressed and *false* otherwise.
    ///
    /// It is recommended to use the [`get_pressed_callback_receiver`] and [`get_released_callback_receiver`] receivers
    /// to handle the button.
    pub fn is_pressed(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderBrickletFunction::IsPressed), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RotaryEncoderBrickletFunction::GetIdentity), payload)
    }
}
