/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Push button with built-in RGB LED.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/RGBLEDButton_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum RgbLedButtonBrickletFunction {
    SetColor,
    GetColor,
    GetButtonState,
    SetColorCalibration,
    GetColorCalibration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackButtonStateChanged,
}
impl From<RgbLedButtonBrickletFunction> for u8 {
    fn from(fun: RgbLedButtonBrickletFunction) -> Self {
        match fun {
            RgbLedButtonBrickletFunction::SetColor => 1,
            RgbLedButtonBrickletFunction::GetColor => 2,
            RgbLedButtonBrickletFunction::GetButtonState => 3,
            RgbLedButtonBrickletFunction::SetColorCalibration => 5,
            RgbLedButtonBrickletFunction::GetColorCalibration => 6,
            RgbLedButtonBrickletFunction::GetSpitfpErrorCount => 234,
            RgbLedButtonBrickletFunction::SetBootloaderMode => 235,
            RgbLedButtonBrickletFunction::GetBootloaderMode => 236,
            RgbLedButtonBrickletFunction::SetWriteFirmwarePointer => 237,
            RgbLedButtonBrickletFunction::WriteFirmware => 238,
            RgbLedButtonBrickletFunction::SetStatusLedConfig => 239,
            RgbLedButtonBrickletFunction::GetStatusLedConfig => 240,
            RgbLedButtonBrickletFunction::GetChipTemperature => 242,
            RgbLedButtonBrickletFunction::Reset => 243,
            RgbLedButtonBrickletFunction::WriteUid => 248,
            RgbLedButtonBrickletFunction::ReadUid => 249,
            RgbLedButtonBrickletFunction::GetIdentity => 255,
            RgbLedButtonBrickletFunction::CallbackButtonStateChanged => 4,
        }
    }
}
pub const RGB_LED_BUTTON_BRICKLET_BUTTON_STATE_PRESSED: u8 = 0;
pub const RGB_LED_BUTTON_BRICKLET_BUTTON_STATE_RELEASED: u8 = 1;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Color {
    pub red: u8,
    pub green: u8,
    pub blue: u8,
}
impl FromByteSlice for Color {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Color {
        Color {
            red: <u8>::from_le_byte_slice(&bytes[0..1]),
            green: <u8>::from_le_byte_slice(&bytes[1..2]),
            blue: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ColorCalibration {
    pub red: u8,
    pub green: u8,
    pub blue: u8,
}
impl FromByteSlice for ColorCalibration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> ColorCalibration {
        ColorCalibration {
            red: <u8>::from_le_byte_slice(&bytes[0..1]),
            green: <u8>::from_le_byte_slice(&bytes[1..2]),
            blue: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Push button with built-in RGB LED
#[derive(Clone)]
pub struct RgbLedButtonBricklet {
    device: Device,
}
impl RgbLedButtonBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 282;
    pub const DEVICE_DISPLAY_NAME: &'static str = "RGB LED Button Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RgbLedButtonBricklet {
        let mut result = RgbLedButtonBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::SetColor) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetColor) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetButtonState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::SetColorCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetColorCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RgbLedButtonBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::rgb_led_button_bricklet::RgbLedButtonBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::rgb_led_button_bricklet::RgbLedButtonBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RgbLedButtonBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: RgbLedButtonBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered every time the button state changes from pressed to
    /// released or from released to pressed.
    ///
    /// The parameter is the current state of the button.
    pub fn get_button_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(RgbLedButtonBrickletFunction::CallbackButtonStateChanged))
    }

    /// Sets the color of the LED.
    pub fn set_color(&self, red: u8, green: u8, blue: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(red));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(green));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(blue));

        self.device.set(u8::from(RgbLedButtonBrickletFunction::SetColor), payload)
    }

    /// Returns the LED color as set by [`set_color`].
    pub fn get_color(&self) -> ConvertingReceiver<Color> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetColor), payload)
    }

    /// Returns the current state of the button (either pressed or released).
    ///
    /// Associated constants:
    /// * RGB_LED_BUTTON_BRICKLET_BUTTON_STATE_PRESSED
    ///	* RGB_LED_BUTTON_BRICKLET_BUTTON_STATE_RELEASED
    pub fn get_button_state(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetButtonState), payload)
    }

    /// Sets a color calibration. Some colors appear brighter then others,
    /// so a calibration may be necessary for uniform colors.
    ///
    /// The calibration is saved in flash. You don't need to call this
    /// function on every startup.
    pub fn set_color_calibration(&self, red: u8, green: u8, blue: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(red));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(green));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(blue));

        self.device.set(u8::from(RgbLedButtonBrickletFunction::SetColorCalibration), payload)
    }

    /// Returns the color calibration as set by [`set_color_calibration`].
    pub fn get_color_calibration(&self) -> ConvertingReceiver<ColorCalibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetColorCalibration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(RgbLedButtonBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* RGB_LED_BUTTON_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(RgbLedButtonBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(RgbLedButtonBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(RgbLedButtonBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* RGB_LED_BUTTON_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(RgbLedButtonBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(RgbLedButtonBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RgbLedButtonBrickletFunction::GetIdentity), payload)
    }
}
