/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Executes user programs and controls other Bricks/Bricklets standalone.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/RED_Brick_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
};
pub enum RedBrickFunction {
    CreateSession,
    ExpireSession,
    ExpireSessionUnchecked,
    KeepSessionAlive,
    ReleaseObject,
    ReleaseObjectUnchecked,
    AllocateString,
    TruncateString,
    GetStringLength,
    SetStringChunk,
    GetStringChunk,
    AllocateList,
    GetListLength,
    GetListItem,
    AppendToList,
    RemoveFromList,
    OpenFile,
    CreatePipe,
    GetFileInfo,
    ReadFile,
    ReadFileAsync,
    AbortAsyncFileRead,
    WriteFile,
    WriteFileUnchecked,
    WriteFileAsync,
    SetFilePosition,
    GetFilePosition,
    SetFileEvents,
    GetFileEvents,
    OpenDirectory,
    GetDirectoryName,
    GetNextDirectoryEntry,
    RewindDirectory,
    CreateDirectory,
    GetProcesses,
    SpawnProcess,
    KillProcess,
    GetProcessCommand,
    GetProcessIdentity,
    GetProcessStdio,
    GetProcessState,
    GetPrograms,
    DefineProgram,
    PurgeProgram,
    GetProgramIdentifier,
    GetProgramRootDirectory,
    SetProgramCommand,
    GetProgramCommand,
    SetProgramStdioRedirection,
    GetProgramStdioRedirection,
    SetProgramSchedule,
    GetProgramSchedule,
    GetProgramSchedulerState,
    ContinueProgramSchedule,
    StartProgram,
    GetLastSpawnedProgramProcess,
    GetCustomProgramOptionNames,
    SetCustomProgramOptionValue,
    GetCustomProgramOptionValue,
    RemoveCustomProgramOption,
    GetIdentity,
    CallbackAsyncFileRead,
    CallbackAsyncFileWrite,
    CallbackFileEventsOccurred,
    CallbackProcessStateChanged,
    CallbackProgramSchedulerStateChanged,
    CallbackProgramProcessSpawned,
}
impl From<RedBrickFunction> for u8 {
    fn from(fun: RedBrickFunction) -> Self {
        match fun {
            RedBrickFunction::CreateSession => 1,
            RedBrickFunction::ExpireSession => 2,
            RedBrickFunction::ExpireSessionUnchecked => 3,
            RedBrickFunction::KeepSessionAlive => 4,
            RedBrickFunction::ReleaseObject => 5,
            RedBrickFunction::ReleaseObjectUnchecked => 6,
            RedBrickFunction::AllocateString => 7,
            RedBrickFunction::TruncateString => 8,
            RedBrickFunction::GetStringLength => 9,
            RedBrickFunction::SetStringChunk => 10,
            RedBrickFunction::GetStringChunk => 11,
            RedBrickFunction::AllocateList => 12,
            RedBrickFunction::GetListLength => 13,
            RedBrickFunction::GetListItem => 14,
            RedBrickFunction::AppendToList => 15,
            RedBrickFunction::RemoveFromList => 16,
            RedBrickFunction::OpenFile => 17,
            RedBrickFunction::CreatePipe => 18,
            RedBrickFunction::GetFileInfo => 19,
            RedBrickFunction::ReadFile => 20,
            RedBrickFunction::ReadFileAsync => 21,
            RedBrickFunction::AbortAsyncFileRead => 22,
            RedBrickFunction::WriteFile => 23,
            RedBrickFunction::WriteFileUnchecked => 24,
            RedBrickFunction::WriteFileAsync => 25,
            RedBrickFunction::SetFilePosition => 26,
            RedBrickFunction::GetFilePosition => 27,
            RedBrickFunction::SetFileEvents => 28,
            RedBrickFunction::GetFileEvents => 29,
            RedBrickFunction::OpenDirectory => 33,
            RedBrickFunction::GetDirectoryName => 34,
            RedBrickFunction::GetNextDirectoryEntry => 35,
            RedBrickFunction::RewindDirectory => 36,
            RedBrickFunction::CreateDirectory => 37,
            RedBrickFunction::GetProcesses => 38,
            RedBrickFunction::SpawnProcess => 39,
            RedBrickFunction::KillProcess => 40,
            RedBrickFunction::GetProcessCommand => 41,
            RedBrickFunction::GetProcessIdentity => 42,
            RedBrickFunction::GetProcessStdio => 43,
            RedBrickFunction::GetProcessState => 44,
            RedBrickFunction::GetPrograms => 46,
            RedBrickFunction::DefineProgram => 47,
            RedBrickFunction::PurgeProgram => 48,
            RedBrickFunction::GetProgramIdentifier => 49,
            RedBrickFunction::GetProgramRootDirectory => 50,
            RedBrickFunction::SetProgramCommand => 51,
            RedBrickFunction::GetProgramCommand => 52,
            RedBrickFunction::SetProgramStdioRedirection => 53,
            RedBrickFunction::GetProgramStdioRedirection => 54,
            RedBrickFunction::SetProgramSchedule => 55,
            RedBrickFunction::GetProgramSchedule => 56,
            RedBrickFunction::GetProgramSchedulerState => 57,
            RedBrickFunction::ContinueProgramSchedule => 58,
            RedBrickFunction::StartProgram => 59,
            RedBrickFunction::GetLastSpawnedProgramProcess => 60,
            RedBrickFunction::GetCustomProgramOptionNames => 61,
            RedBrickFunction::SetCustomProgramOptionValue => 62,
            RedBrickFunction::GetCustomProgramOptionValue => 63,
            RedBrickFunction::RemoveCustomProgramOption => 64,
            RedBrickFunction::GetIdentity => 255,
            RedBrickFunction::CallbackAsyncFileRead => 30,
            RedBrickFunction::CallbackAsyncFileWrite => 31,
            RedBrickFunction::CallbackFileEventsOccurred => 32,
            RedBrickFunction::CallbackProcessStateChanged => 45,
            RedBrickFunction::CallbackProgramSchedulerStateChanged => 65,
            RedBrickFunction::CallbackProgramProcessSpawned => 66,
        }
    }
}
pub const RED_BRICK_ERROR_CODE_SUCCESS: u8 = 0;
pub const RED_BRICK_ERROR_CODE_UNKNOWN_ERROR: u8 = 1;
pub const RED_BRICK_ERROR_CODE_INVALID_OPERATION: u8 = 2;
pub const RED_BRICK_ERROR_CODE_OPERATION_ABORTED: u8 = 3;
pub const RED_BRICK_ERROR_CODE_INTERNAL_ERROR: u8 = 4;
pub const RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID: u8 = 5;
pub const RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID: u8 = 6;
pub const RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID: u8 = 7;
pub const RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID: u8 = 8;
pub const RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED: u8 = 9;
pub const RED_BRICK_ERROR_CODE_NO_MORE_DATA: u8 = 10;
pub const RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE: u8 = 11;
pub const RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED: u8 = 12;
pub const RED_BRICK_ERROR_CODE_INVALID_PARAMETER: u8 = 128;
pub const RED_BRICK_ERROR_CODE_NO_FREE_MEMORY: u8 = 129;
pub const RED_BRICK_ERROR_CODE_NO_FREE_SPACE: u8 = 130;
pub const RED_BRICK_ERROR_CODE_ACCESS_DENIED: u8 = 121;
pub const RED_BRICK_ERROR_CODE_ALREADY_EXISTS: u8 = 132;
pub const RED_BRICK_ERROR_CODE_DOES_NOT_EXIST: u8 = 133;
pub const RED_BRICK_ERROR_CODE_INTERRUPTED: u8 = 134;
pub const RED_BRICK_ERROR_CODE_IS_DIRECTORY: u8 = 135;
pub const RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY: u8 = 136;
pub const RED_BRICK_ERROR_CODE_WOULD_BLOCK: u8 = 137;
pub const RED_BRICK_ERROR_CODE_OVERFLOW: u8 = 138;
pub const RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR: u8 = 139;
pub const RED_BRICK_ERROR_CODE_OUT_OF_RANGE: u8 = 140;
pub const RED_BRICK_ERROR_CODE_NAME_TOO_LONG: u8 = 141;
pub const RED_BRICK_ERROR_CODE_INVALID_SEEK: u8 = 142;
pub const RED_BRICK_ERROR_CODE_NOT_SUPPORTED: u8 = 143;
pub const RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES: u8 = 144;
pub const RED_BRICK_OBJECT_TYPE_STRING: u8 = 0;
pub const RED_BRICK_OBJECT_TYPE_LIST: u8 = 1;
pub const RED_BRICK_OBJECT_TYPE_FILE: u8 = 2;
pub const RED_BRICK_OBJECT_TYPE_DIRECTORY: u8 = 3;
pub const RED_BRICK_OBJECT_TYPE_PROCESS: u8 = 4;
pub const RED_BRICK_OBJECT_TYPE_PROGRAM: u8 = 5;
pub const RED_BRICK_FILE_FLAG_READ_ONLY: u32 = 1;
pub const RED_BRICK_FILE_FLAG_WRITE_ONLY: u32 = 2;
pub const RED_BRICK_FILE_FLAG_READ_WRITE: u32 = 4;
pub const RED_BRICK_FILE_FLAG_APPEND: u32 = 8;
pub const RED_BRICK_FILE_FLAG_CREATE: u32 = 16;
pub const RED_BRICK_FILE_FLAG_EXCLUSIVE: u32 = 32;
pub const RED_BRICK_FILE_FLAG_NON_BLOCKING: u32 = 64;
pub const RED_BRICK_FILE_FLAG_TRUNCATE: u32 = 128;
pub const RED_BRICK_FILE_FLAG_TEMPORARY: u32 = 256;
pub const RED_BRICK_FILE_FLAG_REPLACE: u32 = 512;
pub const RED_BRICK_FILE_PERMISSION_USER_ALL: u16 = 448;
pub const RED_BRICK_FILE_PERMISSION_USER_READ: u16 = 256;
pub const RED_BRICK_FILE_PERMISSION_USER_WRITE: u16 = 128;
pub const RED_BRICK_FILE_PERMISSION_USER_EXECUTE: u16 = 64;
pub const RED_BRICK_FILE_PERMISSION_GROUP_ALL: u16 = 56;
pub const RED_BRICK_FILE_PERMISSION_GROUP_READ: u16 = 32;
pub const RED_BRICK_FILE_PERMISSION_GROUP_WRITE: u16 = 16;
pub const RED_BRICK_FILE_PERMISSION_GROUP_EXECUTE: u16 = 8;
pub const RED_BRICK_FILE_PERMISSION_OTHERS_ALL: u16 = 7;
pub const RED_BRICK_FILE_PERMISSION_OTHERS_READ: u16 = 4;
pub const RED_BRICK_FILE_PERMISSION_OTHERS_WRITE: u16 = 2;
pub const RED_BRICK_FILE_PERMISSION_OTHERS_EXECUTE: u16 = 1;
pub const RED_BRICK_PIPE_FLAG_NON_BLOCKING_READ: u32 = 1;
pub const RED_BRICK_PIPE_FLAG_NON_BLOCKING_WRITE: u32 = 2;
pub const RED_BRICK_FILE_TYPE_UNKNOWN: u8 = 0;
pub const RED_BRICK_FILE_TYPE_REGULAR: u8 = 1;
pub const RED_BRICK_FILE_TYPE_DIRECTORY: u8 = 2;
pub const RED_BRICK_FILE_TYPE_CHARACTER: u8 = 3;
pub const RED_BRICK_FILE_TYPE_BLOCK: u8 = 4;
pub const RED_BRICK_FILE_TYPE_FIFO: u8 = 5;
pub const RED_BRICK_FILE_TYPE_SYMLINK: u8 = 6;
pub const RED_BRICK_FILE_TYPE_SOCKET: u8 = 7;
pub const RED_BRICK_FILE_TYPE_PIPE: u8 = 8;
pub const RED_BRICK_FILE_ORIGIN_BEGINNING: u8 = 0;
pub const RED_BRICK_FILE_ORIGIN_CURRENT: u8 = 1;
pub const RED_BRICK_FILE_ORIGIN_END: u8 = 2;
pub const RED_BRICK_FILE_EVENT_READABLE: u16 = 1;
pub const RED_BRICK_FILE_EVENT_WRITABLE: u16 = 2;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_UNKNOWN: u8 = 0;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_REGULAR: u8 = 1;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_DIRECTORY: u8 = 2;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_CHARACTER: u8 = 3;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_BLOCK: u8 = 4;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_FIFO: u8 = 5;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_SYMLINK: u8 = 6;
pub const RED_BRICK_DIRECTORY_ENTRY_TYPE_SOCKET: u8 = 7;
pub const RED_BRICK_DIRECTORY_FLAG_RECURSIVE: u32 = 1;
pub const RED_BRICK_DIRECTORY_FLAG_EXCLUSIVE: u32 = 2;
pub const RED_BRICK_PROCESS_SIGNAL_INTERRUPT: u8 = 2;
pub const RED_BRICK_PROCESS_SIGNAL_QUIT: u8 = 3;
pub const RED_BRICK_PROCESS_SIGNAL_ABORT: u8 = 6;
pub const RED_BRICK_PROCESS_SIGNAL_KILL: u8 = 9;
pub const RED_BRICK_PROCESS_SIGNAL_USER1: u8 = 10;
pub const RED_BRICK_PROCESS_SIGNAL_USER2: u8 = 12;
pub const RED_BRICK_PROCESS_SIGNAL_TERMINATE: u8 = 15;
pub const RED_BRICK_PROCESS_SIGNAL_CONTINUE: u8 = 18;
pub const RED_BRICK_PROCESS_SIGNAL_STOP: u8 = 19;
pub const RED_BRICK_PROCESS_STATE_UNKNOWN: u8 = 0;
pub const RED_BRICK_PROCESS_STATE_RUNNING: u8 = 1;
pub const RED_BRICK_PROCESS_STATE_ERROR: u8 = 2;
pub const RED_BRICK_PROCESS_STATE_EXITED: u8 = 3;
pub const RED_BRICK_PROCESS_STATE_KILLED: u8 = 4;
pub const RED_BRICK_PROCESS_STATE_STOPPED: u8 = 5;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_DEV_NULL: u8 = 0;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_PIPE: u8 = 1;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_FILE: u8 = 2;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_INDIVIDUAL_LOG: u8 = 3;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_CONTINUOUS_LOG: u8 = 4;
pub const RED_BRICK_PROGRAM_STDIO_REDIRECTION_STDOUT: u8 = 5;
pub const RED_BRICK_PROGRAM_START_MODE_NEVER: u8 = 0;
pub const RED_BRICK_PROGRAM_START_MODE_ALWAYS: u8 = 1;
pub const RED_BRICK_PROGRAM_START_MODE_INTERVAL: u8 = 2;
pub const RED_BRICK_PROGRAM_START_MODE_CRON: u8 = 3;
pub const RED_BRICK_PROGRAM_SCHEDULER_STATE_STOPPED: u8 = 0;
pub const RED_BRICK_PROGRAM_SCHEDULER_STATE_RUNNING: u8 = 1;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CreateSession {
    pub error_code: u8,
    pub session_id: u16,
}
impl FromByteSlice for CreateSession {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> CreateSession {
        CreateSession { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), session_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllocateString {
    pub error_code: u8,
    pub string_id: u16,
}
impl FromByteSlice for AllocateString {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllocateString {
        AllocateString { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), string_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StringLength {
    pub error_code: u8,
    pub length: u32,
}
impl FromByteSlice for StringLength {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> StringLength {
        StringLength { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), length: <u32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone)]
pub struct StringChunk {
    pub error_code: u8,
    pub buffer: String,
}
impl FromByteSlice for StringChunk {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> StringChunk {
        StringChunk { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), buffer: <String>::from_le_byte_slice(&bytes[1..64]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllocateList {
    pub error_code: u8,
    pub list_id: u16,
}
impl FromByteSlice for AllocateList {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllocateList {
        AllocateList { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), list_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ListLength {
    pub error_code: u8,
    pub length: u16,
}
impl FromByteSlice for ListLength {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> ListLength {
        ListLength { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), length: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ListItem {
    pub error_code: u8,
    pub item_object_id: u16,
    pub type_: u8,
}
impl FromByteSlice for ListItem {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> ListItem {
        ListItem {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            item_object_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            type_: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OpenFile {
    pub error_code: u8,
    pub file_id: u16,
}
impl FromByteSlice for OpenFile {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> OpenFile {
        OpenFile { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), file_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CreatePipe {
    pub error_code: u8,
    pub file_id: u16,
}
impl FromByteSlice for CreatePipe {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> CreatePipe {
        CreatePipe { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), file_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FileInfo {
    pub error_code: u8,
    pub type_: u8,
    pub name_string_id: u16,
    pub flags: u32,
    pub permissions: u16,
    pub uid: u32,
    pub gid: u32,
    pub length: u64,
    pub access_timestamp: u64,
    pub modification_timestamp: u64,
    pub status_change_timestamp: u64,
}
impl FromByteSlice for FileInfo {
    fn bytes_expected() -> usize { 50 }
    fn from_le_byte_slice(bytes: &[u8]) -> FileInfo {
        FileInfo {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            type_: <u8>::from_le_byte_slice(&bytes[1..2]),
            name_string_id: <u16>::from_le_byte_slice(&bytes[2..4]),
            flags: <u32>::from_le_byte_slice(&bytes[4..8]),
            permissions: <u16>::from_le_byte_slice(&bytes[8..10]),
            uid: <u32>::from_le_byte_slice(&bytes[10..14]),
            gid: <u32>::from_le_byte_slice(&bytes[14..18]),
            length: <u64>::from_le_byte_slice(&bytes[18..26]),
            access_timestamp: <u64>::from_le_byte_slice(&bytes[26..34]),
            modification_timestamp: <u64>::from_le_byte_slice(&bytes[34..42]),
            status_change_timestamp: <u64>::from_le_byte_slice(&bytes[42..50]),
        }
    }
}

#[derive(Clone, Copy)]
pub struct ReadFile {
    pub error_code: u8,
    pub buffer: [u8; 62],
    pub length_read: u8,
}
impl FromByteSlice for ReadFile {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFile {
        ReadFile {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            buffer: <[u8; 62]>::from_le_byte_slice(&bytes[1..63]),
            length_read: <u8>::from_le_byte_slice(&bytes[63..64]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WriteFile {
    pub error_code: u8,
    pub length_written: u8,
}
impl FromByteSlice for WriteFile {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> WriteFile {
        WriteFile { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), length_written: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetFilePosition {
    pub error_code: u8,
    pub position: u64,
}
impl FromByteSlice for SetFilePosition {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> SetFilePosition {
        SetFilePosition { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), position: <u64>::from_le_byte_slice(&bytes[1..9]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FilePosition {
    pub error_code: u8,
    pub position: u64,
}
impl FromByteSlice for FilePosition {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> FilePosition {
        FilePosition { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), position: <u64>::from_le_byte_slice(&bytes[1..9]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FileEvents {
    pub error_code: u8,
    pub events: u16,
}
impl FromByteSlice for FileEvents {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> FileEvents {
        FileEvents { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), events: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy)]
pub struct AsyncFileReadEvent {
    pub file_id: u16,
    pub error_code: u8,
    pub buffer: [u8; 60],
    pub length_read: u8,
}
impl FromByteSlice for AsyncFileReadEvent {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> AsyncFileReadEvent {
        AsyncFileReadEvent {
            file_id: <u16>::from_le_byte_slice(&bytes[0..2]),
            error_code: <u8>::from_le_byte_slice(&bytes[2..3]),
            buffer: <[u8; 60]>::from_le_byte_slice(&bytes[3..63]),
            length_read: <u8>::from_le_byte_slice(&bytes[63..64]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AsyncFileWriteEvent {
    pub file_id: u16,
    pub error_code: u8,
    pub length_written: u8,
}
impl FromByteSlice for AsyncFileWriteEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> AsyncFileWriteEvent {
        AsyncFileWriteEvent {
            file_id: <u16>::from_le_byte_slice(&bytes[0..2]),
            error_code: <u8>::from_le_byte_slice(&bytes[2..3]),
            length_written: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FileEventsOccurredEvent {
    pub file_id: u16,
    pub events: u16,
}
impl FromByteSlice for FileEventsOccurredEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> FileEventsOccurredEvent {
        FileEventsOccurredEvent { file_id: <u16>::from_le_byte_slice(&bytes[0..2]), events: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OpenDirectory {
    pub error_code: u8,
    pub directory_id: u16,
}
impl FromByteSlice for OpenDirectory {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> OpenDirectory {
        OpenDirectory { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), directory_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DirectoryName {
    pub error_code: u8,
    pub name_string_id: u16,
}
impl FromByteSlice for DirectoryName {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> DirectoryName {
        DirectoryName { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), name_string_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct NextDirectoryEntry {
    pub error_code: u8,
    pub name_string_id: u16,
    pub type_: u8,
}
impl FromByteSlice for NextDirectoryEntry {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> NextDirectoryEntry {
        NextDirectoryEntry {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            name_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            type_: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Processes {
    pub error_code: u8,
    pub processes_list_id: u16,
}
impl FromByteSlice for Processes {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Processes {
        Processes { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), processes_list_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpawnProcess {
    pub error_code: u8,
    pub process_id: u16,
}
impl FromByteSlice for SpawnProcess {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpawnProcess {
        SpawnProcess { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), process_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProcessCommand {
    pub error_code: u8,
    pub executable_string_id: u16,
    pub arguments_list_id: u16,
    pub environment_list_id: u16,
    pub working_directory_string_id: u16,
}
impl FromByteSlice for ProcessCommand {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProcessCommand {
        ProcessCommand {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            executable_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            arguments_list_id: <u16>::from_le_byte_slice(&bytes[3..5]),
            environment_list_id: <u16>::from_le_byte_slice(&bytes[5..7]),
            working_directory_string_id: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProcessIdentity {
    pub error_code: u8,
    pub pid: u32,
    pub uid: u32,
    pub gid: u32,
}
impl FromByteSlice for ProcessIdentity {
    fn bytes_expected() -> usize { 13 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProcessIdentity {
        ProcessIdentity {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            pid: <u32>::from_le_byte_slice(&bytes[1..5]),
            uid: <u32>::from_le_byte_slice(&bytes[5..9]),
            gid: <u32>::from_le_byte_slice(&bytes[9..13]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProcessStdio {
    pub error_code: u8,
    pub stdin_file_id: u16,
    pub stdout_file_id: u16,
    pub stderr_file_id: u16,
}
impl FromByteSlice for ProcessStdio {
    fn bytes_expected() -> usize { 7 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProcessStdio {
        ProcessStdio {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            stdin_file_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            stdout_file_id: <u16>::from_le_byte_slice(&bytes[3..5]),
            stderr_file_id: <u16>::from_le_byte_slice(&bytes[5..7]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProcessState {
    pub error_code: u8,
    pub state: u8,
    pub timestamp: u64,
    pub exit_code: u8,
}
impl FromByteSlice for ProcessState {
    fn bytes_expected() -> usize { 11 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProcessState {
        ProcessState {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            state: <u8>::from_le_byte_slice(&bytes[1..2]),
            timestamp: <u64>::from_le_byte_slice(&bytes[2..10]),
            exit_code: <u8>::from_le_byte_slice(&bytes[10..11]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProcessStateChangedEvent {
    pub process_id: u16,
    pub state: u8,
    pub timestamp: u64,
    pub exit_code: u8,
}
impl FromByteSlice for ProcessStateChangedEvent {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProcessStateChangedEvent {
        ProcessStateChangedEvent {
            process_id: <u16>::from_le_byte_slice(&bytes[0..2]),
            state: <u8>::from_le_byte_slice(&bytes[2..3]),
            timestamp: <u64>::from_le_byte_slice(&bytes[3..11]),
            exit_code: <u8>::from_le_byte_slice(&bytes[11..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Programs {
    pub error_code: u8,
    pub programs_list_id: u16,
}
impl FromByteSlice for Programs {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Programs {
        Programs { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), programs_list_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DefineProgram {
    pub error_code: u8,
    pub program_id: u16,
}
impl FromByteSlice for DefineProgram {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> DefineProgram {
        DefineProgram { error_code: <u8>::from_le_byte_slice(&bytes[0..1]), program_id: <u16>::from_le_byte_slice(&bytes[1..3]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramIdentifier {
    pub error_code: u8,
    pub identifier_string_id: u16,
}
impl FromByteSlice for ProgramIdentifier {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramIdentifier {
        ProgramIdentifier {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            identifier_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramRootDirectory {
    pub error_code: u8,
    pub root_directory_string_id: u16,
}
impl FromByteSlice for ProgramRootDirectory {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramRootDirectory {
        ProgramRootDirectory {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            root_directory_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramCommand {
    pub error_code: u8,
    pub executable_string_id: u16,
    pub arguments_list_id: u16,
    pub environment_list_id: u16,
    pub working_directory_string_id: u16,
}
impl FromByteSlice for ProgramCommand {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramCommand {
        ProgramCommand {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            executable_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            arguments_list_id: <u16>::from_le_byte_slice(&bytes[3..5]),
            environment_list_id: <u16>::from_le_byte_slice(&bytes[5..7]),
            working_directory_string_id: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramStdioRedirection {
    pub error_code: u8,
    pub stdin_redirection: u8,
    pub stdin_file_name_string_id: u16,
    pub stdout_redirection: u8,
    pub stdout_file_name_string_id: u16,
    pub stderr_redirection: u8,
    pub stderr_file_name_string_id: u16,
}
impl FromByteSlice for ProgramStdioRedirection {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramStdioRedirection {
        ProgramStdioRedirection {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            stdin_redirection: <u8>::from_le_byte_slice(&bytes[1..2]),
            stdin_file_name_string_id: <u16>::from_le_byte_slice(&bytes[2..4]),
            stdout_redirection: <u8>::from_le_byte_slice(&bytes[4..5]),
            stdout_file_name_string_id: <u16>::from_le_byte_slice(&bytes[5..7]),
            stderr_redirection: <u8>::from_le_byte_slice(&bytes[7..8]),
            stderr_file_name_string_id: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramSchedule {
    pub error_code: u8,
    pub start_mode: u8,
    pub continue_after_error: bool,
    pub start_interval: u32,
    pub start_fields_string_id: u16,
}
impl FromByteSlice for ProgramSchedule {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramSchedule {
        ProgramSchedule {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            start_mode: <u8>::from_le_byte_slice(&bytes[1..2]),
            continue_after_error: <bool>::from_le_byte_slice(&bytes[2..3]),
            start_interval: <u32>::from_le_byte_slice(&bytes[3..7]),
            start_fields_string_id: <u16>::from_le_byte_slice(&bytes[7..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ProgramSchedulerState {
    pub error_code: u8,
    pub state: u8,
    pub timestamp: u64,
    pub message_string_id: u16,
}
impl FromByteSlice for ProgramSchedulerState {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> ProgramSchedulerState {
        ProgramSchedulerState {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            state: <u8>::from_le_byte_slice(&bytes[1..2]),
            timestamp: <u64>::from_le_byte_slice(&bytes[2..10]),
            message_string_id: <u16>::from_le_byte_slice(&bytes[10..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LastSpawnedProgramProcess {
    pub error_code: u8,
    pub process_id: u16,
    pub timestamp: u64,
}
impl FromByteSlice for LastSpawnedProgramProcess {
    fn bytes_expected() -> usize { 11 }
    fn from_le_byte_slice(bytes: &[u8]) -> LastSpawnedProgramProcess {
        LastSpawnedProgramProcess {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            process_id: <u16>::from_le_byte_slice(&bytes[1..3]),
            timestamp: <u64>::from_le_byte_slice(&bytes[3..11]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CustomProgramOptionNames {
    pub error_code: u8,
    pub names_list_id: u16,
}
impl FromByteSlice for CustomProgramOptionNames {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> CustomProgramOptionNames {
        CustomProgramOptionNames {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            names_list_id: <u16>::from_le_byte_slice(&bytes[1..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CustomProgramOptionValue {
    pub error_code: u8,
    pub value_string_id: u16,
}
impl FromByteSlice for CustomProgramOptionValue {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> CustomProgramOptionValue {
        CustomProgramOptionValue {
            error_code: <u8>::from_le_byte_slice(&bytes[0..1]),
            value_string_id: <u16>::from_le_byte_slice(&bytes[1..3]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Executes user programs and controls other Bricks/Bricklets standalone
#[derive(Clone)]
pub struct RedBrick {
    device: Device,
}
impl RedBrick {
    pub const DEVICE_IDENTIFIER: u16 = 17;
    pub const DEVICE_DISPLAY_NAME: &'static str = "RED Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> RedBrick {
        let mut result = RedBrick { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(RedBrickFunction::CreateSession) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ExpireSession) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ExpireSessionUnchecked) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RedBrickFunction::KeepSessionAlive) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ReleaseObject) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ReleaseObjectUnchecked) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RedBrickFunction::AllocateString) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::TruncateString) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetStringLength) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetStringChunk) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetStringChunk) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::AllocateList) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetListLength) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetListItem) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::AppendToList) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::RemoveFromList) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::OpenFile) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::CreatePipe) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetFileInfo) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ReadFile) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ReadFileAsync) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RedBrickFunction::AbortAsyncFileRead) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::WriteFile) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::WriteFileUnchecked) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RedBrickFunction::WriteFileAsync) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(RedBrickFunction::SetFilePosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetFilePosition) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetFileEvents) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetFileEvents) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::OpenDirectory) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetDirectoryName) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetNextDirectoryEntry) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::RewindDirectory) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::CreateDirectory) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProcesses) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SpawnProcess) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::KillProcess) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProcessCommand) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProcessIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProcessStdio) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProcessState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetPrograms) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::DefineProgram) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::PurgeProgram) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramIdentifier) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramRootDirectory) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetProgramCommand) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramCommand) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetProgramStdioRedirection) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramStdioRedirection) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetProgramSchedule) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramSchedule) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetProgramSchedulerState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::ContinueProgramSchedule) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::StartProgram) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetLastSpawnedProgramProcess) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetCustomProgramOptionNames) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::SetCustomProgramOptionValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetCustomProgramOptionValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::RemoveCustomProgramOption) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(RedBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::red_brick::RedBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::red_brick::RedBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: RedBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: RedBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver reports the result of a call to the [`read_file_async`]
    /// function.
    ///
    /// [`read_file_async`]: #method.read_file_async
    pub fn get_async_file_read_callback_receiver(&self) -> ConvertingCallbackReceiver<AsyncFileReadEvent> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackAsyncFileRead))
    }

    /// This receiver reports the result of a call to the [`write_file_async`]
    /// function.
    pub fn get_async_file_write_callback_receiver(&self) -> ConvertingCallbackReceiver<AsyncFileWriteEvent> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackAsyncFileWrite))
    }

    ///
    pub fn get_file_events_occurred_callback_receiver(&self) -> ConvertingCallbackReceiver<FileEventsOccurredEvent> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackFileEventsOccurred))
    }

    ///
    pub fn get_process_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<ProcessStateChangedEvent> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackProcessStateChanged))
    }

    ///
    pub fn get_program_scheduler_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackProgramSchedulerStateChanged))
    }

    ///
    pub fn get_program_process_spawned_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(RedBrickFunction::CallbackProgramProcessSpawned))
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn create_session(&self, lifetime: u32) -> ConvertingReceiver<CreateSession> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(lifetime));

        self.device.get(u8::from(RedBrickFunction::CreateSession), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn expire_session(&self, session_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::ExpireSession), payload)
    }

    ///
    pub fn expire_session_unchecked(&self, session_id: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.set(u8::from(RedBrickFunction::ExpireSessionUnchecked), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn keep_session_alive(&self, session_id: u16, lifetime: u32) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(session_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(lifetime));

        self.device.get(u8::from(RedBrickFunction::KeepSessionAlive), payload)
    }

    /// Decreases the reference count of an object by one and returns the resulting
    /// error code. If the reference count reaches zero the object gets destroyed.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn release_object(&self, object_id: u16, session_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(object_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::ReleaseObject), payload)
    }

    ///
    pub fn release_object_unchecked(&self, object_id: u16, session_id: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(object_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.set(u8::from(RedBrickFunction::ReleaseObjectUnchecked), payload)
    }

    /// Allocates a new string object, reserves ``length_to_reserve`` bytes memory
    /// for it and sets up to the first 60 bytes. Set ``length_to_reserve`` to the
    /// length of the string that should be stored in the string object.
    ///
    /// Returns the object ID of the new string object and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn allocate_string(&self, length_to_reserve: u32, buffer: String, session_id: u16) -> ConvertingReceiver<AllocateString> {
        let mut payload = vec![0; 64];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(length_to_reserve));
        match <String>::try_to_le_byte_vec(buffer, 58) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[4..62].copy_from_slice(&bytes),
        }

        payload[62..64].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::AllocateString), payload)
    }

    /// Truncates a string object to ``length`` bytes and returns the resulting
    /// error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn truncate_string(&self, string_id: u16, length: u32) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(string_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(length));

        self.device.get(u8::from(RedBrickFunction::TruncateString), payload)
    }

    /// Returns the length of a string object and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_string_length(&self, string_id: u16) -> ConvertingReceiver<StringLength> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(string_id));

        self.device.get(u8::from(RedBrickFunction::GetStringLength), payload)
    }

    /// Sets a chunk of up to 58 bytes in a string object beginning at ``offset``.
    ///
    /// Returns the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_string_chunk(&self, string_id: u16, offset: u32, buffer: String) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(string_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(offset));
        match <String>::try_to_le_byte_vec(buffer, 58) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[6..64].copy_from_slice(&bytes),
        }

        self.device.get(u8::from(RedBrickFunction::SetStringChunk), payload)
    }

    /// Returns a chunk up to 63 bytes from a string object beginning at ``offset`` and
    /// returns the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_string_chunk(&self, string_id: u16, offset: u32) -> ConvertingReceiver<StringChunk> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(string_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(offset));

        self.device.get(u8::from(RedBrickFunction::GetStringChunk), payload)
    }

    /// Allocates a new list object and reserves memory for ``length_to_reserve``
    /// items. Set ``length_to_reserve`` to the number of items that should be stored
    /// in the list object.
    ///
    /// Returns the object ID of the new list object and the resulting error code.
    ///
    /// When a list object gets destroyed then the reference count of each object in
    /// the list object is decreased by one.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn allocate_list(&self, length_to_reserve: u16, session_id: u16) -> ConvertingReceiver<AllocateList> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(length_to_reserve));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::AllocateList), payload)
    }

    /// Returns the length of a list object in items and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_list_length(&self, list_id: u16) -> ConvertingReceiver<ListLength> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(list_id));

        self.device.get(u8::from(RedBrickFunction::GetListLength), payload)
    }

    /// Returns the object ID and type of the object stored at ``index`` in a list
    /// object and returns the resulting error code.
    ///
    /// Possible object types are:
    ///
    /// * String = 0
    /// * List = 1
    /// * File = 2
    /// * Directory = 3
    /// * Process = 4
    /// * Program = 5
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_OBJECT_TYPE_STRING
    ///	* RED_BRICK_OBJECT_TYPE_LIST
    ///	* RED_BRICK_OBJECT_TYPE_FILE
    ///	* RED_BRICK_OBJECT_TYPE_DIRECTORY
    ///	* RED_BRICK_OBJECT_TYPE_PROCESS
    ///	* RED_BRICK_OBJECT_TYPE_PROGRAM
    pub fn get_list_item(&self, list_id: u16, index: u16, session_id: u16) -> ConvertingReceiver<ListItem> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(list_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetListItem), payload)
    }

    /// Appends an object to a list object and increases the reference count of the
    /// appended object by one.
    ///
    /// Returns the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn append_to_list(&self, list_id: u16, item_object_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(list_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(item_object_id));

        self.device.get(u8::from(RedBrickFunction::AppendToList), payload)
    }

    /// Removes the object stored at ``index`` from a list object and decreases the
    /// reference count of the removed object by one.
    ///
    /// Returns the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn remove_from_list(&self, list_id: u16, index: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(list_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(index));

        self.device.get(u8::from(RedBrickFunction::RemoveFromList), payload)
    }

    /// Opens an existing file or creates a new file and allocates a new file object
    /// for it.
    ///
    /// FIXME: name has to be absolute
    ///
    /// The reference count of the name string object is increased by one. When the
    /// file object gets destroyed then the reference count of the name string object is
    /// decreased by one. Also the name string object is locked and cannot be modified
    /// while the file object holds a reference to it.
    ///
    /// The ``flags`` parameter takes a ORed combination of the following possible file
    /// flags (in hexadecimal notation):
    ///
    /// * ReadOnly = 0x0001 (O_RDONLY)
    /// * WriteOnly = 0x0002 (O_WRONLY)
    /// * ReadWrite = 0x0004 (O_RDWR)
    /// * Append = 0x0008 (O_APPEND)
    /// * Create = 0x0010 (O_CREAT)
    /// * Exclusive = 0x0020 (O_EXCL)
    /// * NonBlocking = 0x0040 (O_NONBLOCK)
    /// * Truncate = 0x0080 (O_TRUNC)
    /// * Temporary = 0x0100
    /// * Replace = 0x0200
    ///
    /// FIXME: explain *Temporary* and *Replace* flag
    ///
    /// The ``permissions`` parameter takes a ORed combination of the following
    /// possible file permissions (in octal notation) that match the common UNIX
    /// permission bits:
    ///
    /// * UserRead = 00400
    /// * UserWrite = 00200
    /// * UserExecute = 00100
    /// * GroupRead = 00040
    /// * GroupWrite = 00020
    /// * GroupExecute = 00010
    /// * OthersRead = 00004
    /// * OthersWrite = 00002
    /// * OthersExecute = 00001
    ///
    /// Returns the object ID of the new file object and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_FILE_FLAG_READ_ONLY
    ///	* RED_BRICK_FILE_FLAG_WRITE_ONLY
    ///	* RED_BRICK_FILE_FLAG_READ_WRITE
    ///	* RED_BRICK_FILE_FLAG_APPEND
    ///	* RED_BRICK_FILE_FLAG_CREATE
    ///	* RED_BRICK_FILE_FLAG_EXCLUSIVE
    ///	* RED_BRICK_FILE_FLAG_NON_BLOCKING
    ///	* RED_BRICK_FILE_FLAG_TRUNCATE
    ///	* RED_BRICK_FILE_FLAG_TEMPORARY
    ///	* RED_BRICK_FILE_FLAG_REPLACE
    ///	* RED_BRICK_FILE_PERMISSION_USER_ALL
    ///	* RED_BRICK_FILE_PERMISSION_USER_READ
    ///	* RED_BRICK_FILE_PERMISSION_USER_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_USER_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_ALL
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_READ
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_ALL
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_READ
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_EXECUTE
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn open_file(
        &self,
        name_string_id: u16,
        flags: u32,
        permissions: u16,
        uid: u32,
        gid: u32,
        session_id: u16,
    ) -> ConvertingReceiver<OpenFile> {
        let mut payload = vec![0; 18];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(flags));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(permissions));
        payload[8..12].copy_from_slice(&<u32>::to_le_byte_vec(uid));
        payload[12..16].copy_from_slice(&<u32>::to_le_byte_vec(gid));
        payload[16..18].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::OpenFile), payload)
    }

    /// Creates a new pipe and allocates a new file object for it.
    ///
    /// The ``flags`` parameter takes a ORed combination of the following possible
    /// pipe flags (in hexadecimal notation):
    ///
    /// * NonBlockingRead = 0x0001
    /// * NonBlockingWrite = 0x0002
    ///
    /// The length of the pipe buffer can be specified with the ``length`` parameter
    /// in bytes. If length is set to zero, then the default pipe buffer length is used.
    ///
    /// Returns the object ID of the new file object and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_PIPE_FLAG_NON_BLOCKING_READ
    ///	* RED_BRICK_PIPE_FLAG_NON_BLOCKING_WRITE
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn create_pipe(&self, flags: u32, length: u64, session_id: u16) -> ConvertingReceiver<CreatePipe> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(flags));
        payload[4..12].copy_from_slice(&<u64>::to_le_byte_vec(length));
        payload[12..14].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::CreatePipe), payload)
    }

    /// Returns various information about a file and the resulting error code.
    ///
    /// Possible file types are:
    ///
    /// * Unknown = 0
    /// * Regular = 1
    /// * Directory = 2
    /// * Character = 3
    /// * Block = 4
    /// * FIFO = 5
    /// * Symlink = 6
    /// * Socket = 7
    /// * Pipe = 8
    ///
    /// If the file type is *Pipe* then the returned name string object is invalid,
    /// because a pipe has no name. Otherwise the returned name string object was used
    /// to open or create the file object, as passed to [`open_file`].
    ///
    /// The returned flags were used to open or create the file object, as passed to
    /// [`open_file`] or [`create_pipe`]. See the respective function for a list
    /// of possible file and pipe flags.
    ///
    /// FIXME: everything except flags and length is invalid if file type is *Pipe*
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_FILE_TYPE_UNKNOWN
    ///	* RED_BRICK_FILE_TYPE_REGULAR
    ///	* RED_BRICK_FILE_TYPE_DIRECTORY
    ///	* RED_BRICK_FILE_TYPE_CHARACTER
    ///	* RED_BRICK_FILE_TYPE_BLOCK
    ///	* RED_BRICK_FILE_TYPE_FIFO
    ///	* RED_BRICK_FILE_TYPE_SYMLINK
    ///	* RED_BRICK_FILE_TYPE_SOCKET
    ///	* RED_BRICK_FILE_TYPE_PIPE
    ///	* RED_BRICK_FILE_FLAG_READ_ONLY
    ///	* RED_BRICK_FILE_FLAG_WRITE_ONLY
    ///	* RED_BRICK_FILE_FLAG_READ_WRITE
    ///	* RED_BRICK_FILE_FLAG_APPEND
    ///	* RED_BRICK_FILE_FLAG_CREATE
    ///	* RED_BRICK_FILE_FLAG_EXCLUSIVE
    ///	* RED_BRICK_FILE_FLAG_NON_BLOCKING
    ///	* RED_BRICK_FILE_FLAG_TRUNCATE
    ///	* RED_BRICK_FILE_FLAG_TEMPORARY
    ///	* RED_BRICK_FILE_FLAG_REPLACE
    ///	* RED_BRICK_FILE_PERMISSION_USER_ALL
    ///	* RED_BRICK_FILE_PERMISSION_USER_READ
    ///	* RED_BRICK_FILE_PERMISSION_USER_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_USER_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_ALL
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_READ
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_ALL
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_READ
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_EXECUTE
    pub fn get_file_info(&self, file_id: u16, session_id: u16) -> ConvertingReceiver<FileInfo> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetFileInfo), payload)
    }

    /// Reads up to 62 bytes from a file object.
    ///
    /// Returns the bytes read, the actual number of bytes read and the resulting
    /// error code.
    ///
    /// If there is not data to be read, either because the file position reached
    /// end-of-file or because there is not data in the pipe, then zero bytes are
    /// returned.
    ///
    /// If the file object was created by [`open_file`] without the *NonBlocking*
    /// flag or by [`create_pipe`] without the *NonBlockingRead* flag then the
    /// error code *NotSupported* is returned.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn read_file(&self, file_id: u16, length_to_read: u8) -> ConvertingReceiver<ReadFile> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(length_to_read));

        self.device.get(u8::from(RedBrickFunction::ReadFile), payload)
    }

    /// Reads up to 2\ :sup:`63`\  - 1 bytes from a file object asynchronously.
    ///
    /// Reports the bytes read (in 60 byte chunks), the actual number of bytes read and
    /// the resulting error code via the [`get_async_file_read_callback_receiver`] receiver.
    ///
    /// If there is not data to be read, either because the file position reached
    /// end-of-file or because there is not data in the pipe, then zero bytes are
    /// reported.
    ///
    /// If the file object was created by [`open_file`] without the *NonBlocking*
    /// flag or by [`create_pipe`] without the *NonBlockingRead* flag then the error
    /// code *NotSupported* is reported via the [`get_async_file_read_callback_receiver`] receiver.
    pub fn read_file_async(&self, file_id: u16, length_to_read: u64) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..10].copy_from_slice(&<u64>::to_le_byte_vec(length_to_read));

        self.device.set(u8::from(RedBrickFunction::ReadFileAsync), payload)
    }

    /// Aborts a [`read_file_async`] operation in progress.
    ///
    /// Returns the resulting error code.
    ///
    /// On success the [`get_async_file_read_callback_receiver`] receiver will report *OperationAborted*.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn abort_async_file_read(&self, file_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));

        self.device.get(u8::from(RedBrickFunction::AbortAsyncFileRead), payload)
    }

    /// Writes up to 61 bytes to a file object.
    ///
    /// Returns the actual number of bytes written and the resulting error code.
    ///
    /// If the file object was created by [`open_file`] without the *NonBlocking*
    /// flag or by [`create_pipe`] without the *NonBlockingWrite* flag then the
    /// error code *NotSupported* is returned.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn write_file(&self, file_id: u16, buffer: [u8; 61], length_to_write: u8) -> ConvertingReceiver<WriteFile> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..63].copy_from_slice(&<[u8; 61]>::to_le_byte_vec(buffer));
        payload[63..64].copy_from_slice(&<u8>::to_le_byte_vec(length_to_write));

        self.device.get(u8::from(RedBrickFunction::WriteFile), payload)
    }

    /// Writes up to 61 bytes to a file object.
    ///
    /// Does neither report the actual number of bytes written nor the resulting error
    /// code.
    ///
    /// If the file object was created by [`open_file`] without the *NonBlocking*
    /// flag or by [`create_pipe`] without the *NonBlockingWrite* flag then the
    /// write operation will fail silently.
    pub fn write_file_unchecked(&self, file_id: u16, buffer: [u8; 61], length_to_write: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..63].copy_from_slice(&<[u8; 61]>::to_le_byte_vec(buffer));
        payload[63..64].copy_from_slice(&<u8>::to_le_byte_vec(length_to_write));

        self.device.set(u8::from(RedBrickFunction::WriteFileUnchecked), payload)
    }

    /// Writes up to 61 bytes to a file object.
    ///
    /// Reports the actual number of bytes written and the resulting error code via the
    /// [`get_async_file_write_callback_receiver`] receiver.
    ///
    /// If the file object was created by [`open_file`] without the *NonBlocking*
    /// flag or by [`create_pipe`] without the *NonBlockingWrite* flag then the
    /// error code *NotSupported* is reported via the [`get_async_file_write_callback_receiver`] receiver.
    pub fn write_file_async(&self, file_id: u16, buffer: [u8; 61], length_to_write: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..63].copy_from_slice(&<[u8; 61]>::to_le_byte_vec(buffer));
        payload[63..64].copy_from_slice(&<u8>::to_le_byte_vec(length_to_write));

        self.device.set(u8::from(RedBrickFunction::WriteFileAsync), payload)
    }

    /// Set the current seek position of a file object relative to ``origin``.
    ///
    /// Possible file origins are:
    ///
    /// * Beginning = 0
    /// * Current = 1
    /// * End = 2
    ///
    /// Returns the resulting absolute seek position and error code.
    ///
    /// If the file object was created by [`create_pipe`] then it has no seek
    /// position and the error code *InvalidSeek* is returned.
    ///
    /// Associated constants:
    /// * RED_BRICK_FILE_ORIGIN_BEGINNING
    ///	* RED_BRICK_FILE_ORIGIN_CURRENT
    ///	* RED_BRICK_FILE_ORIGIN_END
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_file_position(&self, file_id: u16, offset: i64, origin: u8) -> ConvertingReceiver<SetFilePosition> {
        let mut payload = vec![0; 11];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..10].copy_from_slice(&<i64>::to_le_byte_vec(offset));
        payload[10..11].copy_from_slice(&<u8>::to_le_byte_vec(origin));

        self.device.get(u8::from(RedBrickFunction::SetFilePosition), payload)
    }

    /// Returns the current seek position of a file object and returns the
    /// resulting error code.
    ///
    /// If the file object was created by [`create_pipe`] then it has no seek
    /// position and the error code *InvalidSeek* is returned.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_file_position(&self, file_id: u16) -> ConvertingReceiver<FilePosition> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));

        self.device.get(u8::from(RedBrickFunction::GetFilePosition), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_FILE_EVENT_READABLE
    ///	* RED_BRICK_FILE_EVENT_WRITABLE
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_file_events(&self, file_id: u16, events: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(events));

        self.device.get(u8::from(RedBrickFunction::SetFileEvents), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_FILE_EVENT_READABLE
    ///	* RED_BRICK_FILE_EVENT_WRITABLE
    pub fn get_file_events(&self, file_id: u16) -> ConvertingReceiver<FileEvents> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(file_id));

        self.device.get(u8::from(RedBrickFunction::GetFileEvents), payload)
    }

    /// Opens an existing directory and allocates a new directory object for it.
    ///
    /// FIXME: name has to be absolute
    ///
    /// The reference count of the name string object is increased by one. When the
    /// directory object is destroyed then the reference count of the name string
    /// object is decreased by one. Also the name string object is locked and cannot be
    /// modified while the directory object holds a reference to it.
    ///
    /// Returns the object ID of the new directory object and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn open_directory(&self, name_string_id: u16, session_id: u16) -> ConvertingReceiver<OpenDirectory> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::OpenDirectory), payload)
    }

    /// Returns the name of a directory object, as passed to [`open_directory`], and
    /// the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_directory_name(&self, directory_id: u16, session_id: u16) -> ConvertingReceiver<DirectoryName> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(directory_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetDirectoryName), payload)
    }

    /// Returns the next entry in a directory object and the resulting error code.
    ///
    /// If there is not next entry then error code *NoMoreData* is returned. To rewind
    /// a directory object call [`rewind_directory`].
    ///
    /// Possible directory entry types are:
    ///
    /// * Unknown = 0
    /// * Regular = 1
    /// * Directory = 2
    /// * Character = 3
    /// * Block = 4
    /// * FIFO = 5
    /// * Symlink = 6
    /// * Socket = 7
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_UNKNOWN
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_REGULAR
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_DIRECTORY
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_CHARACTER
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_BLOCK
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_FIFO
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_SYMLINK
    ///	* RED_BRICK_DIRECTORY_ENTRY_TYPE_SOCKET
    pub fn get_next_directory_entry(&self, directory_id: u16, session_id: u16) -> ConvertingReceiver<NextDirectoryEntry> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(directory_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetNextDirectoryEntry), payload)
    }

    /// Rewinds a directory object and returns the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn rewind_directory(&self, directory_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(directory_id));

        self.device.get(u8::from(RedBrickFunction::RewindDirectory), payload)
    }

    /// FIXME: name has to be absolute
    ///
    /// Associated constants:
    /// * RED_BRICK_DIRECTORY_FLAG_RECURSIVE
    ///	* RED_BRICK_DIRECTORY_FLAG_EXCLUSIVE
    ///	* RED_BRICK_FILE_PERMISSION_USER_ALL
    ///	* RED_BRICK_FILE_PERMISSION_USER_READ
    ///	* RED_BRICK_FILE_PERMISSION_USER_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_USER_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_ALL
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_READ
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_GROUP_EXECUTE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_ALL
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_READ
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_WRITE
    ///	* RED_BRICK_FILE_PERMISSION_OTHERS_EXECUTE
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn create_directory(&self, name_string_id: u16, flags: u32, permissions: u16, uid: u32, gid: u32) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 16];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(flags));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(permissions));
        payload[8..12].copy_from_slice(&<u32>::to_le_byte_vec(uid));
        payload[12..16].copy_from_slice(&<u32>::to_le_byte_vec(gid));

        self.device.get(u8::from(RedBrickFunction::CreateDirectory), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_processes(&self, session_id: u16) -> ConvertingReceiver<Processes> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProcesses), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn spawn_process(
        &self,
        executable_string_id: u16,
        arguments_list_id: u16,
        environment_list_id: u16,
        working_directory_string_id: u16,
        uid: u32,
        gid: u32,
        stdin_file_id: u16,
        stdout_file_id: u16,
        stderr_file_id: u16,
        session_id: u16,
    ) -> ConvertingReceiver<SpawnProcess> {
        let mut payload = vec![0; 24];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(executable_string_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(arguments_list_id));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(environment_list_id));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(working_directory_string_id));
        payload[8..12].copy_from_slice(&<u32>::to_le_byte_vec(uid));
        payload[12..16].copy_from_slice(&<u32>::to_le_byte_vec(gid));
        payload[16..18].copy_from_slice(&<u16>::to_le_byte_vec(stdin_file_id));
        payload[18..20].copy_from_slice(&<u16>::to_le_byte_vec(stdout_file_id));
        payload[20..22].copy_from_slice(&<u16>::to_le_byte_vec(stderr_file_id));
        payload[22..24].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::SpawnProcess), payload)
    }

    /// Sends a UNIX signal to a process object and returns the resulting error code.
    ///
    /// Possible UNIX signals are:
    ///
    /// * Interrupt = 2
    /// * Quit = 3
    /// * Abort = 6
    /// * Kill = 9
    /// * User1 = 10
    /// * User2 = 12
    /// * Terminate = 15
    /// * Continue =  18
    /// * Stop = 19
    ///
    /// Associated constants:
    /// * RED_BRICK_PROCESS_SIGNAL_INTERRUPT
    ///	* RED_BRICK_PROCESS_SIGNAL_QUIT
    ///	* RED_BRICK_PROCESS_SIGNAL_ABORT
    ///	* RED_BRICK_PROCESS_SIGNAL_KILL
    ///	* RED_BRICK_PROCESS_SIGNAL_USER1
    ///	* RED_BRICK_PROCESS_SIGNAL_USER2
    ///	* RED_BRICK_PROCESS_SIGNAL_TERMINATE
    ///	* RED_BRICK_PROCESS_SIGNAL_CONTINUE
    ///	* RED_BRICK_PROCESS_SIGNAL_STOP
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn kill_process(&self, process_id: u16, signal: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(process_id));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(signal));

        self.device.get(u8::from(RedBrickFunction::KillProcess), payload)
    }

    /// Returns the executable, arguments, environment and working directory used to
    /// spawn a process object, as passed to [`spawn_process`], and the resulting
    /// error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_process_command(&self, process_id: u16, session_id: u16) -> ConvertingReceiver<ProcessCommand> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(process_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProcessCommand), payload)
    }

    /// Returns the process ID and the user and group ID used to spawn a process object,
    /// as passed to [`spawn_process`], and the resulting error code.
    ///
    /// The process ID is only valid if the state is *Running* or *Stopped*, see
    /// [`get_process_state`].
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_process_identity(&self, process_id: u16) -> ConvertingReceiver<ProcessIdentity> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(process_id));

        self.device.get(u8::from(RedBrickFunction::GetProcessIdentity), payload)
    }

    /// Returns the stdin, stdout and stderr files used to spawn a process object, as
    /// passed to [`spawn_process`], and the resulting error code.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_process_stdio(&self, process_id: u16, session_id: u16) -> ConvertingReceiver<ProcessStdio> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(process_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProcessStdio), payload)
    }

    /// Returns the current state, timestamp and exit code of a process object, and
    /// the resulting error code.
    ///
    /// Possible process states are:
    ///
    /// * Unknown = 0
    /// * Running = 1
    /// * Error = 2
    /// * Exited = 3
    /// * Killed = 4
    /// * Stopped = 5
    ///
    /// The timestamp represents the UNIX time since when the process is in its current
    /// state.
    ///
    /// The exit code is only valid if the state is *Error*, *Exited*, *Killed* or
    /// *Stopped* and has different meanings depending on the state:
    ///
    /// * Error: error code for error occurred while spawning the process (see below)
    /// * Exited: exit status of the process
    /// * Killed: UNIX signal number used to kill the process
    /// * Stopped: UNIX signal number used to stop the process
    ///
    /// Possible exit/error codes in *Error* state are:
    ///
    /// * InternalError = 125
    /// * CannotExecute = 126
    /// * DoesNotExist = 127
    ///
    /// The *CannotExecute* error can be caused by the executable being opened for
    /// writing.
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_PROCESS_STATE_UNKNOWN
    ///	* RED_BRICK_PROCESS_STATE_RUNNING
    ///	* RED_BRICK_PROCESS_STATE_ERROR
    ///	* RED_BRICK_PROCESS_STATE_EXITED
    ///	* RED_BRICK_PROCESS_STATE_KILLED
    ///	* RED_BRICK_PROCESS_STATE_STOPPED
    pub fn get_process_state(&self, process_id: u16) -> ConvertingReceiver<ProcessState> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(process_id));

        self.device.get(u8::from(RedBrickFunction::GetProcessState), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_programs(&self, session_id: u16) -> ConvertingReceiver<Programs> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetPrograms), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn define_program(&self, identifier_string_id: u16, session_id: u16) -> ConvertingReceiver<DefineProgram> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(identifier_string_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::DefineProgram), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn purge_program(&self, program_id: u16, cookie: u32) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..6].copy_from_slice(&<u32>::to_le_byte_vec(cookie));

        self.device.get(u8::from(RedBrickFunction::PurgeProgram), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_program_identifier(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramIdentifier> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramIdentifier), payload)
    }

    /// FIXME: root directory is absolute: <home>/programs/<identifier>
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_program_root_directory(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramRootDirectory> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramRootDirectory), payload)
    }

    /// FIXME: working directory is relative to <home>/programs/<identifier>/bin
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_program_command(
        &self,
        program_id: u16,
        executable_string_id: u16,
        arguments_list_id: u16,
        environment_list_id: u16,
        working_directory_string_id: u16,
    ) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(executable_string_id));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(arguments_list_id));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(environment_list_id));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(working_directory_string_id));

        self.device.get(u8::from(RedBrickFunction::SetProgramCommand), payload)
    }

    /// FIXME: working directory is relative to <home>/programs/<identifier>/bin
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_program_command(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramCommand> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramCommand), payload)
    }

    /// FIXME: stdio file names are relative to <home>/programs/<identifier>/bin
    ///
    /// Associated constants:
    /// * RED_BRICK_PROGRAM_STDIO_REDIRECTION_DEV_NULL
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_PIPE
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_FILE
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_INDIVIDUAL_LOG
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_CONTINUOUS_LOG
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_STDOUT
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_program_stdio_redirection(
        &self,
        program_id: u16,
        stdin_redirection: u8,
        stdin_file_name_string_id: u16,
        stdout_redirection: u8,
        stdout_file_name_string_id: u16,
        stderr_redirection: u8,
        stderr_file_name_string_id: u16,
    ) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 11];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(stdin_redirection));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(stdin_file_name_string_id));
        payload[5..6].copy_from_slice(&<u8>::to_le_byte_vec(stdout_redirection));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(stdout_file_name_string_id));
        payload[8..9].copy_from_slice(&<u8>::to_le_byte_vec(stderr_redirection));
        payload[9..11].copy_from_slice(&<u16>::to_le_byte_vec(stderr_file_name_string_id));

        self.device.get(u8::from(RedBrickFunction::SetProgramStdioRedirection), payload)
    }

    /// FIXME: stdio file names are relative to <home>/programs/<identifier>/bin
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_DEV_NULL
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_PIPE
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_FILE
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_INDIVIDUAL_LOG
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_CONTINUOUS_LOG
    ///	* RED_BRICK_PROGRAM_STDIO_REDIRECTION_STDOUT
    pub fn get_program_stdio_redirection(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramStdioRedirection> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramStdioRedirection), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_PROGRAM_START_MODE_NEVER
    ///	* RED_BRICK_PROGRAM_START_MODE_ALWAYS
    ///	* RED_BRICK_PROGRAM_START_MODE_INTERVAL
    ///	* RED_BRICK_PROGRAM_START_MODE_CRON
    ///	* RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_program_schedule(
        &self,
        program_id: u16,
        start_mode: u8,
        continue_after_error: bool,
        start_interval: u32,
        start_fields_string_id: u16,
    ) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 10];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(start_mode));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(continue_after_error));
        payload[4..8].copy_from_slice(&<u32>::to_le_byte_vec(start_interval));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(start_fields_string_id));

        self.device.get(u8::from(RedBrickFunction::SetProgramSchedule), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_PROGRAM_START_MODE_NEVER
    ///	* RED_BRICK_PROGRAM_START_MODE_ALWAYS
    ///	* RED_BRICK_PROGRAM_START_MODE_INTERVAL
    ///	* RED_BRICK_PROGRAM_START_MODE_CRON
    pub fn get_program_schedule(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramSchedule> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramSchedule), payload)
    }

    /// FIXME: message is currently valid in error-occurred state only
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    ///	* RED_BRICK_PROGRAM_SCHEDULER_STATE_STOPPED
    ///	* RED_BRICK_PROGRAM_SCHEDULER_STATE_RUNNING
    pub fn get_program_scheduler_state(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<ProgramSchedulerState> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetProgramSchedulerState), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn continue_program_schedule(&self, program_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));

        self.device.get(u8::from(RedBrickFunction::ContinueProgramSchedule), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn start_program(&self, program_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));

        self.device.get(u8::from(RedBrickFunction::StartProgram), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_last_spawned_program_process(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<LastSpawnedProgramProcess> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetLastSpawnedProgramProcess), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_custom_program_option_names(&self, program_id: u16, session_id: u16) -> ConvertingReceiver<CustomProgramOptionNames> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetCustomProgramOptionNames), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn set_custom_program_option_value(&self, program_id: u16, name_string_id: u16, value_string_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(value_string_id));

        self.device.get(u8::from(RedBrickFunction::SetCustomProgramOptionValue), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn get_custom_program_option_value(
        &self,
        program_id: u16,
        name_string_id: u16,
        session_id: u16,
    ) -> ConvertingReceiver<CustomProgramOptionValue> {
        let mut payload = vec![0; 6];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(session_id));

        self.device.get(u8::from(RedBrickFunction::GetCustomProgramOptionValue), payload)
    }

    ///
    ///
    /// Associated constants:
    /// * RED_BRICK_ERROR_CODE_SUCCESS
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_ERROR
    ///	* RED_BRICK_ERROR_CODE_INVALID_OPERATION
    ///	* RED_BRICK_ERROR_CODE_OPERATION_ABORTED
    ///	* RED_BRICK_ERROR_CODE_INTERNAL_ERROR
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SESSION_ID
    ///	* RED_BRICK_ERROR_CODE_UNKNOWN_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_OBJECT_ID
    ///	* RED_BRICK_ERROR_CODE_OBJECT_IS_LOCKED
    ///	* RED_BRICK_ERROR_CODE_NO_MORE_DATA
    ///	* RED_BRICK_ERROR_CODE_WRONG_LIST_ITEM_TYPE
    ///	* RED_BRICK_ERROR_CODE_PROGRAM_IS_PURGED
    ///	* RED_BRICK_ERROR_CODE_INVALID_PARAMETER
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_MEMORY
    ///	* RED_BRICK_ERROR_CODE_NO_FREE_SPACE
    ///	* RED_BRICK_ERROR_CODE_ACCESS_DENIED
    ///	* RED_BRICK_ERROR_CODE_ALREADY_EXISTS
    ///	* RED_BRICK_ERROR_CODE_DOES_NOT_EXIST
    ///	* RED_BRICK_ERROR_CODE_INTERRUPTED
    ///	* RED_BRICK_ERROR_CODE_IS_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_NOT_A_DIRECTORY
    ///	* RED_BRICK_ERROR_CODE_WOULD_BLOCK
    ///	* RED_BRICK_ERROR_CODE_OVERFLOW
    ///	* RED_BRICK_ERROR_CODE_BAD_FILE_DESCRIPTOR
    ///	* RED_BRICK_ERROR_CODE_OUT_OF_RANGE
    ///	* RED_BRICK_ERROR_CODE_NAME_TOO_LONG
    ///	* RED_BRICK_ERROR_CODE_INVALID_SEEK
    ///	* RED_BRICK_ERROR_CODE_NOT_SUPPORTED
    ///	* RED_BRICK_ERROR_CODE_TOO_MANY_OPEN_FILES
    pub fn remove_custom_program_option(&self, program_id: u16, name_string_id: u16) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(program_id));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(name_string_id));

        self.device.get(u8::from(RedBrickFunction::RemoveCustomProgramOption), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(RedBrickFunction::GetIdentity), payload)
    }
}
