/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Reads temperatures from Pt100 und Pt1000 sensors.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/PTC_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum PtcBrickletFunction {
    GetTemperature,
    GetResistance,
    SetTemperatureCallbackPeriod,
    GetTemperatureCallbackPeriod,
    SetResistanceCallbackPeriod,
    GetResistanceCallbackPeriod,
    SetTemperatureCallbackThreshold,
    GetTemperatureCallbackThreshold,
    SetResistanceCallbackThreshold,
    GetResistanceCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetNoiseRejectionFilter,
    GetNoiseRejectionFilter,
    IsSensorConnected,
    SetWireMode,
    GetWireMode,
    SetSensorConnectedCallbackConfiguration,
    GetSensorConnectedCallbackConfiguration,
    GetIdentity,
    CallbackTemperature,
    CallbackTemperatureReached,
    CallbackResistance,
    CallbackResistanceReached,
    CallbackSensorConnected,
}
impl From<PtcBrickletFunction> for u8 {
    fn from(fun: PtcBrickletFunction) -> Self {
        match fun {
            PtcBrickletFunction::GetTemperature => 1,
            PtcBrickletFunction::GetResistance => 2,
            PtcBrickletFunction::SetTemperatureCallbackPeriod => 3,
            PtcBrickletFunction::GetTemperatureCallbackPeriod => 4,
            PtcBrickletFunction::SetResistanceCallbackPeriod => 5,
            PtcBrickletFunction::GetResistanceCallbackPeriod => 6,
            PtcBrickletFunction::SetTemperatureCallbackThreshold => 7,
            PtcBrickletFunction::GetTemperatureCallbackThreshold => 8,
            PtcBrickletFunction::SetResistanceCallbackThreshold => 9,
            PtcBrickletFunction::GetResistanceCallbackThreshold => 10,
            PtcBrickletFunction::SetDebouncePeriod => 11,
            PtcBrickletFunction::GetDebouncePeriod => 12,
            PtcBrickletFunction::SetNoiseRejectionFilter => 17,
            PtcBrickletFunction::GetNoiseRejectionFilter => 18,
            PtcBrickletFunction::IsSensorConnected => 19,
            PtcBrickletFunction::SetWireMode => 20,
            PtcBrickletFunction::GetWireMode => 21,
            PtcBrickletFunction::SetSensorConnectedCallbackConfiguration => 22,
            PtcBrickletFunction::GetSensorConnectedCallbackConfiguration => 23,
            PtcBrickletFunction::GetIdentity => 255,
            PtcBrickletFunction::CallbackTemperature => 13,
            PtcBrickletFunction::CallbackTemperatureReached => 14,
            PtcBrickletFunction::CallbackResistance => 15,
            PtcBrickletFunction::CallbackResistanceReached => 16,
            PtcBrickletFunction::CallbackSensorConnected => 24,
        }
    }
}
pub const PTC_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const PTC_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const PTC_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const PTC_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const PTC_BRICKLET_FILTER_OPTION_50HZ: u8 = 0;
pub const PTC_BRICKLET_FILTER_OPTION_60HZ: u8 = 1;
pub const PTC_BRICKLET_WIRE_MODE_2: u8 = 2;
pub const PTC_BRICKLET_WIRE_MODE_3: u8 = 3;
pub const PTC_BRICKLET_WIRE_MODE_4: u8 = 4;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for TemperatureCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackThreshold {
        TemperatureCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ResistanceCallbackThreshold {
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for ResistanceCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ResistanceCallbackThreshold {
        ResistanceCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i32>::from_le_byte_slice(&bytes[1..5]),
            max: <i32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Reads temperatures from Pt100 und Pt1000 sensors
#[derive(Clone)]
pub struct PtcBricklet {
    device: Device,
}
impl PtcBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 226;
    pub const DEVICE_DISPLAY_NAME: &'static str = "PTC Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> PtcBricklet {
        let mut result = PtcBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(PtcBrickletFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetResistance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetTemperatureCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetTemperatureCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetResistanceCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetResistanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetTemperatureCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetResistanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetResistanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetNoiseRejectionFilter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetNoiseRejectionFilter) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::IsSensorConnected) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetWireMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetWireMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::SetSensorConnectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetSensorConnectedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PtcBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::ptc_bricklet::PtcBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::ptc_bricklet::PtcBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: PtcBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: PtcBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_temperature_callback_period`]. The parameter is the
    /// temperature of the connected sensor.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has changed
    /// since the last triggering.
    ///
    /// [`set_temperature_callback_period`]: #method.set_temperature_callback_period
    /// [`get_temperature_callback_receiver`]: #method.get_temperature_callback_receiver
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(PtcBrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_temperature_callback_threshold`] is reached.
    /// The parameter is the temperature of the connected sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_temperature_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(PtcBrickletFunction::CallbackTemperatureReached))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_resistance_callback_period`]. The parameter is the resistance
    /// of the connected sensor.
    ///
    /// The [`get_resistance_callback_receiver`] receiver is only triggered if the resistance has changed
    /// since the last triggering.
    pub fn get_resistance_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(PtcBrickletFunction::CallbackResistance))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_resistance_callback_threshold`] is reached.
    /// The parameter is the resistance of the connected sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_resistance_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i32> {
        self.device.get_callback_receiver(u8::from(PtcBrickletFunction::CallbackResistanceReached))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_sensor_connected_callback_configuration`].
    ///
    /// The parameter is the same as [`is_sensor_connected`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_sensor_connected_callback_receiver(&self) -> ConvertingCallbackReceiver<bool> {
        self.device.get_callback_receiver(u8::from(PtcBrickletFunction::CallbackSensorConnected))
    }

    /// Returns the temperature of connected sensor.
    ///
    /// If you want to get the temperature periodically, it is recommended
    /// to use the [`get_temperature_callback_receiver`] receiver and set the period with
    /// [`set_temperature_callback_period`].
    pub fn get_temperature(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetTemperature), payload)
    }

    /// Returns the value as measured by the MAX31865 precision delta-sigma ADC.
    ///
    /// The value can be converted with the following formulas:
    ///
    /// * Pt100:  resistance = (value * 390) / 32768
    /// * Pt1000: resistance = (value * 3900) / 32768
    ///
    /// If you want to get the resistance periodically, it is recommended
    /// to use the [`get_resistance_callback_receiver`] receiver and set the period with
    /// [`set_resistance_callback_period`].
    pub fn get_resistance(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetResistance), payload)
    }

    /// Sets the period with which the [`get_temperature_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_temperature_callback_receiver`] receiver is only triggered if the temperature has
    /// changed since the last triggering.
    pub fn set_temperature_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(PtcBrickletFunction::SetTemperatureCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_temperature_callback_period`].
    pub fn get_temperature_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetTemperatureCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_resistance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_resistance_callback_receiver`] receiver is only triggered if the resistance has changed
    /// since the last triggering.
    pub fn set_resistance_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(PtcBrickletFunction::SetResistanceCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_resistance_callback_period`].
    pub fn get_resistance_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetResistanceCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_temperature_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_temperature_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(PtcBrickletFunction::SetTemperatureCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_temperature_callback_threshold`].
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_temperature_callback_threshold(&self) -> ConvertingReceiver<TemperatureCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetTemperatureCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_resistance_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the temperature is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the temperature is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the temperature is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the temperature is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_resistance_callback_threshold(&self, option: char, min: i32, max: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(PtcBrickletFunction::SetResistanceCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_resistance_callback_threshold`].
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* PTC_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_resistance_callback_threshold(&self) -> ConvertingReceiver<ResistanceCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetResistanceCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_temperature_reached_callback_receiver`],
    /// * [`get_resistance_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_temperature_callback_threshold`],
    /// * [`set_resistance_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(PtcBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the noise rejection filter to either 50Hz (0) or 60Hz (1).
    /// Noise from 50Hz or 60Hz power sources (including
    /// harmonics of the AC power's fundamental frequency) is
    /// attenuated by 82dB.
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_FILTER_OPTION_50HZ
    ///	* PTC_BRICKLET_FILTER_OPTION_60HZ
    pub fn set_noise_rejection_filter(&self, filter: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(filter));

        self.device.set(u8::from(PtcBrickletFunction::SetNoiseRejectionFilter), payload)
    }

    /// Returns the noise rejection filter option as set by
    /// [`set_noise_rejection_filter`]
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_FILTER_OPTION_50HZ
    ///	* PTC_BRICKLET_FILTER_OPTION_60HZ
    pub fn get_noise_rejection_filter(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetNoiseRejectionFilter), payload)
    }

    /// Returns *true* if the sensor is connected correctly.
    ///
    /// If this function
    /// returns *false*, there is either no Pt100 or Pt1000 sensor connected,
    /// the sensor is connected incorrectly or the sensor itself is faulty.
    pub fn is_sensor_connected(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::IsSensorConnected), payload)
    }

    /// Sets the wire mode of the sensor. Possible values are 2, 3 and 4 which
    /// correspond to 2-, 3- and 4-wire sensors. The value has to match the jumper
    /// configuration on the Bricklet.
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_WIRE_MODE_2
    ///	* PTC_BRICKLET_WIRE_MODE_3
    ///	* PTC_BRICKLET_WIRE_MODE_4
    pub fn set_wire_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(PtcBrickletFunction::SetWireMode), payload)
    }

    /// Returns the wire mode as set by [`set_wire_mode`]
    ///
    /// Associated constants:
    /// * PTC_BRICKLET_WIRE_MODE_2
    ///	* PTC_BRICKLET_WIRE_MODE_3
    ///	* PTC_BRICKLET_WIRE_MODE_4
    pub fn get_wire_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetWireMode), payload)
    }

    /// If you enable this receiver, the [`get_sensor_connected_callback_receiver`] receiver is triggered
    /// every time a Pt sensor is connected/disconnected.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_sensor_connected_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(PtcBrickletFunction::SetSensorConnectedCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_sensor_connected_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_sensor_connected_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetSensorConnectedCallbackConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PtcBrickletFunction::GetIdentity), payload)
    }
}
