/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives one brushed DC motor with up to 36V and 10A.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/PerformanceDC_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum PerformanceDcBrickletFunction {
    SetEnabled,
    GetEnabled,
    SetVelocity,
    GetVelocity,
    GetCurrentVelocity,
    SetMotion,
    GetMotion,
    FullBrake,
    SetDriveMode,
    GetDriveMode,
    SetPwmFrequency,
    GetPwmFrequency,
    GetPowerStatistics,
    SetThermalShutdown,
    GetThermalShutdown,
    SetGpioConfiguration,
    GetGpioConfiguration,
    SetGpioAction,
    GetGpioAction,
    GetGpioState,
    SetErrorLedConfig,
    GetErrorLedConfig,
    SetCwLedConfig,
    GetCwLedConfig,
    SetCcwLedConfig,
    GetCcwLedConfig,
    SetGpioLedConfig,
    GetGpioLedConfig,
    SetEmergencyShutdownCallbackConfiguration,
    GetEmergencyShutdownCallbackConfiguration,
    SetVelocityReachedCallbackConfiguration,
    GetVelocityReachedCallbackConfiguration,
    SetCurrentVelocityCallbackConfiguration,
    GetCurrentVelocityCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackEmergencyShutdown,
    CallbackVelocityReached,
    CallbackCurrentVelocity,
    CallbackGpioState,
}
impl From<PerformanceDcBrickletFunction> for u8 {
    fn from(fun: PerformanceDcBrickletFunction) -> Self {
        match fun {
            PerformanceDcBrickletFunction::SetEnabled => 1,
            PerformanceDcBrickletFunction::GetEnabled => 2,
            PerformanceDcBrickletFunction::SetVelocity => 3,
            PerformanceDcBrickletFunction::GetVelocity => 4,
            PerformanceDcBrickletFunction::GetCurrentVelocity => 5,
            PerformanceDcBrickletFunction::SetMotion => 6,
            PerformanceDcBrickletFunction::GetMotion => 7,
            PerformanceDcBrickletFunction::FullBrake => 8,
            PerformanceDcBrickletFunction::SetDriveMode => 9,
            PerformanceDcBrickletFunction::GetDriveMode => 10,
            PerformanceDcBrickletFunction::SetPwmFrequency => 11,
            PerformanceDcBrickletFunction::GetPwmFrequency => 12,
            PerformanceDcBrickletFunction::GetPowerStatistics => 13,
            PerformanceDcBrickletFunction::SetThermalShutdown => 14,
            PerformanceDcBrickletFunction::GetThermalShutdown => 15,
            PerformanceDcBrickletFunction::SetGpioConfiguration => 16,
            PerformanceDcBrickletFunction::GetGpioConfiguration => 17,
            PerformanceDcBrickletFunction::SetGpioAction => 18,
            PerformanceDcBrickletFunction::GetGpioAction => 19,
            PerformanceDcBrickletFunction::GetGpioState => 20,
            PerformanceDcBrickletFunction::SetErrorLedConfig => 21,
            PerformanceDcBrickletFunction::GetErrorLedConfig => 22,
            PerformanceDcBrickletFunction::SetCwLedConfig => 23,
            PerformanceDcBrickletFunction::GetCwLedConfig => 24,
            PerformanceDcBrickletFunction::SetCcwLedConfig => 25,
            PerformanceDcBrickletFunction::GetCcwLedConfig => 26,
            PerformanceDcBrickletFunction::SetGpioLedConfig => 27,
            PerformanceDcBrickletFunction::GetGpioLedConfig => 28,
            PerformanceDcBrickletFunction::SetEmergencyShutdownCallbackConfiguration => 29,
            PerformanceDcBrickletFunction::GetEmergencyShutdownCallbackConfiguration => 30,
            PerformanceDcBrickletFunction::SetVelocityReachedCallbackConfiguration => 31,
            PerformanceDcBrickletFunction::GetVelocityReachedCallbackConfiguration => 32,
            PerformanceDcBrickletFunction::SetCurrentVelocityCallbackConfiguration => 33,
            PerformanceDcBrickletFunction::GetCurrentVelocityCallbackConfiguration => 34,
            PerformanceDcBrickletFunction::GetSpitfpErrorCount => 234,
            PerformanceDcBrickletFunction::SetBootloaderMode => 235,
            PerformanceDcBrickletFunction::GetBootloaderMode => 236,
            PerformanceDcBrickletFunction::SetWriteFirmwarePointer => 237,
            PerformanceDcBrickletFunction::WriteFirmware => 238,
            PerformanceDcBrickletFunction::SetStatusLedConfig => 239,
            PerformanceDcBrickletFunction::GetStatusLedConfig => 240,
            PerformanceDcBrickletFunction::GetChipTemperature => 242,
            PerformanceDcBrickletFunction::Reset => 243,
            PerformanceDcBrickletFunction::WriteUid => 248,
            PerformanceDcBrickletFunction::ReadUid => 249,
            PerformanceDcBrickletFunction::GetIdentity => 255,
            PerformanceDcBrickletFunction::CallbackEmergencyShutdown => 35,
            PerformanceDcBrickletFunction::CallbackVelocityReached => 36,
            PerformanceDcBrickletFunction::CallbackCurrentVelocity => 37,
            PerformanceDcBrickletFunction::CallbackGpioState => 38,
        }
    }
}
pub const PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_BRAKE: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_COAST: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NONE: u32 = 0;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE: u32 = 1;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE: u32 = 2;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE: u32 = 4;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE: u32 = 8;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE: u32 = 16;
pub const PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE: u32 = 32;
pub const PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_OFF: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_ON: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_OFF: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_ON: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_FORWARD: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_BACKWARD: u8 = 4;
pub const PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_OFF: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_ON: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_FORWARD: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_BACKWARD: u8 = 4;
pub const PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_OFF: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_ON: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_HIGH: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_LOW: u8 = 4;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Motion {
    pub acceleration: u16,
    pub deceleration: u16,
}
impl FromByteSlice for Motion {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Motion {
        Motion { acceleration: <u16>::from_le_byte_slice(&bytes[0..2]), deceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PowerStatistics {
    pub voltage: u16,
    pub current: u16,
    pub temperature: i16,
}
impl FromByteSlice for PowerStatistics {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> PowerStatistics {
        PowerStatistics {
            voltage: <u16>::from_le_byte_slice(&bytes[0..2]),
            current: <u16>::from_le_byte_slice(&bytes[2..4]),
            temperature: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GpioConfiguration {
    pub debounce: u16,
    pub stop_deceleration: u16,
}
impl FromByteSlice for GpioConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> GpioConfiguration {
        GpioConfiguration { debounce: <u16>::from_le_byte_slice(&bytes[0..2]), stop_deceleration: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentVelocityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for CurrentVelocityCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentVelocityCallbackConfiguration {
        CurrentVelocityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives one brushed DC motor with up to 36V and 10A
#[derive(Clone)]
pub struct PerformanceDcBricklet {
    device: Device,
}
impl PerformanceDcBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2156;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Performance DC Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> PerformanceDcBricklet {
        let mut result = PerformanceDcBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetEnabled) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetCurrentVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetMotion) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetMotion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetDriveMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetDriveMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetPwmFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetPwmFrequency) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetPowerStatistics) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetThermalShutdown) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetThermalShutdown) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetGpioConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetGpioConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetGpioAction) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetGpioAction) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetGpioState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetErrorLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetErrorLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetCwLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetCwLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetCcwLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetCcwLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetGpioLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetGpioLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetEmergencyShutdownCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetEmergencyShutdownCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetVelocityReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetVelocityReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetCurrentVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetCurrentVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(PerformanceDcBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::performance_dc_bricklet::PerformanceDcBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::performance_dc_bricklet::PerformanceDcBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: PerformanceDcBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: PerformanceDcBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered if either the current consumption
    /// is too high or the temperature of the driver chip is too high
    /// (above 150°C) or the user defined thermal shutdown is triggered (see [`set_thermal_shutdown`]).
    /// n case of a voltage below 6V (input voltage) this
    /// receiver is triggered as well.
    ///
    /// If this receiver is triggered, the driver chip gets disabled at the same time.
    /// That means, [`set_enabled`] has to be called to drive the motor again.
    ///
    /// [`set_enabled`]: #method.set_enabled
    /// [`set_thermal_shutdown`]: #method.set_thermal_shutdown
    pub fn get_emergency_shutdown_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(PerformanceDcBrickletFunction::CallbackEmergencyShutdown))
    }

    /// This receiver is triggered whenever a set velocity is reached. For example:
    /// If a velocity of 0 is present, acceleration is set to 5000 and velocity
    /// to 10000, the [`get_velocity_reached_callback_receiver`] receiver will be triggered after about
    /// 2 seconds, when the set velocity is actually reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the DC motor, this only works if the
    ///  acceleration (see [`set_motion`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_velocity_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(PerformanceDcBrickletFunction::CallbackVelocityReached))
    }

    /// This receiver is triggered with the period that is set by
    /// [`set_current_velocity_callback_configuration`]. The parameter is the *current*
    /// velocity used by the motor.
    ///
    /// The [`get_current_velocity_callback_receiver`] receiver is only triggered after the set period
    /// if there is a change in the velocity.
    pub fn get_current_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(PerformanceDcBrickletFunction::CallbackCurrentVelocity))
    }

    /// This receiver is triggered by GPIO changes if it is activated through [`set_gpio_action`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_gpio_state_callback_receiver(&self) -> ConvertingCallbackReceiver<[bool; 2]> {
        self.device.get_callback_receiver(u8::from(PerformanceDcBrickletFunction::CallbackGpioState))
    }

    /// Enables/Disables the driver chip. The driver parameters can be configured
    /// (velocity, acceleration, etc) before it is enabled.
    pub fn set_enabled(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetEnabled), payload)
    }

    /// Returns *true* if the driver chip is enabled, *false* otherwise.
    pub fn get_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetEnabled), payload)
    }

    /// Sets the velocity of the motor. Whereas -32767 is full speed backward,
    /// 0 is stop and 32767 is full speed forward. Depending on the
    /// acceleration (see [`set_motion`]), the motor is not immediately
    /// brought to the velocity but smoothly accelerated.
    ///
    /// The velocity describes the duty cycle of the PWM with which the motor is
    /// controlled, e.g. a velocity of 3277 sets a PWM with a 10% duty cycle.
    /// You can not only control the duty cycle of the PWM but also the frequency,
    /// see [`set_pwm_frequency`].
    pub fn set_velocity(&self, velocity: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetVelocity), payload)
    }

    /// Returns the velocity as set by [`set_velocity`].
    pub fn get_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetVelocity), payload)
    }

    /// Returns the *current* velocity of the motor. This value is different
    /// from [`get_velocity`] whenever the motor is currently accelerating
    /// to a goal set by [`set_velocity`].
    pub fn get_current_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration and deceleration of the motor. It is given in *velocity/s*.
    /// An acceleration of 10000 means, that every second the velocity is increased
    /// by 10000 (or about 30% duty cycle).
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 16000 (about 50% duty cycle) in 10 seconds, you should set
    /// an acceleration of 1600.
    ///
    /// If acceleration and deceleration is set to 0, there is no speed ramping, i.e. a
    /// new velocity is immediately given to the motor.
    pub fn set_motion(&self, acceleration: u16, deceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(deceleration));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetMotion), payload)
    }

    /// Returns the acceleration/deceleration as set by [`set_motion`].
    pub fn get_motion(&self) -> ConvertingReceiver<Motion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetMotion), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`set_velocity`] with 0 if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(PerformanceDcBrickletFunction::FullBrake), payload)
    }

    /// Sets the drive mode. Possible modes are:
    ///
    /// * 0 = Drive/Brake
    /// * 1 = Drive/Coast
    ///
    /// These modes are different kinds of motor controls.
    ///
    /// In Drive/Brake mode, the motor is always either driving or braking. There
    /// is no freewheeling. Advantages are: A more linear correlation between
    /// PWM and velocity, more exact accelerations and the possibility to drive
    /// with slower velocities.
    ///
    /// In Drive/Coast mode, the motor is always either driving or freewheeling.
    /// Advantages are: Less current consumption and less demands on the motor and
    /// driver chip.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_BRAKE
    ///	* PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_COAST
    pub fn set_drive_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetDriveMode), payload)
    }

    /// Returns the drive mode, as set by [`set_drive_mode`].
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_BRAKE
    ///	* PERFORMANCE_DC_BRICKLET_DRIVE_MODE_DRIVE_COAST
    pub fn get_drive_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetDriveMode), payload)
    }

    /// Sets the frequency of the PWM with which the motor is driven.
    /// Often a high frequency
    /// is less noisy and the motor runs smoother. However, with a low frequency
    /// there are less switches and therefore fewer switching losses. Also with
    /// most motors lower frequencies enable higher torque.
    ///
    /// If you have no idea what all this means, just ignore this function and use
    /// the default frequency, it will very likely work fine.
    pub fn set_pwm_frequency(&self, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetPwmFrequency), payload)
    }

    /// Returns the PWM frequency as set by [`set_pwm_frequency`].
    pub fn get_pwm_frequency(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetPwmFrequency), payload)
    }

    /// Returns input voltage, current usage and temperature of the driver.
    pub fn get_power_statistics(&self) -> ConvertingReceiver<PowerStatistics> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetPowerStatistics), payload)
    }

    /// Sets a temperature threshold that is used for thermal shutdown.
    ///
    /// Additionally to this user defined threshold the driver chip will shut down at a
    /// temperature of 150°C.
    ///
    /// If a thermal shutdown is triggered the driver is disabled and has to be
    /// explicitly re-enabled with [`set_enabled`].
    pub fn set_thermal_shutdown(&self, temperature: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(temperature));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetThermalShutdown), payload)
    }

    /// Returns the thermal shutdown temperature as set by [`set_thermal_shutdown`].
    pub fn get_thermal_shutdown(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetThermalShutdown), payload)
    }

    /// Sets the GPIO configuration for the given channel.
    /// You can configure a debounce and the deceleration that is used if the action is
    /// configured as ``normal stop``. See [`set_gpio_action`].
    pub fn set_gpio_configuration(&self, channel: u8, debounce: u16, stop_deceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(debounce));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(stop_deceleration));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetGpioConfiguration), payload)
    }

    /// Returns the GPIO configuration for a channel as set by [`set_gpio_configuration`].
    pub fn get_gpio_configuration(&self, channel: u8) -> ConvertingReceiver<GpioConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetGpioConfiguration), payload)
    }

    /// Sets the GPIO action for the given channel.
    ///
    /// The action can be a normal stop, a full brake or a receiver. Each for a rising
    /// edge or falling edge. The actions are a bitmask they can be used at the same time.
    /// You can for example trigger a full brake and a receiver at the same time or for
    /// rising and falling edge.
    ///
    /// The deceleration speed for the normal stop can be configured with
    /// [`set_gpio_configuration`].
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NONE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE
    pub fn set_gpio_action(&self, channel: u8, action: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(action));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetGpioAction), payload)
    }

    /// Returns the GPIO action for a channel as set by [`set_gpio_action`].
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NONE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_NORMAL_STOP_FALLING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_FULL_BRAKE_FALLING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_RISING_EDGE
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_ACTION_CALLBACK_FALLING_EDGE
    pub fn get_gpio_action(&self, channel: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetGpioAction), payload)
    }

    /// Returns the GPIO state for both channels. True if the state is ``high`` and
    /// false if the state is ``low``.
    pub fn get_gpio_state(&self) -> ConvertingReceiver<[bool; 2]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetGpioState), payload)
    }

    /// Configures the error LED to be either turned off, turned on, blink in
    /// heartbeat mode or show an error.
    ///
    /// If the LED is configured to show errors it has three different states:
    ///
    /// * Off: No error present.
    /// * 1s interval blinking: Input voltage too low (below 6V).
    /// * 250ms interval blinking: Overtemperature or overcurrent.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn set_error_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetErrorLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_error_led_config`]
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_ERROR_LED_CONFIG_SHOW_ERROR
    pub fn get_error_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetErrorLedConfig), payload)
    }

    /// Configures the CW LED to be either turned off, turned on, blink in
    /// heartbeat mode or if the motor turn clockwise.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_FORWARD
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_BACKWARD
    pub fn set_cw_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetCwLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_cw_led_config`]
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_FORWARD
    ///	* PERFORMANCE_DC_BRICKLET_CW_LED_CONFIG_SHOW_CW_AS_BACKWARD
    pub fn get_cw_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetCwLedConfig), payload)
    }

    /// Configures the CCW LED to be either turned off, turned on, blink in
    /// heartbeat mode or if the motor turn counter-clockwise.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_FORWARD
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_BACKWARD
    pub fn set_ccw_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetCcwLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_ccw_led_config`]
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_FORWARD
    ///	* PERFORMANCE_DC_BRICKLET_CCW_LED_CONFIG_SHOW_CCW_AS_BACKWARD
    pub fn get_ccw_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetCcwLedConfig), payload)
    }

    /// Configures the GPIO LED to be either turned off, turned on, blink in
    /// heartbeat mode or the GPIO state.
    ///
    /// The GPIO LED can be configured for both channels.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_HIGH
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_LOW
    pub fn set_gpio_led_config(&self, channel: u8, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetGpioLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_gpio_led_config`]
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_HIGH
    ///	* PERFORMANCE_DC_BRICKLET_GPIO_LED_CONFIG_SHOW_GPIO_ACTIVE_LOW
    pub fn get_gpio_led_config(&self, channel: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetGpioLedConfig), payload)
    }

    /// Enable/Disable [`get_emergency_shutdown_callback_receiver`] receiver.
    pub fn set_emergency_shutdown_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetEmergencyShutdownCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_emergency_shutdown_callback_configuration`].
    pub fn get_emergency_shutdown_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetEmergencyShutdownCallbackConfiguration), payload)
    }

    /// Enable/Disable [`get_velocity_reached_callback_receiver`] receiver.
    pub fn set_velocity_reached_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetVelocityReachedCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_velocity_reached_callback_configuration`].
    pub fn get_velocity_reached_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetVelocityReachedCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_current_velocity_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_current_velocity_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetCurrentVelocityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_current_velocity_callback_configuration`].
    pub fn get_current_velocity_callback_configuration(&self) -> ConvertingReceiver<CurrentVelocityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetCurrentVelocityCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(PerformanceDcBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* PERFORMANCE_DC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(PerformanceDcBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(PerformanceDcBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* PERFORMANCE_DC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(PerformanceDcBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(PerformanceDcBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(PerformanceDcBrickletFunction::GetIdentity), payload)
    }
}
