/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 3.3cm (1.3") OLED display with 128x64 pixels.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/OLED128x64V2_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_receiver::{BrickletError, BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum Oled128x64V2BrickletFunction {
    WritePixelsLowLevel,
    ReadPixelsLowLevel,
    ClearDisplay,
    SetDisplayConfiguration,
    GetDisplayConfiguration,
    WriteLine,
    DrawBufferedFrame,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
}
impl From<Oled128x64V2BrickletFunction> for u8 {
    fn from(fun: Oled128x64V2BrickletFunction) -> Self {
        match fun {
            Oled128x64V2BrickletFunction::WritePixelsLowLevel => 1,
            Oled128x64V2BrickletFunction::ReadPixelsLowLevel => 2,
            Oled128x64V2BrickletFunction::ClearDisplay => 3,
            Oled128x64V2BrickletFunction::SetDisplayConfiguration => 4,
            Oled128x64V2BrickletFunction::GetDisplayConfiguration => 5,
            Oled128x64V2BrickletFunction::WriteLine => 6,
            Oled128x64V2BrickletFunction::DrawBufferedFrame => 7,
            Oled128x64V2BrickletFunction::GetSpitfpErrorCount => 234,
            Oled128x64V2BrickletFunction::SetBootloaderMode => 235,
            Oled128x64V2BrickletFunction::GetBootloaderMode => 236,
            Oled128x64V2BrickletFunction::SetWriteFirmwarePointer => 237,
            Oled128x64V2BrickletFunction::WriteFirmware => 238,
            Oled128x64V2BrickletFunction::SetStatusLedConfig => 239,
            Oled128x64V2BrickletFunction::GetStatusLedConfig => 240,
            Oled128x64V2BrickletFunction::GetChipTemperature => 242,
            Oled128x64V2BrickletFunction::Reset => 243,
            Oled128x64V2BrickletFunction::WriteUid => 248,
            Oled128x64V2BrickletFunction::ReadUid => 249,
            Oled128x64V2BrickletFunction::GetIdentity => 255,
        }
    }
}
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WritePixelsLowLevel {}
impl FromByteSlice for WritePixelsLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> WritePixelsLowLevel { WritePixelsLowLevel {} }
}
impl LowLevelWrite<WritePixelsResult> for WritePixelsLowLevel {
    fn ll_message_written(&self) -> usize { 448 }

    fn get_result(&self) -> WritePixelsResult { WritePixelsResult {} }
}

#[derive(Clone, Copy)]
pub struct ReadPixelsLowLevel {
    pub pixels_length: u16,
    pub pixels_chunk_offset: u16,
    pub pixels_chunk_data: [bool; 480],
}
impl FromByteSlice for ReadPixelsLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadPixelsLowLevel {
        ReadPixelsLowLevel {
            pixels_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            pixels_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            pixels_chunk_data: <[bool; 480]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<bool, ReadPixelsResult> for ReadPixelsLowLevel {
    fn ll_message_length(&self) -> usize { self.pixels_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.pixels_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[bool] { &self.pixels_chunk_data }

    fn get_result(&self) -> ReadPixelsResult { ReadPixelsResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DisplayConfiguration {
    pub contrast: u8,
    pub invert: bool,
    pub automatic_draw: bool,
}
impl FromByteSlice for DisplayConfiguration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> DisplayConfiguration {
        DisplayConfiguration {
            contrast: <u8>::from_le_byte_slice(&bytes[0..1]),
            invert: <bool>::from_le_byte_slice(&bytes[1..2]),
            automatic_draw: <bool>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct WritePixelsResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadPixelsResult {}

/// 3.3cm (1.3") OLED display with 128x64 pixels
#[derive(Clone)]
pub struct Oled128x64V2Bricklet {
    device: Device,
}
impl Oled128x64V2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2112;
    pub const DEVICE_DISPLAY_NAME: &'static str = "OLED 128x64 Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Oled128x64V2Bricklet {
        let mut result = Oled128x64V2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 2) };
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::WritePixelsLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::ReadPixelsLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::ClearDisplay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::SetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetDisplayConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::WriteLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::DrawBufferedFrame) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Oled128x64V2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::oled_128x64_v2_bricklet::Oled128x64V2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::oled_128x64_v2_bricklet::Oled128x64V2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Oled128x64V2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: Oled128x64V2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Writes pixels to the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels are directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the pixels are written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    ///
    /// [`set_display_configuration`]: #method.set_display_configuration
    /// [`draw_buffered_frame`]: #method.draw_buffered_frame
    pub fn write_pixels_low_level(
        &self,
        x_start: u8,
        y_start: u8,
        x_end: u8,
        y_end: u8,
        pixels_length: u16,
        pixels_chunk_offset: u16,
        pixels_chunk_data: [bool; 448],
    ) -> ConvertingReceiver<WritePixelsLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(y_end));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(pixels_length));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(pixels_chunk_offset));
        payload[8..64].copy_from_slice(&<[bool; 448]>::to_le_byte_vec(pixels_chunk_data));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::WritePixelsLowLevel), payload)
    }

    /// Writes pixels to the specified window.
    ///
    /// The pixels are written into the window line by line top to bottom
    /// and each line is written from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels are directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the pixels are written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn write_pixels(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8, pixels: &[bool]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(0, pixels, 65535, 448, &mut |length: usize, chunk_offset: usize, chunk: &[bool]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<bool>::default(); 448];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result =
                self.write_pixels_low_level(x_start, y_start, x_end, y_end, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Reads pixels from the specified window.
    ///
    /// The pixels are read from the window line by line top to bottom
    /// and each line is read from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels that are read are always the
    /// same that are shown on the display.
    ///
    /// If automatic draw is disabled the pixels are read from the internal buffer
    /// (see [`draw_buffered_frame`]).
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn read_pixels_low_level(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8) -> ConvertingReceiver<ReadPixelsLowLevel> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(x_start));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(y_start));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(x_end));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(y_end));

        self.device.get(u8::from(Oled128x64V2BrickletFunction::ReadPixelsLowLevel), payload)
    }

    /// Reads pixels from the specified window.
    ///
    /// The pixels are read from the window line by line top to bottom
    /// and each line is read from left to right.
    ///
    /// If automatic draw is enabled (default) the pixels that are read are always the
    /// same that are shown on the display.
    ///
    /// If automatic draw is disabled the pixels are read from the internal buffer
    /// (see [`draw_buffered_frame`]).
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn read_pixels(&self, x_start: u8, y_start: u8, x_end: u8, y_end: u8) -> Result<Vec<bool>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.read_pixels_low_level(x_start, y_start, x_end, y_end).recv())?;
        Ok(ll_result.0)
    }

    /// Clears the complete content of the display.
    ///
    /// If automatic draw is enabled (default) the pixels are directly cleared.
    ///
    /// If automatic draw is disabled the the internal buffer is cleared and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn clear_display(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Oled128x64V2BrickletFunction::ClearDisplay), payload)
    }

    /// Sets the configuration of the display.
    ///
    /// You can set a contrast value from 0 to 255 and you can invert the color
    /// (white/black) of the display.
    ///
    /// If automatic draw is set to *true*, the display is automatically updated with every
    /// call of [`write_pixels`] or [`write_line`]. If it is set to false, the
    /// changes are written into an internal buffer and only shown on the display after
    /// a call of [`draw_buffered_frame`].
    pub fn set_display_configuration(&self, contrast: u8, invert: bool, automatic_draw: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(contrast));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(invert));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(automatic_draw));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::SetDisplayConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_display_configuration`].
    pub fn get_display_configuration(&self) -> ConvertingReceiver<DisplayConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetDisplayConfiguration), payload)
    }

    /// Writes text to a specific line with a specific position.
    /// The text can have a maximum of 22 characters.
    ///
    /// For example: (1, 10, Hello) will write *Hello* in the middle of the
    /// second line of the display.
    ///
    /// The display uses a special 5x7 pixel charset. You can view the characters
    /// of the charset in Brick Viewer.
    ///
    /// If automatic draw is enabled (default) the text is directly written to
    /// the screen. Only pixels that have actually changed are updated on the screen,
    /// the rest stays the same.
    ///
    /// If automatic draw is disabled the text is written to an internal buffer and
    /// the buffer is transferred to the display only after [`draw_buffered_frame`]
    /// is called. This can be used to avoid flicker when drawing a complex frame in
    /// multiple steps.
    ///
    /// Automatic draw can be configured with the [`set_display_configuration`]
    /// function.
    pub fn write_line(&self, line: u8, position: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 24];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position));
        match <String>::try_to_le_byte_vec(text, 22) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[2..24].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Oled128x64V2BrickletFunction::WriteLine), payload)
    }

    /// Draws the currently buffered frame. Normally each call of [`write_pixels`] and
    /// [`write_line`] draws directly onto the display. If you turn automatic draw off
    /// ([`set_display_configuration`]), the data is written in an internal buffer and
    /// only transferred to the display by calling this function. This can be used to
    /// avoid flicker when drawing a complex frame in multiple steps.
    ///
    /// Set the `force complete redraw` to *true* to redraw the whole display
    /// instead of only the changed parts. Normally it should not be necessary to set this to
    /// *true*. It may only become necessary in case of stuck pixels because of errors.
    pub fn draw_buffered_frame(&self, force_complete_redraw: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(force_complete_redraw));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::DrawBufferedFrame), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(Oled128x64V2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* OLED_128X64_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(Oled128x64V2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* OLED_128X64_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Oled128x64V2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(Oled128x64V2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Oled128x64V2BrickletFunction::GetIdentity), payload)
    }
}
