/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! NFC tag read/write, NFC P2P and Card Emulation.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/NFC_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum NfcBrickletFunction {
    SetMode,
    GetMode,
    ReaderRequestTagId,
    ReaderGetTagIdLowLevel,
    ReaderGetState,
    ReaderWriteNdefLowLevel,
    ReaderRequestNdef,
    ReaderReadNdefLowLevel,
    ReaderAuthenticateMifareClassicPage,
    ReaderWritePageLowLevel,
    ReaderRequestPage,
    ReaderReadPageLowLevel,
    CardemuGetState,
    CardemuStartDiscovery,
    CardemuWriteNdefLowLevel,
    CardemuStartTransfer,
    P2pGetState,
    P2pStartDiscovery,
    P2pWriteNdefLowLevel,
    P2pStartTransfer,
    P2pReadNdefLowLevel,
    SetDetectionLedConfig,
    GetDetectionLedConfig,
    SetMaximumTimeout,
    GetMaximumTimeout,
    SimpleGetTagIdLowLevel,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackReaderStateChanged,
    CallbackCardemuStateChanged,
    CallbackP2pStateChanged,
}
impl From<NfcBrickletFunction> for u8 {
    fn from(fun: NfcBrickletFunction) -> Self {
        match fun {
            NfcBrickletFunction::SetMode => 1,
            NfcBrickletFunction::GetMode => 2,
            NfcBrickletFunction::ReaderRequestTagId => 3,
            NfcBrickletFunction::ReaderGetTagIdLowLevel => 4,
            NfcBrickletFunction::ReaderGetState => 5,
            NfcBrickletFunction::ReaderWriteNdefLowLevel => 6,
            NfcBrickletFunction::ReaderRequestNdef => 7,
            NfcBrickletFunction::ReaderReadNdefLowLevel => 8,
            NfcBrickletFunction::ReaderAuthenticateMifareClassicPage => 9,
            NfcBrickletFunction::ReaderWritePageLowLevel => 10,
            NfcBrickletFunction::ReaderRequestPage => 11,
            NfcBrickletFunction::ReaderReadPageLowLevel => 12,
            NfcBrickletFunction::CardemuGetState => 14,
            NfcBrickletFunction::CardemuStartDiscovery => 15,
            NfcBrickletFunction::CardemuWriteNdefLowLevel => 16,
            NfcBrickletFunction::CardemuStartTransfer => 17,
            NfcBrickletFunction::P2pGetState => 19,
            NfcBrickletFunction::P2pStartDiscovery => 20,
            NfcBrickletFunction::P2pWriteNdefLowLevel => 21,
            NfcBrickletFunction::P2pStartTransfer => 22,
            NfcBrickletFunction::P2pReadNdefLowLevel => 23,
            NfcBrickletFunction::SetDetectionLedConfig => 25,
            NfcBrickletFunction::GetDetectionLedConfig => 26,
            NfcBrickletFunction::SetMaximumTimeout => 27,
            NfcBrickletFunction::GetMaximumTimeout => 28,
            NfcBrickletFunction::SimpleGetTagIdLowLevel => 29,
            NfcBrickletFunction::GetSpitfpErrorCount => 234,
            NfcBrickletFunction::SetBootloaderMode => 235,
            NfcBrickletFunction::GetBootloaderMode => 236,
            NfcBrickletFunction::SetWriteFirmwarePointer => 237,
            NfcBrickletFunction::WriteFirmware => 238,
            NfcBrickletFunction::SetStatusLedConfig => 239,
            NfcBrickletFunction::GetStatusLedConfig => 240,
            NfcBrickletFunction::GetChipTemperature => 242,
            NfcBrickletFunction::Reset => 243,
            NfcBrickletFunction::WriteUid => 248,
            NfcBrickletFunction::ReadUid => 249,
            NfcBrickletFunction::GetIdentity => 255,
            NfcBrickletFunction::CallbackReaderStateChanged => 13,
            NfcBrickletFunction::CallbackCardemuStateChanged => 18,
            NfcBrickletFunction::CallbackP2pStateChanged => 24,
        }
    }
}
pub const NFC_BRICKLET_MODE_OFF: u8 = 0;
pub const NFC_BRICKLET_MODE_CARDEMU: u8 = 1;
pub const NFC_BRICKLET_MODE_P2P: u8 = 2;
pub const NFC_BRICKLET_MODE_READER: u8 = 3;
pub const NFC_BRICKLET_MODE_SIMPLE: u8 = 4;
pub const NFC_BRICKLET_TAG_TYPE_MIFARE_CLASSIC: u8 = 0;
pub const NFC_BRICKLET_TAG_TYPE_TYPE1: u8 = 1;
pub const NFC_BRICKLET_TAG_TYPE_TYPE2: u8 = 2;
pub const NFC_BRICKLET_TAG_TYPE_TYPE3: u8 = 3;
pub const NFC_BRICKLET_TAG_TYPE_TYPE4: u8 = 4;
pub const NFC_BRICKLET_READER_STATE_INITIALIZATION: u8 = 0;
pub const NFC_BRICKLET_READER_STATE_IDLE: u8 = 128;
pub const NFC_BRICKLET_READER_STATE_ERROR: u8 = 192;
pub const NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID: u8 = 2;
pub const NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID_READY: u8 = 130;
pub const NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID_ERROR: u8 = 194;
pub const NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE: u8 = 3;
pub const NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE_READY: u8 = 131;
pub const NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE_ERROR: u8 = 195;
pub const NFC_BRICKLET_READER_STATE_WRITE_PAGE: u8 = 4;
pub const NFC_BRICKLET_READER_STATE_WRITE_PAGE_READY: u8 = 132;
pub const NFC_BRICKLET_READER_STATE_WRITE_PAGE_ERROR: u8 = 196;
pub const NFC_BRICKLET_READER_STATE_REQUEST_PAGE: u8 = 5;
pub const NFC_BRICKLET_READER_STATE_REQUEST_PAGE_READY: u8 = 133;
pub const NFC_BRICKLET_READER_STATE_REQUEST_PAGE_ERROR: u8 = 197;
pub const NFC_BRICKLET_READER_STATE_WRITE_NDEF: u8 = 6;
pub const NFC_BRICKLET_READER_STATE_WRITE_NDEF_READY: u8 = 134;
pub const NFC_BRICKLET_READER_STATE_WRITE_NDEF_ERROR: u8 = 198;
pub const NFC_BRICKLET_READER_STATE_REQUEST_NDEF: u8 = 7;
pub const NFC_BRICKLET_READER_STATE_REQUEST_NDEF_READY: u8 = 135;
pub const NFC_BRICKLET_READER_STATE_REQUEST_NDEF_ERROR: u8 = 199;
pub const NFC_BRICKLET_KEY_A: u8 = 0;
pub const NFC_BRICKLET_KEY_B: u8 = 1;
pub const NFC_BRICKLET_READER_WRITE_TYPE4_CAPABILITY_CONTAINER: u16 = 3;
pub const NFC_BRICKLET_READER_WRITE_TYPE4_NDEF: u16 = 4;
pub const NFC_BRICKLET_READER_REQUEST_TYPE4_CAPABILITY_CONTAINER: u16 = 3;
pub const NFC_BRICKLET_READER_REQUEST_TYPE4_NDEF: u16 = 4;
pub const NFC_BRICKLET_CARDEMU_STATE_INITIALIZATION: u8 = 0;
pub const NFC_BRICKLET_CARDEMU_STATE_IDLE: u8 = 128;
pub const NFC_BRICKLET_CARDEMU_STATE_ERROR: u8 = 192;
pub const NFC_BRICKLET_CARDEMU_STATE_DISCOVER: u8 = 2;
pub const NFC_BRICKLET_CARDEMU_STATE_DISCOVER_READY: u8 = 130;
pub const NFC_BRICKLET_CARDEMU_STATE_DISCOVER_ERROR: u8 = 194;
pub const NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF: u8 = 3;
pub const NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF_READY: u8 = 131;
pub const NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF_ERROR: u8 = 195;
pub const NFC_BRICKLET_CARDEMU_TRANSFER_ABORT: u8 = 0;
pub const NFC_BRICKLET_CARDEMU_TRANSFER_WRITE: u8 = 1;
pub const NFC_BRICKLET_P2P_STATE_INITIALIZATION: u8 = 0;
pub const NFC_BRICKLET_P2P_STATE_IDLE: u8 = 128;
pub const NFC_BRICKLET_P2P_STATE_ERROR: u8 = 192;
pub const NFC_BRICKLET_P2P_STATE_DISCOVER: u8 = 2;
pub const NFC_BRICKLET_P2P_STATE_DISCOVER_READY: u8 = 130;
pub const NFC_BRICKLET_P2P_STATE_DISCOVER_ERROR: u8 = 194;
pub const NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF: u8 = 3;
pub const NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF_READY: u8 = 131;
pub const NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF_ERROR: u8 = 195;
pub const NFC_BRICKLET_P2P_TRANSFER_ABORT: u8 = 0;
pub const NFC_BRICKLET_P2P_TRANSFER_WRITE: u8 = 1;
pub const NFC_BRICKLET_P2P_TRANSFER_READ: u8 = 2;
pub const NFC_BRICKLET_DETECTION_LED_CONFIG_OFF: u8 = 0;
pub const NFC_BRICKLET_DETECTION_LED_CONFIG_ON: u8 = 1;
pub const NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_DETECTION: u8 = 3;
pub const NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const NFC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const NFC_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const NFC_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderGetTagIdLowLevel {
    pub tag_type: u8,
    pub tag_id_length: u8,
    pub tag_id_data: [u8; 32],
}
impl FromByteSlice for ReaderGetTagIdLowLevel {
    fn bytes_expected() -> usize { 34 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReaderGetTagIdLowLevel {
        ReaderGetTagIdLowLevel {
            tag_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            tag_id_length: <u8>::from_le_byte_slice(&bytes[1..2]),
            tag_id_data: <[u8; 32]>::from_le_byte_slice(&bytes[2..34]),
        }
    }
}
impl LowLevelRead<u8, ReaderGetTagIdResult> for ReaderGetTagIdLowLevel {
    fn ll_message_length(&self) -> usize { self.tag_id_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.tag_id_data }

    fn get_result(&self) -> ReaderGetTagIdResult { ReaderGetTagIdResult { tag_type: self.tag_type } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderGetState {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for ReaderGetState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReaderGetState {
        ReaderGetState { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderWriteNdefLowLevel {}
impl FromByteSlice for ReaderWriteNdefLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ReaderWriteNdefLowLevel { ReaderWriteNdefLowLevel {} }
}
impl LowLevelWrite<ReaderWriteNdefResult> for ReaderWriteNdefLowLevel {
    fn ll_message_written(&self) -> usize { 60 }

    fn get_result(&self) -> ReaderWriteNdefResult { ReaderWriteNdefResult {} }
}

#[derive(Clone, Copy)]
pub struct ReaderReadNdefLowLevel {
    pub ndef_length: u16,
    pub ndef_chunk_offset: u16,
    pub ndef_chunk_data: [u8; 60],
}
impl FromByteSlice for ReaderReadNdefLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReaderReadNdefLowLevel {
        ReaderReadNdefLowLevel {
            ndef_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            ndef_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            ndef_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, ReaderReadNdefResult> for ReaderReadNdefLowLevel {
    fn ll_message_length(&self) -> usize { self.ndef_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.ndef_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.ndef_chunk_data }

    fn get_result(&self) -> ReaderReadNdefResult { ReaderReadNdefResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderWritePageLowLevel {}
impl FromByteSlice for ReaderWritePageLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> ReaderWritePageLowLevel { ReaderWritePageLowLevel {} }
}
impl LowLevelWrite<ReaderWritePageResult> for ReaderWritePageLowLevel {
    fn ll_message_written(&self) -> usize { 58 }

    fn get_result(&self) -> ReaderWritePageResult { ReaderWritePageResult {} }
}

#[derive(Clone, Copy)]
pub struct ReaderReadPageLowLevel {
    pub data_length: u16,
    pub data_chunk_offset: u16,
    pub data_chunk_data: [u8; 60],
}
impl FromByteSlice for ReaderReadPageLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReaderReadPageLowLevel {
        ReaderReadPageLowLevel {
            data_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            data_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            data_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, ReaderReadPageResult> for ReaderReadPageLowLevel {
    fn ll_message_length(&self) -> usize { self.data_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.data_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.data_chunk_data }

    fn get_result(&self) -> ReaderReadPageResult { ReaderReadPageResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderStateChangedEvent {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for ReaderStateChangedEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReaderStateChangedEvent {
        ReaderStateChangedEvent { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CardemuGetState {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for CardemuGetState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> CardemuGetState {
        CardemuGetState { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CardemuWriteNdefLowLevel {}
impl FromByteSlice for CardemuWriteNdefLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> CardemuWriteNdefLowLevel { CardemuWriteNdefLowLevel {} }
}
impl LowLevelWrite<CardemuWriteNdefResult> for CardemuWriteNdefLowLevel {
    fn ll_message_written(&self) -> usize { 60 }

    fn get_result(&self) -> CardemuWriteNdefResult { CardemuWriteNdefResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CardemuStateChangedEvent {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for CardemuStateChangedEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> CardemuStateChangedEvent {
        CardemuStateChangedEvent { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct P2pGetState {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for P2pGetState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> P2pGetState {
        P2pGetState { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct P2pWriteNdefLowLevel {}
impl FromByteSlice for P2pWriteNdefLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> P2pWriteNdefLowLevel { P2pWriteNdefLowLevel {} }
}
impl LowLevelWrite<P2pWriteNdefResult> for P2pWriteNdefLowLevel {
    fn ll_message_written(&self) -> usize { 60 }

    fn get_result(&self) -> P2pWriteNdefResult { P2pWriteNdefResult {} }
}

#[derive(Clone, Copy)]
pub struct P2pReadNdefLowLevel {
    pub ndef_length: u16,
    pub ndef_chunk_offset: u16,
    pub ndef_chunk_data: [u8; 60],
}
impl FromByteSlice for P2pReadNdefLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> P2pReadNdefLowLevel {
        P2pReadNdefLowLevel {
            ndef_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            ndef_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            ndef_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, P2pReadNdefResult> for P2pReadNdefLowLevel {
    fn ll_message_length(&self) -> usize { self.ndef_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.ndef_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.ndef_chunk_data }

    fn get_result(&self) -> P2pReadNdefResult { P2pReadNdefResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct P2pStateChangedEvent {
    pub state: u8,
    pub idle: bool,
}
impl FromByteSlice for P2pStateChangedEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> P2pStateChangedEvent {
        P2pStateChangedEvent { state: <u8>::from_le_byte_slice(&bytes[0..1]), idle: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SimpleGetTagIdLowLevel {
    pub tag_type: u8,
    pub tag_id_length: u8,
    pub tag_id_data: [u8; 10],
    pub last_seen: u32,
}
impl FromByteSlice for SimpleGetTagIdLowLevel {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SimpleGetTagIdLowLevel {
        SimpleGetTagIdLowLevel {
            tag_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            tag_id_length: <u8>::from_le_byte_slice(&bytes[1..2]),
            tag_id_data: <[u8; 10]>::from_le_byte_slice(&bytes[2..12]),
            last_seen: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}
impl LowLevelRead<u8, SimpleGetTagIdResult> for SimpleGetTagIdLowLevel {
    fn ll_message_length(&self) -> usize { self.tag_id_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.tag_id_data }

    fn get_result(&self) -> SimpleGetTagIdResult { SimpleGetTagIdResult { tag_type: self.tag_type, last_seen: self.last_seen } }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderGetTagIdResult {
    pub tag_type: u8,
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderWriteNdefResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderReadNdefResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderWritePageResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReaderReadPageResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CardemuWriteNdefResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct P2pWriteNdefResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct P2pReadNdefResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SimpleGetTagIdResult {
    pub tag_type: u8,
    pub last_seen: u32,
}

/// NFC tag read/write, NFC P2P and Card Emulation
#[derive(Clone)]
pub struct NfcBricklet {
    device: Device,
}
impl NfcBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 286;
    pub const DEVICE_DISPLAY_NAME: &'static str = "NFC Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> NfcBricklet {
        let mut result = NfcBricklet { device: Device::new([2, 0, 2], uid, req_sender, 9) };
        result.device.response_expected[u8::from(NfcBrickletFunction::SetMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderRequestTagId) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderGetTagIdLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderGetState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderWriteNdefLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderRequestNdef) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderReadNdefLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderAuthenticateMifareClassicPage) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderWritePageLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderRequestPage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReaderReadPageLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::CardemuGetState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::CardemuStartDiscovery) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::CardemuWriteNdefLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(NfcBrickletFunction::CardemuStartTransfer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::P2pGetState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::P2pStartDiscovery) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::P2pWriteNdefLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(NfcBrickletFunction::P2pStartTransfer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::P2pReadNdefLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SetDetectionLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetDetectionLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SetMaximumTimeout) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetMaximumTimeout) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SimpleGetTagIdLowLevel) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(NfcBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(NfcBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::nfc_bricklet::NfcBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::nfc_bricklet::NfcBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: NfcBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: NfcBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called if the reader state of the NFC Bricklet changes.
    /// See [`reader_get_state`] for more information about the possible states.
    ///
    /// [`reader_get_state`]: #method.reader_get_state
    pub fn get_reader_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<ReaderStateChangedEvent> {
        self.device.get_callback_receiver(u8::from(NfcBrickletFunction::CallbackReaderStateChanged))
    }

    /// This receiver is called if the cardemu state of the NFC Bricklet changes.
    /// See [`cardemu_get_state`] for more information about the possible states.
    pub fn get_cardemu_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<CardemuStateChangedEvent> {
        self.device.get_callback_receiver(u8::from(NfcBrickletFunction::CallbackCardemuStateChanged))
    }

    /// This receiver is called if the P2P state of the NFC Bricklet changes.
    /// See [`p2p_get_state`] for more information about the possible states.
    pub fn get_p2p_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<P2pStateChangedEvent> {
        self.device.get_callback_receiver(u8::from(NfcBrickletFunction::CallbackP2pStateChanged))
    }

    /// Sets the mode. The NFC Bricklet supports four modes:
    ///
    /// * Off
    /// * Card Emulation (Cardemu): Emulates a tag for other readers
    /// * Peer to Peer (P2P): Exchange data with other readers
    /// * Reader: Reads and writes tags
    ///
    /// If you change a mode, the Bricklet will reconfigure the hardware for this mode.
    /// Therefore, you can only use functions corresponding to the current mode. For
    /// example, in Reader mode you can only use Reader functions.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_MODE_OFF
    ///	* NFC_BRICKLET_MODE_CARDEMU
    ///	* NFC_BRICKLET_MODE_P2P
    ///	* NFC_BRICKLET_MODE_READER
    ///	* NFC_BRICKLET_MODE_SIMPLE
    pub fn set_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(NfcBrickletFunction::SetMode), payload)
    }

    /// Returns the mode as set by [`set_mode`].
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_MODE_OFF
    ///	* NFC_BRICKLET_MODE_CARDEMU
    ///	* NFC_BRICKLET_MODE_P2P
    ///	* NFC_BRICKLET_MODE_READER
    ///	* NFC_BRICKLET_MODE_SIMPLE
    pub fn get_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetMode), payload)
    }

    /// After you call [`reader_request_tag_id`] the NFC Bricklet will try to read
    /// the tag ID from the tag. After this process is done the state will change.
    /// You can either register the [`get_reader_state_changed_callback_receiver`] receiver or you can poll
    /// [`reader_get_state`] to find out about the state change.
    ///
    /// If the state changes to *ReaderRequestTagIDError* it means that either there was
    /// no tag present or that the tag has an incompatible type. If the state
    /// changes to *ReaderRequestTagIDReady* it means that a compatible tag was found
    /// and that the tag ID has been saved. You can now read out the tag ID by
    /// calling [`reader_get_tag_id`].
    ///
    /// If two tags are in the proximity of the NFC Bricklet, this
    /// function will cycle through the tags. To select a specific tag you have
    /// to call [`reader_request_tag_id`] until the correct tag ID is found.
    ///
    /// In case of any *ReaderError* state the selection is lost and you have to
    /// start again by calling [`reader_request_tag_id`].
    pub fn reader_request_tag_id(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(NfcBrickletFunction::ReaderRequestTagId), payload)
    }

    /// Returns the tag type and the tag ID. This function can only be called if the
    /// NFC Bricklet is currently in one of the *ReaderReady* states. The returned tag ID
    /// is the tag ID that was saved through the last call of [`reader_request_tag_id`].
    ///
    /// To get the tag ID of a tag the approach is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. Call [`reader_get_tag_id`]
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_TAG_TYPE_MIFARE_CLASSIC
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE1
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE2
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE3
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE4
    pub fn reader_get_tag_id_low_level(&self) -> ConvertingReceiver<ReaderGetTagIdLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::ReaderGetTagIdLowLevel), payload)
    }

    /// Returns the tag type and the tag ID. This function can only be called if the
    /// NFC Bricklet is currently in one of the *ReaderReady* states. The returned tag ID
    /// is the tag ID that was saved through the last call of [`reader_request_tag_id`].
    ///
    /// To get the tag ID of a tag the approach is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. Call [`reader_get_tag_id`]
    pub fn reader_get_tag_id(&self) -> Result<(Vec<u8>, u8), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(0, &mut || self.reader_get_tag_id_low_level().recv())?;
        Ok((ll_result.0, ll_result.1.tag_type))
    }

    /// Returns the current reader state of the NFC Bricklet.
    ///
    /// On startup the Bricklet will be in the *ReaderInitialization* state. The
    /// initialization will only take about 20ms. After that it changes to *ReaderIdle*.
    ///
    /// The Bricklet is also reinitialized if the mode is changed, see [`set_mode`].
    ///
    /// The functions of this Bricklet can be called in the *ReaderIdle* state and all of
    /// the *ReaderReady* and *ReaderError* states.
    ///
    /// Example: If you call [`reader_request_page`], the state will change to
    /// *ReaderRequestPage* until the reading of the page is finished. Then it will change
    /// to either *ReaderRequestPageReady* if it worked or to *ReaderRequestPageError* if it
    /// didn't. If the request worked you can get the page by calling [`reader_read_page`].
    ///
    /// The same approach is used analogously for the other API functions.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_READER_STATE_INITIALIZATION
    ///	* NFC_BRICKLET_READER_STATE_IDLE
    ///	* NFC_BRICKLET_READER_STATE_ERROR
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID_READY
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_TAG_ID_ERROR
    ///	* NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE
    ///	* NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE_READY
    ///	* NFC_BRICKLET_READER_STATE_AUTHENTICATE_MIFARE_CLASSIC_PAGE_ERROR
    ///	* NFC_BRICKLET_READER_STATE_WRITE_PAGE
    ///	* NFC_BRICKLET_READER_STATE_WRITE_PAGE_READY
    ///	* NFC_BRICKLET_READER_STATE_WRITE_PAGE_ERROR
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_PAGE
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_PAGE_READY
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_PAGE_ERROR
    ///	* NFC_BRICKLET_READER_STATE_WRITE_NDEF
    ///	* NFC_BRICKLET_READER_STATE_WRITE_NDEF_READY
    ///	* NFC_BRICKLET_READER_STATE_WRITE_NDEF_ERROR
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_NDEF
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_NDEF_READY
    ///	* NFC_BRICKLET_READER_STATE_REQUEST_NDEF_ERROR
    pub fn reader_get_state(&self) -> ConvertingReceiver<ReaderGetState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::ReaderGetState), payload)
    }

    /// Writes NDEF formated data.
    ///
    /// This function currently supports NFC Forum Type 2 and 4.
    ///
    /// The general approach for writing a NDEF message is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see
    ///    [`reader_get_state`] or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check
    ///    if the expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_write_ndef`] with the NDEF message that you want to write
    /// 5. Wait for state to change to *ReaderWriteNDEFReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    pub fn reader_write_ndef_low_level(
        &self,
        ndef_length: u16,
        ndef_chunk_offset: u16,
        ndef_chunk_data: [u8; 60],
    ) -> ConvertingReceiver<ReaderWriteNdefLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(ndef_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(ndef_chunk_offset));
        payload[4..64].copy_from_slice(&<[u8; 60]>::to_le_byte_vec(ndef_chunk_data));

        self.device.set(u8::from(NfcBrickletFunction::ReaderWriteNdefLowLevel), payload)
    }

    /// Writes NDEF formated data.
    ///
    /// This function currently supports NFC Forum Type 2 and 4.
    ///
    /// The general approach for writing a NDEF message is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see
    ///    [`reader_get_state`] or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check
    ///    if the expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_write_ndef`] with the NDEF message that you want to write
    /// 5. Wait for state to change to *ReaderWriteNDEFReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    pub fn reader_write_ndef(&self, ndef: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(1, ndef, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.reader_write_ndef_low_level(length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Reads NDEF formated data from a tag.
    ///
    /// This function currently supports NFC Forum Type 1, 2, 3 and 4.
    ///
    /// The general approach for reading a NDEF message is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_request_ndef`]
    /// 5. Wait for state to change to *ReaderRequestNDEFReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 6. Call [`reader_read_ndef`] to retrieve the NDEF message from the buffer
    pub fn reader_request_ndef(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(NfcBrickletFunction::ReaderRequestNdef), payload)
    }

    /// Returns the NDEF data from an internal buffer. To fill the buffer
    /// with a NDEF message you have to call [`reader_request_ndef`] beforehand.
    pub fn reader_read_ndef_low_level(&self) -> ConvertingReceiver<ReaderReadNdefLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::ReaderReadNdefLowLevel), payload)
    }

    /// Returns the NDEF data from an internal buffer. To fill the buffer
    /// with a NDEF message you have to call [`reader_request_ndef`] beforehand.
    pub fn reader_read_ndef(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(2, &mut || self.reader_read_ndef_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Mifare Classic tags use authentication. If you want to read from or write to
    /// a Mifare Classic page you have to authenticate it beforehand.
    /// Each page can be authenticated with two keys: A (``key_number`` = 0) and B
    /// (``key_number`` = 1). A new Mifare Classic
    /// tag that has not yet been written to can be accessed with key A
    /// and the default key ``[0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF]``.
    ///
    /// The approach to read or write a Mifare Classic page is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_authenticate_mifare_classic_page`] with page and key for the page
    /// 5. Wait for state to change to *ReaderAuthenticatingMifareClassicPageReady* (see
    ///    [`reader_get_state`] or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 6. Call [`reader_request_page`] or [`reader_write_page`] to read/write page
    ///
    /// The authentication will always work for one whole sector (4 pages).
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_KEY_A
    ///	* NFC_BRICKLET_KEY_B
    pub fn reader_authenticate_mifare_classic_page(&self, page: u16, key_number: u8, key: [u8; 6]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(key_number));
        payload[3..9].copy_from_slice(&<[u8; 6]>::to_le_byte_vec(key));

        self.device.set(u8::from(NfcBrickletFunction::ReaderAuthenticateMifareClassicPage), payload)
    }

    /// Writes a maximum of 8192 bytes starting from the given page. How many pages are written
    /// depends on the tag type. The page sizes are as follows:
    ///
    /// * Mifare Classic page size: 16 byte
    /// * NFC Forum Type 1 page size: 8 byte
    /// * NFC Forum Type 2 page size: 4 byte
    /// * NFC Forum Type 3 page size: 16 byte
    /// * NFC Forum Type 4: No pages, page = file selection (CC or NDEF, see below)
    ///
    /// The general approach for writing to a tag is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_write_page`] with page number and data
    /// 5. Wait for state to change to *ReaderWritePageReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    ///
    /// If you use a Mifare Classic tag you have to authenticate a page before you
    /// can write to it. See [`reader_authenticate_mifare_classic_page`].
    ///
    /// NFC Forum Type 4 tags are not organized into pages but different files. We currently
    /// support two files: Capability Container file (CC) and NDEF file.
    ///
    /// Choose CC by setting page to 3 or NDEF by setting page to 4.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_READER_WRITE_TYPE4_CAPABILITY_CONTAINER
    ///	* NFC_BRICKLET_READER_WRITE_TYPE4_NDEF
    pub fn reader_write_page_low_level(
        &self,
        page: u16,
        data_length: u16,
        data_chunk_offset: u16,
        data_chunk_data: [u8; 58],
    ) -> ConvertingReceiver<ReaderWritePageLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(data_length));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(data_chunk_offset));
        payload[6..64].copy_from_slice(&<[u8; 58]>::to_le_byte_vec(data_chunk_data));

        self.device.set(u8::from(NfcBrickletFunction::ReaderWritePageLowLevel), payload)
    }

    /// Writes a maximum of 8192 bytes starting from the given page. How many pages are written
    /// depends on the tag type. The page sizes are as follows:
    ///
    /// * Mifare Classic page size: 16 byte
    /// * NFC Forum Type 1 page size: 8 byte
    /// * NFC Forum Type 2 page size: 4 byte
    /// * NFC Forum Type 3 page size: 16 byte
    /// * NFC Forum Type 4: No pages, page = file selection (CC or NDEF, see below)
    ///
    /// The general approach for writing to a tag is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *ReaderRequestTagIDReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_write_page`] with page number and data
    /// 5. Wait for state to change to *ReaderWritePageReady* (see [`reader_get_state`] or
    ///    [`get_reader_state_changed_callback_receiver`] receiver)
    ///
    /// If you use a Mifare Classic tag you have to authenticate a page before you
    /// can write to it. See [`reader_authenticate_mifare_classic_page`].
    ///
    /// NFC Forum Type 4 tags are not organized into pages but different files. We currently
    /// support two files: Capability Container file (CC) and NDEF file.
    ///
    /// Choose CC by setting page to 3 or NDEF by setting page to 4.
    pub fn reader_write_page(&self, page: u16, data: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(3, data, 65535, 58, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 58];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.reader_write_page_low_level(page, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Reads a maximum of 8192 bytes starting from the given page and stores them into a buffer.
    /// The buffer can then be read out with [`reader_read_page`].
    /// How many pages are read depends on the tag type. The page sizes are
    /// as follows:
    ///
    /// * Mifare Classic page size: 16 byte
    /// * NFC Forum Type 1 page size: 8 byte
    /// * NFC Forum Type 2 page size: 4 byte
    /// * NFC Forum Type 3 page size: 16 byte
    /// * NFC Forum Type 4: No pages, page = file selection (CC or NDEF, see below)
    ///
    /// The general approach for reading a tag is as follows:
    ///
    /// 1. Call [`reader_request_tag_id`]
    /// 2. Wait for state to change to *RequestTagIDReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 3. If looking for a specific tag then call [`reader_get_tag_id`] and check if the
    ///    expected tag was found, if it was not found got back to step 1
    /// 4. Call [`reader_request_page`] with page number
    /// 5. Wait for state to change to *ReaderRequestPageReady* (see [`reader_get_state`]
    ///    or [`get_reader_state_changed_callback_receiver`] receiver)
    /// 6. Call [`reader_read_page`] to retrieve the page from the buffer
    ///
    /// If you use a Mifare Classic tag you have to authenticate a page before you
    /// can read it. See [`reader_authenticate_mifare_classic_page`].
    ///
    /// NFC Forum Type 4 tags are not organized into pages but different files. We currently
    /// support two files: Capability Container file (CC) and NDEF file.
    ///
    /// Choose CC by setting page to 3 or NDEF by setting page to 4.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_READER_REQUEST_TYPE4_CAPABILITY_CONTAINER
    ///	* NFC_BRICKLET_READER_REQUEST_TYPE4_NDEF
    pub fn reader_request_page(&self, page: u16, length: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(page));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(length));

        self.device.set(u8::from(NfcBrickletFunction::ReaderRequestPage), payload)
    }

    /// Returns the page data from an internal buffer. To fill the buffer
    /// with specific pages you have to call [`reader_request_page`] beforehand.
    pub fn reader_read_page_low_level(&self) -> ConvertingReceiver<ReaderReadPageLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::ReaderReadPageLowLevel), payload)
    }

    /// Returns the page data from an internal buffer. To fill the buffer
    /// with specific pages you have to call [`reader_request_page`] beforehand.
    pub fn reader_read_page(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(4, &mut || self.reader_read_page_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Returns the current cardemu state of the NFC Bricklet.
    ///
    /// On startup the Bricklet will be in the *CardemuInitialization* state. The
    /// initialization will only take about 20ms. After that it changes to *CardemuIdle*.
    ///
    /// The Bricklet is also reinitialized if the mode is changed, see [`set_mode`].
    ///
    /// The functions of this Bricklet can be called in the *CardemuIdle* state and all of
    /// the *CardemuReady* and *CardemuError* states.
    ///
    /// Example: If you call [`cardemu_start_discovery`], the state will change to
    /// *CardemuDiscover* until the discovery is finished. Then it will change
    /// to either *CardemuDiscoverReady* if it worked or to *CardemuDiscoverError* if it
    /// didn't.
    ///
    /// The same approach is used analogously for the other API functions.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_CARDEMU_STATE_INITIALIZATION
    ///	* NFC_BRICKLET_CARDEMU_STATE_IDLE
    ///	* NFC_BRICKLET_CARDEMU_STATE_ERROR
    ///	* NFC_BRICKLET_CARDEMU_STATE_DISCOVER
    ///	* NFC_BRICKLET_CARDEMU_STATE_DISCOVER_READY
    ///	* NFC_BRICKLET_CARDEMU_STATE_DISCOVER_ERROR
    ///	* NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF
    ///	* NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF_READY
    ///	* NFC_BRICKLET_CARDEMU_STATE_TRANSFER_NDEF_ERROR
    pub fn cardemu_get_state(&self) -> ConvertingReceiver<CardemuGetState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::CardemuGetState), payload)
    }

    /// Starts the discovery process. If you call this function while a NFC
    /// reader device is near to the NFC Bricklet the state will change from
    /// *CardemuDiscovery* to *CardemuDiscoveryReady*.
    ///
    /// If no NFC reader device can be found or if there is an error during
    /// discovery the cardemu state will change to *CardemuDiscoveryError*. In this case you
    /// have to restart the discovery process.
    ///
    /// If the cardemu state changes to *CardemuDiscoveryReady* you can start the NDEF message
    /// transfer with [`cardemu_write_ndef`] and [`cardemu_start_transfer`].
    pub fn cardemu_start_discovery(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(NfcBrickletFunction::CardemuStartDiscovery), payload)
    }

    /// Writes the NDEF message that is to be transferred to the NFC peer.
    ///
    /// The maximum supported NDEF message size in Cardemu mode is 255 byte.
    ///
    /// You can call this function at any time in Cardemu mode. The internal buffer
    /// will not be overwritten until you call this function again or change the
    /// mode.
    pub fn cardemu_write_ndef_low_level(
        &self,
        ndef_length: u16,
        ndef_chunk_offset: u16,
        ndef_chunk_data: [u8; 60],
    ) -> ConvertingReceiver<CardemuWriteNdefLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(ndef_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(ndef_chunk_offset));
        payload[4..64].copy_from_slice(&<[u8; 60]>::to_le_byte_vec(ndef_chunk_data));

        self.device.set(u8::from(NfcBrickletFunction::CardemuWriteNdefLowLevel), payload)
    }

    /// Writes the NDEF message that is to be transferred to the NFC peer.
    ///
    /// The maximum supported NDEF message size in Cardemu mode is 255 byte.
    ///
    /// You can call this function at any time in Cardemu mode. The internal buffer
    /// will not be overwritten until you call this function again or change the
    /// mode.
    pub fn cardemu_write_ndef(&self, ndef: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(5, ndef, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.cardemu_write_ndef_low_level(length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// You can start the transfer of a NDEF message if the cardemu state is *CardemuDiscoveryReady*.
    ///
    /// Before you call this function to start a write transfer, the NDEF message that
    /// is to be transferred has to be written via [`cardemu_write_ndef`] first.
    ///
    /// After you call this function the state will change to *CardemuTransferNDEF*. It will
    /// change to *CardemuTransferNDEFReady* if the transfer was successful or
    /// *CardemuTransferNDEFError* if it wasn't.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_CARDEMU_TRANSFER_ABORT
    ///	* NFC_BRICKLET_CARDEMU_TRANSFER_WRITE
    pub fn cardemu_start_transfer(&self, transfer: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(transfer));

        self.device.set(u8::from(NfcBrickletFunction::CardemuStartTransfer), payload)
    }

    /// Returns the current P2P state of the NFC Bricklet.
    ///
    /// On startup the Bricklet will be in the *P2PInitialization* state. The
    /// initialization will only take about 20ms. After that it changes to *P2PIdle*.
    ///
    /// The Bricklet is also reinitialized if the mode is changed, see [`set_mode`].
    ///
    /// The functions of this Bricklet can be called in the *P2PIdle* state and all of
    /// the *P2PReady* and *P2PError* states.
    ///
    /// Example: If you call [`p2p_start_discovery`], the state will change to
    /// *P2PDiscover* until the discovery is finished. Then it will change
    /// to either P2PDiscoverReady* if it worked or to *P2PDiscoverError* if it
    /// didn't.
    ///
    /// The same approach is used analogously for the other API functions.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_P2P_STATE_INITIALIZATION
    ///	* NFC_BRICKLET_P2P_STATE_IDLE
    ///	* NFC_BRICKLET_P2P_STATE_ERROR
    ///	* NFC_BRICKLET_P2P_STATE_DISCOVER
    ///	* NFC_BRICKLET_P2P_STATE_DISCOVER_READY
    ///	* NFC_BRICKLET_P2P_STATE_DISCOVER_ERROR
    ///	* NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF
    ///	* NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF_READY
    ///	* NFC_BRICKLET_P2P_STATE_TRANSFER_NDEF_ERROR
    pub fn p2p_get_state(&self) -> ConvertingReceiver<P2pGetState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::P2pGetState), payload)
    }

    /// Starts the discovery process. If you call this function while another NFC
    /// P2P enabled device is near to the NFC Bricklet the state will change from
    /// *P2PDiscovery* to *P2PDiscoveryReady*.
    ///
    /// If no NFC P2P enabled device can be found or if there is an error during
    /// discovery the P2P state will change to *P2PDiscoveryError*. In this case you
    /// have to restart the discovery process.
    ///
    /// If the P2P state changes to *P2PDiscoveryReady* you can start the NDEF message
    /// transfer with [`p2p_start_transfer`].
    pub fn p2p_start_discovery(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(NfcBrickletFunction::P2pStartDiscovery), payload)
    }

    /// Writes the NDEF message that is to be transferred to the NFC peer.
    ///
    /// The maximum supported NDEF message size for P2P transfer is 255 byte.
    ///
    /// You can call this function at any time in P2P mode. The internal buffer
    /// will not be overwritten until you call this function again, change the
    /// mode or use P2P to read an NDEF messages.
    pub fn p2p_write_ndef_low_level(
        &self,
        ndef_length: u16,
        ndef_chunk_offset: u16,
        ndef_chunk_data: [u8; 60],
    ) -> ConvertingReceiver<P2pWriteNdefLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(ndef_length));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(ndef_chunk_offset));
        payload[4..64].copy_from_slice(&<[u8; 60]>::to_le_byte_vec(ndef_chunk_data));

        self.device.set(u8::from(NfcBrickletFunction::P2pWriteNdefLowLevel), payload)
    }

    /// Writes the NDEF message that is to be transferred to the NFC peer.
    ///
    /// The maximum supported NDEF message size for P2P transfer is 255 byte.
    ///
    /// You can call this function at any time in P2P mode. The internal buffer
    /// will not be overwritten until you call this function again, change the
    /// mode or use P2P to read an NDEF messages.
    pub fn p2p_write_ndef(&self, ndef: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(6, ndef, 65535, 60, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 60];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.p2p_write_ndef_low_level(length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// You can start the transfer of a NDEF message if the P2P state is *P2PDiscoveryReady*.
    ///
    /// Before you call this function to start a write transfer, the NDEF message that
    /// is to be transferred has to be written via [`p2p_write_ndef`] first.
    ///
    /// After you call this function the P2P state will change to *P2PTransferNDEF*. It will
    /// change to *P2PTransferNDEFReady* if the transfer was successfull or
    /// *P2PTransferNDEFError* if it wasn't.
    ///
    /// If you started a write transfer you are now done. If you started a read transfer
    /// you can now use [`p2p_read_ndef`] to read the NDEF message that was written
    /// by the NFC peer.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_P2P_TRANSFER_ABORT
    ///	* NFC_BRICKLET_P2P_TRANSFER_WRITE
    ///	* NFC_BRICKLET_P2P_TRANSFER_READ
    pub fn p2p_start_transfer(&self, transfer: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(transfer));

        self.device.set(u8::from(NfcBrickletFunction::P2pStartTransfer), payload)
    }

    /// Returns the NDEF message that was written by a NFC peer in NFC P2P mode.
    ///
    /// The NDEF message is ready if you called [`p2p_start_transfer`] with a
    /// read transfer and the P2P state changed to *P2PTransferNDEFReady*.
    pub fn p2p_read_ndef_low_level(&self) -> ConvertingReceiver<P2pReadNdefLowLevel> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::P2pReadNdefLowLevel), payload)
    }

    /// Returns the NDEF message that was written by a NFC peer in NFC P2P mode.
    ///
    /// The NDEF message is ready if you called [`p2p_start_transfer`] with a
    /// read transfer and the P2P state changed to *P2PTransferNDEFReady*.
    pub fn p2p_read_ndef(&self) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(7, &mut || self.p2p_read_ndef_low_level().recv())?;
        Ok(ll_result.0)
    }

    /// Sets the detection LED configuration. By default the LED shows
    /// if a card/reader is detected.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_DETECTION_LED_CONFIG_OFF
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_ON
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_DETECTION
    pub fn set_detection_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(NfcBrickletFunction::SetDetectionLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_detection_led_config`]
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_DETECTION_LED_CONFIG_OFF
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_ON
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_HEARTBEAT
    ///	* NFC_BRICKLET_DETECTION_LED_CONFIG_SHOW_DETECTION
    pub fn get_detection_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetDetectionLedConfig), payload)
    }

    /// Sets the maximum timeout.
    ///
    /// This is a global maximum used for all internal state timeouts. The timeouts depend heavily
    /// on the used tags etc. For example: If you use a Type 2 tag and you want to detect if
    /// it is present, you have to use [`reader_request_tag_id`] and wait for the state
    /// to change to either the error state or the ready state.
    ///
    /// With the default configuration this takes 2-3 seconds. By setting the maximum timeout to
    /// 100ms you can reduce this time to ~150-200ms. For Type 2 this would also still work
    /// with a 20ms timeout (a Type 2 tag answers usually within 10ms). A type 4 tag can take
    /// up to 500ms in our tests.
    ///
    /// If you need a fast response time to discover if a tag is present or not you can find
    /// a good timeout value by trial and error for your specific tag.
    ///
    /// By default we use a very conservative timeout, to be sure that any tag can always
    /// answer in time.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn set_maximum_timeout(&self, timeout: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(timeout));

        self.device.set(u8::from(NfcBrickletFunction::SetMaximumTimeout), payload)
    }

    /// Returns the timeout as set by [`set_maximum_timeout`]
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_maximum_timeout(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetMaximumTimeout), payload)
    }

    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_TAG_TYPE_MIFARE_CLASSIC
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE1
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE2
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE3
    ///	* NFC_BRICKLET_TAG_TYPE_TYPE4
    pub fn simple_get_tag_id_low_level(&self, index: u8) -> ConvertingReceiver<SimpleGetTagIdLowLevel> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(NfcBrickletFunction::SimpleGetTagIdLowLevel), payload)
    }

    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn simple_get_tag_id(&self, index: u8) -> Result<(Vec<u8>, SimpleGetTagIdResult), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(8, &mut || self.simple_get_tag_id_low_level(index).recv())?;
        Ok((ll_result.0, ll_result.1))
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* NFC_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(NfcBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* NFC_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(NfcBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(NfcBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(NfcBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * NFC_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* NFC_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(NfcBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(NfcBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(NfcBrickletFunction::GetIdentity), payload)
    }
}
