/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Capacitive touch sensor for 12 electrodes.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/MultiTouchV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum MultiTouchV2BrickletFunction {
    GetTouchState,
    SetTouchStateCallbackConfiguration,
    GetTouchStateCallbackConfiguration,
    Recalibrate,
    SetElectrodeConfig,
    GetElectrodeConfig,
    SetElectrodeSensitivity,
    GetElectrodeSensitivity,
    SetTouchLedConfig,
    GetTouchLedConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackTouchState,
}
impl From<MultiTouchV2BrickletFunction> for u8 {
    fn from(fun: MultiTouchV2BrickletFunction) -> Self {
        match fun {
            MultiTouchV2BrickletFunction::GetTouchState => 1,
            MultiTouchV2BrickletFunction::SetTouchStateCallbackConfiguration => 2,
            MultiTouchV2BrickletFunction::GetTouchStateCallbackConfiguration => 3,
            MultiTouchV2BrickletFunction::Recalibrate => 5,
            MultiTouchV2BrickletFunction::SetElectrodeConfig => 6,
            MultiTouchV2BrickletFunction::GetElectrodeConfig => 7,
            MultiTouchV2BrickletFunction::SetElectrodeSensitivity => 8,
            MultiTouchV2BrickletFunction::GetElectrodeSensitivity => 9,
            MultiTouchV2BrickletFunction::SetTouchLedConfig => 10,
            MultiTouchV2BrickletFunction::GetTouchLedConfig => 11,
            MultiTouchV2BrickletFunction::GetSpitfpErrorCount => 234,
            MultiTouchV2BrickletFunction::SetBootloaderMode => 235,
            MultiTouchV2BrickletFunction::GetBootloaderMode => 236,
            MultiTouchV2BrickletFunction::SetWriteFirmwarePointer => 237,
            MultiTouchV2BrickletFunction::WriteFirmware => 238,
            MultiTouchV2BrickletFunction::SetStatusLedConfig => 239,
            MultiTouchV2BrickletFunction::GetStatusLedConfig => 240,
            MultiTouchV2BrickletFunction::GetChipTemperature => 242,
            MultiTouchV2BrickletFunction::Reset => 243,
            MultiTouchV2BrickletFunction::WriteUid => 248,
            MultiTouchV2BrickletFunction::ReadUid => 249,
            MultiTouchV2BrickletFunction::GetIdentity => 255,
            MultiTouchV2BrickletFunction::CallbackTouchState => 4,
        }
    }
}
pub const MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_OFF: u8 = 0;
pub const MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_ON: u8 = 1;
pub const MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH: u8 = 3;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TouchStateCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for TouchStateCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> TouchStateCallbackConfiguration {
        TouchStateCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Capacitive touch sensor for 12 electrodes
#[derive(Clone)]
pub struct MultiTouchV2Bricklet {
    device: Device,
}
impl MultiTouchV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2129;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Multi Touch Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MultiTouchV2Bricklet {
        let mut result = MultiTouchV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetTouchState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetTouchStateCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetTouchStateCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::Recalibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetElectrodeConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetElectrodeConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetElectrodeSensitivity) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetElectrodeSensitivity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetTouchLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetTouchLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::multi_touch_v2_bricklet::MultiTouchV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::multi_touch_v2_bricklet::MultiTouchV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MultiTouchV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: MultiTouchV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Returns the current touch state, see [`get_touch_state`] for
    /// information about the state.
    ///
    /// This receiver is triggered every time the touch state changes with
    /// a given period (see [`set_touch_state_callback_configuration`])
    ///
    /// [`get_touch_state`]: #method.get_touch_state
    /// [`set_touch_state_callback_configuration`]: #method.set_touch_state_callback_configuration
    pub fn get_touch_state_callback_receiver(&self) -> ConvertingCallbackReceiver<[bool; 13]> {
        self.device.get_callback_receiver(u8::from(MultiTouchV2BrickletFunction::CallbackTouchState))
    }

    /// Returns the current touch state. The state is given as a array of
    /// bools.
    ///
    /// Element 0 to 11 represent the 12 electrodes and element 12 represents
    /// the proximity.
    ///
    /// If an electrode is touched, the corresponding element is *true*. If
    /// a hand or similar is in proximity to the electrodes, element 12 is
    /// *true*.
    ///
    /// The proximity is activated with a distance of 1-2cm. An electrode
    /// is already counted as touched if a finger is nearly touching the
    /// electrode. This means that you can put a piece of paper or foil
    /// or similar on top of a electrode to build a touch panel with
    /// a professional look.
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_touch_state_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_touch_state_callback_configuration`].
    pub fn get_touch_state(&self) -> ConvertingReceiver<[bool; 13]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetTouchState), payload)
    }

    /// The period is the period with which the [`get_touch_state_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_touch_state_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetTouchStateCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_touch_state_callback_configuration`].
    pub fn get_touch_state_callback_configuration(&self) -> ConvertingReceiver<TouchStateCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetTouchStateCallbackConfiguration), payload)
    }

    /// Recalibrates the electrodes. Call this function whenever you changed
    /// or moved you electrodes.
    pub fn recalibrate(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MultiTouchV2BrickletFunction::Recalibrate), payload)
    }

    /// Enables/disables electrodes with a bool array (see [`get_touch_state`]).
    ///
    /// *True* enables the electrode, *false* disables the electrode. A
    /// disabled electrode will always return *false* as its state. If you
    /// don't need all electrodes you can disable the electrodes that are
    /// not needed.
    ///
    /// It is recommended that you disable the proximity electrode (element 12) if
    /// the proximity feature is not needed. This will reduce the amount of
    /// traffic that is produced by the [`get_touch_state_callback_receiver`] receiver.
    ///
    /// Disabling electrodes will also reduce power consumption.
    pub fn set_electrode_config(&self, enabled_electrodes: [bool; 13]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<[bool; 13]>::to_le_byte_vec(enabled_electrodes));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetElectrodeConfig), payload)
    }

    /// Returns the electrode configuration, as set by [`set_electrode_config`].
    pub fn get_electrode_config(&self) -> ConvertingReceiver<[bool; 13]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetElectrodeConfig), payload)
    }

    /// Sets the sensitivity of the electrodes. An electrode with a high sensitivity
    /// will register a touch earlier then an electrode with a low sensitivity.
    ///
    /// If you build a big electrode you might need to decrease the sensitivity, since
    /// the area that can be charged will get bigger. If you want to be able to
    /// activate an electrode from further away you need to increase the sensitivity.
    ///
    /// After a new sensitivity is set, you likely want to call [`recalibrate`]
    /// to calibrate the electrodes with the newly defined sensitivity.
    pub fn set_electrode_sensitivity(&self, sensitivity: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensitivity));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetElectrodeSensitivity), payload)
    }

    /// Returns the current sensitivity, as set by [`set_electrode_sensitivity`].
    pub fn get_electrode_sensitivity(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetElectrodeSensitivity), payload)
    }

    /// Configures the touch LED to be either turned off, turned on, blink in
    /// heartbeat mode or show the touch state (electrode touched = LED on).
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_OFF
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_ON
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH
    pub fn set_touch_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetTouchLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_touch_led_config`]
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_OFF
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_ON
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MULTI_TOUCH_V2_BRICKLET_TOUCH_LED_CONFIG_SHOW_TOUCH
    pub fn get_touch_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetTouchLedConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(MultiTouchV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* MULTI_TOUCH_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(MultiTouchV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MULTI_TOUCH_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MultiTouchV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(MultiTouchV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchV2BrickletFunction::GetIdentity), payload)
    }
}
