/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Capacitive touch sensor for 12 electrodes.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/MultiTouch_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum MultiTouchBrickletFunction {
    GetTouchState,
    Recalibrate,
    SetElectrodeConfig,
    GetElectrodeConfig,
    SetElectrodeSensitivity,
    GetElectrodeSensitivity,
    GetIdentity,
    CallbackTouchState,
}
impl From<MultiTouchBrickletFunction> for u8 {
    fn from(fun: MultiTouchBrickletFunction) -> Self {
        match fun {
            MultiTouchBrickletFunction::GetTouchState => 1,
            MultiTouchBrickletFunction::Recalibrate => 2,
            MultiTouchBrickletFunction::SetElectrodeConfig => 3,
            MultiTouchBrickletFunction::GetElectrodeConfig => 4,
            MultiTouchBrickletFunction::SetElectrodeSensitivity => 6,
            MultiTouchBrickletFunction::GetElectrodeSensitivity => 7,
            MultiTouchBrickletFunction::GetIdentity => 255,
            MultiTouchBrickletFunction::CallbackTouchState => 5,
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Capacitive touch sensor for 12 electrodes
#[derive(Clone)]
pub struct MultiTouchBricklet {
    device: Device,
}
impl MultiTouchBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 234;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Multi Touch Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MultiTouchBricklet {
        let mut result = MultiTouchBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::GetTouchState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::Recalibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::SetElectrodeConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::GetElectrodeConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::SetElectrodeSensitivity) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::GetElectrodeSensitivity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MultiTouchBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::multi_touch_bricklet::MultiTouchBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::multi_touch_bricklet::MultiTouchBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MultiTouchBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: MultiTouchBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Returns the current touch state, see [`get_touch_state`] for
    /// information about the state.
    ///
    /// This receiver is triggered every time the touch state changes.
    ///
    /// [`get_touch_state`]: #method.get_touch_state
    pub fn get_touch_state_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MultiTouchBrickletFunction::CallbackTouchState))
    }

    /// Returns the current touch state. The state is given as a bitfield.
    ///
    /// Bits 0 to 11 represent the 12 electrodes and bit 12 represents
    /// the proximity.
    ///
    /// If an electrode is touched, the corresponding bit is *true*. If
    /// a hand or similar is in proximity to the electrodes, bit 12 is
    /// *true*.
    ///
    /// Example: The state 4103 = 0x1007 = 0b1000000000111 means that
    /// electrodes 0, 1 and 2 are touched and that something is in the
    /// proximity of the electrodes.
    ///
    /// The proximity is activated with a distance of 1-2cm. An electrode
    /// is already counted as touched if a finger is nearly touching the
    /// electrode. This means that you can put a piece of paper or foil
    /// or similar on top of a electrode to build a touch panel with
    /// a professional look.
    pub fn get_touch_state(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchBrickletFunction::GetTouchState), payload)
    }

    /// Recalibrates the electrodes. Call this function whenever you changed
    /// or moved you electrodes.
    pub fn recalibrate(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MultiTouchBrickletFunction::Recalibrate), payload)
    }

    /// Enables/disables electrodes with a bitfield (see [`get_touch_state`]).
    ///
    /// *True* enables the electrode, *false* disables the electrode. A
    /// disabled electrode will always return *false* as its state. If you
    /// don't need all electrodes you can disable the electrodes that are
    /// not needed.
    ///
    /// It is recommended that you disable the proximity bit (bit 12) if
    /// the proximity feature is not needed. This will reduce the amount of
    /// traffic that is produced by the [`get_touch_state_callback_receiver`] receiver.
    ///
    /// Disabling electrodes will also reduce power consumption.
    ///
    /// Default: 8191 = 0x1FFF = 0b1111111111111 (all electrodes and proximity feature enabled)
    pub fn set_electrode_config(&self, enabled_electrodes: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(enabled_electrodes));

        self.device.set(u8::from(MultiTouchBrickletFunction::SetElectrodeConfig), payload)
    }

    /// Returns the electrode configuration, as set by [`set_electrode_config`].
    pub fn get_electrode_config(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchBrickletFunction::GetElectrodeConfig), payload)
    }

    /// Sets the sensitivity of the electrodes. An electrode with a high sensitivity
    /// will register a touch earlier then an electrode with a low sensitivity.
    ///
    /// If you build a big electrode you might need to decrease the sensitivity, since
    /// the area that can be charged will get bigger. If you want to be able to
    /// activate an electrode from further away you need to increase the sensitivity.
    ///
    /// After a new sensitivity is set, you likely want to call [`recalibrate`]
    /// to calibrate the electrodes with the newly defined sensitivity.
    pub fn set_electrode_sensitivity(&self, sensitivity: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensitivity));

        self.device.set(u8::from(MultiTouchBrickletFunction::SetElectrodeSensitivity), payload)
    }

    /// Returns the current sensitivity, as set by [`set_electrode_sensitivity`].
    pub fn get_electrode_sensitivity(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchBrickletFunction::GetElectrodeSensitivity), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MultiTouchBrickletFunction::GetIdentity), payload)
    }
}
