/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Motorized Linear Potentiometer.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/MotorizedLinearPoti_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum MotorizedLinearPotiBrickletFunction {
    GetPosition,
    SetPositionCallbackConfiguration,
    GetPositionCallbackConfiguration,
    SetMotorPosition,
    GetMotorPosition,
    Calibrate,
    SetPositionReachedCallbackConfiguration,
    GetPositionReachedCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackPosition,
    CallbackPositionReached,
}
impl From<MotorizedLinearPotiBrickletFunction> for u8 {
    fn from(fun: MotorizedLinearPotiBrickletFunction) -> Self {
        match fun {
            MotorizedLinearPotiBrickletFunction::GetPosition => 1,
            MotorizedLinearPotiBrickletFunction::SetPositionCallbackConfiguration => 2,
            MotorizedLinearPotiBrickletFunction::GetPositionCallbackConfiguration => 3,
            MotorizedLinearPotiBrickletFunction::SetMotorPosition => 5,
            MotorizedLinearPotiBrickletFunction::GetMotorPosition => 6,
            MotorizedLinearPotiBrickletFunction::Calibrate => 7,
            MotorizedLinearPotiBrickletFunction::SetPositionReachedCallbackConfiguration => 8,
            MotorizedLinearPotiBrickletFunction::GetPositionReachedCallbackConfiguration => 9,
            MotorizedLinearPotiBrickletFunction::GetSpitfpErrorCount => 234,
            MotorizedLinearPotiBrickletFunction::SetBootloaderMode => 235,
            MotorizedLinearPotiBrickletFunction::GetBootloaderMode => 236,
            MotorizedLinearPotiBrickletFunction::SetWriteFirmwarePointer => 237,
            MotorizedLinearPotiBrickletFunction::WriteFirmware => 238,
            MotorizedLinearPotiBrickletFunction::SetStatusLedConfig => 239,
            MotorizedLinearPotiBrickletFunction::GetStatusLedConfig => 240,
            MotorizedLinearPotiBrickletFunction::GetChipTemperature => 242,
            MotorizedLinearPotiBrickletFunction::Reset => 243,
            MotorizedLinearPotiBrickletFunction::WriteUid => 248,
            MotorizedLinearPotiBrickletFunction::ReadUid => 249,
            MotorizedLinearPotiBrickletFunction::GetIdentity => 255,
            MotorizedLinearPotiBrickletFunction::CallbackPosition => 4,
            MotorizedLinearPotiBrickletFunction::CallbackPositionReached => 10,
        }
    }
}
pub const MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_FAST: u8 = 0;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_SMOOTH: u8 = 1;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PositionCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for PositionCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> PositionCallbackConfiguration {
        PositionCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u16>::from_le_byte_slice(&bytes[6..8]),
            max: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MotorPosition {
    pub position: u16,
    pub drive_mode: u8,
    pub hold_position: bool,
    pub position_reached: bool,
}
impl FromByteSlice for MotorPosition {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> MotorPosition {
        MotorPosition {
            position: <u16>::from_le_byte_slice(&bytes[0..2]),
            drive_mode: <u8>::from_le_byte_slice(&bytes[2..3]),
            hold_position: <bool>::from_le_byte_slice(&bytes[3..4]),
            position_reached: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Motorized Linear Potentiometer
#[derive(Clone)]
pub struct MotorizedLinearPotiBricklet {
    device: Device,
}
impl MotorizedLinearPotiBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 267;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Motorized Linear Poti Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> MotorizedLinearPotiBricklet {
        let mut result = MotorizedLinearPotiBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetPositionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetPositionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetMotorPosition) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetMotorPosition) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::Calibrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetPositionReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetPositionReachedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(MotorizedLinearPotiBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::motorized_linear_poti_bricklet::MotorizedLinearPotiBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::motorized_linear_poti_bricklet::MotorizedLinearPotiBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: MotorizedLinearPotiBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: MotorizedLinearPotiBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_position_callback_configuration`].
    ///
    /// The parameter is the same as [`get_position`].
    ///
    /// [`get_position`]: #method.get_position
    /// [`set_position_callback_configuration`]: #method.set_position_callback_configuration
    pub fn get_position_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MotorizedLinearPotiBrickletFunction::CallbackPosition))
    }

    /// This receiver is triggered if a new position as set by
    /// [`set_motor_position`] is reached.
    ///
    /// The parameter is the current position.
    pub fn get_position_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(MotorizedLinearPotiBrickletFunction::CallbackPositionReached))
    }

    /// Returns the position of the linear potentiometer. The value is
    /// between 0 (slider down) and 100 (slider up).
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_position_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_position_callback_configuration`].
    pub fn get_position(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetPosition), payload)
    }

    /// The period is the period with which the [`get_position_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_position_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_position_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u16,
        max: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::SetPositionCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_position_callback_configuration`].
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_position_callback_configuration(&self) -> ConvertingReceiver<PositionCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetPositionCallbackConfiguration), payload)
    }

    /// Sets the position of the potentiometer. The motorized potentiometer will
    /// immediately start to approach the position. Depending on the chosen drive mode,
    /// the position will either be reached as fast as possible or in a slow but smooth
    /// motion.
    ///
    /// The position has to be between 0 (slider down) and 100 (slider up).
    ///
    /// If you set the hold position parameter to true, the position will automatically
    /// be retained. If a user changes the position of the potentiometer, it will
    /// automatically drive back to the original set point.
    ///
    /// If the hold position parameter is set to false, the potentiometer can be changed
    /// again by the user as soon as the set point was reached once.
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_FAST
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_SMOOTH
    pub fn set_motor_position(&self, position: u16, drive_mode: u8, hold_position: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(position));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(drive_mode));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(hold_position));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::SetMotorPosition), payload)
    }

    /// Returns the last motor position as set by [`set_motor_position`]. This is not
    /// the current position (use [`get_position`] to get the current position). This
    /// is the last used set point and configuration.
    ///
    /// The position reached parameter is true if the position has been reached at one point.
    /// The position may have been changed again in the meantime by the user.
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_FAST
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_DRIVE_MODE_SMOOTH
    pub fn get_motor_position(&self) -> ConvertingReceiver<MotorPosition> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetMotorPosition), payload)
    }

    /// Starts a calibration procedure. The potentiometer will be driven to the extreme
    /// points to calibrate the potentiometer.
    ///
    /// The calibration is saved in flash, it does not have to be called on every start up.
    ///
    /// The Motorized Linear Poti Bricklet is already factory-calibrated during
    /// testing at Tinkerforge.
    pub fn calibrate(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::Calibrate), payload)
    }

    /// Enables/Disables [`get_position_reached_callback_receiver`] receiver.
    pub fn set_position_reached_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::SetPositionReachedCallbackConfiguration), payload)
    }

    /// Returns the [`get_position_reached_callback_receiver`] receiver configuration
    /// as set by [`set_position_reached_callback_configuration`].
    pub fn get_position_reached_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetPositionReachedCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* MOTORIZED_LINEAR_POTI_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(MotorizedLinearPotiBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(MotorizedLinearPotiBrickletFunction::GetIdentity), payload)
    }
}
