/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Controls up to 2048 RGB(W) LEDs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LEDStripV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum LedStripV2BrickletFunction {
    SetLedValuesLowLevel,
    GetLedValuesLowLevel,
    SetFrameDuration,
    GetFrameDuration,
    GetSupplyVoltage,
    SetClockFrequency,
    GetClockFrequency,
    SetChipType,
    GetChipType,
    SetChannelMapping,
    GetChannelMapping,
    SetFrameStartedCallbackConfiguration,
    GetFrameStartedCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackFrameStarted,
}
impl From<LedStripV2BrickletFunction> for u8 {
    fn from(fun: LedStripV2BrickletFunction) -> Self {
        match fun {
            LedStripV2BrickletFunction::SetLedValuesLowLevel => 1,
            LedStripV2BrickletFunction::GetLedValuesLowLevel => 2,
            LedStripV2BrickletFunction::SetFrameDuration => 3,
            LedStripV2BrickletFunction::GetFrameDuration => 4,
            LedStripV2BrickletFunction::GetSupplyVoltage => 5,
            LedStripV2BrickletFunction::SetClockFrequency => 7,
            LedStripV2BrickletFunction::GetClockFrequency => 8,
            LedStripV2BrickletFunction::SetChipType => 9,
            LedStripV2BrickletFunction::GetChipType => 10,
            LedStripV2BrickletFunction::SetChannelMapping => 11,
            LedStripV2BrickletFunction::GetChannelMapping => 12,
            LedStripV2BrickletFunction::SetFrameStartedCallbackConfiguration => 13,
            LedStripV2BrickletFunction::GetFrameStartedCallbackConfiguration => 14,
            LedStripV2BrickletFunction::GetSpitfpErrorCount => 234,
            LedStripV2BrickletFunction::SetBootloaderMode => 235,
            LedStripV2BrickletFunction::GetBootloaderMode => 236,
            LedStripV2BrickletFunction::SetWriteFirmwarePointer => 237,
            LedStripV2BrickletFunction::WriteFirmware => 238,
            LedStripV2BrickletFunction::SetStatusLedConfig => 239,
            LedStripV2BrickletFunction::GetStatusLedConfig => 240,
            LedStripV2BrickletFunction::GetChipTemperature => 242,
            LedStripV2BrickletFunction::Reset => 243,
            LedStripV2BrickletFunction::WriteUid => 248,
            LedStripV2BrickletFunction::ReadUid => 249,
            LedStripV2BrickletFunction::GetIdentity => 255,
            LedStripV2BrickletFunction::CallbackFrameStarted => 6,
        }
    }
}
pub const LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2801: u16 = 2801;
pub const LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2811: u16 = 2811;
pub const LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2812: u16 = 2812;
pub const LED_STRIP_V2_BRICKLET_CHIP_TYPE_LPD8806: u16 = 8806;
pub const LED_STRIP_V2_BRICKLET_CHIP_TYPE_APA102: u16 = 102;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGB: u8 = 6;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBG: u8 = 9;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRG: u8 = 33;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGR: u8 = 36;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRB: u8 = 18;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBR: u8 = 24;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGBW: u8 = 27;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGWB: u8 = 30;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBGW: u8 = 39;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBWG: u8 = 45;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWGB: u8 = 54;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWBG: u8 = 57;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRWB: u8 = 78;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRBW: u8 = 75;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBWR: u8 = 108;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBRW: u8 = 99;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWBR: u8 = 120;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWRB: u8 = 114;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRGW: u8 = 135;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRWG: u8 = 141;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGRW: u8 = 147;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGWR: u8 = 156;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWRG: u8 = 177;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWGR: u8 = 180;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRBG: u8 = 201;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRGB: u8 = 198;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGBR: u8 = 216;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGRB: u8 = 210;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBGR: u8 = 228;
pub const LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBRG: u8 = 225;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetLedValuesLowLevel {}
impl FromByteSlice for SetLedValuesLowLevel {
    fn bytes_expected() -> usize { 0 }
    fn from_le_byte_slice(_bytes: &[u8]) -> SetLedValuesLowLevel { SetLedValuesLowLevel {} }
}
impl LowLevelWrite<SetLedValuesResult> for SetLedValuesLowLevel {
    fn ll_message_written(&self) -> usize { 58 }

    fn get_result(&self) -> SetLedValuesResult { SetLedValuesResult {} }
}

#[derive(Clone, Copy)]
pub struct LedValuesLowLevel {
    pub value_length: u16,
    pub value_chunk_offset: u16,
    pub value_chunk_data: [u8; 60],
}
impl FromByteSlice for LedValuesLowLevel {
    fn bytes_expected() -> usize { 64 }
    fn from_le_byte_slice(bytes: &[u8]) -> LedValuesLowLevel {
        LedValuesLowLevel {
            value_length: <u16>::from_le_byte_slice(&bytes[0..2]),
            value_chunk_offset: <u16>::from_le_byte_slice(&bytes[2..4]),
            value_chunk_data: <[u8; 60]>::from_le_byte_slice(&bytes[4..64]),
        }
    }
}
impl LowLevelRead<u8, LedValuesResult> for LedValuesLowLevel {
    fn ll_message_length(&self) -> usize { self.value_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { self.value_chunk_offset as usize }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.value_chunk_data }

    fn get_result(&self) -> LedValuesResult { LedValuesResult {} }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SetLedValuesResult {}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LedValuesResult {}

/// Controls up to 2048 RGB(W) LEDs
#[derive(Clone)]
pub struct LedStripV2Bricklet {
    device: Device,
}
impl LedStripV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2103;
    pub const DEVICE_DISPLAY_NAME: &'static str = "LED Strip Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LedStripV2Bricklet {
        let mut result = LedStripV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 2) };
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetLedValuesLowLevel) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetLedValuesLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetFrameDuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetFrameDuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetSupplyVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetClockFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetClockFrequency) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetChipType) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetChipType) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetChannelMapping) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetChannelMapping) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetFrameStartedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetFrameStartedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::led_strip_v2_bricklet::LedStripV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::led_strip_v2_bricklet::LedStripV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LedStripV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LedStripV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered directly after a new frame render is started.
    /// The parameter is the number of LEDs in that frame.
    ///
    /// You should send the data for the next frame directly after this receiver
    /// was triggered.
    ///
    /// For an explanation of the general approach see [`set_led_values`].
    ///
    /// [`set_led_values`]: #method.set_led_values
    pub fn get_frame_started_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(LedStripV2BrickletFunction::CallbackFrameStarted))
    }

    /// Sets the RGB(W) values for the LEDs starting from *index*.
    /// You can set at most 2048 RGB values or 1536 RGBW values (6144 byte each).
    ///
    /// To make the colors show correctly you need to configure the chip type
    /// (see [`set_chip_type`]) and a channel mapping (see [`set_channel_mapping`])
    /// according to the connected LEDs.
    ///
    /// If the channel mapping has 3 colors, you need to give the data in the sequence
    /// RGBRGBRGB... if the channel mapping has 4 colors you need to give data in the
    /// sequence RGBWRGBWRGBW...
    ///
    /// The data is double buffered and the colors will be transfered to the
    /// LEDs when the next frame duration ends (see [`set_frame_duration`]).
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents the number of frames per
    ///   second you want to achieve.
    /// * Set all of the LED colors for one frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * Set all of the LED colors for next frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * And so on.
    ///
    /// This approach ensures that you can change the LED colors with a fixed frame rate.
    pub fn set_led_values_low_level(
        &self,
        index: u16,
        value_length: u16,
        value_chunk_offset: u16,
        value_chunk_data: [u8; 58],
    ) -> ConvertingReceiver<SetLedValuesLowLevel> {
        let mut payload = vec![0; 64];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(value_length));
        payload[4..6].copy_from_slice(&<u16>::to_le_byte_vec(value_chunk_offset));
        payload[6..64].copy_from_slice(&<[u8; 58]>::to_le_byte_vec(value_chunk_data));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetLedValuesLowLevel), payload)
    }

    /// Sets the RGB(W) values for the LEDs starting from *index*.
    /// You can set at most 2048 RGB values or 1536 RGBW values (6144 byte each).
    ///
    /// To make the colors show correctly you need to configure the chip type
    /// (see [`set_chip_type`]) and a channel mapping (see [`set_channel_mapping`])
    /// according to the connected LEDs.
    ///
    /// If the channel mapping has 3 colors, you need to give the data in the sequence
    /// RGBRGBRGB... if the channel mapping has 4 colors you need to give data in the
    /// sequence RGBWRGBWRGBW...
    ///
    /// The data is double buffered and the colors will be transfered to the
    /// LEDs when the next frame duration ends (see [`set_frame_duration`]).
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents the number of frames per
    ///   second you want to achieve.
    /// * Set all of the LED colors for one frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * Set all of the LED colors for next frame.
    /// * Wait for the [`get_frame_started_callback_receiver`] receiver.
    /// * And so on.
    ///
    /// This approach ensures that you can change the LED colors with a fixed frame rate.
    pub fn set_led_values(&self, index: u16, value: &[u8]) -> Result<(), BrickletRecvTimeoutError> {
        let _ll_result = self.device.set_high_level(0, value, 65535, 58, &mut |length: usize, chunk_offset: usize, chunk: &[u8]| {
            let chunk_length = chunk.len() as u16;
            let mut chunk_array = [<u8>::default(); 58];
            chunk_array[0..chunk_length as usize].copy_from_slice(&chunk);

            let result = self.set_led_values_low_level(index, length as u16, chunk_offset as u16, chunk_array).recv();
            if let Err(BrickletRecvTimeoutError::SuccessButResponseExpectedIsDisabled) = result {
                Ok(Default::default())
            } else {
                result
            }
        })?;
        Ok(())
    }

    /// Returns *length* RGB(W) values starting from the
    /// given *index*.
    ///
    /// If the channel mapping has 3 colors, you will get the data in the sequence
    /// RGBRGBRGB... if the channel mapping has 4 colors you will get the data in the
    /// sequence RGBWRGBWRGBW...
    /// (assuming you start at an index divisible by 3 (RGB) or 4 (RGBW)).
    pub fn get_led_values_low_level(&self, index: u16, length: u16) -> ConvertingReceiver<LedValuesLowLevel> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(length));

        self.device.get(u8::from(LedStripV2BrickletFunction::GetLedValuesLowLevel), payload)
    }

    /// Returns *length* RGB(W) values starting from the
    /// given *index*.
    ///
    /// If the channel mapping has 3 colors, you will get the data in the sequence
    /// RGBRGBRGB... if the channel mapping has 4 colors you will get the data in the
    /// sequence RGBWRGBWRGBW...
    /// (assuming you start at an index divisible by 3 (RGB) or 4 (RGBW)).
    pub fn get_led_values(&self, index: u16, length: u16) -> Result<Vec<u8>, BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(1, &mut || self.get_led_values_low_level(index, length).recv())?;
        Ok(ll_result.0)
    }

    /// Sets the frame duration.
    ///
    /// Example: If you want to achieve 20 frames per second, you should
    /// set the frame duration to 50ms (50ms * 20 = 1 second).
    ///
    /// For an explanation of the general approach see [`set_led_values`].
    ///
    /// Default value: 100ms (10 frames per second).
    pub fn set_frame_duration(&self, duration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(duration));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetFrameDuration), payload)
    }

    /// Returns the frame duration as set by [`set_frame_duration`].
    pub fn get_frame_duration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetFrameDuration), payload)
    }

    /// Returns the current supply voltage of the LEDs.
    pub fn get_supply_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetSupplyVoltage), payload)
    }

    /// Sets the frequency of the clock.
    ///
    /// The Bricklet will choose the nearest achievable frequency, which may
    /// be off by a few Hz. You can get the exact frequency that is used by
    /// calling [`get_clock_frequency`].
    ///
    /// If you have problems with flickering LEDs, they may be bits flipping. You
    /// can fix this by either making the connection between the LEDs and the
    /// Bricklet shorter or by reducing the frequency.
    ///
    /// With a decreasing frequency your maximum frames per second will decrease
    /// too.
    pub fn set_clock_frequency(&self, frequency: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(frequency));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetClockFrequency), payload)
    }

    /// Returns the currently used clock frequency as set by [`set_clock_frequency`].
    pub fn get_clock_frequency(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetClockFrequency), payload)
    }

    /// Sets the type of the LED driver chip. We currently support the chips
    ///
    /// * WS2801,
    /// * WS2811,
    /// * WS2812 / SK6812 / NeoPixel RGB,
    /// * SK6812RGBW / NeoPixel RGBW (Chip Type = WS2812),
    /// * WS2813 / WS2815 (Chip Type = WS2812)
    /// * LPD8806 and
    /// * APA102 / DotStar.
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2801
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2811
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2812
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_LPD8806
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_APA102
    pub fn set_chip_type(&self, chip: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(chip));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetChipType), payload)
    }

    /// Returns the currently used chip type as set by [`set_chip_type`].
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2801
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2811
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_WS2812
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_LPD8806
    ///	* LED_STRIP_V2_BRICKLET_CHIP_TYPE_APA102
    pub fn get_chip_type(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetChipType), payload)
    }

    /// Sets the channel mapping for the connected LEDs.
    ///
    /// If the mapping has 4 colors, the function [`set_led_values`] expects 4
    /// values per pixel and if the mapping has 3 colors it expects 3 values per pixel.
    ///
    /// The function always expects the order RGB(W). The connected LED driver chips
    /// might have their 3 or 4 channels in a different order. For example, the WS2801
    /// chips typically use BGR order, then WS2812 chips typically use GRB order and
    /// the APA102 chips typically use WBGR order.
    ///
    /// The APA102 chips are special. They have three 8-bit channels for RGB
    /// and an additional 5-bit channel for the overall brightness of the RGB LED
    /// making them 4-channel chips. Internally the brightness channel is the first
    /// channel, therefore one of the Wxyz channel mappings should be used. Then
    /// the W channel controls the brightness.
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGBW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGWB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBGW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBWG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRWB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRBW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBWR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBRW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRGW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRWG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGRW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGWR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWRG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBRG
    pub fn set_channel_mapping(&self, mapping: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mapping));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetChannelMapping), payload)
    }

    /// Returns the currently used channel mapping as set by [`set_channel_mapping`].
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGBW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RGWB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBGW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RBWG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_RWBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRWB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GRBW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBWR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GBRW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_GWRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRGW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BRWG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGRW
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BGWR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWRG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_BWGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRBG
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WRGB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGBR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WGRB
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBGR
    ///	* LED_STRIP_V2_BRICKLET_CHANNEL_MAPPING_WBRG
    pub fn get_channel_mapping(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetChannelMapping), payload)
    }

    /// Enables/disables the [`get_frame_started_callback_receiver`] receiver.
    pub fn set_frame_started_callback_configuration(&self, enable: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetFrameStartedCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by
    /// [`set_frame_started_callback_configuration`].
    pub fn get_frame_started_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetFrameStartedCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(LedStripV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* LED_STRIP_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(LedStripV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(LedStripV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* LED_STRIP_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LedStripV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(LedStripV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripV2BrickletFunction::GetIdentity), payload)
    }
}
