/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Controls up to 320 RGB LEDs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LEDStrip_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum LedStripBrickletFunction {
    SetRgbValues,
    GetRgbValues,
    SetFrameDuration,
    GetFrameDuration,
    GetSupplyVoltage,
    SetClockFrequency,
    GetClockFrequency,
    SetChipType,
    GetChipType,
    SetRgbwValues,
    GetRgbwValues,
    SetChannelMapping,
    GetChannelMapping,
    EnableFrameRenderedCallback,
    DisableFrameRenderedCallback,
    IsFrameRenderedCallbackEnabled,
    GetIdentity,
    CallbackFrameRendered,
}
impl From<LedStripBrickletFunction> for u8 {
    fn from(fun: LedStripBrickletFunction) -> Self {
        match fun {
            LedStripBrickletFunction::SetRgbValues => 1,
            LedStripBrickletFunction::GetRgbValues => 2,
            LedStripBrickletFunction::SetFrameDuration => 3,
            LedStripBrickletFunction::GetFrameDuration => 4,
            LedStripBrickletFunction::GetSupplyVoltage => 5,
            LedStripBrickletFunction::SetClockFrequency => 7,
            LedStripBrickletFunction::GetClockFrequency => 8,
            LedStripBrickletFunction::SetChipType => 9,
            LedStripBrickletFunction::GetChipType => 10,
            LedStripBrickletFunction::SetRgbwValues => 11,
            LedStripBrickletFunction::GetRgbwValues => 12,
            LedStripBrickletFunction::SetChannelMapping => 13,
            LedStripBrickletFunction::GetChannelMapping => 14,
            LedStripBrickletFunction::EnableFrameRenderedCallback => 15,
            LedStripBrickletFunction::DisableFrameRenderedCallback => 16,
            LedStripBrickletFunction::IsFrameRenderedCallbackEnabled => 17,
            LedStripBrickletFunction::GetIdentity => 255,
            LedStripBrickletFunction::CallbackFrameRendered => 6,
        }
    }
}
pub const LED_STRIP_BRICKLET_CHIP_TYPE_WS2801: u16 = 2801;
pub const LED_STRIP_BRICKLET_CHIP_TYPE_WS2811: u16 = 2811;
pub const LED_STRIP_BRICKLET_CHIP_TYPE_WS2812: u16 = 2812;
pub const LED_STRIP_BRICKLET_CHIP_TYPE_LPD8806: u16 = 8806;
pub const LED_STRIP_BRICKLET_CHIP_TYPE_APA102: u16 = 102;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGB: u8 = 6;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBG: u8 = 9;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRG: u8 = 33;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGR: u8 = 36;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRB: u8 = 18;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBR: u8 = 24;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGBW: u8 = 27;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGWB: u8 = 30;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBGW: u8 = 39;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBWG: u8 = 45;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWGB: u8 = 54;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWBG: u8 = 57;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRWB: u8 = 78;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRBW: u8 = 75;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBWR: u8 = 108;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBRW: u8 = 99;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWBR: u8 = 120;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWRB: u8 = 114;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRGW: u8 = 135;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRWG: u8 = 141;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGRW: u8 = 147;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGWR: u8 = 156;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWRG: u8 = 177;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWGR: u8 = 180;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRBG: u8 = 201;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRGB: u8 = 198;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGBR: u8 = 216;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGRB: u8 = 210;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBGR: u8 = 228;
pub const LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBRG: u8 = 225;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RgbValues {
    pub r: [u8; 16],
    pub g: [u8; 16],
    pub b: [u8; 16],
}
impl FromByteSlice for RgbValues {
    fn bytes_expected() -> usize { 48 }
    fn from_le_byte_slice(bytes: &[u8]) -> RgbValues {
        RgbValues {
            r: <[u8; 16]>::from_le_byte_slice(&bytes[0..16]),
            g: <[u8; 16]>::from_le_byte_slice(&bytes[16..32]),
            b: <[u8; 16]>::from_le_byte_slice(&bytes[32..48]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct RgbwValues {
    pub r: [u8; 12],
    pub g: [u8; 12],
    pub b: [u8; 12],
    pub w: [u8; 12],
}
impl FromByteSlice for RgbwValues {
    fn bytes_expected() -> usize { 48 }
    fn from_le_byte_slice(bytes: &[u8]) -> RgbwValues {
        RgbwValues {
            r: <[u8; 12]>::from_le_byte_slice(&bytes[0..12]),
            g: <[u8; 12]>::from_le_byte_slice(&bytes[12..24]),
            b: <[u8; 12]>::from_le_byte_slice(&bytes[24..36]),
            w: <[u8; 12]>::from_le_byte_slice(&bytes[36..48]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Controls up to 320 RGB LEDs
#[derive(Clone)]
pub struct LedStripBricklet {
    device: Device,
}
impl LedStripBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 231;
    pub const DEVICE_DISPLAY_NAME: &'static str = "LED Strip Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LedStripBricklet {
        let mut result = LedStripBricklet { device: Device::new([2, 0, 3], uid, req_sender, 0) };
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetRgbValues) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetRgbValues) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetFrameDuration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetFrameDuration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetSupplyVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetClockFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetClockFrequency) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetChipType) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetChipType) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetRgbwValues) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetRgbwValues) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::SetChannelMapping) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetChannelMapping) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::EnableFrameRenderedCallback) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LedStripBrickletFunction::DisableFrameRenderedCallback) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LedStripBrickletFunction::IsFrameRenderedCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LedStripBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::led_strip_bricklet::LedStripBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::led_strip_bricklet::LedStripBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LedStripBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LedStripBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered directly after a new frame is rendered. The
    /// parameter is the number of RGB or RGBW LEDs in that frame.
    ///
    /// You should send the data for the next frame directly after this receiver
    /// was triggered.
    ///
    /// For an explanation of the general approach see [`set_rgb_values`].
    ///
    /// [`set_rgb_values`]: #method.set_rgb_values
    pub fn get_frame_rendered_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(LedStripBrickletFunction::CallbackFrameRendered))
    }

    /// Sets *length* RGB values for the LEDs starting from *index*.
    ///
    /// To make the colors show correctly you need to configure the chip type
    /// (:func:[Set Chip Type`) and a 3-channel channel mapping ([`set_channel_mapping`])
    /// according to the connected LEDs.
    ///
    /// Example: If you set
    ///
    /// * index to 5,
    /// * length to 3,
    /// * r to [255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    /// * g to [0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0] and
    /// * b to [0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    ///
    /// the LED with index 5 will be red, 6 will be green and 7 will be blue.
    ///
    /// # Note Depending on the LED circuitry colors can be permuted.
    ///
    /// The colors will be transfered to actual LEDs when the next
    /// frame duration ends, see [`set_frame_duration`].
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents
    ///   the number of frames per second you want to achieve.
    /// * Set all of the LED colors for one frame.
    /// * Wait for the [`get_frame_rendered_callback_receiver`] receiver.
    /// * Set all of the LED colors for next frame.
    /// * Wait for the [`get_frame_rendered_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// This approach ensures that you can change the LED colors with
    /// a fixed frame rate.
    ///
    /// The actual number of controllable LEDs depends on the number of free
    /// Bricklet ports. See `here](led_strip_bricklet_ram_constraints) for more
    /// information. A call of [`set_rgb_values`] with index + length above the
    /// bounds is ignored completely.
    pub fn set_rgb_values(&self, index: u16, length: u8, r: [u8; 16], g: [u8; 16], b: [u8; 16]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 51];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(length));
        payload[3..19].copy_from_slice(&<[u8; 16]>::to_le_byte_vec(r));
        payload[19..35].copy_from_slice(&<[u8; 16]>::to_le_byte_vec(g));
        payload[35..51].copy_from_slice(&<[u8; 16]>::to_le_byte_vec(b));

        self.device.set(u8::from(LedStripBrickletFunction::SetRgbValues), payload)
    }

    /// Returns *length* R, G and B values starting from the
    /// given LED *index*.
    ///
    /// The values are the last values that were set by [`set_rgb_values`].
    pub fn get_rgb_values(&self, index: u16, length: u8) -> ConvertingReceiver<RgbValues> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(LedStripBrickletFunction::GetRgbValues), payload)
    }

    /// Sets the frame duration.
    ///
    /// Example: If you want to achieve 20 frames per second, you should
    /// set the frame duration to 50ms (50ms * 20 = 1 second).
    ///
    /// For an explanation of the general approach see [`set_rgb_values`].
    pub fn set_frame_duration(&self, duration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(duration));

        self.device.set(u8::from(LedStripBrickletFunction::SetFrameDuration), payload)
    }

    /// Returns the frame duration as set by [`set_frame_duration`].
    pub fn get_frame_duration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetFrameDuration), payload)
    }

    /// Returns the current supply voltage of the LEDs.
    pub fn get_supply_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetSupplyVoltage), payload)
    }

    /// Sets the frequency of the clock.
    ///
    /// The Bricklet will choose the nearest achievable frequency, which may
    /// be off by a few Hz. You can get the exact frequency that is used by
    /// calling [`get_clock_frequency`].
    ///
    /// If you have problems with flickering LEDs, they may be bits flipping. You
    /// can fix this by either making the connection between the LEDs and the
    /// Bricklet shorter or by reducing the frequency.
    ///
    /// With a decreasing frequency your maximum frames per second will decrease
    /// too.
    ///
    /// # Note
    ///  The frequency in firmware version 2.0.0 is fixed at 2MHz.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn set_clock_frequency(&self, frequency: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(frequency));

        self.device.set(u8::from(LedStripBrickletFunction::SetClockFrequency), payload)
    }

    /// Returns the currently used clock frequency as set by [`set_clock_frequency`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_clock_frequency(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetClockFrequency), payload)
    }

    /// Sets the type of the LED driver chip. We currently support the chips
    ///
    /// * WS2801,
    /// * WS2811,
    /// * WS2812 / SK6812 / NeoPixel RGB,
    /// * SK6812RGBW / NeoPixel RGBW (Chip Type = WS2812),
    /// * LPD8806 and
    /// * APA102 / DotStar.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LED_STRIP_BRICKLET_CHIP_TYPE_WS2801
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_WS2811
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_WS2812
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_LPD8806
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_APA102
    pub fn set_chip_type(&self, chip: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(chip));

        self.device.set(u8::from(LedStripBrickletFunction::SetChipType), payload)
    }

    /// Returns the currently used chip type as set by [`set_chip_type`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LED_STRIP_BRICKLET_CHIP_TYPE_WS2801
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_WS2811
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_WS2812
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_LPD8806
    ///	* LED_STRIP_BRICKLET_CHIP_TYPE_APA102
    pub fn get_chip_type(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetChipType), payload)
    }

    /// Sets *length* RGBW values for the LEDs starting from *index*.
    ///
    /// To make the colors show correctly you need to configure the chip type
    /// (:func:[Set Chip Type`) and a 4-channel channel mapping ([`set_channel_mapping`])
    /// according to the connected LEDs.
    ///
    /// The maximum length is 12, the index goes from 0 to 239 and the rgbw values
    /// have 8 bits each.
    ///
    /// Example: If you set
    ///
    /// * index to 5,
    /// * length to 4,
    /// * r to [255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    /// * g to [0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    /// * b to [0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0] and
    /// * w to [0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0]
    ///
    /// the LED with index 5 will be red, 6 will be green, 7 will be blue and 8 will be white.
    ///
    /// # Note Depending on the LED circuitry colors can be permuted.
    ///
    /// The colors will be transfered to actual LEDs when the next
    /// frame duration ends, see [`set_frame_duration`].
    ///
    /// Generic approach:
    ///
    /// * Set the frame duration to a value that represents
    ///   the number of frames per second you want to achieve.
    /// * Set all of the LED colors for one frame.
    /// * Wait for the [`get_frame_rendered_callback_receiver`] receiver.
    /// * Set all of the LED colors for next frame.
    /// * Wait for the [`get_frame_rendered_callback_receiver`] receiver.
    /// * and so on.
    ///
    /// This approach ensures that you can change the LED colors with
    /// a fixed frame rate.
    ///
    /// The actual number of controllable LEDs depends on the number of free
    /// Bricklet ports. See `here](led_strip_bricklet_ram_constraints) for more
    /// information. A call of [`set_rgbw_values`] with index + length above the
    /// bounds is ignored completely.
    ///
    /// The LPD8806 LED driver chips have 7-bit channels for RGB. Internally the LED
    /// Strip Bricklets divides the 8-bit values set using this function by 2 to make
    /// them 7-bit. Therefore, you can just use the normal value range (0-255) for
    /// LPD8806 LEDs.
    ///
    /// The brightness channel of the APA102 LED driver chips has 5-bit. Internally the
    /// LED Strip Bricklets divides the 8-bit values set using this function by 8 to make
    /// them 5-bit. Therefore, you can just use the normal value range (0-255) for
    /// the brightness channel of APA102 LEDs.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn set_rgbw_values(&self, index: u16, length: u8, r: [u8; 12], g: [u8; 12], b: [u8; 12], w: [u8; 12]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 51];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(length));
        payload[3..15].copy_from_slice(&<[u8; 12]>::to_le_byte_vec(r));
        payload[15..27].copy_from_slice(&<[u8; 12]>::to_le_byte_vec(g));
        payload[27..39].copy_from_slice(&<[u8; 12]>::to_le_byte_vec(b));
        payload[39..51].copy_from_slice(&<[u8; 12]>::to_le_byte_vec(w));

        self.device.set(u8::from(LedStripBrickletFunction::SetRgbwValues), payload)
    }

    /// Returns *length* RGBW values starting from the given *index*.
    ///
    /// The values are the last values that were set by [`set_rgbw_values`].
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn get_rgbw_values(&self, index: u16, length: u8) -> ConvertingReceiver<RgbwValues> {
        let mut payload = vec![0; 3];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(index));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(LedStripBrickletFunction::GetRgbwValues), payload)
    }

    /// Sets the channel mapping for the connected LEDs.
    ///
    /// [`set_rgb_values`] and [`set_rgbw_values`] take the data in RGB(W) order.
    /// But the connected LED driver chips might have their 3 or 4 channels in a
    /// different order. For example, the WS2801 chips typically use BGR order, the
    /// WS2812 chips typically use GRB order and the APA102 chips typically use WBGR
    /// order.
    ///
    /// The APA102 chips are special. They have three 8-bit channels for RGB
    /// and an additional 5-bit channel for the overall brightness of the RGB LED
    /// making them 4-channel chips. Internally the brightness channel is the first
    /// channel, therefore one of the Wxyz channel mappings should be used. Then
    /// the W channel controls the brightness.
    ///
    /// If a 3-channel mapping is selected then [`set_rgb_values`] has to be used.
    /// Calling [`set_rgbw_values`] with a 3-channel mapping will produce incorrect
    /// results. Vice-versa if a 4-channel mapping is selected then
    /// [`set_rgbw_values`] has to be used. Calling [`set_rgb_values`] with a
    /// 4-channel mapping will produce incorrect results.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGBW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGWB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBGW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBWG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRWB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRBW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBWR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBRW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRGW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRWG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGRW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGWR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWRG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBRG
    pub fn set_channel_mapping(&self, mapping: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mapping));

        self.device.set(u8::from(LedStripBrickletFunction::SetChannelMapping), payload)
    }

    /// Returns the currently used channel mapping as set by [`set_channel_mapping`].
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGBW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RGWB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBGW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RBWG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_RWBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRWB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GRBW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBWR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GBRW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_GWRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRGW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BRWG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGRW
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BGWR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWRG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_BWGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRBG
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WRGB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGBR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WGRB
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBGR
    ///	* LED_STRIP_BRICKLET_CHANNEL_MAPPING_WBRG
    pub fn get_channel_mapping(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetChannelMapping), payload)
    }

    /// Enables the [`get_frame_rendered_callback_receiver`] receiver.
    ///
    /// By default the receiver is enabled.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn enable_frame_rendered_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LedStripBrickletFunction::EnableFrameRenderedCallback), payload)
    }

    /// Disables the [`get_frame_rendered_callback_receiver`] receiver.
    ///
    /// By default the receiver is enabled.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn disable_frame_rendered_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LedStripBrickletFunction::DisableFrameRenderedCallback), payload)
    }

    /// Returns *true* if the [`get_frame_rendered_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn is_frame_rendered_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::IsFrameRenderedCallbackEnabled), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LedStripBrickletFunction::GetIdentity), payload)
    }
}
