/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 20x4 character alphanumeric display with blue backlight.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LCD20x4_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
};
pub enum Lcd20x4BrickletFunction {
    WriteLine,
    ClearDisplay,
    BacklightOn,
    BacklightOff,
    IsBacklightOn,
    SetConfig,
    GetConfig,
    IsButtonPressed,
    SetCustomCharacter,
    GetCustomCharacter,
    SetDefaultText,
    GetDefaultText,
    SetDefaultTextCounter,
    GetDefaultTextCounter,
    GetIdentity,
    CallbackButtonPressed,
    CallbackButtonReleased,
}
impl From<Lcd20x4BrickletFunction> for u8 {
    fn from(fun: Lcd20x4BrickletFunction) -> Self {
        match fun {
            Lcd20x4BrickletFunction::WriteLine => 1,
            Lcd20x4BrickletFunction::ClearDisplay => 2,
            Lcd20x4BrickletFunction::BacklightOn => 3,
            Lcd20x4BrickletFunction::BacklightOff => 4,
            Lcd20x4BrickletFunction::IsBacklightOn => 5,
            Lcd20x4BrickletFunction::SetConfig => 6,
            Lcd20x4BrickletFunction::GetConfig => 7,
            Lcd20x4BrickletFunction::IsButtonPressed => 8,
            Lcd20x4BrickletFunction::SetCustomCharacter => 11,
            Lcd20x4BrickletFunction::GetCustomCharacter => 12,
            Lcd20x4BrickletFunction::SetDefaultText => 13,
            Lcd20x4BrickletFunction::GetDefaultText => 14,
            Lcd20x4BrickletFunction::SetDefaultTextCounter => 15,
            Lcd20x4BrickletFunction::GetDefaultTextCounter => 16,
            Lcd20x4BrickletFunction::GetIdentity => 255,
            Lcd20x4BrickletFunction::CallbackButtonPressed => 9,
            Lcd20x4BrickletFunction::CallbackButtonReleased => 10,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Config {
    pub cursor: bool,
    pub blinking: bool,
}
impl FromByteSlice for Config {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Config {
        Config { cursor: <bool>::from_le_byte_slice(&bytes[0..1]), blinking: <bool>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 20x4 character alphanumeric display with blue backlight
#[derive(Clone)]
pub struct Lcd20x4Bricklet {
    device: Device,
}
impl Lcd20x4Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 212;
    pub const DEVICE_DISPLAY_NAME: &'static str = "LCD 20x4 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Lcd20x4Bricklet {
        let mut result = Lcd20x4Bricklet { device: Device::new([2, 0, 2], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::WriteLine) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::ClearDisplay) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::BacklightOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::BacklightOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::IsBacklightOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::SetConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::GetConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::IsButtonPressed) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::SetCustomCharacter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::GetCustomCharacter) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::SetDefaultText) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::GetDefaultText) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::SetDefaultTextCounter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::GetDefaultTextCounter) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Lcd20x4BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::lcd_20x4_bricklet::Lcd20x4Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::lcd_20x4_bricklet::Lcd20x4Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Lcd20x4BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Lcd20x4BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when a button is pressed. The parameter is
    /// the number of the button (0 to 2 or 0 to 3 since hardware version 1.2).
    pub fn get_button_pressed_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(Lcd20x4BrickletFunction::CallbackButtonPressed))
    }

    /// This receiver is triggered when a button is released. The parameter is
    /// the number of the button (0 to 2 or 0 to 3 since hardware version 1.2).
    pub fn get_button_released_callback_receiver(&self) -> ConvertingCallbackReceiver<u8> {
        self.device.get_callback_receiver(u8::from(Lcd20x4BrickletFunction::CallbackButtonReleased))
    }

    /// Writes text to a specific line with a specific position.
    /// The text can have a maximum of 20 characters.
    ///
    /// For example: (0, 7, Hello) will write *Hello* in the middle of the
    /// first line of the display.
    ///
    /// The display uses a special charset that includes all ASCII characters except
    /// backslash and tilde. The LCD charset also includes several other non-ASCII characters, see
    /// the [charset specification](https://github.com/Tinkerforge/lcd-20x4-bricklet/raw/master/datasheets/standard_charset.pdf)__
    /// for details. The Unicode example above shows how to specify non-ASCII characters
    /// and how to translate from Unicode to the LCD charset.
    pub fn write_line(&self, line: u8, position: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 22];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(position));
        match <String>::try_to_le_byte_vec(text, 20) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[2..22].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd20x4BrickletFunction::WriteLine), payload)
    }

    /// Deletes all characters from the display.
    pub fn clear_display(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd20x4BrickletFunction::ClearDisplay), payload)
    }

    /// Turns the backlight on.
    pub fn backlight_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd20x4BrickletFunction::BacklightOn), payload)
    }

    /// Turns the backlight off.
    pub fn backlight_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(Lcd20x4BrickletFunction::BacklightOff), payload)
    }

    /// Returns *true* if the backlight is on and *false* otherwise.
    pub fn is_backlight_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd20x4BrickletFunction::IsBacklightOn), payload)
    }

    /// Configures if the cursor (shown as _) should be visible and if it
    /// should be blinking (shown as a blinking block). The cursor position
    /// is one character behind the the last text written with
    /// [`write_line`].
    pub fn set_config(&self, cursor: bool, blinking: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(cursor));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(blinking));

        self.device.set(u8::from(Lcd20x4BrickletFunction::SetConfig), payload)
    }

    /// Returns the configuration as set by [`set_config`].
    pub fn get_config(&self) -> ConvertingReceiver<Config> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd20x4BrickletFunction::GetConfig), payload)
    }

    /// Returns *true* if the button (0 to 2 or 0 to 3 since hardware version 1.2)
    /// is pressed.
    ///
    /// If you want to react on button presses and releases it is recommended to use
    /// the [`get_button_pressed_callback_receiver`] and [`get_button_released_callback_receiver`] receivers.
    pub fn is_button_pressed(&self, button: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(button));

        self.device.get(u8::from(Lcd20x4BrickletFunction::IsButtonPressed), payload)
    }

    /// The LCD 20x4 Bricklet can store up to 8 custom characters. The characters
    /// consist of 5x8 pixels and can be addressed with the index 0-7. To describe
    /// the pixels, the first 5 bits of 8 bytes are used. For example, to make
    /// a custom character H, you should transfer the following:
    ///
    /// * ``character[0] = 0b00010001`` (decimal value 17)
    /// * ``character[1] = 0b00010001`` (decimal value 17)
    /// * ``character[2] = 0b00010001`` (decimal value 17)
    /// * ``character[3] = 0b00011111`` (decimal value 31)
    /// * ``character[4] = 0b00010001`` (decimal value 17)
    /// * ``character[5] = 0b00010001`` (decimal value 17)
    /// * ``character[6] = 0b00010001`` (decimal value 17)
    /// * ``character[7] = 0b00000000`` (decimal value 0)
    ///
    /// The characters can later be written with [`write_line`] by using the
    /// characters with the byte representation 8 (\\x08 or \\u0008) to 15
    /// (\\x0F or \\u000F).
    ///
    /// You can play around with the custom characters in Brick Viewer version
    /// since 2.0.1.
    ///
    /// Custom characters are stored by the LCD in RAM, so they have to be set
    /// after each startup.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn set_custom_character(&self, index: u8, character: [u8; 8]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));
        payload[1..9].copy_from_slice(&<[u8; 8]>::to_le_byte_vec(character));

        self.device.set(u8::from(Lcd20x4BrickletFunction::SetCustomCharacter), payload)
    }

    /// Returns the custom character for a given index, as set with
    /// [`set_custom_character`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_custom_character(&self, index: u8) -> ConvertingReceiver<[u8; 8]> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(index));

        self.device.get(u8::from(Lcd20x4BrickletFunction::GetCustomCharacter), payload)
    }

    /// Sets the default text for lines 0-3. The max number of characters
    /// per line is 20.
    ///
    /// The default text is shown on the LCD, if the default text counter
    /// expires, see [`set_default_text_counter`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_default_text(&self, line: u8, text: String) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 21];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));
        match <String>::try_to_le_byte_vec(text, 20) {
            Err(e) => {
                let (tx, rx) = std::sync::mpsc::channel::<Result<Vec<u8>, BrickletError>>();
                let _ = tx.send(Err(e));
                return ConvertingReceiver::new(rx, std::time::Duration::new(1, 0));
            }
            Ok(bytes) => payload[1..21].copy_from_slice(&bytes),
        }

        self.device.set(u8::from(Lcd20x4BrickletFunction::SetDefaultText), payload)
    }

    /// Returns the default text for a given line (0-3) as set by
    /// [`set_default_text`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_default_text(&self, line: u8) -> ConvertingReceiver<String> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(line));

        self.device.get(u8::from(Lcd20x4BrickletFunction::GetDefaultText), payload)
    }

    /// Sets the default text counter. This counter is decremented each
    /// ms by the LCD firmware. If the counter reaches 0, the default text
    /// (see [`set_default_text`]) is shown on the LCD.
    ///
    /// This functionality can be used to show a default text if the controlling
    /// program crashes or the connection is interrupted.
    ///
    /// A possible approach is to call [`set_default_text_counter`] every
    /// minute with the parameter 1000*60*2 (2 minutes). In this case the
    /// default text will be shown no later than 2 minutes after the
    /// controlling program crashes.
    ///
    /// A negative counter turns the default text functionality off.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn set_default_text_counter(&self, counter: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<i32>::to_le_byte_vec(counter));

        self.device.set(u8::from(Lcd20x4BrickletFunction::SetDefaultTextCounter), payload)
    }

    /// Returns the current value of the default text counter.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    pub fn get_default_text_counter(&self) -> ConvertingReceiver<i32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd20x4BrickletFunction::GetDefaultTextCounter), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Lcd20x4BrickletFunction::GetIdentity), payload)
    }
}
