/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures distance up to 40m with laser light.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/LaserRangeFinder_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum LaserRangeFinderBrickletFunction {
    GetDistance,
    GetVelocity,
    SetDistanceCallbackPeriod,
    GetDistanceCallbackPeriod,
    SetVelocityCallbackPeriod,
    GetVelocityCallbackPeriod,
    SetDistanceCallbackThreshold,
    GetDistanceCallbackThreshold,
    SetVelocityCallbackThreshold,
    GetVelocityCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetMovingAverage,
    GetMovingAverage,
    SetMode,
    GetMode,
    EnableLaser,
    DisableLaser,
    IsLaserEnabled,
    GetSensorHardwareVersion,
    SetConfiguration,
    GetConfiguration,
    GetIdentity,
    CallbackDistance,
    CallbackVelocity,
    CallbackDistanceReached,
    CallbackVelocityReached,
}
impl From<LaserRangeFinderBrickletFunction> for u8 {
    fn from(fun: LaserRangeFinderBrickletFunction) -> Self {
        match fun {
            LaserRangeFinderBrickletFunction::GetDistance => 1,
            LaserRangeFinderBrickletFunction::GetVelocity => 2,
            LaserRangeFinderBrickletFunction::SetDistanceCallbackPeriod => 3,
            LaserRangeFinderBrickletFunction::GetDistanceCallbackPeriod => 4,
            LaserRangeFinderBrickletFunction::SetVelocityCallbackPeriod => 5,
            LaserRangeFinderBrickletFunction::GetVelocityCallbackPeriod => 6,
            LaserRangeFinderBrickletFunction::SetDistanceCallbackThreshold => 7,
            LaserRangeFinderBrickletFunction::GetDistanceCallbackThreshold => 8,
            LaserRangeFinderBrickletFunction::SetVelocityCallbackThreshold => 9,
            LaserRangeFinderBrickletFunction::GetVelocityCallbackThreshold => 10,
            LaserRangeFinderBrickletFunction::SetDebouncePeriod => 11,
            LaserRangeFinderBrickletFunction::GetDebouncePeriod => 12,
            LaserRangeFinderBrickletFunction::SetMovingAverage => 13,
            LaserRangeFinderBrickletFunction::GetMovingAverage => 14,
            LaserRangeFinderBrickletFunction::SetMode => 15,
            LaserRangeFinderBrickletFunction::GetMode => 16,
            LaserRangeFinderBrickletFunction::EnableLaser => 17,
            LaserRangeFinderBrickletFunction::DisableLaser => 18,
            LaserRangeFinderBrickletFunction::IsLaserEnabled => 19,
            LaserRangeFinderBrickletFunction::GetSensorHardwareVersion => 24,
            LaserRangeFinderBrickletFunction::SetConfiguration => 25,
            LaserRangeFinderBrickletFunction::GetConfiguration => 26,
            LaserRangeFinderBrickletFunction::GetIdentity => 255,
            LaserRangeFinderBrickletFunction::CallbackDistance => 20,
            LaserRangeFinderBrickletFunction::CallbackVelocity => 21,
            LaserRangeFinderBrickletFunction::CallbackDistanceReached => 22,
            LaserRangeFinderBrickletFunction::CallbackVelocityReached => 23,
        }
    }
}
pub const LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const LASER_RANGE_FINDER_BRICKLET_MODE_DISTANCE: u8 = 0;
pub const LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_13MS: u8 = 1;
pub const LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_32MS: u8 = 2;
pub const LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_64MS: u8 = 3;
pub const LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_127MS: u8 = 4;
pub const LASER_RANGE_FINDER_BRICKLET_VERSION_1: u8 = 1;
pub const LASER_RANGE_FINDER_BRICKLET_VERSION_3: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DistanceCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for DistanceCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> DistanceCallbackThreshold {
        DistanceCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VelocityCallbackThreshold {
    pub option: char,
    pub min: i16,
    pub max: i16,
}
impl FromByteSlice for VelocityCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VelocityCallbackThreshold {
        VelocityCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <i16>::from_le_byte_slice(&bytes[1..3]),
            max: <i16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MovingAverage {
    pub distance_average_length: u8,
    pub velocity_average_length: u8,
}
impl FromByteSlice for MovingAverage {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> MovingAverage {
        MovingAverage {
            distance_average_length: <u8>::from_le_byte_slice(&bytes[0..1]),
            velocity_average_length: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub acquisition_count: u8,
    pub enable_quick_termination: bool,
    pub threshold_value: u8,
    pub measurement_frequency: u16,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            acquisition_count: <u8>::from_le_byte_slice(&bytes[0..1]),
            enable_quick_termination: <bool>::from_le_byte_slice(&bytes[1..2]),
            threshold_value: <u8>::from_le_byte_slice(&bytes[2..3]),
            measurement_frequency: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures distance up to 40m with laser light
#[derive(Clone)]
pub struct LaserRangeFinderBricklet {
    device: Device,
}
impl LaserRangeFinderBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 255;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Laser Range Finder Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> LaserRangeFinderBricklet {
        let mut result = LaserRangeFinderBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetDistance) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetVelocity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetDistanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetDistanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetVelocityCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetVelocityCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetDistanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetDistanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetVelocityCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetVelocityCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetDebouncePeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetMovingAverage) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetMovingAverage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::EnableLaser) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::DisableLaser) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::IsLaserEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetSensorHardwareVersion) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(LaserRangeFinderBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::laser_range_finder_bricklet::LaserRangeFinderBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::laser_range_finder_bricklet::LaserRangeFinderBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: LaserRangeFinderBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: LaserRangeFinderBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_distance_callback_period`]. The parameter is the distance
    /// value of the sensor.
    ///
    /// The [`get_distance_callback_receiver`] receiver is only triggered if the distance value has changed
    /// since the last triggering.
    ///
    /// [`set_distance_callback_period`]: #method.set_distance_callback_period
    /// [`get_distance_callback_receiver`]: #method.get_distance_callback_receiver
    pub fn get_distance_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderBrickletFunction::CallbackDistance))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_velocity_callback_period`]. The parameter is the velocity
    /// value of the sensor.
    ///
    /// The [`get_velocity_callback_receiver`] receiver is only triggered if the velocity has changed since
    /// the last triggering.
    pub fn get_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderBrickletFunction::CallbackVelocity))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_distance_callback_threshold`] is reached.
    /// The parameter is the distance value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_distance_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderBrickletFunction::CallbackDistanceReached))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_velocity_callback_threshold`] is reached.
    /// The parameter is the velocity value of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_velocity_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(LaserRangeFinderBrickletFunction::CallbackVelocityReached))
    }

    /// Returns the measured distance.
    ///
    /// Sensor hardware version 1 (see [`get_sensor_hardware_version`]) cannot
    /// measure distance and velocity at the same time. Therefore, the distance mode
    /// has to be enabled using [`set_mode`].
    /// Sensor hardware version 3 can measure distance and velocity at the same
    /// time. Also the laser has to be enabled, see [`enable_laser`].
    ///
    /// If you want to get the distance periodically, it is recommended to
    /// use the [`get_distance_callback_receiver`] receiver and set the period with
    /// [`set_distance_callback_period`].
    pub fn get_distance(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetDistance), payload)
    }

    /// Returns the measured velocity.
    ///
    /// Sensor hardware version 1 (see [`get_sensor_hardware_version`]) cannot
    /// measure distance and velocity at the same time. Therefore, the velocity mode
    /// has to be enabled using [`set_mode`].
    /// Sensor hardware version 3 can measure distance and velocity at the same
    /// time, but the velocity measurement only produces stables results if a fixed
    /// measurement rate (see [`set_configuration`]) is configured. Also the laser
    /// has to be enabled, see [`enable_laser`].
    ///
    /// If you want to get the velocity periodically, it is recommended to
    /// use the [`get_velocity_callback_receiver`] receiver and set the period with
    /// [`set_velocity_callback_period`].
    pub fn get_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetVelocity), payload)
    }

    /// Sets the period with which the [`get_distance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_distance_callback_receiver`] receiver is only triggered if the distance value has
    /// changed since the last triggering.
    pub fn set_distance_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetDistanceCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_distance_callback_period`].
    pub fn get_distance_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetDistanceCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_velocity_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_velocity_callback_receiver`] receiver is only triggered if the velocity value has
    /// changed since the last triggering.
    pub fn set_velocity_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetVelocityCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_velocity_callback_period`].
    pub fn get_velocity_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetVelocityCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_distance_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the distance value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the distance value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the distance value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the distance value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_distance_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetDistanceCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_distance_callback_threshold`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_distance_callback_threshold(&self) -> ConvertingReceiver<DistanceCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetDistanceCallbackThreshold), payload)
    }

    /// Sets the thresholds for the [`get_velocity_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the velocity is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the velocity is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the velocity is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the velocity is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_velocity_callback_threshold(&self, option: char, min: i16, max: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetVelocityCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_velocity_callback_threshold`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* LASER_RANGE_FINDER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_velocity_callback_threshold(&self) -> ConvertingReceiver<VelocityCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetVelocityCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_distance_reached_callback_receiver`],
    /// * [`get_velocity_reached_callback_receiver`],
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_distance_callback_threshold`],
    /// * [`set_velocity_callback_threshold`],
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the distance and velocity.
    ///
    /// Setting the length to 0 will turn the averaging completely off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, distance_average_length: u8, velocity_average_length: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(distance_average_length));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(velocity_average_length));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<MovingAverage> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetMovingAverage), payload)
    }

    /// # Note
    ///  This function is only available if you have a LIDAR-Lite sensor with hardware
    ///  version 1. Use [`set_configuration`] for hardware version 3. You can check
    ///  the sensor hardware version using [`get_sensor_hardware_version`].
    ///
    /// The LIDAR-Lite sensor (hardware version 1) has five different modes. One mode is
    /// for distance measurements and four modes are for velocity measurements with
    /// different ranges.
    ///
    /// The following modes are available:
    ///
    /// * 0: Distance is measured with resolution 1.0 cm and range 0-4000 cm
    /// * 1: Velocity is measured with resolution 0.1 m/s and range is 0-12.7 m/s
    /// * 2: Velocity is measured with resolution 0.25 m/s and range is 0-31.75 m/s
    /// * 3: Velocity is measured with resolution 0.5 m/s and range is 0-63.5 m/s
    /// * 4: Velocity is measured with resolution 1.0 m/s and range is 0-127 m/s
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_MODE_DISTANCE
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_13MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_32MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_64MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_127MS
    pub fn set_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetMode), payload)
    }

    /// Returns the mode as set by [`set_mode`].
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_MODE_DISTANCE
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_13MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_32MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_64MS
    ///	* LASER_RANGE_FINDER_BRICKLET_MODE_VELOCITY_MAX_127MS
    pub fn get_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetMode), payload)
    }

    /// Activates the laser of the LIDAR.
    ///
    /// We recommend that you wait 250ms after enabling the laser before
    /// the first call of [`get_distance`] to ensure stable measurements.
    pub fn enable_laser(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::EnableLaser), payload)
    }

    /// Deactivates the laser of the LIDAR.
    pub fn disable_laser(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::DisableLaser), payload)
    }

    /// Returns *true* if the laser is enabled, *false* otherwise.
    pub fn is_laser_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::IsLaserEnabled), payload)
    }

    /// Returns the LIDAR-Lite hardware version.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * LASER_RANGE_FINDER_BRICKLET_VERSION_1
    ///	* LASER_RANGE_FINDER_BRICKLET_VERSION_3
    pub fn get_sensor_hardware_version(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetSensorHardwareVersion), payload)
    }

    /// # Note
    ///  This function is only available if you have a LIDAR-Lite sensor with hardware
    ///  version 3. Use [`set_mode`] for hardware version 1. You can check
    ///  the sensor hardware version using [`get_sensor_hardware_version`].
    ///
    /// The **Acquisition Count** defines the number of times the Laser Range Finder Bricklet
    /// will integrate acquisitions to find a correlation record peak. With a higher count,
    /// the Bricklet can measure longer distances. With a lower count, the rate increases. The
    /// allowed values are 1-255.
    ///
    /// If you set **Enable Quick Termination** to true, the distance measurement will be terminated
    /// early if a high peak was already detected. This means that a higher measurement rate can be achieved
    /// and long distances can be measured at the same time. However, the chance of false-positive
    /// distance measurements increases.
    ///
    /// Normally the distance is calculated with a detection algorithm that uses peak value,
    /// signal strength and noise. You can however also define a fixed **Threshold Value**.
    /// Set this to a low value if you want to measure the distance to something that has
    /// very little reflection (e.g. glass) and set it to a high value if you want to measure
    /// the distance to something with a very high reflection (e.g. mirror). Set this to 0 to
    /// use the default algorithm. The other allowed values are 1-255.
    ///
    /// Set the **Measurement Frequency** to force a fixed measurement rate. If set to 0,
    /// the Laser Range Finder Bricklet will use the optimal frequency according to the other
    /// configurations and the actual measured distance. Since the rate is not fixed in this case,
    /// the velocity measurement is not stable. For a stable velocity measurement you should
    /// set a fixed measurement frequency. The lower the frequency, the higher is the resolution
    /// of the calculated velocity. The allowed values are 10Hz-500Hz (and 0 to turn the fixed
    /// frequency off).
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn set_configuration(
        &self,
        acquisition_count: u8,
        enable_quick_termination: bool,
        threshold_value: u8,
        measurement_frequency: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(acquisition_count));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(enable_quick_termination));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(threshold_value));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(measurement_frequency));

        self.device.set(u8::from(LaserRangeFinderBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(LaserRangeFinderBrickletFunction::GetIdentity), payload)
    }
}
