/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 16-channel digital input/output.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IO16_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum Io16BrickletFunction {
    SetPort,
    GetPort,
    SetPortConfiguration,
    GetPortConfiguration,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetPortInterrupt,
    GetPortInterrupt,
    SetPortMonoflop,
    GetPortMonoflop,
    SetSelectedValues,
    GetEdgeCount,
    SetEdgeCountConfig,
    GetEdgeCountConfig,
    GetIdentity,
    CallbackInterrupt,
    CallbackMonoflopDone,
}
impl From<Io16BrickletFunction> for u8 {
    fn from(fun: Io16BrickletFunction) -> Self {
        match fun {
            Io16BrickletFunction::SetPort => 1,
            Io16BrickletFunction::GetPort => 2,
            Io16BrickletFunction::SetPortConfiguration => 3,
            Io16BrickletFunction::GetPortConfiguration => 4,
            Io16BrickletFunction::SetDebouncePeriod => 5,
            Io16BrickletFunction::GetDebouncePeriod => 6,
            Io16BrickletFunction::SetPortInterrupt => 7,
            Io16BrickletFunction::GetPortInterrupt => 8,
            Io16BrickletFunction::SetPortMonoflop => 10,
            Io16BrickletFunction::GetPortMonoflop => 11,
            Io16BrickletFunction::SetSelectedValues => 13,
            Io16BrickletFunction::GetEdgeCount => 14,
            Io16BrickletFunction::SetEdgeCountConfig => 15,
            Io16BrickletFunction::GetEdgeCountConfig => 16,
            Io16BrickletFunction::GetIdentity => 255,
            Io16BrickletFunction::CallbackInterrupt => 9,
            Io16BrickletFunction::CallbackMonoflopDone => 12,
        }
    }
}
pub const IO16_BRICKLET_DIRECTION_IN: char = 'i';
pub const IO16_BRICKLET_DIRECTION_OUT: char = 'o';
pub const IO16_BRICKLET_EDGE_TYPE_RISING: u8 = 0;
pub const IO16_BRICKLET_EDGE_TYPE_FALLING: u8 = 1;
pub const IO16_BRICKLET_EDGE_TYPE_BOTH: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PortConfiguration {
    pub direction_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for PortConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> PortConfiguration {
        PortConfiguration { direction_mask: <u8>::from_le_byte_slice(&bytes[0..1]), value_mask: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct InterruptEvent {
    pub port: char,
    pub interrupt_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for InterruptEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> InterruptEvent {
        InterruptEvent {
            port: <char>::from_le_byte_slice(&bytes[0..1]),
            interrupt_mask: <u8>::from_le_byte_slice(&bytes[1..2]),
            value_mask: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct PortMonoflop {
    pub value: u8,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for PortMonoflop {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> PortMonoflop {
        PortMonoflop {
            value: <u8>::from_le_byte_slice(&bytes[0..1]),
            time: <u32>::from_le_byte_slice(&bytes[1..5]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MonoflopDoneEvent {
    pub port: char,
    pub selection_mask: u8,
    pub value_mask: u8,
}
impl FromByteSlice for MonoflopDoneEvent {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> MonoflopDoneEvent {
        MonoflopDoneEvent {
            port: <char>::from_le_byte_slice(&bytes[0..1]),
            selection_mask: <u8>::from_le_byte_slice(&bytes[1..2]),
            value_mask: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct EdgeCountConfig {
    pub edge_type: u8,
    pub debounce: u8,
}
impl FromByteSlice for EdgeCountConfig {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> EdgeCountConfig {
        EdgeCountConfig { edge_type: <u8>::from_le_byte_slice(&bytes[0..1]), debounce: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 16-channel digital input/output
#[derive(Clone)]
pub struct Io16Bricklet {
    device: Device,
}
impl Io16Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 28;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IO-16 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> Io16Bricklet {
        let mut result = Io16Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(Io16BrickletFunction::SetPort) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetPort) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetPortConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetPortConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetDebouncePeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetPortInterrupt) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetPortInterrupt) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetPortMonoflop) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetPortMonoflop) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetSelectedValues) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetEdgeCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::SetEdgeCountConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetEdgeCountConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(Io16BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::io16_bricklet::Io16Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::io16_bricklet::Io16Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: Io16BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: Io16BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever a change of the voltage level is detected
    /// on pins where the interrupt was activated with [`set_port_interrupt`].
    ///
    /// The values are the port, a bitmask that specifies which interrupts occurred
    /// and the current value bitmask of the port.
    ///
    /// For example:
    ///
    /// * ('a', 1, 1) or ('a', 0b00000001, 0b00000001) means that on port A an
    ///   interrupt on pin 0 occurred and currently pin 0 is high and pins 1-7 are low.
    /// * ('b', 129, 254) or ('b', 0b10000001, 0b11111110) means that on port B
    ///   interrupts on pins 0 and 7 occurred and currently pin 0 is low and pins 1-7
    ///   are high.
    ///
    /// [`set_port_interrupt`]: #method.set_port_interrupt
    pub fn get_interrupt_callback_receiver(&self) -> ConvertingCallbackReceiver<InterruptEvent> {
        self.device.get_callback_receiver(u8::from(Io16BrickletFunction::CallbackInterrupt))
    }

    /// This receiver is triggered whenever a monoflop timer reaches 0. The
    /// parameters contain the port, the involved pins and the current value of
    /// the pins (the value after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<MonoflopDoneEvent> {
        self.device.get_callback_receiver(u8::from(Io16BrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the output value (high or low) for a port (a or b) with a bitmask
    /// (8bit). A 1 in the bitmask means high and a 0 in the bitmask means low.
    ///
    /// For example: The value 15 or 0b00001111 will turn the pins 0-3 high and the
    /// pins 4-7 low for the specified port.
    ///
    /// All running monoflop timers of the given port will be aborted if this function
    /// is called.
    ///
    /// # Note
    ///  This function does nothing for pins that are configured as input.
    ///  Pull-up resistors can be switched on with [`set_port_configuration`].
    pub fn set_port(&self, port: char, value_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(Io16BrickletFunction::SetPort), payload)
    }

    /// Returns a bitmask of the values that are currently measured on the
    /// specified port. This function works if the pin is configured to input
    /// as well as if it is configured to output.
    pub fn get_port(&self, port: char) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(Io16BrickletFunction::GetPort), payload)
    }

    /// Configures the value and direction of a specified port. Possible directions
    /// are 'i' and 'o' for input and output.
    ///
    /// If the direction is configured as output, the value is either high or low
    /// (set as *true* or *false*).
    ///
    /// If the direction is configured as input, the value is either pull-up or
    /// default (set as *true* or *false*).
    ///
    /// For example:
    ///
    /// * ('a', 255, 'i', true) or ('a', 0b11111111, 'i', true) will set all pins of port A as input pull-up.
    /// * ('a', 128, 'i', false) or ('a', 0b10000000, 'i', false) will set pin 7 of port A as input default (floating if nothing is connected).
    /// * ('b', 3, 'o', false) or ('b', 0b00000011, 'o', false) will set pins 0 and 1 of port B as output low.
    /// * ('b', 4, 'o', true) or ('b', 0b00000100, 'o', true) will set pin 2 of port B as output high.
    ///
    /// Running monoflop timers for the selected pins will be aborted if this
    /// function is called.
    ///
    /// Associated constants:
    /// * IO16_BRICKLET_DIRECTION_IN
    ///	* IO16_BRICKLET_DIRECTION_OUT
    pub fn set_port_configuration(&self, port: char, selection_mask: u8, direction: char, value: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[2..3].copy_from_slice(&<char>::to_le_byte_vec(direction));
        payload[3..4].copy_from_slice(&<bool>::to_le_byte_vec(value));

        self.device.set(u8::from(Io16BrickletFunction::SetPortConfiguration), payload)
    }

    /// Returns a direction bitmask and a value bitmask for the specified port. A 1 in
    /// the direction bitmask means input and a 0 in the bitmask means output.
    ///
    /// For example: A return value of (15, 51) or (0b00001111, 0b00110011) for
    /// direction and value means that:
    ///
    /// * pins 0 and 1 are configured as input pull-up,
    /// * pins 2 and 3 are configured as input default,
    /// * pins 4 and 5 are configured as output high
    /// * and pins 6 and 7 are configured as output low.
    pub fn get_port_configuration(&self, port: char) -> ConvertingReceiver<PortConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(Io16BrickletFunction::GetPortConfiguration), payload)
    }

    /// Sets the debounce period of the [`get_interrupt_callback_receiver`] receiver.
    ///
    /// For example: If you set this value to 100, you will get the interrupt
    /// maximal every 100ms. This is necessary if something that bounces is
    /// connected to the IO-16 Bricklet, such as a button.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Io16BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the pins on which an interrupt is activated with a bitmask.
    /// Interrupts are triggered on changes of the voltage level of the pin,
    /// i.e. changes from high to low and low to high.
    ///
    /// For example: ('a', 129) or ('a', 0b10000001) will enable the interrupt for
    /// pins 0 and 7 of port a.
    ///
    /// The interrupt is delivered with the [`get_interrupt_callback_receiver`] receiver.
    pub fn set_port_interrupt(&self, port: char, interrupt_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(interrupt_mask));

        self.device.set(u8::from(Io16BrickletFunction::SetPortInterrupt), payload)
    }

    /// Returns the interrupt bitmask for the specified port as set by
    /// [`set_port_interrupt`].
    pub fn get_port_interrupt(&self, port: char) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(Io16BrickletFunction::GetPortInterrupt), payload)
    }

    /// Configures a monoflop of the pins specified by the second parameter as 8 bit
    /// long bitmask. The specified pins must be configured for output. Non-output
    /// pins will be ignored.
    ///
    /// The third parameter is a bitmask with the desired value of the specified
    /// output pins. A 1 in the bitmask means high and a 0 in the bitmask means low.
    ///
    /// The forth parameter indicates the time that the pins should hold
    /// the value.
    ///
    /// If this function is called with the parameters ('a', 9, 1, 1500) or
    /// ('a', 0b00001001, 0b00000001, 1500): Pin 0 will get high and pin 3 will get
    /// low on port 'a'. In 1.5s pin 0 will get low and pin 3 will get high again.
    ///
    /// A monoflop can be used as a fail-safe mechanism. For example: Lets assume you
    /// have a RS485 bus and an IO-16 Bricklet connected to one of the slave
    /// stacks. You can now call this function every second, with a time parameter
    /// of two seconds and pin 0 set to high. Pin 0 will be high all the time. If now
    /// the RS485 connection is lost, then pin 0 will get low in at most two seconds.
    pub fn set_port_monoflop(&self, port: char, selection_mask: u8, value_mask: u8, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 7];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));
        payload[3..7].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(Io16BrickletFunction::SetPortMonoflop), payload)
    }

    /// Returns (for the given pin) the current value and the time as set by
    /// [`set_port_monoflop`] as well as the remaining time until the value flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_port_monoflop(&self, port: char, pin: u8) -> ConvertingReceiver<PortMonoflop> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(Io16BrickletFunction::GetPortMonoflop), payload)
    }

    /// Sets the output value (high or low) for a port (a or b with a bitmask,
    /// according to the selection mask. The bitmask is 8 bit long and a 1 in the
    /// bitmask means high and a 0 in the bitmask means low.
    ///
    /// For example: The parameters ('a', 192, 128) or ('a', 0b11000000, 0b10000000)
    /// will turn pin 7 high and pin 6 low on port A, pins 0-6 will remain untouched.
    ///
    /// Running monoflop timers for the selected pins will be aborted if this
    /// function is called.
    ///
    /// # Note
    ///  This function does nothing for pins that are configured as input.
    ///  Pull-up resistors can be switched on with [`set_port_configuration`].
    pub fn set_selected_values(&self, port: char, selection_mask: u8, value_mask: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(selection_mask));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(Io16BrickletFunction::SetSelectedValues), payload)
    }

    /// Returns the current value of the edge counter for the selected pin on port A.
    /// You can configure the edges that are counted with [`set_edge_count_config`].
    ///
    /// If you set the reset counter to *true*, the count is set back to 0
    /// directly after it is read.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    pub fn get_edge_count(&self, pin: u8, reset_counter: bool) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(reset_counter));

        self.device.get(u8::from(Io16BrickletFunction::GetEdgeCount), payload)
    }

    /// Configures the edge counter for the selected pin of port A. Pins 0 and 1
    /// are available for edge counting.
    ///
    /// The edge type parameter configures if rising edges, falling edges or
    /// both are counted if the pin is configured for input. Possible edge types are:
    ///
    /// * 0 = rising
    /// * 1 = falling
    /// * 2 = both
    ///
    /// Configuring an edge counter resets its value to 0.
    ///
    /// If you don't know what any of this means, just leave it at default. The
    /// default configuration is very likely OK for you.
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * IO16_BRICKLET_EDGE_TYPE_RISING
    ///	* IO16_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO16_BRICKLET_EDGE_TYPE_BOTH
    pub fn set_edge_count_config(&self, pin: u8, edge_type: u8, debounce: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(edge_type));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(debounce));

        self.device.set(u8::from(Io16BrickletFunction::SetEdgeCountConfig), payload)
    }

    /// Returns the edge type and debounce time for the selected pin of port A as set by
    /// [`set_edge_count_config`].
    ///
    ///
    /// .. versionadded:: 2.0.3$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * IO16_BRICKLET_EDGE_TYPE_RISING
    ///	* IO16_BRICKLET_EDGE_TYPE_FALLING
    ///	* IO16_BRICKLET_EDGE_TYPE_BOTH
    pub fn get_edge_count_config(&self, pin: u8) -> ConvertingReceiver<EdgeCountConfig> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(Io16BrickletFunction::GetEdgeCountConfig), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(Io16BrickletFunction::GetIdentity), payload)
    }
}
