/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures two DC voltages between -35V and +35V with 24bit resolution each.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDualAnalogInV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDualAnalogInV2BrickletFunction {
    GetVoltage,
    SetVoltageCallbackConfiguration,
    GetVoltageCallbackConfiguration,
    SetSampleRate,
    GetSampleRate,
    SetCalibration,
    GetCalibration,
    GetAdcValues,
    SetChannelLedConfig,
    GetChannelLedConfig,
    SetChannelLedStatusConfig,
    GetChannelLedStatusConfig,
    GetAllVoltages,
    SetAllVoltagesCallbackConfiguration,
    GetAllVoltagesCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackVoltage,
    CallbackAllVoltages,
}
impl From<IndustrialDualAnalogInV2BrickletFunction> for u8 {
    fn from(fun: IndustrialDualAnalogInV2BrickletFunction) -> Self {
        match fun {
            IndustrialDualAnalogInV2BrickletFunction::GetVoltage => 1,
            IndustrialDualAnalogInV2BrickletFunction::SetVoltageCallbackConfiguration => 2,
            IndustrialDualAnalogInV2BrickletFunction::GetVoltageCallbackConfiguration => 3,
            IndustrialDualAnalogInV2BrickletFunction::SetSampleRate => 5,
            IndustrialDualAnalogInV2BrickletFunction::GetSampleRate => 6,
            IndustrialDualAnalogInV2BrickletFunction::SetCalibration => 7,
            IndustrialDualAnalogInV2BrickletFunction::GetCalibration => 8,
            IndustrialDualAnalogInV2BrickletFunction::GetAdcValues => 9,
            IndustrialDualAnalogInV2BrickletFunction::SetChannelLedConfig => 10,
            IndustrialDualAnalogInV2BrickletFunction::GetChannelLedConfig => 11,
            IndustrialDualAnalogInV2BrickletFunction::SetChannelLedStatusConfig => 12,
            IndustrialDualAnalogInV2BrickletFunction::GetChannelLedStatusConfig => 13,
            IndustrialDualAnalogInV2BrickletFunction::GetAllVoltages => 14,
            IndustrialDualAnalogInV2BrickletFunction::SetAllVoltagesCallbackConfiguration => 15,
            IndustrialDualAnalogInV2BrickletFunction::GetAllVoltagesCallbackConfiguration => 16,
            IndustrialDualAnalogInV2BrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialDualAnalogInV2BrickletFunction::SetBootloaderMode => 235,
            IndustrialDualAnalogInV2BrickletFunction::GetBootloaderMode => 236,
            IndustrialDualAnalogInV2BrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialDualAnalogInV2BrickletFunction::WriteFirmware => 238,
            IndustrialDualAnalogInV2BrickletFunction::SetStatusLedConfig => 239,
            IndustrialDualAnalogInV2BrickletFunction::GetStatusLedConfig => 240,
            IndustrialDualAnalogInV2BrickletFunction::GetChipTemperature => 242,
            IndustrialDualAnalogInV2BrickletFunction::Reset => 243,
            IndustrialDualAnalogInV2BrickletFunction::WriteUid => 248,
            IndustrialDualAnalogInV2BrickletFunction::ReadUid => 249,
            IndustrialDualAnalogInV2BrickletFunction::GetIdentity => 255,
            IndustrialDualAnalogInV2BrickletFunction::CallbackVoltage => 4,
            IndustrialDualAnalogInV2BrickletFunction::CallbackAllVoltages => 17,
        }
    }
}
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_976_SPS: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_488_SPS: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_244_SPS: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_122_SPS: u8 = 3;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_61_SPS: u8 = 4;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_4_SPS: u8 = 5;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_2_SPS: u8 = 6;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_1_SPS: u8 = 7;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS: u8 = 3;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for VoltageCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageCallbackConfiguration {
        VoltageCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltageEvent {
    pub channel: u8,
    pub voltage: i32,
}
impl FromByteSlice for VoltageEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltageEvent {
        VoltageEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), voltage: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Calibration {
    pub offset: [i32; 2],
    pub gain: [i32; 2],
}
impl FromByteSlice for Calibration {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> Calibration {
        Calibration { offset: <[i32; 2]>::from_le_byte_slice(&bytes[0..8]), gain: <[i32; 2]>::from_le_byte_slice(&bytes[8..16]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ChannelLedStatusConfig {
    pub min: i32,
    pub max: i32,
    pub config: u8,
}
impl FromByteSlice for ChannelLedStatusConfig {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ChannelLedStatusConfig {
        ChannelLedStatusConfig {
            min: <i32>::from_le_byte_slice(&bytes[0..4]),
            max: <i32>::from_le_byte_slice(&bytes[4..8]),
            config: <u8>::from_le_byte_slice(&bytes[8..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllVoltagesCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllVoltagesCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllVoltagesCallbackConfiguration {
        AllVoltagesCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures two DC voltages between -35V and +35V with 24bit resolution each
#[derive(Clone)]
pub struct IndustrialDualAnalogInV2Bricklet {
    device: Device,
}
impl IndustrialDualAnalogInV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2121;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Dual Analog In Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDualAnalogInV2Bricklet {
        let mut result = IndustrialDualAnalogInV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetVoltageCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetSampleRate) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetSampleRate) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetCalibration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetCalibration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAdcValues) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetChannelLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChannelLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetChannelLedStatusConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChannelLedStatusConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAllVoltages) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetAllVoltagesCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAllVoltagesCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::WriteUid) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::ReadUid) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDualAnalogInV2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_dual_analog_in_v2_bricklet::IndustrialDualAnalogInV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_dual_analog_in_v2_bricklet::IndustrialDualAnalogInV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDualAnalogInV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDualAnalogInV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_voltage_callback_configuration`].
    ///
    /// The parameter is the same as [`get_voltage`].
    ///
    /// [`get_voltage`]: #method.get_voltage
    /// [`set_voltage_callback_configuration`]: #method.set_voltage_callback_configuration
    pub fn get_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<VoltageEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDualAnalogInV2BrickletFunction::CallbackVoltage))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_all_voltages_callback_configuration`].
    ///
    /// The parameters are the same as [`get_all_voltages`].
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn get_all_voltages_callback_receiver(&self) -> ConvertingCallbackReceiver<[i32; 2]> {
        self.device.get_callback_receiver(u8::from(IndustrialDualAnalogInV2BrickletFunction::CallbackAllVoltages))
    }

    /// Returns the voltage for the given channel.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_voltage_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_voltage_callback_configuration`].
    pub fn get_voltage(&self, channel: u8) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetVoltage), payload)
    }

    /// The period is the period with which the [`get_voltage_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_voltage_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_voltage_callback_configuration(
        &self,
        channel: u8,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[6..7].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[7..11].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[11..15].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetVoltageCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_voltage_callback_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_voltage_callback_configuration(&self, channel: u8) -> ConvertingReceiver<VoltageCallbackConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetVoltageCallbackConfiguration), payload)
    }

    /// Sets the sample rate. The sample rate can be between 1 sample per second
    /// and 976 samples per second. Decreasing the sample rate will also decrease the
    /// noise on the data.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_976_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_488_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_244_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_122_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_61_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_4_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_2_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_1_SPS
    pub fn set_sample_rate(&self, rate: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetSampleRate), payload)
    }

    /// Returns the sample rate as set by [`set_sample_rate`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_976_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_488_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_244_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_122_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_61_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_4_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_2_SPS
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_SAMPLE_RATE_1_SPS
    pub fn get_sample_rate(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetSampleRate), payload)
    }

    /// Sets offset and gain of MCP3911 internal calibration registers.
    ///
    /// See MCP3911 datasheet 7.7 and 7.8. The Industrial Dual Analog In Bricklet 2.0
    /// is already factory calibrated by Tinkerforge. It should not be necessary
    /// for you to use this function
    pub fn set_calibration(&self, offset: [i32; 2], gain: [i32; 2]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 16];
        payload[0..8].copy_from_slice(&<[i32; 2]>::to_le_byte_vec(offset));
        payload[8..16].copy_from_slice(&<[i32; 2]>::to_le_byte_vec(gain));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetCalibration), payload)
    }

    /// Returns the calibration as set by [`set_calibration`].
    pub fn get_calibration(&self) -> ConvertingReceiver<Calibration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetCalibration), payload)
    }

    /// Returns the ADC values as given by the MCP3911 IC. This function
    /// is needed for proper calibration, see [`set_calibration`].
    pub fn get_adc_values(&self) -> ConvertingReceiver<[i32; 2]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAdcValues), payload)
    }

    /// Each channel has a corresponding LED. You can turn the LED off, on or show a
    /// heartbeat. You can also set the LED to Channel Status. In this mode the
    /// LED can either be turned on with a pre-defined threshold or the intensity
    /// of the LED can change with the measured value.
    ///
    /// You can configure the channel status behavior with [`set_channel_led_status_config`].
    ///
    /// By default all channel LEDs are configured as Channel Status.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn set_channel_led_config(&self, channel: u8, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetChannelLedConfig), payload)
    }

    /// Returns the channel LED configuration as set by [`set_channel_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn get_channel_led_config(&self, channel: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChannelLedConfig), payload)
    }

    /// Sets the channel LED status config. This config is used if the channel LED is
    /// configured as Channel Status, see [`set_channel_led_config`].
    ///
    /// For each channel you can choose between threshold and intensity mode.
    ///
    /// In threshold mode you can define a positive or a negative threshold.
    /// For a positive threshold set the min parameter to the threshold value in mV
    /// above which the LED should turn on and set the max parameter to 0. Example:
    /// If you set a positive threshold of 10V, the LED will turn on as soon as the
    /// voltage exceeds 10V and turn off again if it goes below 10V.
    /// For a negative threshold set the max parameter to the threshold value in mV
    /// below which the LED should turn on and set the min parameter to 0. Example:
    /// If you set a negative threshold of 10V, the LED will turn on as soon as the
    /// voltage goes below 10V and the LED will turn off when the voltage exceeds 10V.
    ///
    /// In intensity mode you can define a range in mV that is used to scale the brightness
    /// of the LED. Example with min=4V, max=20V: The LED is off at 4V, on at 20V
    /// and the brightness is linearly scaled between the values 4V and 20V. If the
    /// min value is greater than the max value, the LED brightness is scaled the other
    /// way around.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY
    pub fn set_channel_led_status_config(&self, channel: u8, min: i32, max: i32, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));
        payload[9..10].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetChannelLedStatusConfig), payload)
    }

    /// Returns the channel LED status configuration as set by
    /// [`set_channel_led_status_config`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY
    pub fn get_channel_led_status_config(&self, channel: u8) -> ConvertingReceiver<ChannelLedStatusConfig> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChannelLedStatusConfig), payload)
    }

    /// Returns the voltages for all channels.
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_all_voltages_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_all_voltages_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn get_all_voltages(&self) -> ConvertingReceiver<[i32; 2]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAllVoltages), payload)
    }

    /// The period is the period with which the [`get_all_voltages_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after at least one of the values has changed. If the values didn't
    /// change within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn set_all_voltages_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetAllVoltagesCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_all_voltages_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.6$nbsp;(Plugin)
    pub fn get_all_voltages_callback_configuration(&self) -> ConvertingReceiver<AllVoltagesCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetAllVoltagesCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_ANALOG_IN_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialDualAnalogInV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDualAnalogInV2BrickletFunction::GetIdentity), payload)
    }
}
