/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures two DC currents between 0mA and 20mA (IEC 60381-1).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDual020mAV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDual020maV2BrickletFunction {
    GetCurrent,
    SetCurrentCallbackConfiguration,
    GetCurrentCallbackConfiguration,
    SetSampleRate,
    GetSampleRate,
    SetGain,
    GetGain,
    SetChannelLedConfig,
    GetChannelLedConfig,
    SetChannelLedStatusConfig,
    GetChannelLedStatusConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackCurrent,
}
impl From<IndustrialDual020maV2BrickletFunction> for u8 {
    fn from(fun: IndustrialDual020maV2BrickletFunction) -> Self {
        match fun {
            IndustrialDual020maV2BrickletFunction::GetCurrent => 1,
            IndustrialDual020maV2BrickletFunction::SetCurrentCallbackConfiguration => 2,
            IndustrialDual020maV2BrickletFunction::GetCurrentCallbackConfiguration => 3,
            IndustrialDual020maV2BrickletFunction::SetSampleRate => 5,
            IndustrialDual020maV2BrickletFunction::GetSampleRate => 6,
            IndustrialDual020maV2BrickletFunction::SetGain => 7,
            IndustrialDual020maV2BrickletFunction::GetGain => 8,
            IndustrialDual020maV2BrickletFunction::SetChannelLedConfig => 9,
            IndustrialDual020maV2BrickletFunction::GetChannelLedConfig => 10,
            IndustrialDual020maV2BrickletFunction::SetChannelLedStatusConfig => 11,
            IndustrialDual020maV2BrickletFunction::GetChannelLedStatusConfig => 12,
            IndustrialDual020maV2BrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialDual020maV2BrickletFunction::SetBootloaderMode => 235,
            IndustrialDual020maV2BrickletFunction::GetBootloaderMode => 236,
            IndustrialDual020maV2BrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialDual020maV2BrickletFunction::WriteFirmware => 238,
            IndustrialDual020maV2BrickletFunction::SetStatusLedConfig => 239,
            IndustrialDual020maV2BrickletFunction::GetStatusLedConfig => 240,
            IndustrialDual020maV2BrickletFunction::GetChipTemperature => 242,
            IndustrialDual020maV2BrickletFunction::Reset => 243,
            IndustrialDual020maV2BrickletFunction::WriteUid => 248,
            IndustrialDual020maV2BrickletFunction::ReadUid => 249,
            IndustrialDual020maV2BrickletFunction::GetIdentity => 255,
            IndustrialDual020maV2BrickletFunction::CallbackCurrent => 4,
        }
    }
}
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_240_SPS: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_60_SPS: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_15_SPS: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_4_SPS: u8 = 3;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_1X: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_2X: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_4X: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_8X: u8 = 3;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS: u8 = 3;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: i32,
    pub max: i32,
}
impl FromByteSlice for CurrentCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentCallbackConfiguration {
        CurrentCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <i32>::from_le_byte_slice(&bytes[6..10]),
            max: <i32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CurrentEvent {
    pub channel: u8,
    pub current: i32,
}
impl FromByteSlice for CurrentEvent {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> CurrentEvent {
        CurrentEvent { channel: <u8>::from_le_byte_slice(&bytes[0..1]), current: <i32>::from_le_byte_slice(&bytes[1..5]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ChannelLedStatusConfig {
    pub min: i32,
    pub max: i32,
    pub config: u8,
}
impl FromByteSlice for ChannelLedStatusConfig {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> ChannelLedStatusConfig {
        ChannelLedStatusConfig {
            min: <i32>::from_le_byte_slice(&bytes[0..4]),
            max: <i32>::from_le_byte_slice(&bytes[4..8]),
            config: <u8>::from_le_byte_slice(&bytes[8..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures two DC currents between 0mA and 20mA (IEC 60381-1)
#[derive(Clone)]
pub struct IndustrialDual020maV2Bricklet {
    device: Device,
}
impl IndustrialDual020maV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2120;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Dual 0-20mA Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDual020maV2Bricklet {
        let mut result = IndustrialDual020maV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetCurrent) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetCurrentCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetCurrentCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetSampleRate) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetSampleRate) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetGain) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetGain) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetChannelLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetChannelLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetChannelLedStatusConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetChannelLedStatusConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::ReadUid) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDual020maV2BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_dual_0_20ma_v2_bricklet::IndustrialDual020maV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_dual_0_20ma_v2_bricklet::IndustrialDual020maV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDual020maV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDual020maV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_current_callback_configuration`].
    ///
    /// The parameter is the same as [`get_current`].
    ///
    /// [`get_current`]: #method.get_current
    /// [`set_current_callback_configuration`]: #method.set_current_callback_configuration
    pub fn get_current_callback_receiver(&self) -> ConvertingCallbackReceiver<CurrentEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDual020maV2BrickletFunction::CallbackCurrent))
    }

    /// Returns the current of the specified channel.
    ///
    /// It is possible to detect if an IEC 60381-1 compatible sensor is connected
    /// and if it works probably.
    ///
    /// If the returned current is below 4mA, there is likely no sensor connected
    /// or the connected sensor is defective. If the returned current is over 20mA,
    /// there might be a short circuit or the sensor is defective.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_current_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_current_callback_configuration`].
    pub fn get_current(&self, channel: u8) -> ConvertingReceiver<i32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetCurrent), payload)
    }

    /// The period is the period with which the [`get_current_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_current_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_current_callback_configuration(
        &self,
        channel: u8,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: i32,
        max: i32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 15];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[5..6].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[6..7].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[7..11].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[11..15].copy_from_slice(&<i32>::to_le_byte_vec(max));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetCurrentCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_current_callback_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_current_callback_configuration(&self, channel: u8) -> ConvertingReceiver<CurrentCallbackConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetCurrentCallbackConfiguration), payload)
    }

    /// Sets the sample rate to either 240, 60, 15 or 4 samples per second.
    /// The resolution for the rates is 12, 14, 16 and 18 bit respectively.
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0|    240 samples per second| 12 bit resolution
    ///  1|    60 samples per second| 14 bit resolution
    ///  2|    15 samples per second| 16 bit resolution
    ///  3|    4 samples per second| 18 bit resolution
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_240_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_60_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_15_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_4_SPS
    pub fn set_sample_rate(&self, rate: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(rate));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetSampleRate), payload)
    }

    /// Returns the sample rate as set by [`set_sample_rate`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_240_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_60_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_15_SPS
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_SAMPLE_RATE_4_SPS
    pub fn get_sample_rate(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetSampleRate), payload)
    }

    /// Sets a gain between 1x and 8x. If you want to measure a very small current,
    /// you can increase the gain to get some more resolution.
    ///
    /// Example: If you measure 0.5mA with a gain of 8x the return value will be
    /// 4mA.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_1X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_2X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_4X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_8X
    pub fn set_gain(&self, gain: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(gain));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetGain), payload)
    }

    /// Returns the gain as set by [`set_gain`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_1X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_2X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_4X
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_GAIN_8X
    pub fn get_gain(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetGain), payload)
    }

    /// Each channel has a corresponding LED. You can turn the LED off, on or show a
    /// heartbeat. You can also set the LED to Channel Status. In this mode the
    /// LED can either be turned on with a pre-defined threshold or the intensity
    /// of the LED can change with the measured value.
    ///
    /// You can configure the channel status behavior with [`set_channel_led_status_config`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn set_channel_led_config(&self, channel: u8, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetChannelLedConfig), payload)
    }

    /// Returns the channel LED configuration as set by [`set_channel_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn get_channel_led_config(&self, channel: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetChannelLedConfig), payload)
    }

    /// Sets the channel LED status config. This config is used if the channel LED is
    /// configured as Channel Status, see [`set_channel_led_config`].
    ///
    /// For each channel you can choose between threshold and intensity mode.
    ///
    /// In threshold mode you can define a positive or a negative threshold.
    /// For a positive threshold set the min parameter to the threshold value in nA
    /// above which the LED should turn on and set the max parameter to 0. Example:
    /// If you set a positive threshold of 10mA, the LED will turn on as soon as the
    /// current exceeds 10mA and turn off again if it goes below 10mA.
    /// For a negative threshold set the max parameter to the threshold value in nA
    /// below which the LED should turn on and set the min parameter to 0. Example:
    /// If you set a negative threshold of 10mA, the LED will turn on as soon as the
    /// current goes below 10mA and the LED will turn off when the current exceeds 10mA.
    ///
    /// In intensity mode you can define a range in nA that is used to scale the brightness
    /// of the LED. Example with min=4mA and max=20mA: The LED is off at 4mA and below,
    /// on at 20mA and above and the brightness is linearly scaled between the values
    /// 4mA and 20mA. If the min value is greater than the max value, the LED brightness
    /// is scaled the other way around.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY
    pub fn set_channel_led_status_config(&self, channel: u8, min: i32, max: i32, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..5].copy_from_slice(&<i32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<i32>::to_le_byte_vec(max));
        payload[9..10].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetChannelLedStatusConfig), payload)
    }

    /// Returns the channel LED status configuration as set by
    /// [`set_channel_led_status_config`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_THRESHOLD
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_CHANNEL_LED_STATUS_CONFIG_INTENSITY
    pub fn get_channel_led_status_config(&self, channel: u8) -> ConvertingReceiver<ChannelLedStatusConfig> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetChannelLedStatusConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_DUAL_0_20MA_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialDual020maV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDual020maV2BrickletFunction::GetIdentity), payload)
    }
}
