/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 4 galvanically isolated digital outputs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialDigitalOut4_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialDigitalOut4BrickletFunction {
    SetValue,
    GetValue,
    SetMonoflop,
    GetMonoflop,
    SetGroup,
    GetGroup,
    GetAvailableForGroup,
    SetSelectedValues,
    GetIdentity,
    CallbackMonoflopDone,
}
impl From<IndustrialDigitalOut4BrickletFunction> for u8 {
    fn from(fun: IndustrialDigitalOut4BrickletFunction) -> Self {
        match fun {
            IndustrialDigitalOut4BrickletFunction::SetValue => 1,
            IndustrialDigitalOut4BrickletFunction::GetValue => 2,
            IndustrialDigitalOut4BrickletFunction::SetMonoflop => 3,
            IndustrialDigitalOut4BrickletFunction::GetMonoflop => 4,
            IndustrialDigitalOut4BrickletFunction::SetGroup => 5,
            IndustrialDigitalOut4BrickletFunction::GetGroup => 6,
            IndustrialDigitalOut4BrickletFunction::GetAvailableForGroup => 7,
            IndustrialDigitalOut4BrickletFunction::SetSelectedValues => 9,
            IndustrialDigitalOut4BrickletFunction::GetIdentity => 255,
            IndustrialDigitalOut4BrickletFunction::CallbackMonoflopDone => 8,
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Monoflop {
    pub value: u16,
    pub time: u32,
    pub time_remaining: u32,
}
impl FromByteSlice for Monoflop {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> Monoflop {
        Monoflop {
            value: <u16>::from_le_byte_slice(&bytes[0..2]),
            time: <u32>::from_le_byte_slice(&bytes[2..6]),
            time_remaining: <u32>::from_le_byte_slice(&bytes[6..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MonoflopDoneEvent {
    pub selection_mask: u16,
    pub value_mask: u16,
}
impl FromByteSlice for MonoflopDoneEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> MonoflopDoneEvent {
        MonoflopDoneEvent { selection_mask: <u16>::from_le_byte_slice(&bytes[0..2]), value_mask: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 4 galvanically isolated digital outputs
#[derive(Clone)]
pub struct IndustrialDigitalOut4Bricklet {
    device: Device,
}
impl IndustrialDigitalOut4Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 224;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Digital Out 4 Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialDigitalOut4Bricklet {
        let mut result = IndustrialDigitalOut4Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::SetValue) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::GetValue) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::SetMonoflop) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::GetMonoflop) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::SetGroup) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::GetGroup) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::GetAvailableForGroup) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::SetSelectedValues) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialDigitalOut4BrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_digital_out_4_bricklet::IndustrialDigitalOut4Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_digital_out_4_bricklet::IndustrialDigitalOut4Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialDigitalOut4BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialDigitalOut4BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered whenever a monoflop timer reaches 0. The
    /// parameters contain the involved pins and the current value of the pins
    /// (the value after the monoflop).
    pub fn get_monoflop_done_callback_receiver(&self) -> ConvertingCallbackReceiver<MonoflopDoneEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialDigitalOut4BrickletFunction::CallbackMonoflopDone))
    }

    /// Sets the output value with a bitmask (16bit). A 1 in the bitmask means high
    /// and a 0 in the bitmask means low.
    ///
    /// For example: The value 3 or 0b0011 will turn pins 0-1 high and the other pins
    /// low.
    ///
    /// If no groups are used (see [`set_group`]), the pins correspond to the
    /// markings on the Industrial Digital Out 4 Bricklet.
    ///
    /// If groups are used, the pins correspond to the element in the group.
    /// Element 1 in the group will get pins 0-3, element 2 pins 4-7, element 3
    /// pins 8-11 and element 4 pins 12-15.
    ///
    /// All running monoflop timers will be aborted if this function is called.
    pub fn set_value(&self, value_mask: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(IndustrialDigitalOut4BrickletFunction::SetValue), payload)
    }

    /// Returns the bitmask as set by [`set_value`].
    pub fn get_value(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalOut4BrickletFunction::GetValue), payload)
    }

    /// Configures a monoflop of the pins specified by the first parameter
    /// bitmask.
    ///
    /// The second parameter is a bitmask with the desired value of the specified
    /// pins. A 1 in the bitmask means high and a 0 in the bitmask means low.
    ///
    /// The third parameter indicates the time that the pins should hold
    /// the value.
    ///
    /// If this function is called with the parameters (9, 1, 1500) or
    /// (0b1001, 0b0001, 1500): Pin 0 will get high and pin 3 will get low. In 1.5s
    /// pin 0 will get low and pin 3 will get high again.
    ///
    /// A monoflop can be used as a fail-safe mechanism. For example: Lets assume you
    /// have a RS485 bus and a Digital Out 4 Bricklet connected to one of the slave
    /// stacks. You can now call this function every second, with a time parameter
    /// of two seconds and pin 0 high. Pin 0 will be high all the time. If now
    /// the RS485 connection is lost, then pin 0 will turn low in at most two seconds.
    pub fn set_monoflop(&self, selection_mask: u16, value_mask: u16, time: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 8];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(selection_mask));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(value_mask));
        payload[4..8].copy_from_slice(&<u32>::to_le_byte_vec(time));

        self.device.set(u8::from(IndustrialDigitalOut4BrickletFunction::SetMonoflop), payload)
    }

    /// Returns (for the given pin) the current value and the time as set by
    /// [`set_monoflop`] as well as the remaining time until the value flips.
    ///
    /// If the timer is not running currently, the remaining time will be returned
    /// as 0.
    pub fn get_monoflop(&self, pin: u8) -> ConvertingReceiver<Monoflop> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(pin));

        self.device.get(u8::from(IndustrialDigitalOut4BrickletFunction::GetMonoflop), payload)
    }

    /// Sets a group of Digital Out 4 Bricklets that should work together. You can
    /// find Bricklets that can be grouped together with [`get_available_for_group`].
    ///
    /// The group consists of 4 elements. Element 1 in the group will get pins 0-3,
    /// element 2 pins 4-7, element 3 pins 8-11 and element 4 pins 12-15.
    ///
    /// Each element can either be one of the ports ('a' to 'd') or 'n' if it should
    /// not be used.
    ///
    /// For example: If you have two Digital Out 4 Bricklets connected to port A and
    /// port B respectively, you could call with ``['a', 'b', 'n', 'n']``.
    ///
    /// Now the pins on the Digital Out 4 on port A are assigned to 0-3 and the
    /// pins on the Digital Out 4 on port B are assigned to 4-7. It is now possible
    /// to call [`set_value`] and control two Bricklets at the same time.
    pub fn set_group(&self, group: [char; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<[char; 4]>::to_le_byte_vec(group));

        self.device.set(u8::from(IndustrialDigitalOut4BrickletFunction::SetGroup), payload)
    }

    /// Returns the group as set by [`set_group`]
    pub fn get_group(&self) -> ConvertingReceiver<[char; 4]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalOut4BrickletFunction::GetGroup), payload)
    }

    /// Returns a bitmask of ports that are available for grouping. For example the
    /// value 5 or 0b0101 means: Port A and port C are connected to Bricklets that
    /// can be grouped together.
    pub fn get_available_for_group(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalOut4BrickletFunction::GetAvailableForGroup), payload)
    }

    /// Sets the output value with a bitmask, according to the selection mask.
    /// The bitmask is 16 bit long, *true* refers to high and *false* refers to
    /// low.
    ///
    /// For example: The values (3, 1) or (0b0011, 0b0001) will turn pin 0 high, pin 1
    /// low the other pins remain untouched.
    ///
    /// If no groups are used (see [`set_group`]), the pins correspond to the
    /// markings on the Industrial Digital Out 4 Bricklet.
    ///
    /// If groups are used, the pins correspond to the element in the group.
    /// Element 1 in the group will get pins 0-3, element 2 pins 4-7, element 3
    /// pins 8-11 and element 4 pins 12-15.
    ///
    /// Running monoflop timers for the selected pins will be aborted if this function
    /// is called.
    pub fn set_selected_values(&self, selection_mask: u16, value_mask: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(selection_mask));
        payload[2..4].copy_from_slice(&<u16>::to_le_byte_vec(value_mask));

        self.device.set(u8::from(IndustrialDigitalOut4BrickletFunction::SetSelectedValues), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialDigitalOut4BrickletFunction::GetIdentity), payload)
    }
}
