/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! 4 channel counter up to 4MHz.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialCounter_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum IndustrialCounterBrickletFunction {
    GetCounter,
    GetAllCounter,
    SetCounter,
    SetAllCounter,
    GetSignalData,
    GetAllSignalData,
    SetCounterActive,
    SetAllCounterActive,
    GetCounterActive,
    GetAllCounterActive,
    SetCounterConfiguration,
    GetCounterConfiguration,
    SetAllCounterCallbackConfiguration,
    GetAllCounterCallbackConfiguration,
    SetAllSignalDataCallbackConfiguration,
    GetAllSignalDataCallbackConfiguration,
    SetChannelLedConfig,
    GetChannelLedConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackAllCounter,
    CallbackAllSignalData,
}
impl From<IndustrialCounterBrickletFunction> for u8 {
    fn from(fun: IndustrialCounterBrickletFunction) -> Self {
        match fun {
            IndustrialCounterBrickletFunction::GetCounter => 1,
            IndustrialCounterBrickletFunction::GetAllCounter => 2,
            IndustrialCounterBrickletFunction::SetCounter => 3,
            IndustrialCounterBrickletFunction::SetAllCounter => 4,
            IndustrialCounterBrickletFunction::GetSignalData => 5,
            IndustrialCounterBrickletFunction::GetAllSignalData => 6,
            IndustrialCounterBrickletFunction::SetCounterActive => 7,
            IndustrialCounterBrickletFunction::SetAllCounterActive => 8,
            IndustrialCounterBrickletFunction::GetCounterActive => 9,
            IndustrialCounterBrickletFunction::GetAllCounterActive => 10,
            IndustrialCounterBrickletFunction::SetCounterConfiguration => 11,
            IndustrialCounterBrickletFunction::GetCounterConfiguration => 12,
            IndustrialCounterBrickletFunction::SetAllCounterCallbackConfiguration => 13,
            IndustrialCounterBrickletFunction::GetAllCounterCallbackConfiguration => 14,
            IndustrialCounterBrickletFunction::SetAllSignalDataCallbackConfiguration => 15,
            IndustrialCounterBrickletFunction::GetAllSignalDataCallbackConfiguration => 16,
            IndustrialCounterBrickletFunction::SetChannelLedConfig => 17,
            IndustrialCounterBrickletFunction::GetChannelLedConfig => 18,
            IndustrialCounterBrickletFunction::GetSpitfpErrorCount => 234,
            IndustrialCounterBrickletFunction::SetBootloaderMode => 235,
            IndustrialCounterBrickletFunction::GetBootloaderMode => 236,
            IndustrialCounterBrickletFunction::SetWriteFirmwarePointer => 237,
            IndustrialCounterBrickletFunction::WriteFirmware => 238,
            IndustrialCounterBrickletFunction::SetStatusLedConfig => 239,
            IndustrialCounterBrickletFunction::GetStatusLedConfig => 240,
            IndustrialCounterBrickletFunction::GetChipTemperature => 242,
            IndustrialCounterBrickletFunction::Reset => 243,
            IndustrialCounterBrickletFunction::WriteUid => 248,
            IndustrialCounterBrickletFunction::ReadUid => 249,
            IndustrialCounterBrickletFunction::GetIdentity => 255,
            IndustrialCounterBrickletFunction::CallbackAllCounter => 19,
            IndustrialCounterBrickletFunction::CallbackAllSignalData => 20,
        }
    }
}
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_RISING: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_FALLING: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_BOTH: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_UP: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_DOWN: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_UP: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_DOWN: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16: u8 = 4;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32: u8 = 5;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_64: u8 = 6;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_128: u8 = 7;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_256: u8 = 8;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_512: u8 = 9;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1024: u8 = 10;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2048: u8 = 11;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4096: u8 = 12;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8192: u8 = 13;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16384: u8 = 14;
pub const INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32768: u8 = 15;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_128_MS: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_256_MS: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_512_MS: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_1024_MS: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_2048_MS: u8 = 4;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_4096_MS: u8 = 5;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_8192_MS: u8 = 6;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_16384_MS: u8 = 7;
pub const INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_32768_MS: u8 = 8;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SignalData {
    pub duty_cycle: u16,
    pub period: u64,
    pub frequency: u32,
    pub value: bool,
}
impl FromByteSlice for SignalData {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> SignalData {
        SignalData {
            duty_cycle: <u16>::from_le_byte_slice(&bytes[0..2]),
            period: <u64>::from_le_byte_slice(&bytes[2..10]),
            frequency: <u32>::from_le_byte_slice(&bytes[10..14]),
            value: <bool>::from_le_byte_slice(&bytes[14..15]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllSignalData {
    pub duty_cycle: [u16; 4],
    pub period: [u64; 4],
    pub frequency: [u32; 4],
    pub value: [bool; 4],
}
impl FromByteSlice for AllSignalData {
    fn bytes_expected() -> usize { 57 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllSignalData {
        AllSignalData {
            duty_cycle: <[u16; 4]>::from_le_byte_slice(&bytes[0..8]),
            period: <[u64; 4]>::from_le_byte_slice(&bytes[8..40]),
            frequency: <[u32; 4]>::from_le_byte_slice(&bytes[40..56]),
            value: <[bool; 4]>::from_le_byte_slice(&bytes[56..57]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CounterConfiguration {
    pub count_edge: u8,
    pub count_direction: u8,
    pub duty_cycle_prescaler: u8,
    pub frequency_integration_time: u8,
}
impl FromByteSlice for CounterConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> CounterConfiguration {
        CounterConfiguration {
            count_edge: <u8>::from_le_byte_slice(&bytes[0..1]),
            count_direction: <u8>::from_le_byte_slice(&bytes[1..2]),
            duty_cycle_prescaler: <u8>::from_le_byte_slice(&bytes[2..3]),
            frequency_integration_time: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllCounterCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllCounterCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllCounterCallbackConfiguration {
        AllCounterCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllSignalDataCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllSignalDataCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllSignalDataCallbackConfiguration {
        AllSignalDataCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllSignalDataEvent {
    pub duty_cycle: [u16; 4],
    pub period: [u64; 4],
    pub frequency: [u32; 4],
    pub value: [bool; 4],
}
impl FromByteSlice for AllSignalDataEvent {
    fn bytes_expected() -> usize { 57 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllSignalDataEvent {
        AllSignalDataEvent {
            duty_cycle: <[u16; 4]>::from_le_byte_slice(&bytes[0..8]),
            period: <[u64; 4]>::from_le_byte_slice(&bytes[8..40]),
            frequency: <[u32; 4]>::from_le_byte_slice(&bytes[40..56]),
            value: <[bool; 4]>::from_le_byte_slice(&bytes[56..57]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// 4 channel counter up to 4MHz
#[derive(Clone)]
pub struct IndustrialCounterBricklet {
    device: Device,
}
impl IndustrialCounterBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 293;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Counter Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialCounterBricklet {
        let mut result = IndustrialCounterBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetCounter) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetAllCounter) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetCounter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetAllCounter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetSignalData) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetAllSignalData) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetCounterActive) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetAllCounterActive) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetCounterActive) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetAllCounterActive) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetCounterConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetCounterConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetAllCounterCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetAllCounterCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetAllSignalDataCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetAllSignalDataCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetChannelLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetChannelLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialCounterBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_counter_bricklet::IndustrialCounterBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_counter_bricklet::IndustrialCounterBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialCounterBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialCounterBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_all_counter_callback_configuration`].
    ///
    /// The parameters are the same as [`get_all_counter`].
    ///
    /// [`get_all_counter`]: #method.get_all_counter
    /// [`set_all_counter_callback_configuration`]: #method.set_all_counter_callback_configuration
    pub fn get_all_counter_callback_receiver(&self) -> ConvertingCallbackReceiver<[i64; 4]> {
        self.device.get_callback_receiver(u8::from(IndustrialCounterBrickletFunction::CallbackAllCounter))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_all_signal_data_callback_configuration`].
    ///
    /// The parameters are the same as [`get_all_signal_data`].
    pub fn get_all_signal_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllSignalDataEvent> {
        self.device.get_callback_receiver(u8::from(IndustrialCounterBrickletFunction::CallbackAllSignalData))
    }

    /// Returns the current counter value for the given channel.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    pub fn get_counter(&self, channel: u8) -> ConvertingReceiver<i64> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetCounter), payload)
    }

    /// Returns the current counter values for all four channels.
    pub fn get_all_counter(&self) -> ConvertingReceiver<[i64; 4]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetAllCounter), payload)
    }

    /// Sets the counter value for the given channel.
    ///
    /// The default value for the counters on startup is 0.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    pub fn set_counter(&self, channel: u8, counter: i64) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..9].copy_from_slice(&<i64>::to_le_byte_vec(counter));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetCounter), payload)
    }

    /// Sets the counter values for all four channels.
    ///
    /// The default value for the counters on startup is 0.
    pub fn set_all_counter(&self, counter: [i64; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 32];
        payload[0..32].copy_from_slice(&<[i64; 4]>::to_le_byte_vec(counter));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetAllCounter), payload)
    }

    /// Returns the signal data (duty cycle, period, frequency and value) for the
    /// given channel.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    pub fn get_signal_data(&self, channel: u8) -> ConvertingReceiver<SignalData> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetSignalData), payload)
    }

    /// Returns the signal data (duty cycle, period, frequency and value) for all four
    /// channels.
    pub fn get_all_signal_data(&self) -> ConvertingReceiver<AllSignalData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetAllSignalData), payload)
    }

    /// Activates/deactivates the counter of the given channel.
    ///
    /// true = activate, false = deactivate.
    ///
    /// By default all channels are activated.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    pub fn set_counter_active(&self, channel: u8, active: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(active));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetCounterActive), payload)
    }

    /// Activates/deactivates the counter of all four channels.
    ///
    /// true = activate, false = deactivate.
    ///
    /// By default all channels are activated.
    pub fn set_all_counter_active(&self, active: [bool; 4]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<[bool; 4]>::to_le_byte_vec(active));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetAllCounterActive), payload)
    }

    /// Returns the activation state of the given channel.
    ///
    /// true = activated, false = deactivated.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    pub fn get_counter_active(&self, channel: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetCounterActive), payload)
    }

    /// Returns the activation state of all four channels.
    ///
    /// true = activated, false = deactivated.
    pub fn get_all_counter_active(&self) -> ConvertingReceiver<[bool; 4]> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetAllCounterActive), payload)
    }

    /// Sets the counter configuration for the given channel.
    ///
    /// * Count Edge: Counter can count on rising, falling or both edges.
    /// * Count Direction: Counter can count up or down. You can also use
    ///   another channel as direction input, see
    ///   [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#external-count-direction)__
    ///   for details.
    /// * Duty Cycle Prescaler: Sets a divider for the internal clock. See
    ///   [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#duty-cycle-prescaler-and-frequency-integration-time)__
    ///   for details.
    /// * Frequency Integration Time: Sets the integration time for the
    ///   frequency measurement. See
    ///   [here](https://www.tinkerforge.com/en/doc/Hardware/Bricklets/Industrial_Counter.html#duty-cycle-prescaler-and-frequency-integration-time)__
    ///   for details.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_RISING
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_FALLING
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_BOTH
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_UP
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_DOWN
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_UP
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_DOWN
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_64
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_128
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_256
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_512
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1024
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2048
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4096
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8192
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16384
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32768
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_128_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_256_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_512_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_1024_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_2048_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_4096_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_8192_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_16384_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_32768_MS
    pub fn set_counter_configuration(
        &self,
        channel: u8,
        count_edge: u8,
        count_direction: u8,
        duty_cycle_prescaler: u8,
        frequency_integration_time: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(count_edge));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(count_direction));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(duty_cycle_prescaler));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(frequency_integration_time));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetCounterConfiguration), payload)
    }

    /// Returns the counter configuration as set by [`set_counter_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_RISING
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_FALLING
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_EDGE_BOTH
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_UP
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_DOWN
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_UP
    ///	* INDUSTRIAL_COUNTER_BRICKLET_COUNT_DIRECTION_EXTERNAL_DOWN
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_64
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_128
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_256
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_512
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_1024
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_2048
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_4096
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_8192
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_16384
    ///	* INDUSTRIAL_COUNTER_BRICKLET_DUTY_CYCLE_PRESCALER_32768
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_128_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_256_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_512_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_1024_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_2048_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_4096_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_8192_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_16384_MS
    ///	* INDUSTRIAL_COUNTER_BRICKLET_FREQUENCY_INTEGRATION_TIME_32768_MS
    pub fn get_counter_configuration(&self, channel: u8) -> ConvertingReceiver<CounterConfiguration> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetCounterConfiguration), payload)
    }

    /// The period is the period with which the [`get_all_counter_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_all_counter_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetAllCounterCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_all_counter_callback_configuration`].
    pub fn get_all_counter_callback_configuration(&self) -> ConvertingReceiver<AllCounterCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetAllCounterCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_all_signal_data_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_all_signal_data_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetAllSignalDataCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_all_signal_data_callback_configuration`].
    pub fn get_all_signal_data_callback_configuration(&self) -> ConvertingReceiver<AllSignalDataCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetAllSignalDataCallbackConfiguration), payload)
    }

    /// Each channel has a corresponding LED. You can turn the LED off, on or show a
    /// heartbeat. You can also set the LED to Channel Status. In this mode the
    /// LED is on if the channel is high and off otherwise.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn set_channel_led_config(&self, channel: u8, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetChannelLedConfig), payload)
    }

    /// Returns the channel LED configuration as set by [`set_channel_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_0
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_1
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_2
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_3
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_OFF
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_ON
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_CHANNEL_LED_CONFIG_SHOW_CHANNEL_STATUS
    pub fn get_channel_led_config(&self, channel: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(channel));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetChannelLedConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(IndustrialCounterBrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* INDUSTRIAL_COUNTER_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialCounterBrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(IndustrialCounterBrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialCounterBrickletFunction::GetIdentity), payload)
    }
}
