/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Generates configurable DC voltage and current, 0V to 10V and 4mA to 20mA.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IndustrialAnalogOut_Bricklet_Rust.html).
use crate::{byte_converter::*, converting_receiver::ConvertingReceiver, device::*, ip_connection::GetRequestSender};
pub enum IndustrialAnalogOutBrickletFunction {
    Enable,
    Disable,
    IsEnabled,
    SetVoltage,
    GetVoltage,
    SetCurrent,
    GetCurrent,
    SetConfiguration,
    GetConfiguration,
    GetIdentity,
}
impl From<IndustrialAnalogOutBrickletFunction> for u8 {
    fn from(fun: IndustrialAnalogOutBrickletFunction) -> Self {
        match fun {
            IndustrialAnalogOutBrickletFunction::Enable => 1,
            IndustrialAnalogOutBrickletFunction::Disable => 2,
            IndustrialAnalogOutBrickletFunction::IsEnabled => 3,
            IndustrialAnalogOutBrickletFunction::SetVoltage => 4,
            IndustrialAnalogOutBrickletFunction::GetVoltage => 5,
            IndustrialAnalogOutBrickletFunction::SetCurrent => 6,
            IndustrialAnalogOutBrickletFunction::GetCurrent => 7,
            IndustrialAnalogOutBrickletFunction::SetConfiguration => 8,
            IndustrialAnalogOutBrickletFunction::GetConfiguration => 9,
            IndustrialAnalogOutBrickletFunction::GetIdentity => 255,
        }
    }
}
pub const INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_5V: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_10V: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_4_TO_20MA: u8 = 0;
pub const INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_20MA: u8 = 1;
pub const INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_24MA: u8 = 2;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub voltage_range: u8,
    pub current_range: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { voltage_range: <u8>::from_le_byte_slice(&bytes[0..1]), current_range: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Generates configurable DC voltage and current, 0V to 10V and 4mA to 20mA
#[derive(Clone)]
pub struct IndustrialAnalogOutBricklet {
    device: Device,
}
impl IndustrialAnalogOutBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 258;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Industrial Analog Out Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> IndustrialAnalogOutBricklet {
        let mut result = IndustrialAnalogOutBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::Enable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::Disable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::IsEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::SetVoltage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::GetVoltage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::SetCurrent) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::GetCurrent) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::SetConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(IndustrialAnalogOutBrickletFunction::GetIdentity) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::industrial_analog_out_bricklet::IndustrialAnalogOutBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::industrial_analog_out_bricklet::IndustrialAnalogOutBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: IndustrialAnalogOutBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: IndustrialAnalogOutBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Enables the output of voltage and current.
    ///
    /// The default is disabled.
    pub fn enable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialAnalogOutBrickletFunction::Enable), payload)
    }

    /// Disables the output of voltage and current.
    ///
    /// The default is disabled.
    pub fn disable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(IndustrialAnalogOutBrickletFunction::Disable), payload)
    }

    /// Returns *true* if output of voltage and current is enabled, *false* otherwise.
    pub fn is_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutBrickletFunction::IsEnabled), payload)
    }

    /// Sets the output voltage.
    ///
    /// The output voltage and output current are linked. Changing the output voltage
    /// also changes the output current.
    pub fn set_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(IndustrialAnalogOutBrickletFunction::SetVoltage), payload)
    }

    /// Returns the voltage as set by [`set_voltage`].
    pub fn get_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutBrickletFunction::GetVoltage), payload)
    }

    /// Sets the output current.
    ///
    /// The output current and output voltage are linked. Changing the output current
    /// also changes the output voltage.
    pub fn set_current(&self, current: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(current));

        self.device.set(u8::from(IndustrialAnalogOutBrickletFunction::SetCurrent), payload)
    }

    /// Returns the current as set by [`set_current`].
    pub fn get_current(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutBrickletFunction::GetCurrent), payload)
    }

    /// Configures the voltage and current range.
    ///
    /// Possible voltage ranges are:
    ///
    /// * 0V to 5V
    /// * 0V to 10V
    ///
    /// Possible current ranges are:
    ///
    /// * 4mA to 20mA
    /// * 0mA to 20mA
    /// * 0mA to 24mA
    ///
    /// The resolution will always be 12 bit. This means, that the
    /// precision is higher with a smaller range.
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_5V
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_10V
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_4_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_24MA
    pub fn set_configuration(&self, voltage_range: u8, current_range: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(voltage_range));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(current_range));

        self.device.set(u8::from(IndustrialAnalogOutBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_5V
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_VOLTAGE_RANGE_0_TO_10V
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_4_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_20MA
    ///	* INDUSTRIAL_ANALOG_OUT_BRICKLET_CURRENT_RANGE_0_TO_24MA
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutBrickletFunction::GetConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(IndustrialAnalogOutBrickletFunction::GetIdentity), payload)
    }
}
