/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Full fledged AHRS with 9 degrees of freedom.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/IMUV3_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ImuV3BrickletFunction {
    GetAcceleration,
    GetMagneticField,
    GetAngularVelocity,
    GetTemperature,
    GetOrientation,
    GetLinearAcceleration,
    GetGravityVector,
    GetQuaternion,
    GetAllData,
    SaveCalibration,
    SetSensorConfiguration,
    GetSensorConfiguration,
    SetSensorFusionMode,
    GetSensorFusionMode,
    SetAccelerationCallbackConfiguration,
    GetAccelerationCallbackConfiguration,
    SetMagneticFieldCallbackConfiguration,
    GetMagneticFieldCallbackConfiguration,
    SetAngularVelocityCallbackConfiguration,
    GetAngularVelocityCallbackConfiguration,
    SetTemperatureCallbackConfiguration,
    GetTemperatureCallbackConfiguration,
    SetOrientationCallbackConfiguration,
    GetOrientationCallbackConfiguration,
    SetLinearAccelerationCallbackConfiguration,
    GetLinearAccelerationCallbackConfiguration,
    SetGravityVectorCallbackConfiguration,
    GetGravityVectorCallbackConfiguration,
    SetQuaternionCallbackConfiguration,
    GetQuaternionCallbackConfiguration,
    SetAllDataCallbackConfiguration,
    GetAllDataCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackAcceleration,
    CallbackMagneticField,
    CallbackAngularVelocity,
    CallbackTemperature,
    CallbackLinearAcceleration,
    CallbackGravityVector,
    CallbackOrientation,
    CallbackQuaternion,
    CallbackAllData,
}
impl From<ImuV3BrickletFunction> for u8 {
    fn from(fun: ImuV3BrickletFunction) -> Self {
        match fun {
            ImuV3BrickletFunction::GetAcceleration => 1,
            ImuV3BrickletFunction::GetMagneticField => 2,
            ImuV3BrickletFunction::GetAngularVelocity => 3,
            ImuV3BrickletFunction::GetTemperature => 4,
            ImuV3BrickletFunction::GetOrientation => 5,
            ImuV3BrickletFunction::GetLinearAcceleration => 6,
            ImuV3BrickletFunction::GetGravityVector => 7,
            ImuV3BrickletFunction::GetQuaternion => 8,
            ImuV3BrickletFunction::GetAllData => 9,
            ImuV3BrickletFunction::SaveCalibration => 10,
            ImuV3BrickletFunction::SetSensorConfiguration => 11,
            ImuV3BrickletFunction::GetSensorConfiguration => 12,
            ImuV3BrickletFunction::SetSensorFusionMode => 13,
            ImuV3BrickletFunction::GetSensorFusionMode => 14,
            ImuV3BrickletFunction::SetAccelerationCallbackConfiguration => 15,
            ImuV3BrickletFunction::GetAccelerationCallbackConfiguration => 16,
            ImuV3BrickletFunction::SetMagneticFieldCallbackConfiguration => 17,
            ImuV3BrickletFunction::GetMagneticFieldCallbackConfiguration => 18,
            ImuV3BrickletFunction::SetAngularVelocityCallbackConfiguration => 19,
            ImuV3BrickletFunction::GetAngularVelocityCallbackConfiguration => 20,
            ImuV3BrickletFunction::SetTemperatureCallbackConfiguration => 21,
            ImuV3BrickletFunction::GetTemperatureCallbackConfiguration => 22,
            ImuV3BrickletFunction::SetOrientationCallbackConfiguration => 23,
            ImuV3BrickletFunction::GetOrientationCallbackConfiguration => 24,
            ImuV3BrickletFunction::SetLinearAccelerationCallbackConfiguration => 25,
            ImuV3BrickletFunction::GetLinearAccelerationCallbackConfiguration => 26,
            ImuV3BrickletFunction::SetGravityVectorCallbackConfiguration => 27,
            ImuV3BrickletFunction::GetGravityVectorCallbackConfiguration => 28,
            ImuV3BrickletFunction::SetQuaternionCallbackConfiguration => 29,
            ImuV3BrickletFunction::GetQuaternionCallbackConfiguration => 30,
            ImuV3BrickletFunction::SetAllDataCallbackConfiguration => 31,
            ImuV3BrickletFunction::GetAllDataCallbackConfiguration => 32,
            ImuV3BrickletFunction::GetSpitfpErrorCount => 234,
            ImuV3BrickletFunction::SetBootloaderMode => 235,
            ImuV3BrickletFunction::GetBootloaderMode => 236,
            ImuV3BrickletFunction::SetWriteFirmwarePointer => 237,
            ImuV3BrickletFunction::WriteFirmware => 238,
            ImuV3BrickletFunction::SetStatusLedConfig => 239,
            ImuV3BrickletFunction::GetStatusLedConfig => 240,
            ImuV3BrickletFunction::GetChipTemperature => 242,
            ImuV3BrickletFunction::Reset => 243,
            ImuV3BrickletFunction::WriteUid => 248,
            ImuV3BrickletFunction::ReadUid => 249,
            ImuV3BrickletFunction::GetIdentity => 255,
            ImuV3BrickletFunction::CallbackAcceleration => 33,
            ImuV3BrickletFunction::CallbackMagneticField => 34,
            ImuV3BrickletFunction::CallbackAngularVelocity => 35,
            ImuV3BrickletFunction::CallbackTemperature => 36,
            ImuV3BrickletFunction::CallbackLinearAcceleration => 37,
            ImuV3BrickletFunction::CallbackGravityVector => 38,
            ImuV3BrickletFunction::CallbackOrientation => 39,
            ImuV3BrickletFunction::CallbackQuaternion => 40,
            ImuV3BrickletFunction::CallbackAllData => 41,
        }
    }
}
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_2HZ: u8 = 0;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_6HZ: u8 = 1;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_8HZ: u8 = 2;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_10HZ: u8 = 3;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_15HZ: u8 = 4;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_20HZ: u8 = 5;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_25HZ: u8 = 6;
pub const IMU_V3_BRICKLET_MAGNETOMETER_RATE_30HZ: u8 = 7;
pub const IMU_V3_BRICKLET_GYROSCOPE_RANGE_2000DPS: u8 = 0;
pub const IMU_V3_BRICKLET_GYROSCOPE_RANGE_1000DPS: u8 = 1;
pub const IMU_V3_BRICKLET_GYROSCOPE_RANGE_500DPS: u8 = 2;
pub const IMU_V3_BRICKLET_GYROSCOPE_RANGE_250DPS: u8 = 3;
pub const IMU_V3_BRICKLET_GYROSCOPE_RANGE_125DPS: u8 = 4;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_523HZ: u8 = 0;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_230HZ: u8 = 1;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_116HZ: u8 = 2;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_47HZ: u8 = 3;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_23HZ: u8 = 4;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_12HZ: u8 = 5;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_64HZ: u8 = 6;
pub const IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_32HZ: u8 = 7;
pub const IMU_V3_BRICKLET_ACCELEROMETER_RANGE_2G: u8 = 0;
pub const IMU_V3_BRICKLET_ACCELEROMETER_RANGE_4G: u8 = 1;
pub const IMU_V3_BRICKLET_ACCELEROMETER_RANGE_8G: u8 = 2;
pub const IMU_V3_BRICKLET_ACCELEROMETER_RANGE_16G: u8 = 3;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_7_81HZ: u8 = 0;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_15_63HZ: u8 = 1;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_31_25HZ: u8 = 2;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_62_5HZ: u8 = 3;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_125HZ: u8 = 4;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_250HZ: u8 = 5;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_500HZ: u8 = 6;
pub const IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_1000HZ: u8 = 7;
pub const IMU_V3_BRICKLET_SENSOR_FUSION_OFF: u8 = 0;
pub const IMU_V3_BRICKLET_SENSOR_FUSION_ON: u8 = 1;
pub const IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER: u8 = 2;
pub const IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION: u8 = 3;
pub const IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const IMU_V3_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const IMU_V3_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const IMU_V3_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Acceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Acceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Acceleration {
        Acceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticField {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticField {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticField {
        MagneticField {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocity {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocity {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocity {
        AngularVelocity {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Orientation {
    pub heading: i16,
    pub roll: i16,
    pub pitch: i16,
}
impl FromByteSlice for Orientation {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Orientation {
        Orientation {
            heading: <i16>::from_le_byte_slice(&bytes[0..2]),
            roll: <i16>::from_le_byte_slice(&bytes[2..4]),
            pitch: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LinearAcceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for LinearAcceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> LinearAcceleration {
        LinearAcceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GravityVector {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for GravityVector {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GravityVector {
        GravityVector {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Quaternion {
    pub w: i16,
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Quaternion {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Quaternion {
        Quaternion {
            w: <i16>::from_le_byte_slice(&bytes[0..2]),
            x: <i16>::from_le_byte_slice(&bytes[2..4]),
            y: <i16>::from_le_byte_slice(&bytes[4..6]),
            z: <i16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub acceleration: [i16; 3],
    pub magnetic_field: [i16; 3],
    pub angular_velocity: [i16; 3],
    pub euler_angle: [i16; 3],
    pub quaternion: [i16; 4],
    pub linear_acceleration: [i16; 3],
    pub gravity_vector: [i16; 3],
    pub temperature: i8,
    pub calibration_status: u8,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 46 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[0..6]),
            magnetic_field: <[i16; 3]>::from_le_byte_slice(&bytes[6..12]),
            angular_velocity: <[i16; 3]>::from_le_byte_slice(&bytes[12..18]),
            euler_angle: <[i16; 3]>::from_le_byte_slice(&bytes[18..24]),
            quaternion: <[i16; 4]>::from_le_byte_slice(&bytes[24..32]),
            linear_acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[32..38]),
            gravity_vector: <[i16; 3]>::from_le_byte_slice(&bytes[38..44]),
            temperature: <i8>::from_le_byte_slice(&bytes[44..45]),
            calibration_status: <u8>::from_le_byte_slice(&bytes[45..46]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SensorConfiguration {
    pub magnetometer_rate: u8,
    pub gyroscope_range: u8,
    pub gyroscope_bandwidth: u8,
    pub accelerometer_range: u8,
    pub accelerometer_bandwidth: u8,
}
impl FromByteSlice for SensorConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SensorConfiguration {
        SensorConfiguration {
            magnetometer_rate: <u8>::from_le_byte_slice(&bytes[0..1]),
            gyroscope_range: <u8>::from_le_byte_slice(&bytes[1..2]),
            gyroscope_bandwidth: <u8>::from_le_byte_slice(&bytes[2..3]),
            accelerometer_range: <u8>::from_le_byte_slice(&bytes[3..4]),
            accelerometer_bandwidth: <u8>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AccelerationCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationCallbackConfiguration {
        AccelerationCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFieldCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for MagneticFieldCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFieldCallbackConfiguration {
        MagneticFieldCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocityCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AngularVelocityCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocityCallbackConfiguration {
        AngularVelocityCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct TemperatureCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for TemperatureCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> TemperatureCallbackConfiguration {
        TemperatureCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OrientationCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for OrientationCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> OrientationCallbackConfiguration {
        OrientationCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LinearAccelerationCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for LinearAccelerationCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> LinearAccelerationCallbackConfiguration {
        LinearAccelerationCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GravityVectorCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for GravityVectorCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> GravityVectorCallbackConfiguration {
        GravityVectorCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct QuaternionCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for QuaternionCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> QuaternionCallbackConfiguration {
        QuaternionCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AllDataCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataCallbackConfiguration {
        AllDataCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationEvent {
        AccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFieldEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticFieldEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFieldEvent {
        MagneticFieldEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocityEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocityEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocityEvent {
        AngularVelocityEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LinearAccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for LinearAccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> LinearAccelerationEvent {
        LinearAccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct GravityVectorEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for GravityVectorEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> GravityVectorEvent {
        GravityVectorEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OrientationEvent {
    pub heading: i16,
    pub roll: i16,
    pub pitch: i16,
}
impl FromByteSlice for OrientationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> OrientationEvent {
        OrientationEvent {
            heading: <i16>::from_le_byte_slice(&bytes[0..2]),
            roll: <i16>::from_le_byte_slice(&bytes[2..4]),
            pitch: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct QuaternionEvent {
    pub w: i16,
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for QuaternionEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> QuaternionEvent {
        QuaternionEvent {
            w: <i16>::from_le_byte_slice(&bytes[0..2]),
            x: <i16>::from_le_byte_slice(&bytes[2..4]),
            y: <i16>::from_le_byte_slice(&bytes[4..6]),
            z: <i16>::from_le_byte_slice(&bytes[6..8]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub acceleration: [i16; 3],
    pub magnetic_field: [i16; 3],
    pub angular_velocity: [i16; 3],
    pub euler_angle: [i16; 3],
    pub quaternion: [i16; 4],
    pub linear_acceleration: [i16; 3],
    pub gravity_vector: [i16; 3],
    pub temperature: i8,
    pub calibration_status: u8,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 46 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[0..6]),
            magnetic_field: <[i16; 3]>::from_le_byte_slice(&bytes[6..12]),
            angular_velocity: <[i16; 3]>::from_le_byte_slice(&bytes[12..18]),
            euler_angle: <[i16; 3]>::from_le_byte_slice(&bytes[18..24]),
            quaternion: <[i16; 4]>::from_le_byte_slice(&bytes[24..32]),
            linear_acceleration: <[i16; 3]>::from_le_byte_slice(&bytes[32..38]),
            gravity_vector: <[i16; 3]>::from_le_byte_slice(&bytes[38..44]),
            temperature: <i8>::from_le_byte_slice(&bytes[44..45]),
            calibration_status: <u8>::from_le_byte_slice(&bytes[45..46]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Full fledged AHRS with 9 degrees of freedom
#[derive(Clone)]
pub struct ImuV3Bricklet {
    device: Device,
}
impl ImuV3Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2161;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IMU Bricklet 3.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ImuV3Bricklet {
        let mut result = ImuV3Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetMagneticField) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAngularVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetOrientation) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetLinearAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetGravityVector) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetQuaternion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SaveCalibration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetSensorConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetSensorConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetSensorFusionMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetSensorFusionMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetMagneticFieldCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetMagneticFieldCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetAngularVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAngularVelocityCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetTemperatureCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetOrientationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetOrientationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetLinearAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetLinearAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetGravityVectorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetGravityVectorCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetQuaternionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetQuaternionCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetAllDataCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetAllDataCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuV3BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::imu_v3_bricklet::ImuV3Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::imu_v3_bricklet::ImuV3Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ImuV3BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ImuV3BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_acceleration_callback_configuration`]. The parameters are the acceleration
    /// for the x, y and z axis.
    ///
    /// [`set_acceleration_callback_configuration`]: #method.set_acceleration_callback_configuration
    pub fn get_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackAcceleration))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_magnetic_field_callback_configuration`]. The parameters are the magnetic
    /// field for the x, y and z axis.
    pub fn get_magnetic_field_callback_receiver(&self) -> ConvertingCallbackReceiver<MagneticFieldEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackMagneticField))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_angular_velocity_callback_configuration`]. The parameters are the angular
    /// velocity for the x, y and z axis.
    pub fn get_angular_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<AngularVelocityEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackAngularVelocity))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_temperature_callback_configuration`]. The parameter is the temperature.
    pub fn get_temperature_callback_receiver(&self) -> ConvertingCallbackReceiver<i8> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackTemperature))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_linear_acceleration_callback_configuration`]. The parameters are the
    /// linear acceleration for the x, y and z axis.
    pub fn get_linear_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<LinearAccelerationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackLinearAcceleration))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_gravity_vector_callback_configuration`]. The parameters gravity vector
    /// for the x, y and z axis.
    pub fn get_gravity_vector_callback_receiver(&self) -> ConvertingCallbackReceiver<GravityVectorEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackGravityVector))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_orientation_callback_configuration`]. The parameters are the orientation
    /// (heading (yaw), roll, pitch) of the IMU Brick in Euler angles. See
    /// [`get_orientation`] for details.
    pub fn get_orientation_callback_receiver(&self) -> ConvertingCallbackReceiver<OrientationEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackOrientation))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_quaternion_callback_configuration`]. The parameters are the orientation
    /// (w, x, y, z) of the IMU Brick in quaternions. See [`get_quaternion`]
    /// for details.
    pub fn get_quaternion_callback_receiver(&self) -> ConvertingCallbackReceiver<QuaternionEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackQuaternion))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_data_callback_configuration`]. The parameters are as for
    /// [`get_all_data`].
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(ImuV3BrickletFunction::CallbackAllData))
    }

    /// Returns the calibrated acceleration from the accelerometer for the
    /// x, y and z axis. The acceleration is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// If you want to get the acceleration periodically, it is recommended
    /// to use the [`get_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_acceleration_callback_configuration`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<Acceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAcceleration), payload)
    }

    /// Returns the calibrated magnetic field from the magnetometer for the
    /// x, y and z axis.
    ///
    /// If you want to get the magnetic field periodically, it is recommended
    /// to use the [`get_magnetic_field_callback_receiver`] receiver and set the period with
    /// [`set_magnetic_field_callback_configuration`].
    pub fn get_magnetic_field(&self) -> ConvertingReceiver<MagneticField> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetMagneticField), payload)
    }

    /// Returns the calibrated angular velocity from the gyroscope for the
    /// x, y and z axis. The angular velocity is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// If you want to get the angular velocity periodically, it is recommended
    /// to use the [`get_angular_velocity_callback_receiver`] areceiver nd set the period with
    /// [`set_angular_velocity_callback_configuration`].
    pub fn get_angular_velocity(&self) -> ConvertingReceiver<AngularVelocity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAngularVelocity), payload)
    }

    /// Returns the temperature of the IMU Brick.
    /// The temperature is measured in the core of the BNO055 IC, it is not the
    /// ambient temperature
    pub fn get_temperature(&self) -> ConvertingReceiver<i8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetTemperature), payload)
    }

    /// Returns the current orientation (heading, roll, pitch) of the IMU Brick as
    /// independent Euler angles. Note that Euler angles always
    /// experience a [gimbal lock](https://en.wikipedia.org/wiki/Gimbal_lock)__.
    /// We recommend that you use quaternions instead, if you need the absolute
    /// orientation.
    ///
    /// If you want to get the orientation periodically, it is recommended
    /// to use the [`get_orientation_callback_receiver`] receiver and set the period with
    /// [`set_orientation_callback_configuration`].
    pub fn get_orientation(&self) -> ConvertingReceiver<Orientation> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetOrientation), payload)
    }

    /// Returns the linear acceleration of the IMU Brick for the
    /// x, y and z axis. The acceleration is in the range configured with
    /// [`set_sensor_configuration`].
    ///
    /// The linear acceleration is the acceleration in each of the three
    /// axis of the IMU Brick with the influences of gravity removed.
    ///
    /// It is also possible to get the gravity vector with the influence of linear
    /// acceleration removed, see [`get_gravity_vector`].
    ///
    /// If you want to get the linear acceleration periodically, it is recommended
    /// to use the [`get_linear_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_linear_acceleration_callback_configuration`].
    pub fn get_linear_acceleration(&self) -> ConvertingReceiver<LinearAcceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetLinearAcceleration), payload)
    }

    /// Returns the current gravity vector of the IMU Brick for the
    /// x, y and z axis.
    ///
    /// The gravity vector is the acceleration that occurs due to gravity.
    /// Influences of additional linear acceleration are removed.
    ///
    /// It is also possible to get the linear acceleration with the influence
    /// of gravity removed, see [`get_linear_acceleration`].
    ///
    /// If you want to get the gravity vector periodically, it is recommended
    /// to use the [`get_gravity_vector_callback_receiver`] receiver and set the period with
    /// [`set_gravity_vector_callback_configuration`].
    pub fn get_gravity_vector(&self) -> ConvertingReceiver<GravityVector> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetGravityVector), payload)
    }

    /// Returns the current orientation (w, x, y, z) of the IMU Brick as
    /// [quaternions](https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation)__.
    ///
    /// You have to divide the return values by 16383 (14 bit) to get
    /// the usual range of -1.0 to +1.0 for quaternions.
    ///
    /// If you want to get the quaternions periodically, it is recommended
    /// to use the [`get_quaternion_callback_receiver`] receiver and set the period with
    /// [`set_quaternion_callback_configuration`].
    pub fn get_quaternion(&self) -> ConvertingReceiver<Quaternion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetQuaternion), payload)
    }

    /// Return all of the available data of the IMU Brick.
    ///
    /// * acceleration (see [`get_acceleration`])
    /// * magnetic field (see [`get_magnetic_field`])
    /// * angular velocity (see [`get_angular_velocity`])
    /// * Euler angles (see [`get_orientation`])
    /// * quaternion (see [`get_quaternion`])
    /// * linear acceleration (see [`get_linear_acceleration`])
    /// * gravity vector (see [`get_gravity_vector`])
    /// * temperature (see [`get_temperature`])
    /// * calibration status (see below)
    ///
    /// The calibration status consists of four pairs of two bits. Each pair
    /// of bits represents the status of the current calibration.
    ///
    /// * bit 0-1: Magnetometer
    /// * bit 2-3: Accelerometer
    /// * bit 4-5: Gyroscope
    /// * bit 6-7: System
    ///
    /// A value of 0 means for not calibrated and a value of 3 means
    /// fully calibrated. In your program you should always be able to
    /// ignore the calibration status, it is used by the calibration
    /// window of the Brick Viewer and it can be ignored after the first
    /// calibration. See the documentation in the calibration window for
    /// more information regarding the calibration of the IMU Brick.
    ///
    /// If you want to get the data periodically, it is recommended
    /// to use the [`get_all_data_callback_receiver`] receiver and set the period with
    /// [`set_all_data_callback_configuration`].
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAllData), payload)
    }

    /// A call of this function saves the current calibration to be used
    /// as a starting point for the next restart of continuous calibration
    /// of the IMU Brick.
    ///
    /// A return value of *true* means that the calibration could be used and
    /// *false* means that it could not be used (this happens if the calibration
    /// status is not fully calibrated).
    ///
    /// This function is used by the calibration window of the Brick Viewer, you
    /// should not need to call it in your program.
    pub fn save_calibration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::SaveCalibration), payload)
    }

    /// Sets the available sensor configuration for the Magnetometer, Gyroscope and
    /// Accelerometer. The Accelerometer Range is user selectable in all fusion modes,
    /// all other configurations are auto-controlled in fusion mode.
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_MAGNETOMETER_RATE_2HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_6HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_8HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_10HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_15HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_20HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_25HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_30HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_2000DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_1000DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_500DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_250DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_125DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_523HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_230HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_116HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_47HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_23HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_12HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_64HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_32HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_2G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_4G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_8G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_16G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_7_81HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_15_63HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_31_25HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_62_5HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_125HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_250HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_500HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_1000HZ
    pub fn set_sensor_configuration(
        &self,
        magnetometer_rate: u8,
        gyroscope_range: u8,
        gyroscope_bandwidth: u8,
        accelerometer_range: u8,
        accelerometer_bandwidth: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(magnetometer_rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(gyroscope_range));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(gyroscope_bandwidth));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(accelerometer_range));
        payload[4..5].copy_from_slice(&<u8>::to_le_byte_vec(accelerometer_bandwidth));

        self.device.set(u8::from(ImuV3BrickletFunction::SetSensorConfiguration), payload)
    }

    /// Returns the sensor configuration as set by [`set_sensor_configuration`].
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_MAGNETOMETER_RATE_2HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_6HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_8HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_10HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_15HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_20HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_25HZ
    ///	* IMU_V3_BRICKLET_MAGNETOMETER_RATE_30HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_2000DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_1000DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_500DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_250DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_RANGE_125DPS
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_523HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_230HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_116HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_47HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_23HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_12HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_64HZ
    ///	* IMU_V3_BRICKLET_GYROSCOPE_BANDWIDTH_32HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_2G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_4G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_8G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_RANGE_16G
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_7_81HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_15_63HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_31_25HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_62_5HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_125HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_250HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_500HZ
    ///	* IMU_V3_BRICKLET_ACCELEROMETER_BANDWIDTH_1000HZ
    pub fn get_sensor_configuration(&self) -> ConvertingReceiver<SensorConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetSensorConfiguration), payload)
    }

    /// If the fusion mode is turned off, the functions [`get_acceleration`],
    /// [`get_magnetic_field`] and [`get_angular_velocity`] return uncalibrated
    /// and uncompensated sensor data. All other sensor data getters return no data.
    ///
    /// Since firmware version 2.0.6 you can also use a fusion mode without magnetometer.
    /// In this mode the calculated orientation is relative (with magnetometer it is
    /// absolute with respect to the earth). However, the calculation can't be influenced
    /// by spurious magnetic fields.
    ///
    /// Since firmware version 2.0.13 you can also use a fusion mode without fast
    /// magnetometer calibration. This mode is the same as the normal fusion mode,
    /// but the fast magnetometer calibration is turned off. So to find the orientation
    /// the first time will likely take longer, but small magnetic influences might
    /// not affect the automatic calibration as much.
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_SENSOR_FUSION_OFF
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION
    pub fn set_sensor_fusion_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(ImuV3BrickletFunction::SetSensorFusionMode), payload)
    }

    /// Returns the sensor fusion mode as set by [`set_sensor_fusion_mode`].
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_SENSOR_FUSION_OFF
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_MAGNETOMETER
    ///	* IMU_V3_BRICKLET_SENSOR_FUSION_ON_WITHOUT_FAST_MAGNETOMETER_CALIBRATION
    pub fn get_sensor_fusion_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetSensorFusionMode), payload)
    }

    /// The period is the period with which the [`get_acceleration_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_acceleration_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetAccelerationCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_acceleration_callback_configuration`].
    pub fn get_acceleration_callback_configuration(&self) -> ConvertingReceiver<AccelerationCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAccelerationCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_magnetic_field_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_magnetic_field_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetMagneticFieldCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_magnetic_field_callback_configuration`].
    pub fn get_magnetic_field_callback_configuration(&self) -> ConvertingReceiver<MagneticFieldCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetMagneticFieldCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_angular_velocity_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_angular_velocity_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetAngularVelocityCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_angular_velocity_callback_configuration`].
    pub fn get_angular_velocity_callback_configuration(&self) -> ConvertingReceiver<AngularVelocityCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAngularVelocityCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_temperature_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_temperature_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetTemperatureCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_temperature_callback_configuration`].
    pub fn get_temperature_callback_configuration(&self) -> ConvertingReceiver<TemperatureCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetTemperatureCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_orientation_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_orientation_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetOrientationCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_orientation_callback_configuration`].
    pub fn get_orientation_callback_configuration(&self) -> ConvertingReceiver<OrientationCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetOrientationCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_linear_acceleration_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_linear_acceleration_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetLinearAccelerationCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_linear_acceleration_callback_configuration`].
    pub fn get_linear_acceleration_callback_configuration(&self) -> ConvertingReceiver<LinearAccelerationCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetLinearAccelerationCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_gravity_vector_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_gravity_vector_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetGravityVectorCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_gravity_vector_callback_configuration`].
    pub fn get_gravity_vector_callback_configuration(&self) -> ConvertingReceiver<GravityVectorCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetGravityVectorCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_quaternion_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_quaternion_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetQuaternionCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_quaternion_callback_configuration`].
    pub fn get_quaternion_callback_configuration(&self) -> ConvertingReceiver<QuaternionCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetQuaternionCallbackConfiguration), payload)
    }

    /// The period is the period with which the [`get_all_data_callback_receiver`] receiver
    /// is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    pub fn set_all_data_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(ImuV3BrickletFunction::SetAllDataCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_all_data_callback_configuration`].
    pub fn get_all_data_callback_configuration(&self) -> ConvertingReceiver<AllDataCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetAllDataCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(ImuV3BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* IMU_V3_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(ImuV3BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(ImuV3BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(ImuV3BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * IMU_V3_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* IMU_V3_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuV3BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(ImuV3BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuV3BrickletFunction::GetIdentity), payload)
    }
}
