/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Full fledged AHRS with 9 degrees of freedom.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/IMU_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum ImuBrickFunction {
    GetAcceleration,
    GetMagneticField,
    GetAngularVelocity,
    GetAllData,
    GetOrientation,
    GetQuaternion,
    GetImuTemperature,
    LedsOn,
    LedsOff,
    AreLedsOn,
    SetAccelerationRange,
    GetAccelerationRange,
    SetMagnetometerRange,
    GetMagnetometerRange,
    SetConvergenceSpeed,
    GetConvergenceSpeed,
    SetCalibration,
    GetCalibration,
    SetAccelerationPeriod,
    GetAccelerationPeriod,
    SetMagneticFieldPeriod,
    GetMagneticFieldPeriod,
    SetAngularVelocityPeriod,
    GetAngularVelocityPeriod,
    SetAllDataPeriod,
    GetAllDataPeriod,
    SetOrientationPeriod,
    GetOrientationPeriod,
    SetQuaternionPeriod,
    GetQuaternionPeriod,
    OrientationCalculationOn,
    OrientationCalculationOff,
    IsOrientationCalculationOn,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackAcceleration,
    CallbackMagneticField,
    CallbackAngularVelocity,
    CallbackAllData,
    CallbackOrientation,
    CallbackQuaternion,
}
impl From<ImuBrickFunction> for u8 {
    fn from(fun: ImuBrickFunction) -> Self {
        match fun {
            ImuBrickFunction::GetAcceleration => 1,
            ImuBrickFunction::GetMagneticField => 2,
            ImuBrickFunction::GetAngularVelocity => 3,
            ImuBrickFunction::GetAllData => 4,
            ImuBrickFunction::GetOrientation => 5,
            ImuBrickFunction::GetQuaternion => 6,
            ImuBrickFunction::GetImuTemperature => 7,
            ImuBrickFunction::LedsOn => 8,
            ImuBrickFunction::LedsOff => 9,
            ImuBrickFunction::AreLedsOn => 10,
            ImuBrickFunction::SetAccelerationRange => 11,
            ImuBrickFunction::GetAccelerationRange => 12,
            ImuBrickFunction::SetMagnetometerRange => 13,
            ImuBrickFunction::GetMagnetometerRange => 14,
            ImuBrickFunction::SetConvergenceSpeed => 15,
            ImuBrickFunction::GetConvergenceSpeed => 16,
            ImuBrickFunction::SetCalibration => 17,
            ImuBrickFunction::GetCalibration => 18,
            ImuBrickFunction::SetAccelerationPeriod => 19,
            ImuBrickFunction::GetAccelerationPeriod => 20,
            ImuBrickFunction::SetMagneticFieldPeriod => 21,
            ImuBrickFunction::GetMagneticFieldPeriod => 22,
            ImuBrickFunction::SetAngularVelocityPeriod => 23,
            ImuBrickFunction::GetAngularVelocityPeriod => 24,
            ImuBrickFunction::SetAllDataPeriod => 25,
            ImuBrickFunction::GetAllDataPeriod => 26,
            ImuBrickFunction::SetOrientationPeriod => 27,
            ImuBrickFunction::GetOrientationPeriod => 28,
            ImuBrickFunction::SetQuaternionPeriod => 29,
            ImuBrickFunction::GetQuaternionPeriod => 30,
            ImuBrickFunction::OrientationCalculationOn => 37,
            ImuBrickFunction::OrientationCalculationOff => 38,
            ImuBrickFunction::IsOrientationCalculationOn => 39,
            ImuBrickFunction::SetSpitfpBaudrateConfig => 231,
            ImuBrickFunction::GetSpitfpBaudrateConfig => 232,
            ImuBrickFunction::GetSendTimeoutCount => 233,
            ImuBrickFunction::SetSpitfpBaudrate => 234,
            ImuBrickFunction::GetSpitfpBaudrate => 235,
            ImuBrickFunction::GetSpitfpErrorCount => 237,
            ImuBrickFunction::EnableStatusLed => 238,
            ImuBrickFunction::DisableStatusLed => 239,
            ImuBrickFunction::IsStatusLedEnabled => 240,
            ImuBrickFunction::GetProtocol1BrickletName => 241,
            ImuBrickFunction::GetChipTemperature => 242,
            ImuBrickFunction::Reset => 243,
            ImuBrickFunction::WriteBrickletPlugin => 246,
            ImuBrickFunction::ReadBrickletPlugin => 247,
            ImuBrickFunction::GetIdentity => 255,
            ImuBrickFunction::CallbackAcceleration => 31,
            ImuBrickFunction::CallbackMagneticField => 32,
            ImuBrickFunction::CallbackAngularVelocity => 33,
            ImuBrickFunction::CallbackAllData => 34,
            ImuBrickFunction::CallbackOrientation => 35,
            ImuBrickFunction::CallbackQuaternion => 36,
        }
    }
}
pub const IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_GAIN: u8 = 0;
pub const IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_BIAS: u8 = 1;
pub const IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_GAIN: u8 = 2;
pub const IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_BIAS: u8 = 3;
pub const IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_GAIN: u8 = 4;
pub const IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_BIAS: u8 = 5;
pub const IMU_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const IMU_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const IMU_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const IMU_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const IMU_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const IMU_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const IMU_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const IMU_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Acceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Acceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Acceleration {
        Acceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticField {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticField {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticField {
        MagneticField {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocity {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocity {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocity {
        AngularVelocity {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllData {
    pub acc_x: i16,
    pub acc_y: i16,
    pub acc_z: i16,
    pub mag_x: i16,
    pub mag_y: i16,
    pub mag_z: i16,
    pub ang_x: i16,
    pub ang_y: i16,
    pub ang_z: i16,
    pub temperature: i16,
}
impl FromByteSlice for AllData {
    fn bytes_expected() -> usize { 20 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllData {
        AllData {
            acc_x: <i16>::from_le_byte_slice(&bytes[0..2]),
            acc_y: <i16>::from_le_byte_slice(&bytes[2..4]),
            acc_z: <i16>::from_le_byte_slice(&bytes[4..6]),
            mag_x: <i16>::from_le_byte_slice(&bytes[6..8]),
            mag_y: <i16>::from_le_byte_slice(&bytes[8..10]),
            mag_z: <i16>::from_le_byte_slice(&bytes[10..12]),
            ang_x: <i16>::from_le_byte_slice(&bytes[12..14]),
            ang_y: <i16>::from_le_byte_slice(&bytes[14..16]),
            ang_z: <i16>::from_le_byte_slice(&bytes[16..18]),
            temperature: <i16>::from_le_byte_slice(&bytes[18..20]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Orientation {
    pub roll: i16,
    pub pitch: i16,
    pub yaw: i16,
}
impl FromByteSlice for Orientation {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Orientation {
        Orientation {
            roll: <i16>::from_le_byte_slice(&bytes[0..2]),
            pitch: <i16>::from_le_byte_slice(&bytes[2..4]),
            yaw: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct Quaternion {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
impl FromByteSlice for Quaternion {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> Quaternion {
        Quaternion {
            x: <f32>::from_le_byte_slice(&bytes[0..4]),
            y: <f32>::from_le_byte_slice(&bytes[4..8]),
            z: <f32>::from_le_byte_slice(&bytes[8..12]),
            w: <f32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationEvent {
        AccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MagneticFieldEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for MagneticFieldEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> MagneticFieldEvent {
        MagneticFieldEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AngularVelocityEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AngularVelocityEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AngularVelocityEvent {
        AngularVelocityEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AllDataEvent {
    pub acc_x: i16,
    pub acc_y: i16,
    pub acc_z: i16,
    pub mag_x: i16,
    pub mag_y: i16,
    pub mag_z: i16,
    pub ang_x: i16,
    pub ang_y: i16,
    pub ang_z: i16,
    pub temperature: i16,
}
impl FromByteSlice for AllDataEvent {
    fn bytes_expected() -> usize { 20 }
    fn from_le_byte_slice(bytes: &[u8]) -> AllDataEvent {
        AllDataEvent {
            acc_x: <i16>::from_le_byte_slice(&bytes[0..2]),
            acc_y: <i16>::from_le_byte_slice(&bytes[2..4]),
            acc_z: <i16>::from_le_byte_slice(&bytes[4..6]),
            mag_x: <i16>::from_le_byte_slice(&bytes[6..8]),
            mag_y: <i16>::from_le_byte_slice(&bytes[8..10]),
            mag_z: <i16>::from_le_byte_slice(&bytes[10..12]),
            ang_x: <i16>::from_le_byte_slice(&bytes[12..14]),
            ang_y: <i16>::from_le_byte_slice(&bytes[14..16]),
            ang_z: <i16>::from_le_byte_slice(&bytes[16..18]),
            temperature: <i16>::from_le_byte_slice(&bytes[18..20]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct OrientationEvent {
    pub roll: i16,
    pub pitch: i16,
    pub yaw: i16,
}
impl FromByteSlice for OrientationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> OrientationEvent {
        OrientationEvent {
            roll: <i16>::from_le_byte_slice(&bytes[0..2]),
            pitch: <i16>::from_le_byte_slice(&bytes[2..4]),
            yaw: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq)]
pub struct QuaternionEvent {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
impl FromByteSlice for QuaternionEvent {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> QuaternionEvent {
        QuaternionEvent {
            x: <f32>::from_le_byte_slice(&bytes[0..4]),
            y: <f32>::from_le_byte_slice(&bytes[4..8]),
            z: <f32>::from_le_byte_slice(&bytes[8..12]),
            w: <f32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Full fledged AHRS with 9 degrees of freedom
#[derive(Clone)]
pub struct ImuBrick {
    device: Device,
}
impl ImuBrick {
    pub const DEVICE_IDENTIFIER: u16 = 16;
    pub const DEVICE_DISPLAY_NAME: &'static str = "IMU Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> ImuBrick {
        let mut result = ImuBrick { device: Device::new([2, 0, 4], uid, req_sender, 0) };
        result.device.response_expected[u8::from(ImuBrickFunction::GetAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetMagneticField) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAngularVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAllData) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetOrientation) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetQuaternion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetImuTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::LedsOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::LedsOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::AreLedsOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetAccelerationRange) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAccelerationRange) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetMagnetometerRange) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetMagnetometerRange) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetConvergenceSpeed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetConvergenceSpeed) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetCalibration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetCalibration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetAccelerationPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAccelerationPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetMagneticFieldPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetMagneticFieldPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetAngularVelocityPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAngularVelocityPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetAllDataPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetAllDataPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetOrientationPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetOrientationPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetQuaternionPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(ImuBrickFunction::GetQuaternionPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::OrientationCalculationOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::OrientationCalculationOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::IsOrientationCalculationOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetProtocol1BrickletName) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(ImuBrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(ImuBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::imu_brick::ImuBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::imu_brick::ImuBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: ImuBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: ImuBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_acceleration_period`]. The parameters are the acceleration
    /// for the x, y and z axis.
    ///
    /// [`set_acceleration_period`]: #method.set_acceleration_period
    pub fn get_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackAcceleration))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_magnetic_field_period`]. The parameters are the magnetic
    /// field for the x, y and z axis.
    pub fn get_magnetic_field_callback_receiver(&self) -> ConvertingCallbackReceiver<MagneticFieldEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackMagneticField))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_angular_velocity_period`]. The parameters are the angular
    /// velocity for the x, y and z axis.
    pub fn get_angular_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<AngularVelocityEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackAngularVelocity))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_all_data_period`]. The parameters are the acceleration,
    /// the magnetic field and the angular velocity for the x, y and z axis as
    /// well as the temperature of the IMU Brick.
    pub fn get_all_data_callback_receiver(&self) -> ConvertingCallbackReceiver<AllDataEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackAllData))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_orientation_period`]. The parameters are the orientation
    /// (roll, pitch and yaw) of the IMU Brick in Euler angles. See
    /// [`get_orientation`] for details.
    pub fn get_orientation_callback_receiver(&self) -> ConvertingCallbackReceiver<OrientationEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackOrientation))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_quaternion_period`]. The parameters are the orientation
    /// (x, y, z, w) of the IMU Brick in quaternions. See [`get_quaternion`]
    /// for details.
    pub fn get_quaternion_callback_receiver(&self) -> ConvertingCallbackReceiver<QuaternionEvent> {
        self.device.get_callback_receiver(u8::from(ImuBrickFunction::CallbackQuaternion))
    }

    /// Returns the calibrated acceleration from the accelerometer for the
    /// x, y and z axis.
    ///
    /// If you want to get the acceleration periodically, it is recommended
    /// to use the [`get_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_acceleration_period`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<Acceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAcceleration), payload)
    }

    /// Returns the calibrated magnetic field from the magnetometer for the
    /// x, y and z axis.
    ///
    /// If you want to get the magnetic field periodically, it is recommended
    /// to use the [`get_magnetic_field_callback_receiver`] receiver and set the period with
    /// [`set_magnetic_field_period`].
    pub fn get_magnetic_field(&self) -> ConvertingReceiver<MagneticField> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetMagneticField), payload)
    }

    /// Returns the calibrated angular velocity from the gyroscope for the
    /// x, y and z axis in °/14.375s (you have to divide by 14.375 to
    /// get the value in °/s).
    ///
    /// If you want to get the angular velocity periodically, it is recommended
    /// to use the [`get_angular_velocity_callback_receiver`] receiver and set the period with
    /// [`set_angular_velocity_period`].
    pub fn get_angular_velocity(&self) -> ConvertingReceiver<AngularVelocity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAngularVelocity), payload)
    }

    /// Returns the data from [`get_acceleration`], [`get_magnetic_field`]
    /// and [`get_angular_velocity`] as well as the temperature of the IMU Brick.
    ///
    /// If you want to get the data periodically, it is recommended
    /// to use the [`get_all_data_callback_receiver`] receiver and set the period with
    /// [`set_all_data_period`].
    pub fn get_all_data(&self) -> ConvertingReceiver<AllData> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAllData), payload)
    }

    /// Returns the current orientation (roll, pitch, yaw) of the IMU Brick as Euler
    /// angles. Note that Euler angles always experience a
    /// [gimbal lock](https://en.wikipedia.org/wiki/Gimbal_lock)__.
    ///
    /// We recommend that you use quaternions instead.
    ///
    /// The order to sequence in which the orientation values should be applied is
    /// roll, yaw, pitch.
    ///
    /// If you want to get the orientation periodically, it is recommended
    /// to use the [`get_orientation_callback_receiver`] receiver and set the period with
    /// [`set_orientation_period`].
    pub fn get_orientation(&self) -> ConvertingReceiver<Orientation> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetOrientation), payload)
    }

    /// Returns the current orientation (x, y, z, w) of the IMU as
    /// [quaternions](https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation)__.
    ///
    /// You can go from quaternions to Euler angles with the following formula::
    ///
    ///  xAngle = atan2(2*y*w - 2*x*z, 1 - 2*y*y - 2*z*z)
    ///  yAngle = atan2(2*x*w - 2*y*z, 1 - 2*x*x - 2*z*z)
    ///  zAngle =  asin(2*x*y + 2*z*w)
    ///
    /// This process is not reversible, because of the
    /// [gimbal lock](https://en.wikipedia.org/wiki/Gimbal_lock)__.
    ///
    /// It is also possible to calculate independent angles. You can calculate
    /// yaw, pitch and roll in a right-handed vehicle coordinate system according to
    /// DIN70000 with::
    ///
    ///  yaw   =  atan2(2*x*y + 2*w*z, w*w + x*x - y*y - z*z)
    ///  pitch = -asin(2*w*y - 2*x*z)
    ///  roll  = -atan2(2*y*z + 2*w*x, -w*w + x*x + y*y - z*z))
    ///
    /// Converting the quaternions to an OpenGL transformation matrix is
    /// possible with the following formula::
    ///
    ///  matrix = [[1 - 2*(y*y + z*z),     2*(x*y - w*z),     2*(x*z + w*y), 0],
    ///            [    2*(x*y + w*z), 1 - 2*(x*x + z*z),     2*(y*z - w*x), 0],
    ///            [    2*(x*z - w*y),     2*(y*z + w*x), 1 - 2*(x*x + y*y), 0],
    ///            [                0,                 0,                 0, 1]]
    ///
    /// If you want to get the quaternions periodically, it is recommended
    /// to use the [`get_quaternion_callback_receiver`] receiver and set the period with
    /// [`set_quaternion_period`].
    pub fn get_quaternion(&self) -> ConvertingReceiver<Quaternion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetQuaternion), payload)
    }

    /// Returns the temperature of the IMU Brick.
    pub fn get_imu_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetImuTemperature), payload)
    }

    /// Turns the orientation and direction LEDs of the IMU Brick on.
    pub fn leds_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::LedsOn), payload)
    }

    /// Turns the orientation and direction LEDs of the IMU Brick off.
    pub fn leds_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::LedsOff), payload)
    }

    /// Returns *true* if the orientation and direction LEDs of the IMU Brick
    /// are on, *false* otherwise.
    pub fn are_leds_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::AreLedsOn), payload)
    }

    /// Not implemented yet.
    pub fn set_acceleration_range(&self, range: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(range));

        self.device.set(u8::from(ImuBrickFunction::SetAccelerationRange), payload)
    }

    /// Not implemented yet.
    pub fn get_acceleration_range(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAccelerationRange), payload)
    }

    /// Not implemented yet.
    pub fn set_magnetometer_range(&self, range: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(range));

        self.device.set(u8::from(ImuBrickFunction::SetMagnetometerRange), payload)
    }

    /// Not implemented yet.
    pub fn get_magnetometer_range(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetMagnetometerRange), payload)
    }

    /// Sets the convergence speed of the IMU Brick. The convergence speed
    /// determines how the different sensor measurements are fused.
    ///
    /// If the orientation of the IMU Brick is off by 10° and the convergence speed is
    /// set to 20°/s, it will take 0.5s until the orientation is corrected. However,
    /// if the correct orientation is reached and the convergence speed is too high,
    /// the orientation will fluctuate with the fluctuations of the accelerometer and
    /// the magnetometer.
    ///
    /// If you set the convergence speed to 0, practically only the gyroscope is used
    /// to calculate the orientation. This gives very smooth movements, but errors of the
    /// gyroscope will not be corrected. If you set the convergence speed to something
    /// above 500, practically only the magnetometer and the accelerometer are used to
    /// calculate the orientation. In this case the movements are abrupt and the values
    /// will fluctuate, but there won't be any errors that accumulate over time.
    ///
    /// In an application with high angular velocities, we recommend a high convergence
    /// speed, so the errors of the gyroscope can be corrected fast. In applications with
    /// only slow movements we recommend a low convergence speed. You can change the
    /// convergence speed on the fly. So it is possible (and recommended) to increase
    /// the convergence speed before an abrupt movement and decrease it afterwards
    /// again.
    ///
    /// You might want to play around with the convergence speed in the Brick Viewer to
    /// get a feeling for a good value for your application.
    pub fn set_convergence_speed(&self, speed: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(speed));

        self.device.set(u8::from(ImuBrickFunction::SetConvergenceSpeed), payload)
    }

    /// Returns the convergence speed as set by [`set_convergence_speed`].
    pub fn get_convergence_speed(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetConvergenceSpeed), payload)
    }

    /// There are several different types that can be calibrated:
    ///
    ///  Type| Description| Values
    ///  --- | --- | ---
    ///  0|    Accelerometer Gain| ``[mul x| mul y| mul z| div x| div y| div z| 0| 0| 0| 0]``
    ///  1|    Accelerometer Bias| ``[bias x| bias y| bias z| 0| 0| 0| 0| 0| 0| 0]``
    ///  2|    Magnetometer Gain|  ``[mul x| mul y| mul z| div x| div y| div z| 0| 0| 0| 0]``
    ///  3|    Magnetometer Bias|  ``[bias x| bias y| bias z| 0| 0| 0| 0| 0| 0| 0]``
    ///  4|    Gyroscope Gain|     ``[mul x| mul y| mul z| div x| div y| div z| 0| 0| 0| 0]``
    ///  5|    Gyroscope Bias|     ``[bias xl| bias yl| bias zl| temp l| bias xh| bias yh| bias zh| temp h| 0| 0]``
    ///
    /// The calibration via gain and bias is done with the following formula::
    ///
    ///  new_value = (bias + orig_value) * gain_mul / gain_div
    ///
    /// If you really want to write your own calibration software, please keep
    /// in mind that you first have to undo the old calibration (set bias to 0 and
    /// gain to 1/1) and that you have to average over several thousand values
    /// to obtain a usable result in the end.
    ///
    /// The gyroscope bias is highly dependent on the temperature, so you have to
    /// calibrate the bias two times with different temperatures. The values ``xl``,
    /// ``yl``, ``zl`` and ``temp l`` are the bias for ``x``, ``y``, ``z`` and the
    /// corresponding temperature for a low temperature. The values ``xh``, ``yh``,
    /// ``zh`` and ``temp h`` are the same for a high temperatures. The temperature
    /// difference should be at least 5°C. If you have a temperature where the
    /// IMU Brick is mostly used, you should use this temperature for one of the
    /// sampling points.
    ///
    /// # Note
    ///  We highly recommend that you use the Brick Viewer to calibrate your
    ///  IMU Brick.
    ///
    /// Associated constants:
    /// * IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_BIAS
    ///	* IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_BIAS
    ///	* IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_BIAS
    pub fn set_calibration(&self, typ: u8, data: [i16; 10]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 21];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(typ));
        payload[1..21].copy_from_slice(&<[i16; 10]>::to_le_byte_vec(data));

        self.device.set(u8::from(ImuBrickFunction::SetCalibration), payload)
    }

    /// Returns the calibration for a given type as set by [`set_calibration`].
    ///
    /// Associated constants:
    /// * IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_ACCELEROMETER_BIAS
    ///	* IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_MAGNETOMETER_BIAS
    ///	* IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_GAIN
    ///	* IMU_BRICK_CALIBRATION_TYPE_GYROSCOPE_BIAS
    pub fn get_calibration(&self, typ: u8) -> ConvertingReceiver<[i16; 10]> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(typ));

        self.device.get(u8::from(ImuBrickFunction::GetCalibration), payload)
    }

    /// Sets the period with which the [`get_acceleration_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_acceleration_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetAccelerationPeriod), payload)
    }

    /// Returns the period as set by [`set_acceleration_period`].
    pub fn get_acceleration_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAccelerationPeriod), payload)
    }

    /// Sets the period with which the [`get_magnetic_field_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    pub fn set_magnetic_field_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetMagneticFieldPeriod), payload)
    }

    /// Returns the period as set by [`set_magnetic_field_period`].
    pub fn get_magnetic_field_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetMagneticFieldPeriod), payload)
    }

    /// Sets the period with which the [`get_angular_velocity_callback_receiver`] receiver is
    /// triggered periodically. A value of 0 turns the receiver off.
    pub fn set_angular_velocity_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetAngularVelocityPeriod), payload)
    }

    /// Returns the period as set by [`set_angular_velocity_period`].
    pub fn get_angular_velocity_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAngularVelocityPeriod), payload)
    }

    /// Sets the period with which the [`get_all_data_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_all_data_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetAllDataPeriod), payload)
    }

    /// Returns the period as set by [`set_all_data_period`].
    pub fn get_all_data_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetAllDataPeriod), payload)
    }

    /// Sets the period with which the [`get_orientation_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_orientation_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetOrientationPeriod), payload)
    }

    /// Returns the period as set by [`set_orientation_period`].
    pub fn get_orientation_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetOrientationPeriod), payload)
    }

    /// Sets the period with which the [`get_quaternion_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    pub fn set_quaternion_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(ImuBrickFunction::SetQuaternionPeriod), payload)
    }

    /// Returns the period as set by [`set_quaternion_period`].
    pub fn get_quaternion_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetQuaternionPeriod), payload)
    }

    /// Turns the orientation calculation of the IMU Brick on.
    ///
    /// As default the calculation is on.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Firmware)
    pub fn orientation_calculation_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::OrientationCalculationOn), payload)
    }

    /// Turns the orientation calculation of the IMU Brick off.
    ///
    /// If the calculation is off, [`get_orientation`] will return
    /// the last calculated value until the calculation is turned on again.
    ///
    /// The trigonometric functions that are needed to calculate the orientation
    /// are very expensive. We recommend to turn the orientation calculation
    /// off if the orientation is not needed, to free calculation time for the
    /// sensor fusion algorithm.
    ///
    /// As default the calculation is on.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Firmware)
    pub fn orientation_calculation_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::OrientationCalculationOff), payload)
    }

    /// Returns *true* if the orientation calculation of the IMU Brick
    /// is on, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Firmware)
    pub fn is_orientation_calculation_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::IsOrientationCalculationOn), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.3.5$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(ImuBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.3.5$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * IMU_BRICK_COMMUNICATION_METHOD_NONE
    ///	* IMU_BRICK_COMMUNICATION_METHOD_USB
    ///	* IMU_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* IMU_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* IMU_BRICK_COMMUNICATION_METHOD_RS485
    ///	* IMU_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* IMU_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* IMU_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(ImuBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(ImuBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ImuBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(ImuBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(ImuBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(ImuBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(ImuBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(ImuBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(ImuBrickFunction::GetIdentity), payload)
    }
}
