/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! HAT for Raspberry Pi with 8 Bricklets ports and real-time clock.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/HAT_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum HatBrickFunction {
    SetSleepMode,
    GetSleepMode,
    SetBrickletPower,
    GetBrickletPower,
    GetVoltages,
    SetVoltagesCallbackConfiguration,
    GetVoltagesCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackVoltages,
}
impl From<HatBrickFunction> for u8 {
    fn from(fun: HatBrickFunction) -> Self {
        match fun {
            HatBrickFunction::SetSleepMode => 1,
            HatBrickFunction::GetSleepMode => 2,
            HatBrickFunction::SetBrickletPower => 3,
            HatBrickFunction::GetBrickletPower => 4,
            HatBrickFunction::GetVoltages => 5,
            HatBrickFunction::SetVoltagesCallbackConfiguration => 6,
            HatBrickFunction::GetVoltagesCallbackConfiguration => 7,
            HatBrickFunction::GetSpitfpErrorCount => 234,
            HatBrickFunction::SetBootloaderMode => 235,
            HatBrickFunction::GetBootloaderMode => 236,
            HatBrickFunction::SetWriteFirmwarePointer => 237,
            HatBrickFunction::WriteFirmware => 238,
            HatBrickFunction::SetStatusLedConfig => 239,
            HatBrickFunction::GetStatusLedConfig => 240,
            HatBrickFunction::GetChipTemperature => 242,
            HatBrickFunction::Reset => 243,
            HatBrickFunction::WriteUid => 248,
            HatBrickFunction::ReadUid => 249,
            HatBrickFunction::GetIdentity => 255,
            HatBrickFunction::CallbackVoltages => 8,
        }
    }
}
pub const HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const HAT_BRICK_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const HAT_BRICK_BOOTLOADER_STATUS_OK: u8 = 0;
pub const HAT_BRICK_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const HAT_BRICK_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const HAT_BRICK_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const HAT_BRICK_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const HAT_BRICK_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const HAT_BRICK_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const HAT_BRICK_STATUS_LED_CONFIG_ON: u8 = 1;
pub const HAT_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const HAT_BRICK_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SleepMode {
    pub power_off_delay: u32,
    pub power_off_duration: u32,
    pub raspberry_pi_off: bool,
    pub bricklets_off: bool,
    pub enable_sleep_indicator: bool,
}
impl FromByteSlice for SleepMode {
    fn bytes_expected() -> usize { 11 }
    fn from_le_byte_slice(bytes: &[u8]) -> SleepMode {
        SleepMode {
            power_off_delay: <u32>::from_le_byte_slice(&bytes[0..4]),
            power_off_duration: <u32>::from_le_byte_slice(&bytes[4..8]),
            raspberry_pi_off: <bool>::from_le_byte_slice(&bytes[8..9]),
            bricklets_off: <bool>::from_le_byte_slice(&bytes[9..10]),
            enable_sleep_indicator: <bool>::from_le_byte_slice(&bytes[10..11]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Voltages {
    pub voltage_usb: u16,
    pub voltage_dc: u16,
}
impl FromByteSlice for Voltages {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> Voltages {
        Voltages { voltage_usb: <u16>::from_le_byte_slice(&bytes[0..2]), voltage_dc: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltagesCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for VoltagesCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltagesCallbackConfiguration {
        VoltagesCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct VoltagesEvent {
    pub voltage_usb: u16,
    pub voltage_dc: u16,
}
impl FromByteSlice for VoltagesEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> VoltagesEvent {
        VoltagesEvent { voltage_usb: <u16>::from_le_byte_slice(&bytes[0..2]), voltage_dc: <u16>::from_le_byte_slice(&bytes[2..4]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// HAT for Raspberry Pi with 8 Bricklets ports and real-time clock
#[derive(Clone)]
pub struct HatBrick {
    device: Device,
}
impl HatBrick {
    pub const DEVICE_IDENTIFIER: u16 = 111;
    pub const DEVICE_DISPLAY_NAME: &'static str = "HAT Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> HatBrick {
        let mut result = HatBrick { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(HatBrickFunction::SetSleepMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::GetSleepMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::SetBrickletPower) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::GetBrickletPower) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::GetVoltages) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::SetVoltagesCallbackConfiguration) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(HatBrickFunction::GetVoltagesCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(HatBrickFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(HatBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::hat_brick::HatBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::hat_brick::HatBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: HatBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: HatBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_voltages_callback_configuration`].
    ///
    /// The parameters are the same as [`get_voltages`].
    ///
    /// [`get_voltages`]: #method.get_voltages
    /// [`set_voltages_callback_configuration`]: #method.set_voltages_callback_configuration
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn get_voltages_callback_receiver(&self) -> ConvertingCallbackReceiver<VoltagesEvent> {
        self.device.get_callback_receiver(u8::from(HatBrickFunction::CallbackVoltages))
    }

    /// Sets the sleep mode.
    ///
    /// # Note
    ///  Calling this function will cut the Raspberry Pi's power after Power Off Delay seconds.
    ///  You have to shut down the operating system yourself, e.g. by calling 'sudo shutdown -h now'.
    ///
    /// Parameters:
    ///
    /// * Power Off Delay: Time before the RPi/Bricklets are powered off.
    /// * Power Off Duration: Duration that the RPi/Bricklets stay powered off.
    /// * Raspberry Pi Off: RPi is powered off if set to true.
    /// * Bricklets Off: Bricklets are powered off if set to true.
    /// * Enable Sleep Indicator: If set to true, the status LED will blink in a 1s interval
    ///   during the whole power off duration. This will draw additional 0.3mA.
    ///
    /// Example: To turn RPi and Bricklets off in 5 seconds for 10 minutes with sleep
    /// indicator enabled, call (5, 60*10, true, true, true).
    ///
    /// This function can also be used to implement a watchdog. To do this you can
    /// write a program that calls this function once per second in a loop with
    /// (10, 2, true, false, false). If the RPi crashes or gets stuck
    /// the HAT will reset the RPi after 10 seconds.
    pub fn set_sleep_mode(
        &self,
        power_off_delay: u32,
        power_off_duration: u32,
        raspberry_pi_off: bool,
        bricklets_off: bool,
        enable_sleep_indicator: bool,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 11];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(power_off_delay));
        payload[4..8].copy_from_slice(&<u32>::to_le_byte_vec(power_off_duration));
        payload[8..9].copy_from_slice(&<bool>::to_le_byte_vec(raspberry_pi_off));
        payload[9..10].copy_from_slice(&<bool>::to_le_byte_vec(bricklets_off));
        payload[10..11].copy_from_slice(&<bool>::to_le_byte_vec(enable_sleep_indicator));

        self.device.set(u8::from(HatBrickFunction::SetSleepMode), payload)
    }

    /// Returns the sleep mode settings as set by [`set_sleep_mode`].
    pub fn get_sleep_mode(&self) -> ConvertingReceiver<SleepMode> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetSleepMode), payload)
    }

    /// Set to true/false to turn the power supply of the connected Bricklets on/off.
    pub fn set_bricklet_power(&self, bricklet_power: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(bricklet_power));

        self.device.set(u8::from(HatBrickFunction::SetBrickletPower), payload)
    }

    /// Returns the power status of the connected Bricklets as set by [`set_bricklet_power`].
    pub fn get_bricklet_power(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetBrickletPower), payload)
    }

    /// Returns the USB supply voltage and the DC input supply voltage.
    ///
    /// There are three possible combinations:
    ///
    /// * Only USB connected: The USB supply voltage will be fed back to the
    ///   DC input connector. You will read the USB voltage and a slightly lower
    ///   voltage on the DC input.
    /// * Only DC input connected: The DC voltage will not be fed back to the
    ///   USB connector. You will read the DC input voltage and the USB voltage
    ///   will be 0.
    /// * USB and DC input connected: You will read both voltages. In this case
    ///   the USB supply will be without load, but it will work as backup if you
    ///   disconnect the DC input (or if the DC input voltage falls below the
    ///   USB voltage).
    pub fn get_voltages(&self) -> ConvertingReceiver<Voltages> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetVoltages), payload)
    }

    /// The period is the period with which the [`get_voltages_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn set_voltages_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(HatBrickFunction::SetVoltagesCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_voltages_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Firmware)
    pub fn get_voltages_callback_configuration(&self) -> ConvertingReceiver<VoltagesCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetVoltagesCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE
    ///	* HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* HAT_BRICK_BOOTLOADER_STATUS_OK
    ///	* HAT_BRICK_BOOTLOADER_STATUS_INVALID_MODE
    ///	* HAT_BRICK_BOOTLOADER_STATUS_NO_CHANGE
    ///	* HAT_BRICK_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* HAT_BRICK_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* HAT_BRICK_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(HatBrickFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE
    ///	* HAT_BRICK_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* HAT_BRICK_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(HatBrickFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(HatBrickFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * HAT_BRICK_STATUS_LED_CONFIG_OFF
    ///	* HAT_BRICK_STATUS_LED_CONFIG_ON
    ///	* HAT_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* HAT_BRICK_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(HatBrickFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * HAT_BRICK_STATUS_LED_CONFIG_OFF
    ///	* HAT_BRICK_STATUS_LED_CONFIG_ON
    ///	* HAT_BRICK_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* HAT_BRICK_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(HatBrickFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(HatBrickFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the HAT is connected to
    /// (typically '0' as the HAT is the root device in the topology),
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The HAT (Zero) Brick is always at position 'i'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(HatBrickFunction::GetIdentity), payload)
    }
}
